/*
 * Decompiled with CFR 0.152.
 */
package com.dominikdorn.ssft;

import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorityEvaluator {
    public static Set<String> parseAuthorities(String grantedRoles) {
        TreeSet<String> parsedAuthorities = new TreeSet<String>();
        if (grantedRoles == null || grantedRoles.isEmpty()) {
            return parsedAuthorities;
        }
        String[] parsedAuthoritiesArr = grantedRoles.contains(",") || grantedRoles.contains(" ") || grantedRoles.contains(";") ? grantedRoles.split("[,; ]") : new String[]{grantedRoles};
        for (String auth : parsedAuthoritiesArr) {
            parsedAuthorities.add(auth.trim());
        }
        return parsedAuthorities;
    }

    public static boolean ifAnyGranted(String roles, Set<String> authorities) {
        Set<String> parsedAuthorities = AuthorityEvaluator.parseAuthorities(roles);
        if (parsedAuthorities.isEmpty()) {
            return false;
        }
        for (String authority : authorities) {
            if (!parsedAuthorities.contains(authority)) continue;
            return true;
        }
        return false;
    }

    public static boolean ifAllGranted(String requiredRoles, Set<String> authorities) {
        Set<String> requiredAuthorities = AuthorityEvaluator.parseAuthorities(requiredRoles);
        if (requiredAuthorities.isEmpty()) {
            return false;
        }
        for (String requiredAuthority : requiredAuthorities) {
            if (authorities.contains(requiredAuthority)) continue;
            return false;
        }
        return true;
    }

    public static boolean ifNotGranted(String notGrantedRoles, Set<String> authorities) {
        Set<String> parsedAuthorities = AuthorityEvaluator.parseAuthorities(notGrantedRoles);
        if (parsedAuthorities.isEmpty()) {
            return true;
        }
        for (String authority : authorities) {
            if (!parsedAuthorities.contains(authority)) continue;
            return false;
        }
        return true;
    }
}

