/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.JRCsvExporterNature;
import net.sf.jasperreports.engine.export.JRExporterContext;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.export.CsvExporterConfiguration;
import net.sf.jasperreports.export.CsvReportConfiguration;
import net.sf.jasperreports.export.ExporterInputItem;
import net.sf.jasperreports.export.WriterExporterOutput;

public abstract class JRAbstractCsvExporter<RC extends CsvReportConfiguration, C extends CsvExporterConfiguration, E extends JRExporterContext>
extends JRAbstractExporter<RC, C, WriterExporterOutput, E> {
    protected static final String CSV_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.csv.";
    public static final String CSV_EXPORTER_KEY = "net.sf.jasperreports.csv";
    protected Writer writer;
    protected ExporterNature nature;

    public JRAbstractCsvExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRAbstractCsvExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
    }

    @Override
    public void exportReport() throws JRException {
        this.ensureJasperReportsContext();
        this.ensureInput();
        this.initExport();
        this.ensureOutput();
        this.writer = ((WriterExporterOutput)this.getExporterOutput()).getWriter();
        try {
            this.exportReportToWriter();
        }
        catch (IOException e) {
            throw new JRException("Error writing to output writer : " + this.jasperPrint.getName(), e);
        }
        finally {
            ((WriterExporterOutput)this.getExporterOutput()).close();
        }
    }

    protected void exportReportToWriter() throws JRException, IOException {
        List<ExporterInputItem> items = this.exporterInput.getItems();
        for (int reportIndex = 0; reportIndex < items.size(); ++reportIndex) {
            ExporterInputItem item = items.get(reportIndex);
            this.setCurrentExporterInputItem(item);
            List<JRPrintPage> pages = this.jasperPrint.getPages();
            if (pages == null || pages.size() <= 0) continue;
            JRAbstractExporter.PageRange pageRange = this.getPageRange();
            int startPageIndex = pageRange == null || pageRange.getStartPageIndex() == null ? 0 : pageRange.getStartPageIndex();
            int endPageIndex = pageRange == null || pageRange.getEndPageIndex() == null ? pages.size() - 1 : pageRange.getEndPageIndex();
            for (int i = startPageIndex; i <= endPageIndex; ++i) {
                if (Thread.interrupted()) {
                    throw new JRException("Current thread interrupted.");
                }
                JRPrintPage page = pages.get(i);
                this.exportPage(page);
            }
        }
        this.writer.flush();
    }

    protected abstract void exportPage(JRPrintPage var1) throws IOException;

    @Override
    public JRStyledText getStyledText(JRPrintText textElement) {
        return textElement.getFullStyledText(this.noneSelector);
    }

    protected String prepareText(String source) {
        String str = null;
        if (source != null) {
            boolean putQuotes = false;
            CsvExporterConfiguration configuration = (CsvExporterConfiguration)this.getCurrentConfiguration();
            String fieldDelimiter = configuration.getFieldDelimiter();
            String recordDelimiter = configuration.getRecordDelimiter();
            if (source.indexOf(fieldDelimiter) >= 0 || source.indexOf(recordDelimiter) >= 0) {
                putQuotes = true;
            }
            StringBuffer sbuffer = new StringBuffer();
            StringTokenizer tkzer = new StringTokenizer(source, "\"\n", true);
            String token = null;
            while (tkzer.hasMoreTokens()) {
                token = tkzer.nextToken();
                if ("\"".equals(token)) {
                    putQuotes = true;
                    sbuffer.append("\"\"");
                    continue;
                }
                if ("\n".equals(token)) {
                    putQuotes = true;
                    sbuffer.append("\n");
                    continue;
                }
                sbuffer.append(token);
            }
            str = sbuffer.toString();
            if (putQuotes) {
                str = "\"" + str + "\"";
            }
        }
        return str;
    }

    @Override
    protected void initExport() {
        super.initExport();
    }

    @Override
    protected void initReport() {
        super.initReport();
        this.nature = new JRCsvExporterNature(this.jasperReportsContext, this.filter);
    }

    @Override
    public String getExporterKey() {
        return CSV_EXPORTER_KEY;
    }

    @Override
    public String getExporterPropertiesPrefix() {
        return CSV_EXPORTER_PROPERTIES_PREFIX;
    }
}

