/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseGraphicElement;
import net.sf.jasperreports.engine.base.JRBaseHyperlink;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import net.sf.jasperreports.engine.util.JRBoxUtil;
import net.sf.jasperreports.engine.util.JRCloneUtils;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public class JRBaseImage
extends JRBaseGraphicElement
implements JRImage {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_LAZY = "isLazy";
    public static final String PROPERTY_ON_ERROR_TYPE = "onErrorType";
    public static final String PROPERTY_USING_CACHE = "isUsingCache";
    protected ScaleImageEnum scaleImageValue;
    protected HorizontalAlignEnum horizontalAlignmentValue;
    protected VerticalAlignEnum verticalAlignmentValue;
    protected Boolean isUsingCache;
    protected boolean isLazy;
    protected OnErrorTypeEnum onErrorTypeValue = OnErrorTypeEnum.ERROR;
    protected EvaluationTimeEnum evaluationTimeValue = EvaluationTimeEnum.NOW;
    protected String linkType;
    protected String linkTarget;
    private JRHyperlinkParameter[] hyperlinkParameters;
    protected JRLineBox lineBox;
    protected JRGroup evaluationGroup;
    protected JRExpression expression;
    protected JRExpression anchorNameExpression;
    protected JRExpression hyperlinkReferenceExpression;
    protected JRExpression hyperlinkWhenExpression;
    protected JRExpression hyperlinkAnchorExpression;
    protected JRExpression hyperlinkPageExpression;
    private JRExpression hyperlinkTooltipExpression;
    protected int bookmarkLevel = 0;
    private int PSEUDO_SERIAL_VERSION_UID = 50502;
    private Byte horizontalAlignment;
    private Byte verticalAlignment;
    private Byte border;
    private Byte topBorder;
    private Byte leftBorder;
    private Byte bottomBorder;
    private Byte rightBorder;
    private Color borderColor;
    private Color topBorderColor;
    private Color leftBorderColor;
    private Color bottomBorderColor;
    private Color rightBorderColor;
    private Integer padding;
    private Integer topPadding;
    private Integer leftPadding;
    private Integer bottomPadding;
    private Integer rightPadding;
    private byte hyperlinkType;
    private byte hyperlinkTarget;
    private Byte scaleImage;
    private byte onErrorType;
    private byte evaluationTime;

    protected JRBaseImage(JRImage image, JRBaseObjectFactory factory) {
        super(image, factory);
        this.scaleImageValue = image.getOwnScaleImageValue();
        this.horizontalAlignmentValue = image.getOwnHorizontalAlignmentValue();
        this.verticalAlignmentValue = image.getOwnVerticalAlignmentValue();
        this.isUsingCache = image.getUsingCache();
        this.isLazy = image.isLazy();
        this.onErrorTypeValue = image.getOnErrorTypeValue();
        this.evaluationTimeValue = image.getEvaluationTimeValue();
        this.linkType = image.getLinkType();
        this.linkTarget = image.getLinkTarget();
        this.hyperlinkParameters = JRBaseHyperlink.copyHyperlinkParameters(image, factory);
        this.lineBox = image.getLineBox().clone(this);
        this.evaluationGroup = factory.getGroup(image.getEvaluationGroup());
        this.expression = factory.getExpression(image.getExpression());
        this.anchorNameExpression = factory.getExpression(image.getAnchorNameExpression());
        this.hyperlinkReferenceExpression = factory.getExpression(image.getHyperlinkReferenceExpression());
        this.hyperlinkWhenExpression = factory.getExpression(image.getHyperlinkWhenExpression());
        this.hyperlinkAnchorExpression = factory.getExpression(image.getHyperlinkAnchorExpression());
        this.hyperlinkPageExpression = factory.getExpression(image.getHyperlinkPageExpression());
        this.hyperlinkTooltipExpression = factory.getExpression(image.getHyperlinkTooltipExpression());
        this.bookmarkLevel = image.getBookmarkLevel();
    }

    @Override
    public ModeEnum getModeValue() {
        return JRStyleResolver.getMode(this, ModeEnum.TRANSPARENT);
    }

    @Override
    public ScaleImageEnum getScaleImageValue() {
        return JRStyleResolver.getScaleImageValue(this);
    }

    @Override
    public ScaleImageEnum getOwnScaleImageValue() {
        return this.scaleImageValue;
    }

    @Override
    public void setScaleImage(ScaleImageEnum scaleImageValue) {
        ScaleImageEnum old = this.scaleImageValue;
        this.scaleImageValue = scaleImageValue;
        this.getEventSupport().firePropertyChange("scaleImage", old, this.scaleImageValue);
    }

    @Override
    public HorizontalAlignEnum getHorizontalAlignmentValue() {
        return JRStyleResolver.getHorizontalAlignmentValue(this);
    }

    @Override
    public HorizontalAlignEnum getOwnHorizontalAlignmentValue() {
        return this.horizontalAlignmentValue;
    }

    @Override
    public void setHorizontalAlignment(HorizontalAlignEnum horizontalAlignmentValue) {
        HorizontalAlignEnum old = this.horizontalAlignmentValue;
        this.horizontalAlignmentValue = horizontalAlignmentValue;
        this.getEventSupport().firePropertyChange("horizontalAlignment", old, this.horizontalAlignmentValue);
    }

    @Override
    public VerticalAlignEnum getVerticalAlignmentValue() {
        return JRStyleResolver.getVerticalAlignmentValue(this);
    }

    @Override
    public VerticalAlignEnum getOwnVerticalAlignmentValue() {
        return this.verticalAlignmentValue;
    }

    @Override
    public void setVerticalAlignment(VerticalAlignEnum verticalAlignmentValue) {
        VerticalAlignEnum old = this.verticalAlignmentValue;
        this.verticalAlignmentValue = verticalAlignmentValue;
        this.getEventSupport().firePropertyChange("verticalAlignment", old, this.verticalAlignmentValue);
    }

    @Override
    public boolean isUsingCache() {
        if (this.isUsingCache == null) {
            if (this.getExpression() != null) {
                return String.class.getName().equals(this.getExpression().getValueClassName());
            }
            return true;
        }
        return this.isUsingCache;
    }

    @Override
    public Boolean isOwnUsingCache() {
        return this.isUsingCache;
    }

    @Override
    public Boolean getUsingCache() {
        return this.isUsingCache;
    }

    @Override
    public void setUsingCache(boolean isUsingCache) {
        this.setUsingCache(isUsingCache ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setUsingCache(Boolean isUsingCache) {
        Boolean old = this.isUsingCache;
        this.isUsingCache = isUsingCache;
        this.getEventSupport().firePropertyChange(PROPERTY_USING_CACHE, old, this.isUsingCache);
    }

    @Override
    public boolean isLazy() {
        return this.isLazy;
    }

    @Override
    public void setLazy(boolean isLazy) {
        boolean old = this.isLazy;
        this.isLazy = isLazy;
        this.getEventSupport().firePropertyChange(PROPERTY_LAZY, old, this.isLazy);
    }

    @Override
    public OnErrorTypeEnum getOnErrorTypeValue() {
        return this.onErrorTypeValue;
    }

    @Override
    public void setOnErrorType(OnErrorTypeEnum onErrorTypeValue) {
        OnErrorTypeEnum old = this.onErrorTypeValue;
        this.onErrorTypeValue = onErrorTypeValue;
        this.getEventSupport().firePropertyChange(PROPERTY_ON_ERROR_TYPE, old, this.onErrorTypeValue);
    }

    @Override
    public EvaluationTimeEnum getEvaluationTimeValue() {
        return this.evaluationTimeValue;
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    @Override
    public byte getHyperlinkType() {
        return this.getHyperlinkTypeValue().getValue();
    }

    @Override
    public HyperlinkTypeEnum getHyperlinkTypeValue() {
        return JRHyperlinkHelper.getHyperlinkTypeValue(this);
    }

    @Override
    public byte getHyperlinkTarget() {
        return JRHyperlinkHelper.getHyperlinkTarget(this);
    }

    @Override
    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    @Override
    public JRExpression getExpression() {
        return this.expression;
    }

    @Override
    public JRExpression getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    @Override
    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    @Override
    public JRExpression getHyperlinkWhenExpression() {
        return this.hyperlinkWhenExpression;
    }

    @Override
    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    @Override
    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitImage(this);
    }

    @Override
    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    @Override
    public Float getDefaultLineWidth() {
        return JRPen.LINE_WIDTH_0;
    }

    @Override
    public String getLinkType() {
        return this.linkType;
    }

    @Override
    public String getLinkTarget() {
        return this.linkTarget;
    }

    @Override
    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return this.hyperlinkParameters;
    }

    @Override
    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }

    @Override
    public Object clone() {
        JRBaseImage clone = (JRBaseImage)super.clone();
        clone.lineBox = this.lineBox.clone(clone);
        clone.hyperlinkParameters = (JRHyperlinkParameter[])JRCloneUtils.cloneArray((JRCloneable[])this.hyperlinkParameters);
        clone.expression = JRCloneUtils.nullSafeClone(this.expression);
        clone.anchorNameExpression = JRCloneUtils.nullSafeClone(this.anchorNameExpression);
        clone.hyperlinkReferenceExpression = JRCloneUtils.nullSafeClone(this.hyperlinkReferenceExpression);
        clone.hyperlinkWhenExpression = JRCloneUtils.nullSafeClone(this.hyperlinkWhenExpression);
        clone.hyperlinkAnchorExpression = JRCloneUtils.nullSafeClone(this.hyperlinkAnchorExpression);
        clone.hyperlinkPageExpression = JRCloneUtils.nullSafeClone(this.hyperlinkPageExpression);
        clone.hyperlinkTooltipExpression = JRCloneUtils.nullSafeClone(this.hyperlinkTooltipExpression);
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.horizontalAlignmentValue = HorizontalAlignEnum.getByValue(this.horizontalAlignment);
            this.verticalAlignmentValue = VerticalAlignEnum.getByValue(this.verticalAlignment);
            this.scaleImageValue = ScaleImageEnum.getByValue(this.scaleImage);
            this.onErrorTypeValue = OnErrorTypeEnum.getByValue(this.onErrorType);
            this.evaluationTimeValue = EvaluationTimeEnum.getByValue(this.evaluationTime);
            this.horizontalAlignment = null;
            this.verticalAlignment = null;
            this.scaleImage = null;
        }
        if (this.lineBox == null) {
            this.lineBox = new JRBaseLineBox(this);
            JRBoxUtil.setToBox(this.border, this.topBorder, this.leftBorder, this.bottomBorder, this.rightBorder, this.borderColor, this.topBorderColor, this.leftBorderColor, this.bottomBorderColor, this.rightBorderColor, this.padding, this.topPadding, this.leftPadding, this.bottomPadding, this.rightPadding, this.lineBox);
            this.border = null;
            this.topBorder = null;
            this.leftBorder = null;
            this.bottomBorder = null;
            this.rightBorder = null;
            this.borderColor = null;
            this.topBorderColor = null;
            this.leftBorderColor = null;
            this.bottomBorderColor = null;
            this.rightBorderColor = null;
            this.padding = null;
            this.topPadding = null;
            this.leftPadding = null;
            this.bottomPadding = null;
            this.rightPadding = null;
        }
        if (this.linkType == null) {
            this.linkType = JRHyperlinkHelper.getLinkType(HyperlinkTypeEnum.getByValue(this.hyperlinkType));
        }
        if (this.linkTarget == null) {
            this.linkTarget = JRHyperlinkHelper.getLinkTarget(HyperlinkTargetEnum.getByValue(this.hyperlinkTarget));
        }
    }
}

