/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.event;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.MethodNotFoundException;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;

public class MethodExpressionActionListener
implements ActionListener,
StateHolder {
    private static final Logger LOGGER = Logger.getLogger("javax.faces.event", "javax.faces.LogStrings");
    private MethodExpression methodExpressionOneArg = null;
    private MethodExpression methodExpressionZeroArg = null;
    private boolean isTransient;
    private static final Class[] ACTION_LISTENER_ZEROARG_SIG = new Class[0];

    public MethodExpressionActionListener() {
    }

    public MethodExpressionActionListener(MethodExpression methodExpressionOneArg) {
        this.methodExpressionOneArg = methodExpressionOneArg;
        FacesContext context = FacesContext.getCurrentInstance();
        ELContext elContext = context.getELContext();
        this.methodExpressionZeroArg = context.getApplication().getExpressionFactory().createMethodExpression(elContext, methodExpressionOneArg.getExpressionString(), Void.class, ACTION_LISTENER_ZEROARG_SIG);
    }

    public MethodExpressionActionListener(MethodExpression methodExpressionOneArg, MethodExpression methodExpressionZeroArg) {
        this.methodExpressionOneArg = methodExpressionOneArg;
        this.methodExpressionZeroArg = methodExpressionZeroArg;
    }

    public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
        Throwable cause = null;
        ELException thrown = null;
        if (actionEvent == null) {
            throw new NullPointerException();
        }
        FacesContext context = FacesContext.getCurrentInstance();
        ELContext elContext = context.getELContext();
        try {
            this.methodExpressionOneArg.invoke(elContext, new Object[]{actionEvent});
        }
        catch (MethodNotFoundException mnfe) {
            if (null != this.methodExpressionZeroArg) {
                try {
                    this.methodExpressionZeroArg.invoke(elContext, new Object[0]);
                }
                catch (ELException ee) {
                    cause = ee.getCause();
                    thrown = ee;
                }
            }
        }
        catch (ELException ee) {
            cause = ee.getCause();
            thrown = ee;
        }
        if (null != thrown) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "severe.event.exception_invoking_processaction", new Object[]{cause == null ? ((Object)((Object)thrown)).getClass().getName() : cause.getClass().getName(), this.methodExpressionOneArg.getExpressionString(), actionEvent.getComponent().getId()});
                StringWriter writer = new StringWriter(1024);
                if (cause == null) {
                    thrown.printStackTrace(new PrintWriter(writer));
                } else {
                    cause.printStackTrace(new PrintWriter(writer));
                }
                LOGGER.severe(writer.toString());
            }
            throw cause == null ? new AbortProcessingException(thrown.getMessage(), thrown) : new AbortProcessingException(thrown.getMessage(), cause);
        }
    }

    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        return new Object[]{this.methodExpressionOneArg, this.methodExpressionZeroArg};
    }

    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            return;
        }
        this.methodExpressionOneArg = (MethodExpression)((Object[])state)[0];
        this.methodExpressionZeroArg = (MethodExpression)((Object[])state)[1];
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean newTransientValue) {
        this.isTransient = newTransientValue;
    }
}

