/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.spi;

import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.MembersInjector;
import com.google.inject.Module;
import com.google.inject.PrivateBinder;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.internal.Maps;
import com.google.inject.internal.Preconditions;
import com.google.inject.spi.BindingScopingVisitor;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.ConstructorBinding;
import com.google.inject.spi.ConvertedConstantBinding;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.ExposedBinding;
import com.google.inject.spi.InjectionRequest;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.InterceptorBinding;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.MembersInjectorLookup;
import com.google.inject.spi.Message;
import com.google.inject.spi.PrivateElements;
import com.google.inject.spi.ProviderBinding;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderKeyBinding;
import com.google.inject.spi.ProviderLookup;
import com.google.inject.spi.ScopeBinding;
import com.google.inject.spi.StaticInjectionRequest;
import com.google.inject.spi.TypeConverterBinding;
import com.google.inject.spi.TypeListenerBinding;
import com.google.inject.spi.UntargettedBinding;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleWriter {
    private final Map<PrivateElements, PrivateBinder> environmentToBinder = Maps.newHashMap();

    public final Module create(final Iterable<? extends Element> elements) {
        return new Module(){

            public void configure(Binder binder) {
                ModuleWriter.this.apply(binder, elements);
            }
        };
    }

    public final void apply(final Binder binder, Iterable<? extends Element> elements) {
        Preconditions.checkNotNull(binder, "binder");
        Preconditions.checkNotNull(elements, "elements");
        ElementVisitor<Void> visitor = new ElementVisitor<Void>(){

            @Override
            public Void visit(Message message) {
                ModuleWriter.this.writeMessage(binder, message);
                return null;
            }

            @Override
            public Void visit(InterceptorBinding element) {
                ModuleWriter.this.writeBindInterceptor(binder, element);
                return null;
            }

            @Override
            public Void visit(ScopeBinding element) {
                ModuleWriter.this.writeBindScope(binder, element);
                return null;
            }

            @Override
            public Void visit(InjectionRequest element) {
                ModuleWriter.this.writeRequestInjection(binder, element);
                return null;
            }

            @Override
            public Void visit(StaticInjectionRequest element) {
                ModuleWriter.this.writeRequestStaticInjection(binder, element);
                return null;
            }

            @Override
            public Void visit(TypeConverterBinding element) {
                ModuleWriter.this.writeConvertToTypes(binder, element);
                return null;
            }

            @Override
            public <T> Void visit(Binding<T> element) {
                ModuleWriter.this.writeBind(binder, element);
                return null;
            }

            @Override
            public <T> Void visit(ProviderLookup<T> element) {
                ModuleWriter.this.writeGetProvider(binder, element);
                return null;
            }

            @Override
            public <T> Void visit(MembersInjectorLookup<T> element) {
                ModuleWriter.this.writeGetMembersInjector(binder, element);
                return null;
            }

            @Override
            public Void visit(TypeListenerBinding element) {
                ModuleWriter.this.writeBindListener(binder, element);
                return null;
            }

            @Override
            public Void visit(PrivateElements privateElements) {
                ModuleWriter.this.writePrivateElements(binder, privateElements);
                return null;
            }
        };
        for (Element element : elements) {
            element.acceptVisitor(visitor);
        }
    }

    protected void writeMessage(Binder binder, Message element) {
        binder.addError(element);
    }

    protected void writeBindInterceptor(Binder binder, InterceptorBinding element) {
        List<MethodInterceptor> interceptors = element.getInterceptors();
        binder.withSource(element.getSource()).bindInterceptor(element.getClassMatcher(), element.getMethodMatcher(), interceptors.toArray(new MethodInterceptor[interceptors.size()]));
    }

    protected void writeBindListener(Binder binder, TypeListenerBinding element) {
        binder.withSource(element.getSource()).bindListener(element.getTypeMatcher(), element.getListener());
    }

    protected void writeBindScope(Binder binder, ScopeBinding element) {
        binder.withSource(element.getSource()).bindScope(element.getAnnotationType(), element.getScope());
    }

    protected void writeRequestInjection(Binder binder, InjectionRequest element) {
        binder.withSource(element.getSource()).requestInjection(element.getInstance());
    }

    protected void writeRequestStaticInjection(Binder binder, StaticInjectionRequest element) {
        Class<?> type = element.getType();
        binder.withSource(element.getSource()).requestStaticInjection(type);
    }

    protected void writeConvertToTypes(Binder binder, TypeConverterBinding element) {
        binder.withSource(element.getSource()).convertToTypes(element.getTypeMatcher(), element.getTypeConverter());
    }

    protected <T> void writeBind(Binder binder, Binding<T> element) {
        ScopedBindingBuilder sbb = this.bindKeyToTarget(element, binder.withSource(element.getSource()), element.getKey());
        this.applyScoping(element, sbb);
    }

    protected void writePrivateElements(Binder binder, PrivateElements element) {
        PrivateBinder privateBinder = binder.withSource(element.getSource()).newPrivateBinder();
        this.setPrivateBinder(element, privateBinder);
        this.apply(privateBinder, element.getElements());
    }

    protected <T> ScopedBindingBuilder bindKeyToTarget(Binding<T> binding, final Binder binder, final Key<T> key) {
        return (ScopedBindingBuilder)binding.acceptTargetVisitor(new BindingTargetVisitor<T, ScopedBindingBuilder>(){

            @Override
            public ScopedBindingBuilder visit(InstanceBinding<? extends T> binding) {
                binder.bind(key).toInstance(binding.getInstance());
                return null;
            }

            @Override
            public ScopedBindingBuilder visit(ProviderInstanceBinding<? extends T> binding) {
                return binder.bind(key).toProvider(binding.getProviderInstance());
            }

            @Override
            public ScopedBindingBuilder visit(ProviderKeyBinding<? extends T> binding) {
                return binder.bind(key).toProvider(binding.getProviderKey());
            }

            @Override
            public ScopedBindingBuilder visit(LinkedKeyBinding<? extends T> binding) {
                return binder.bind(key).to(binding.getLinkedKey());
            }

            @Override
            public ScopedBindingBuilder visit(UntargettedBinding<? extends T> binding) {
                return binder.bind(key);
            }

            @Override
            public ScopedBindingBuilder visit(ExposedBinding<? extends T> binding) {
                PrivateBinder privateBinder = ModuleWriter.this.getPrivateBinder(binding.getPrivateElements());
                privateBinder.withSource(binding.getSource()).expose(key);
                return null;
            }

            @Override
            public ScopedBindingBuilder visit(ConvertedConstantBinding<? extends T> binding) {
                throw new IllegalArgumentException("Non-module element");
            }

            @Override
            public ScopedBindingBuilder visit(ConstructorBinding<? extends T> binding) {
                throw new IllegalArgumentException("Non-module element");
            }

            @Override
            public ScopedBindingBuilder visit(ProviderBinding<? extends T> binding) {
                throw new IllegalArgumentException("Non-module element");
            }
        });
    }

    protected void setPrivateBinder(PrivateElements privateElements, PrivateBinder binder) {
        Preconditions.checkArgument(!this.environmentToBinder.containsKey(privateElements), "A private binder already exists for %s", privateElements);
        this.environmentToBinder.put(privateElements, binder);
    }

    protected PrivateBinder getPrivateBinder(PrivateElements privateElements) {
        PrivateBinder privateBinder = this.environmentToBinder.get(privateElements);
        Preconditions.checkArgument(privateBinder != null, "No private binder for %s", privateElements);
        return privateBinder;
    }

    protected void applyScoping(Binding<?> binding, final ScopedBindingBuilder scopedBindingBuilder) {
        binding.acceptScopingVisitor(new BindingScopingVisitor<Void>(){

            @Override
            public Void visitEagerSingleton() {
                scopedBindingBuilder.asEagerSingleton();
                return null;
            }

            @Override
            public Void visitScope(Scope scope) {
                scopedBindingBuilder.in(scope);
                return null;
            }

            @Override
            public Void visitScopeAnnotation(Class<? extends Annotation> scopeAnnotation) {
                scopedBindingBuilder.in(scopeAnnotation);
                return null;
            }

            @Override
            public Void visitNoScoping() {
                return null;
            }
        });
    }

    protected <T> void writeGetProvider(Binder binder, ProviderLookup<T> element) {
        Provider<T> provider = binder.withSource(element.getSource()).getProvider(element.getKey());
        element.initializeDelegate(provider);
    }

    protected <T> void writeGetMembersInjector(Binder binder, MembersInjectorLookup<T> element) {
        MembersInjector<T> membersInjector = binder.withSource(element.getSource()).getMembersInjector(element.getType());
        element.initializeDelegate(membersInjector);
    }
}

