/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.taglibs.facelets;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringSecurityELLibrary {
    private static Set<String> parseAuthorities(String grantedRoles) {
        TreeSet<String> parsedAuthorities = new TreeSet<String>();
        if (grantedRoles == null || "".equals(grantedRoles.trim())) {
            return parsedAuthorities;
        }
        String[] parsedAuthoritiesArr = grantedRoles.contains(",") ? grantedRoles.split(",") : new String[]{grantedRoles};
        for (String auth : parsedAuthoritiesArr) {
            parsedAuthorities.add(auth.trim());
        }
        return parsedAuthorities;
    }

    private static GrantedAuthority[] getUserAuthorities() {
        if (SecurityContextHolder.getContext() == null) {
            System.out.println("security context is empty, this seems to be a bug/misconfiguration!");
            return new GrantedAuthority[0];
        }
        Authentication currentUser = SecurityContextHolder.getContext().getAuthentication();
        if (currentUser == null) {
            return new GrantedAuthority[0];
        }
        Collection authorities = currentUser.getAuthorities();
        if (authorities == null) {
            return new GrantedAuthority[0];
        }
        return authorities.toArray(new GrantedAuthority[0]);
    }

    public static boolean ifAnyGranted(String grantedRoles) {
        GrantedAuthority[] authorities;
        Set<String> parsedAuthorities = SpringSecurityELLibrary.parseAuthorities(grantedRoles);
        if (parsedAuthorities.isEmpty()) {
            return false;
        }
        for (GrantedAuthority authority : authorities = SpringSecurityELLibrary.getUserAuthorities()) {
            if (!parsedAuthorities.contains(authority.getAuthority())) continue;
            return true;
        }
        return false;
    }

    public static boolean ifAllGranted(String requiredRoles) {
        Set<String> requiredAuthorities = SpringSecurityELLibrary.parseAuthorities(requiredRoles);
        if (requiredAuthorities.isEmpty()) {
            return false;
        }
        GrantedAuthority[] authoritiesArray = SpringSecurityELLibrary.getUserAuthorities();
        TreeSet<String> grantedAuthorities = new TreeSet<String>();
        for (GrantedAuthority authority : authoritiesArray) {
            grantedAuthorities.add(authority.getAuthority());
        }
        for (String requiredAuthority : requiredAuthorities) {
            if (grantedAuthorities.contains(requiredAuthority)) continue;
            return false;
        }
        return true;
    }

    public static boolean ifNotGranted(String notGrantedRoles) {
        GrantedAuthority[] authorities;
        Set<String> parsedAuthorities = SpringSecurityELLibrary.parseAuthorities(notGrantedRoles);
        if (parsedAuthorities.isEmpty()) {
            return true;
        }
        for (GrantedAuthority authority : authorities = SpringSecurityELLibrary.getUserAuthorities()) {
            if (!parsedAuthorities.contains(authority.getAuthority())) continue;
            return false;
        }
        return true;
    }

    public static boolean isAuthenticated() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || authentication instanceof AnonymousAuthenticationToken) {
            return false;
        }
        return authentication.isAuthenticated();
    }

    public static boolean isAnonymous() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || authentication instanceof AnonymousAuthenticationToken) {
            return true;
        }
        return !authentication.isAuthenticated();
    }
}

