#!/bin/bash

script=$1
program=$2
resultsDir=$3

#echo "SCRIPT=$script"
#echo "PROGRAM=$program"

outdir="$resultsDir/"$(basename $script .sh)
mkdir -p $outdir
output=$outdir/$(basename $program .c)

if [ -e $output ] ; then
    if ! grep FAILURE $output > /dev/null ; then
#       echo "IGNORING $script $program"
       echo -n "."
       exit 0
    fi
fi

if [[ $script == *"merge"* ]] && [[ $program == *"indcall"* ]]; then
   echo "NOT_APPLICABLE $script $program => $output" | tee $output
   exit 0
fi

echo "TESTING $script $program => $output" | tee $output
$script $program >> $output 2>&1

egrep 'SUCCESS|FAILURE|NOT_APPLICABLE|NOT_IMPLEMENTED' $output
