#!/bin/bash

scriptsDir=$1
resultsDir=$2
xargs=$3

find $scriptsDir -name \*.sh > /tmp/scripts.txt
find generated/programs/*/* -name \*.c > /tmp/programs.txt

if [[ -n $xargs ]]
then
   $xargs -a /tmp/scripts.txt -a /tmp/programs.txt scripts/runTest.sh
else
   join -t" " -j 9999 -o 1.1,2.1 /tmp/scripts.txt /tmp/programs.txt > /tmp/tests.txt
   IFS=$'\n'
   for test in `cat /tmp/tests.txt`
   do
#      echo "RUNSCRIPTS=$test"
      IFS=" "
      args=($test)
#      echo "RUNSCRIPTS1=${args[0]}"
#      echo "RUNSCRIPTS2=${args[1]}"
      scripts/runTest.sh ${args[0]} ${args[1]} $resultsDir 
   done
fi
