#!/bin/bash

allowInlineAssembly=$1
outdir=$2

if [ "$allowInlineAssembly" == 0 ]; then
   singleTransforms=( \
      'antiAliasAnalysis1' \
      'virtualize1 switch' \
      'virtualize1 indirect' \
      'virtualize1 direct' \
      'flatten1 switch' \
      'flatten1 indirect' \
      'flatten1 goto' \
      'jit1' \
      'split1 top' \
      'split1 block' \
      'split1 deep' \
      'split1 recursive' \
      'split1 level' \
      'split1 inside' \
      'merge1 false goto' \
      'merge1 true switch' \
      'merge1 true goto' \
      'merge1 true indirect' \
      'merge2 compute' \
      'jitDynamic1 xtea' \
      'virtualize2 switch xtea' \
      'addopaque1 list call' \
      'addopaque1 list bug' \
      'addopaque1 list true' \
      'addopaque1 list junk' \
      'addopaque2 list' \
      'addopaque2 array' \
      'rndargs1' \
      'literals1' \
      'arithmetic1' \
   )
else
   singleTransforms=( \
      'antiAliasAnalysis1' \
      'antiBranchAnalysis1 branchFuns true' \
      'virtualize1 switch' \
      'virtualize1 indirect' \
      'virtualize1 direct' \
      'flatten1 switch' \
      'flatten1 indirect' \
      'flatten1 goto' \
      'jit1' \
      'split1 top' \
      'split1 block' \
      'split1 deep' \
      'split1 recursive' \
      'split1 level' \
      'split1 inside' \
      'merge1 false goto' \
      'merge1 true switch' \
      'merge1 true goto' \
      'merge1 true indirect' \
      'merge2 compute' \
      'jitDynamic1 xtea' \
      'virtualize2 switch xtea' \
      'addopaque1 list call' \
      'addopaque1 list bug' \
      'addopaque1 list true' \
      'addopaque1 list junk' \
      'addopaque2 list' \
      'addopaque2 array' \
      'rndargs1' \
      'literals1' \
      'arithmetic1' \
   )
fi

# This has multiple issues in MacOS/llvm, so we delete it for now:
#   'merge2 flag' \

mkdir -p $outdir

for ((i=0; i<${#singleTransforms[*]}; i++));
do
#      echo ${singleTransforms[i]}
      vals=( ${singleTransforms[i]} )
      inFile="t-patterns"/${vals[0]}".in"
      arg1=${vals[1]}
      arg2=${vals[2]}
      outFile="$outdir/${vals[0]}"
      if [ "$arg1" != "" ]; then
         outFile=${outFile}"_"${arg1}
      fi
      if [ "$arg2" != "" ]; then
         outFile=${outFile}"_"${arg2}
      fi
      outFile=${outFile}".in"
      echo ${outfile}
      sedScript="s/\${arg1}/$arg1/g;s/\${arg2}/$arg2/g"
      sed $sedScript $inFile > ${outFile}
done


