#!/bin/bash 

allowInlineAssembly=$1
patternsDir=$2
scriptsDir=$3

##############################################################################
# Generate the output script
##############################################################################
function generate() {
   name=$1
   file=$2
   init=$3

if egrep 'Transform=Jit|Transform=JitDynamic' $name > /dev/null ; then
   JIT="-DJIT=1"
else
   JIT=""
fi

cat > $file <<END
#!/bin/bash

input=\$1
debug=\$2

UNAME_S=\$(uname -s)
UNAME_M=\$(uname -m)

case "\$UNAME_M" in
   x86_64) 
      PROC="x86_64"
      ;;
   armv7*)
      PROC="armv7"
      ;;
   armv8*)
      PROC="armv8"
      ;;
   *) 
     echo "Unknown architecture \$UNAME_M"
     exit 1
esac

if [ "\$UNAME_S" = "Linux" ]; then
   ENV=\${PROC}:\${UNAME_S}:Gcc:4.6
else
   ENV=\${PROC}:\${UNAME_S}:Clang:5.1
fi

output=\$(basename \$input .c)"-obf.c"
exe=\$(basename \$input .c)"-obf.exe"
if [ "\$debug" = "" ]; then
   exe="/tmp/"\${exe}
   output="/tmp/"\${output}
fi
seed=\$RANDOM
echo "============================================================"
echo "= $name"
echo "= RUNNING TIGRESS"
#$JITTEST
tigressout=/tmp/tigout.\$\$
timeout 120s tigress \
   -Wno-builtin-requires-header -fgnu89-inline --Verbosity=1 --Seed=\$seed ${JIT} --Environment=\${ENV} \\
   $(printf '%s\n' "`cat $init`")
   $(printf '%s\n' "`cat $name`")
   --out=\$output \$input  2> >(tee \$tigressout)
if [ \$? -eq 124 ]; then
   echo "TIMEOUT-TIGRESS"  2> >(tee \$tigressout)
   exit 0
fi
echo "= DONE RUNNING TIGRESS"

if grep "Transformation not possible" \$tigressout > /dev/null; then
   echo "NOT_APPLICABLE"
   exit 0
fi

if grep "Not yet implemented" \$tigressout > /dev/null; then
   echo "NOT_IMPLEMENTED"
   exit 0
fi

echo "= COMPILING"
timeout 30s gcc -g -o \$exe \$output -lm
if [ \$? -eq 124 ]; then
   echo "TIMEOUT-GCC"
   exit 0
fi
echo "= DONE COMPILING"

echo "= EXECUTING"
exeout=/tmp/exeout.\$\$
timeout 30s \$exe | tee \$exeout
if [ \$? -eq 124 ]; then
   echo TIMEOUT >> \$exeout
fi
echo "= DONE EXECUTING"
if ! egrep 'SUCCESS|FAILURE|UNIMPLEMENTED|NOT_APPLICABLE' \$exeout > /dev/null ; then
   echo "FAILURE"
   exit 0
fi
echo "============================================================"
if [ "\$debug" = "" ]; then
   /bin/rm \$exe \$output \$exeout
fi
exit 0
END
   chmod a+rx $file
}

mkdir -p $scriptsDir

for infile in `ls $patternsDir/*.in`
do
   infile1=`basename $infile .in`
   filename="$scriptsDir/${infile1}.sh"

   if [ $allowInlineAssembly == 1 ]; then
      init="t-patterns/init1.in"
   else
      init="t-patterns/init1-noAsm.in"
   fi
   generate $infile $filename $init
done


