#!/bin/bash

allowInlineAssembly=$1
outdir=$2

if [ "$allowInlineAssembly" == 0 ]; then
   singleTransforms=( \
      'antiBranchAnalysis1 branchFuns true' \
      'virtualize1 indirect' \
      'flatten1 goto' \
      'jit1' \
      'split1 block' \
      'jitDynamic1 xtea' \
      'virtualize2 switch xtea' \
      'addopaque1 list,array call,bug,true,junk' \
      'rndargs1' \
      'literals1' \
      'arithmetic1' \
      'antiAliasAnalysis1' \
      'merge1 true goto' \
   )
else
   singleTransforms=( \
      'virtualize1 indirect' \
      'flatten1 goto' \
      'jit1' \
      'split1 block' \
      'jitDynamic1 xtea' \
      'virtualize2 switch xtea' \
      'addopaque1 list,array call,bug,true,junk' \
      'rndargs1' \
      'literals1' \
      'arithmetic1' \
      'antiAliasAnalysis1' \
      'merge1 true goto' \
   )
fi

mkdir -p $outdir

for ((i=0; i<${#singleTransforms[*]}; i++));
do
   vals1=( ${singleTransforms[i]} )
   if [ ${vals1[0]} == "antiAliasAnalysis1" ] || [ ${vals1[0]} == "merge1" ]; then
      continue;
   fi
   inFile1="t-patterns"/${vals1[0]}".in"
   arg11=${vals1[1]}
   arg12=${vals1[2]}
   outFile1="$outdir/${vals1[0]}"
   if [ "$arg11" != "" ]; then
      outFile1=${outFile1}"_"${arg11}
   fi
   if [ "$arg12" != "" ]; then
      outFile1=${outFile1}"_"${arg12}
   fi
   for ((j=0; j<${#singleTransforms[*]}; j++));
   do
      vals2=( ${singleTransforms[j]} )
      inFile2="t-patterns"/${vals2[0]}".in"
      arg21=${vals2[1]}
      arg22=${vals2[2]}
      outFile2="${outFile1}-${vals2[0]}"
      if [ "$arg21" != "" ]; then
         outFile2=${outFile2}"_"${arg21}
      fi
      if [ "$arg22" != "" ]; then
         outFile2=${outFile2}"_"${arg22}
      fi
      outFile2="${outFile2}.in"
#      echo ${outFile2}
#      printf "'%s'\n" "${outfile2}"
      sedScript1="s/\${arg1}/$arg11/g;s/\${arg2}/$arg12/g"
      sedScript2="s/\${arg1}/$arg21/g;s/\${arg2}/$arg22/g"
      sed $sedScript1 $inFile1 > /tmp/infile1.in
      sed $sedScript2 $inFile2 > /tmp/infile2.in
      cat /tmp/infile1.in /tmp/infile2.in > ${outFile2}
   done
done


