
intTypes[0]="unsigned char"
intValues[0]="0 1 2 127 128 129 UCHAR_MAX"
intArithValues[0]="22 10"

intTypes[1]="signed char"
intValues[1]="0 1 67 -69 SCHAR_MIN SCHAR_MAX"
intArithValues[1]="12 -10"
 
intTypes[2]="signed short"
intValues[2]="0 -1 1 2 1024 SHRT_MIN SHRT_MAX"
intArithValues[2]="420 -10"

intTypes[3]="unsigned short"
intValues[3]="0 1 2 1024 USHRT_MAX"
intArithValues[3]="220 100"

intTypes[4]="signed int"
intValues[4]="0 -1 1 2 1024 27562478 INT_MIN INT_MAX"
intArithValues[4]="42001 -101"

intTypes[5]="unsigned int"
intValues[5]="0x00000000 0x00000001 0x555a786c 0xfffffff UINT_MAX"
intArithValues[5]="0x5a786 0x42"

#intTypes[6]="signed long"
#intValues[6]="0 -1 1 2 1024 27562478 LONG_MIN LONG_MAX"
#intArithValues[6]="27569762478 -42"
#
#intTypes[7]="unsigned long"
#intValues[7]="0x000000000000000 0x000000000000001 0xf096ab6c8d01456 0xfffffffffffffff ULONG_MAX"
#intArithValues[7]="0xf096b6d0156 0x424"

intTypes[6]="signed long long"
intValues[6]="0 -1 1 2 1024 27562478 LLONG_MIN LLONG_MAX"
intArithValues[6]="27569762478 -42"

intTypes[7]="unsigned long long"
intValues[7]="0x000000000000000 0x000000000000001 0xf096ab6c8d01456 0xfffffffffffffff ULLONG_MAX"
intArithValues[7]="0xf096b6d0156 0x424"

floatTypes[0]="float"
floatValues[0]="2.0f 42.0f -1024.0f 7981324.0f"
floatArithValues[0]="59762.0f -42.0f"

floatTypes[1]="double"
floatValues[1]="2.0 42.0 -1024.0 23423746237462.0"
floatArithValues[1]="59898798762.0 -420.0"

output=../../generated/programs/$(basename $(pwd))
mkdir -p $output

function copyInFile() {
   /bin/cp $1.in $output
}

function for_intTypes_and_arithOps_do() {
   name=$1
   copyInFile ${name}
   for ((i=0; i<${#intTypes[*]}; i++));
   do
      ops=("+" "-" "*" "/" "%" "<<" ">>")
      for ((j=0; j<${#ops[*]}; j++));
      do
         ((number++))
         type=${intTypes[i]} 
         vals=( ${intArithValues[i]} )
         left=${vals[0]}
         right=${vals[1]}
         op=${ops[j]}
         if [ "$op" == "<<" ] || [ "$op" == ">>" ]; then
            right=3
         fi
         file=${output}/${name}_${number}.c
cat > $file <<- END
#define NAME "$file"
#define TYPE $type
#define RESTYPE $type
#define OP $op
#define LEFT $left
#define RIGHT $right 
#include "$name.in"
END
      done
   done
}

function for_intTypes_and_cmpOps_do() {
   name=$1
   copyInFile ${name}
   for ((i=0; i<${#intTypes[*]}; i++));
   do
      ops=("<" ">" "==" "<=" ">=" "!=")
      for ((j=0; j<${#ops[*]}; j++));
      do
         ((number++))
         type=${intTypes[i]} 
         vals=( ${intArithValues[i]} )
         left=${vals[0]}
         right=${vals[1]}
         op=${ops[j]}
         file=${output}/${name}_${number}.c
cat > $file <<- END
#define NAME "$file"
#define TYPE $type
#define RESTYPE int
#define OP $op
#define LEFT $left
#define RIGHT $right 
#include "$name.in"
END
      done
   done
}

function for_floatTypes_and_arithOps_do() {
   name=$1
   copyInFile ${name}
   for ((i=0; i<${#floatTypes[*]}; i++));
   do
      ops=("+" "-" "*" "/")
      for ((j=0; j<${#ops[*]}; j++));
      do
         ((number++))
         type=${floatTypes[i]} 
         vals=( ${floatArithValues[i]} )
         left=${vals[0]}
         right=${vals[1]}
         op=${ops[j]}
         file=${output}/${name}_${number}.c
cat > $file <<- END
#define NAME "$file"
#define TYPE $type
#define RESTYPE $type
#define OP $op
#define LEFT $left
#define RIGHT $right 
#include "$name.in"
END
      done
   done
}

function for_floatTypes_and_cmpOps_do() {
   name=$1
   copyInFile ${name}
   for ((i=0; i<${#floatTypes[*]}; i++));
   do
      ops=("<" ">" "==" "<=" ">=" "!=")
      for ((j=0; j<${#ops[*]}; j++));
      do
         ((number++))
         type=${floatTypes[i]} 
         vals=( ${floatArithValues[i]} )
         left=${vals[0]}
         right=${vals[1]}
         op=${ops[j]}
         file=${output}/${name}_${number}.c
cat > $file <<- END
#define NAME "$file"
#define TYPE $type
#define RESTYPE int
#define OP $op
#define LEFT $left
#define RIGHT $right 
#include "$name.in"
END
      done
   done
}

function for_intTypes_and_unaryArithOps_do() {
   name=$1
   copyInFile ${name}
   for ((i=0; i<${#intTypes[*]}; i++));
   do
      ops=("~" "!" "-")
      for ((j=0; j<${#ops[*]}; j++));
      do
         ((number++))
         type=${intTypes[i]} 
         vals=( ${intArithValues[i]} )
         right=${vals[0]}
         op=${ops[j]}
         if [[ "$type" =~ .*unsigned.* ]]; then
             right=`echo "-" $right`
         fi
         file=${output}/${name}_${number}.c
cat > $file <<- END
#define NAME "$file"
#define TYPE $type
#define RESTYPE $type
#define OP $op
#define RIGHT $right 
#include "$name.in"
END
      done
   done
}

function for_intTypes_do() {
   name=$1
   copyInFile ${name}
   for ((i=0; i<${#intTypes[*]}; i++));
   do
         ((number++))
         type=${intTypes[i]} 
         vals=( ${intArithValues[i]} )
         left=${vals[0]}
         right=${vals[1]}
         file=${output}/${name}_${number}.c
#echo "for_intTypes_do: $type $left $right"
cat > $file <<- END
#define NAME "$file"
#define TYPE $type
#define LEFT $left
#define RIGHT $right
#include "$name.in"
END
   done
}

function for_floatTypes_do() {
   name=$1
   copyInFile ${name}
   for ((i=0; i<${#floatTypes[*]}; i++));
   do
         ((number++))
         type=${floatTypes[i]} 
         vals=( ${floatArithValues[i]} )
         left=${vals[0]}
         right=${vals[1]}
         file=${output}/${name}_${number}.c
cat > $file <<- END
#define NAME "$file"
#define TYPE $type
#define LEFT $left
#define RIGHT $right
#include "$name.in"
END
   done
}

function for_intTypes_and_intTypes_do() {
   name=$1
   copyInFile ${name}
   for ((i=0; i<${#intTypes[*]}; i++));
   do
      for ((j=0; j<${#intTypes[*]}; j++));
      do
         if [ $i != $j ]; then
            ((number++))
            restype=${intTypes[i]} 
            type=${intTypes[j]} 
            lvals=( ${intArithValues[j]} )
            left=${lvals[0]}
            rvals=( ${intArithValues[i]} )
            right=${rvals[0]}
            file=${output}/${name}_${number}.c
cat > $file <<- END
#define NAME "$file"
#define TYPE $type
#define RESTYPE $restype
#define LEFT $left
#define RIGHT $right
#include "$name.in"
END
         fi
      done
   done
}

function for_intTypes_and_floatTypes_do() {
   name=$1
   copyInFile ${name}
   for ((i=0; i<${#intTypes[*]}; i++));
   do
      for ((j=0; j<${#floatTypes[*]}; j++));
      do
         if [ $i != $j ]; then
            ((number++))
            restype=${intTypes[i]} 
            type=${floatTypes[j]} 
            vals=( ${floatValues[j]} )
            left=${vals[0]}
            file=${output}/${name}_${number}.c
cat > $file <<- END
#define NAME "$file"
#define TYPE $type
#define RESTYPE $restype
#define LEFT $left
#include "$name.in"
END
         fi
      done
   done
}

function for_floatTypes_and_intTypes_do() {
   name=$1
   copyInFile ${name}
   for ((i=0; i<${#floatTypes[*]}; i++));
   do
      for ((j=0; j<${#intTypes[*]}; j++));
      do
         if [ $i != $j ]; then
            ((number++))
            restype=${floatTypes[i]} 
            type=${intTypes[j]} 
            vals=( ${intValues[j]} )
            left=${vals[0]}
            file=${output}/${name}_${number}.c
cat > $file <<- END
#define NAME "$file"
#define TYPE $type
#define RESTYPE $restype
#define LEFT $left
#include "$name.in"
END
         fi
      done
   done
}

function for_intTypes_and_values_do() {
   name=$1
   copyInFile ${name}
   for ((i=0; i<${#intTypes[*]}; i++));
   do
      type=${intTypes[i]}
      vals=( ${intValues[i]} )
      for ((j=0; j<${#vals[*]}; j++));
      do
         ((number++))
         value=${vals[j]}
         file=${output}/${name}_${number}.c 
cat > $file <<- END
#define NAME "$file"
#define TYPE $type
#define LEFT $value
#include "$name.in"
END
      done
   done
}

function for_floatTypes_and_values_do() {
   name=$1
   copyInFile ${name}
   for ((i=0; i<${#floatTypes[*]}; i++));
   do
      type=${floatTypes[i]}
      vals=( ${floatValues[i]} )
      for ((j=0; j<${#vals[*]}; j++));
      do
         ((number++))
         value=${vals[j]}
         file=${output}/${name}_${number}.c 
cat > $file <<- END
#define NAME "$file"
#define TYPE $type
#define LEFT $value
#include "$name.in"
END
      done
   done
}

function for_single_do() {
   ((number++))
   name=$1
   copyInFile ${name}
   file=${output}/${name}_${number}.c 
cat > $file <<- END
#define NAME "$file"
#include "$name.in"
END
}

function for_enumType_do() {
   name=$1
   copyInFile ${name}
   ((number++))
   file=${output}/${name}_${number}.c
cat > $file <<- END
enum etype {enum1,enum2};
#define NAME "$file"
#define TYPE enum etype
#define LEFT enum1
#define RIGHT enum2
#include "$name.in"
END
}

function for_typedefType_do() {
   name=$1
   copyInFile ${name}
   ((number++))
   file=${output}/${name}_${number}.c
cat > $file <<- END
typedef enum etype {enum1,enum2} edef;
#define NAME "$file"
#define TYPE edef
#define LEFT enum1
#define RIGHT enum2
#include "$name.in"
END
}


##################################################################
# Test with gcc
##################################################################
function execute() {
   for f in $output/*.c; do 
#      echo "EXECUTING $f"
      gcc -o exe $f -lm
      ./exe
   done
}
