#!/bin/bash 

/bin/rm -f *.c exe

source "../types.sh"

number=0

##################################################################
# void foo(TYPE x)
##################################################################

function generateTrueRange () {
   op=$1
   local right="XXX"
   case $op in
     "<") right="(LEFT+1)" 
          ;;
     "<=") right="(LEFT+1)" 
          ;;
     ">=") right="(LEFT-1)" 
          ;;
     ">") right="(LEFT-1)" 
          ;;
     "==") right="LEFT" 
          ;;
     "!=") right="(LEFT+1)" 
          ;;
   esac
   echo $right
}

function generateIncrement () {
   op=$1
   local incr="XXX"
   case $op in
     "<") incr="++" 
          ;;
     "<=") incr="++" 
          ;;
     ">=") incr="--" 
          ;;
     ">") incr="--" 
          ;;
     "==") incr="++" 
          ;;
     "!=") incr="++" 
          ;;
   esac
   echo $incr
}

function forAllIntTypes1() {
   name=$1
   copyInFile ${name}
   for ((i=0; i<${#intTypes[*]}; i++));
   do
      ops=("<" ">" "==" "<=" ">=" "!=")
      for ((j=0; j<${#ops[*]}; j++));
      do
         ((number++))
         type=${intTypes[i]} 
         vals=( ${intArithValues[i]} )
         left=${vals[0]}
         op=${ops[j]}
         right=`generateTrueRange $op`
         incr=`generateIncrement $op`
         file=${output}/${name}_${number}.c
cat > $file <<- END
#define NAME "$file"
#define TYPE $type
#define OP $op
#define INCR $incr
#define LEFT $left
#define RIGHT $right 
#include "$name.in"
END
      done
   done
}

function forAllFloatTypes1() {
   name=$1
   copyInFile ${name}
   for ((i=0; i<${#floatTypes[*]}; i++));
   do
      ops=("<" ">" "==" "<=" ">=" "!=")
      for ((j=0; j<${#ops[*]}; j++));
      do
         ((number++))
         type=${floatTypes[i]} 
         vals=( ${floatArithValues[i]} )
         left=${vals[0]}
         op=${ops[j]}
         right=`generateTrueRange $op`
         incr=`generateIncrement $op`
         file=${output}/${name}_${number}.c
cat > $file <<- END
#define NAME "$file"
#define TYPE $type
#define OP $op
#define INCR $incr
#define LEFT $left
#define RIGHT $right 
#include "$name.in"
END
      done
   done
}

##################################################################
# generate C programs
##################################################################
function generate() {
   forAllIntTypes1 if1
   forAllFloatTypes1 if1
   for_intTypes_do if2
   forAllFloatTypes1 if2
   forAllIntTypes1 while1
   forAllFloatTypes1 while1
   forAllIntTypes1 for1
   forAllFloatTypes1 for1
   for_intTypes_do switch1
   for_intTypes_do switch2
   for_intTypes_do switch3
   for_enumType_do switch1
   for_enumType_do switch2
   for_enumType_do switch3
   for_typedefType_do switch1
   for_typedefType_do switch2
   for_typedefType_do switch3
   for_single_do break1
   for_single_do continue1
   for_single_do goto1
   for_single_do goto2
   for_single_do goto3
   for_single_do goto4
   for_single_do if3
   forAllIntTypes1 do1
   for_intTypes_do ternary1
   for_floatTypes_do ternary1
   for_single_do and1
   for_single_do or1
   for_single_do not1
}

##################################################################
# main()
##################################################################
function main() {
   generate
   execute
}

##################################################################
# run
##################################################################
main
exit 0
