#  This repository is to collect BERT related resources. 

AD:  a repository for graph convolutional networks at https://github.com/Jiakui/awesome-gcn (resources for graph convolutional networks  （图卷积神经网络相关资源）). 


# Papers: 

1. [arXiv:1810.04805](https://arxiv.org/abs/1810.04805), BERT: Pre-training of Deep Bidirectional Transformers for Language Understanding
, Authors: Jacob Devlin, Ming-Wei Chang, Kenton Lee, Kristina Toutanova

<details>

<summary><b> Click to see more </b></summary>

2. [arXiv:1812.06705](https://arxiv.org/abs/1812.06705), Conditional BERT Contextual Augmentation, Authors: Xing Wu, Shangwen Lv, Liangjun Zang, Jizhong Han, Songlin Hu

3. [arXiv:1812.03593](https://arxiv.org/pdf/1812.03593), SDNet: Contextualized Attention-based Deep Network for Conversational Question Answering, Authors: Chenguang Zhu, Michael Zeng, Xuedong Huang

4. [arXiv:1901.02860](https://arxiv.org/abs/1901.02860), Transformer-XL: Attentive Language Models Beyond a Fixed-Length Context,  Authors: Zihang Dai, Zhilin Yang, Yiming Yang, William W. Cohen, Jaime Carbonell, Quoc V. Le and Ruslan Salakhutdinov.

5. [arXiv:1901.04085](https://arxiv.org/pdf/1901.04085.pdf), Passage Re-ranking with BERT, Authors: Rodrigo Nogueira, Kyunghyun Cho

6. [arXiv:1902.02671](https://arxiv.org/pdf/1902.02671.pdf), BERT and PALs: Projected Attention Layers for Efficient Adaptation in Multi-Task Learning, Authors: Asa Cooper Stickland, Iain Murray

7. [arXiv:1904.02232](https://arxiv.org/abs/1904.02232), BERT Post-Training for Review Reading Comprehension and Aspect-based Sentiment Analysis, Authors: Hu Xu, Bing Liu, Lei Shu, Philip S. Yu, [[code](https://github.com/howardhsu/BERT-for-RRC-ABSA)]

</details>




# Github Repositories: 

## official implement:

1.  [google-research/bert](https://github.com/google-research/bert),  **officical** TensorFlow code and pre-trained models for BERT ,
![](https://img.shields.io/github/stars/google-research/bert.svg)


## implement of BERT besides tensorflow: 




1. [codertimo/BERT-pytorch](https://github.com/codertimo/BERT-pytorch),   Google AI 2018 BERT pytorch implementation,
![](https://img.shields.io/github/stars/codertimo/BERT-pytorch.svg)

2. [huggingface/pytorch-pretrained-BERT](https://github.com/huggingface/pytorch-pretrained-BERT),   A PyTorch implementation of Google AI's BERT model with script to load Google's pre-trained models,
![](https://img.shields.io/github/stars/huggingface/pytorch-pretrained-BERT.svg)



3. [dmlc/gluon-nlp](https://github.com/dmlc/gluon-nlp), Gluon + MXNet implementation that reproduces BERT pretraining and finetuning on GLUE benchmark, SQuAD, etc,
![](https://img.shields.io/github/stars/dmlc/gluon-nlp.svg)

4. [dbiir/UER-py](https://github.com/dbiir/UER-py),  UER-py is a toolkit for pre-training on general-domain corpus and fine-tuning on downstream task. UER-py maintains model modularity and supports research extensibility. It facilitates the use of different pre-training models (e.g. BERT), and provides interfaces for users to further extend upon.  
![](https://img.shields.io/github/stars/dbiir/UER-py.svg)


5. [BrikerMan/Kashgari](https://github.com/BrikerMan/Kashgari), Simple, Keras-powered multilingual NLP framework, allows you to build your models in 5 minutes for named entity recognition (NER), part-of-speech tagging (PoS) and text classification tasks. Includes BERT, GPT-2 and word2vec embedding. 
![](https://img.shields.io/github/stars/BrikerMan/Kashgari.svg)

6. [kaushaltrivedi/fast-bert](https://github.com/kaushaltrivedi/fast-bert), Super easy library for BERT based NLP models, 
![](https://img.shields.io/github/stars/kaushaltrivedi/fast-bert.svg)




<details>
 
<summary><b> Click to see more </b></summary>


7. [Separius/BERT-keras](https://github.com/Separius/BERT-keras), Keras implementation of BERT with pre-trained weights, 
![](https://img.shields.io/github/stars/Separius/BERT-keras.svg)

8. [soskek/bert-chainer](https://github.com/soskek/bert-chainer),  Chainer implementation of "BERT: Pre-training of Deep Bidirectional Transformers for Language Understanding",
![](https://img.shields.io/github/stars/soskek/bert-chainer.svg)

9. [innodatalabs/tbert](https://github.com/innodatalabs/tbert), PyTorch port of BERT ML model
![](https://img.shields.io/github/stars/innodatalabs/tbert.svg)

10. [guotong1988/BERT-tensorflow](https://github.com/guotong1988/BERT-tensorflow), BERT: Pre-training of Deep Bidirectional Transformers for Language Understanding
![](https://img.shields.io/github/stars/guotong1988/BERT-tensorflow.svg)

11. [dreamgonfly/BERT-pytorch](https://github.com/dreamgonfly/BERT-pytorch), 
PyTorch implementation of BERT in "BERT: Pre-training of Deep Bidirectional Transformers for Language Understanding" 
![](https://img.shields.io/github/stars/dreamgonfly/BERT-pytorch.svg)

12. [CyberZHG/keras-bert](https://github.com/CyberZHG/keras-bert), Implementation of BERT that could load official pre-trained models for feature extraction and prediction
![](https://img.shields.io/github/stars/CyberZHG/keras-bert.svg)

13. [soskek/bert-chainer](https://github.com/soskek/bert-chainer), Chainer implementation of "BERT: Pre-training of Deep Bidirectional Transformers for Language Understanding"
![](https://img.shields.io/github/stars/soskek/bert-chainer.svg)

14. [MaZhiyuanBUAA/bert-tf1.4.0](https://github.com/MaZhiyuanBUAA/bert-tf1.4.0), bert-tf1.4.0
![](https://img.shields.io/github/stars/MaZhiyuanBUAA/bert-tf1.4.0.svg)

15. [dhlee347/pytorchic-bert](https://github.com/dhlee347/pytorchic-bert), Pytorch Implementation of Google BERT,
![](https://img.shields.io/github/stars/dhlee347/pytorchic-bert.svg)

16. [kpot/keras-transformer](https://github.com/kpot/keras-transformer), Keras library for building (Universal) Transformers, facilitating BERT and GPT models,
![](https://img.shields.io/github/stars/kpot/keras-transformer.svg)

17. [miroozyx/BERT_with_keras](https://github.com/miroozyx/BERT_with_keras), A Keras version of Google's BERT model,
![](https://img.shields.io/github/stars/miroozyx/BERT_with_keras.svg)

18. [conda-forge/pytorch-pretrained-bert-feedstock](https://github.com/conda-forge/pytorch-pretrained-bert-feedstock), A conda-smithy repository for pytorch-pretrained-bert. ,
![](https://img.shields.io/github/stars/conda-forge/pytorch-pretrained-bert-feedstock.svg)


19. [Rshcaroline/BERT_Pytorch_fastNLP](https://github.com/Rshcaroline/BERT_Pytorch_fastNLP), A PyTorch & fastNLP implementation of Google AI's BERT model.
![](https://img.shields.io/github/stars/Rshcaroline/BERT_Pytorch_fastNLP.svg)

20. [nghuyong/ERNIE-Pytorch](https://github.com/nghuyong/ERNIE-Pytorch), ERNIE Pytorch Version,
![](https://img.shields.io/github/stars/nghuyong/ERNIE-Pytorch.svg)

</details>



##  Pretrained BERT weights: 
1. [brightmart/roberta_zh](https://github.com/brightmart/roberta_zh), RoBERTa for Chinese, 中文预训练RoBERTa模型, 
![](https://img.shields.io/github/stars/brightmart/roberta_zh.svg)

2. [ymcui/Chinese-BERT-wwm](https://github.com/ymcui/Chinese-BERT-wwm), Pre-Training with Whole Word Masking for Chinese BERT（中文BERT-wwm预训练模型） https://arxiv.org/abs/1906.08101, 
![](https://img.shields.io/github/stars/ymcui/Chinese-BERT-wwm.svg)

3. [thunlp/OpenCLaP](https://github.com/thunlp/OpenCLaP),Open Chinese Language Pre-trained Model Zoo, OpenCLaP：多领域开源中文预训练语言模型仓库, 
![](https://img.shields.io/github/stars/thunlp/OpenCLaP.svg)

4. [ymcui/Chinese-PreTrained-XLNet](https://github.com/ymcui/Chinese-PreTrained-XLNet), Pre-Trained Chinese XLNet（中文XLNet预训练模型）, 
![](https://img.shields.io/github/stars/ymcui/Chinese-PreTrained-XLNet.svg)

5. [brightmart/xlnet_zh](https://github.com/brightmart/xlnet_zh), 中文预训练XLNet模型: Pre-Trained Chinese XLNet_Large, 
![](https://img.shields.io/github/stars/brightmart/xlnet_zh.svg)


## improvement over BERT:
1. [thunlp/ERNIE](https://github.com/https://github.com/thunlp/ERNIE), Source code and dataset for ACL 2019 paper "ERNIE: Enhanced Language Representation with Informative Entities", imporove bert with heterogeneous information fusion. 
![](https://img.shields.io/github/stars/thunlp/ERNIE.svg)

2. [PaddlePaddle/LARK](https://github.com/PaddlePaddle/LARK),  LAnguage Representations Kit, PaddlePaddle implementation of BERT. It also contains an improved version of BERT, ERNIE, for chinese NLP tasks.  BERT 的中文改进版 ERNIE, 
![](https://img.shields.io/github/stars/PaddlePaddle/LARK.svg)
 
3. [zihangdai/xlnet](https://github.com/zihangdai/xlnet), XLNet: Generalized Autoregressive Pretraining for Language Understanding, 
![](https://img.shields.io/github/stars/zihangdai/xlnet.svg)

4. [kimiyoung/transformer-xl](https://github.com/kimiyoung/transformer-xl), Transformer-XL: Attentive Language Models Beyond a Fixed-Length Context, This repository contains the code in both PyTorch and TensorFlow for our paper. 
![](https://img.shields.io/github/stars/kimiyoung/transformer-xl.svg)

5. [GaoPeng97/transformer-xl-chinese](https://github.com/GaoPeng97/transformer-xl-chinese), transformer xl在中文文本生成上的尝试。（transformer xl for text generation of chinese）, 
![](https://img.shields.io/github/stars/GaoPeng97/transformer-xl-chinese.svg)

6. [PaddlePaddle/ERNIE](https://github.com/PaddlePaddle/ERNIE),  An Implementation of ERNIE For Language Understanding (including Pre-training models and Fine-tuning tools)  BERT 的中文改进版 ERNIE, 
![](https://img.shields.io/github/stars/PaddlePaddle/ERNIE.svg)

7. [pytorch/fairseq](https://github.com/pytorch/fairseq),  Facebook AI Research Sequence-to-Sequence Toolkit written in Python. RoBERTa: A Robustly Optimized BERT Pretraining Approach, 
![](https://img.shields.io/github/stars/pytorch/fairseq.svg)


8. [facebookresearch/SpanBERT](https://github.com/facebookresearch/SpanBERT), Code for using and evaluating SpanBERT.
, This repository contains code and models for the paper: SpanBERT: Improving Pre-training by Representing and Predicting Spans., 
![](https://img.shields.io/github/stars/facebookresearch/SpanBERT.svg)

9. [brightmart/albert_zh](https://github.com/brightmart/albert_zh), 海量中文预训练ALBERT模型, A LITE BERT FOR SELF-SUPERVISED LEARNING OF LANGUAGE REPRESENTATIONS https://arxiv.org/pdf/1909.11942.pdf, 
![](https://img.shields.io/github/stars/brightmart/albert_zh.svg)

10. [lonePatient/albert_pytorch](https://github.com/lonePatient/albert_pytorch), A Lite Bert For Self-Supervised Learning Language Representations, 
![](https://img.shields.io/github/stars/lonePatient/albert_pytorch.svg)


11. [kpe/bert-for-tf2](https://github.com/kpe/bert-for-tf2), A Keras TensorFlow 2.0 implementation of BERT, ALBERT and adapter-BERT. https://github.com/kpe/bert-for-tf2, 
![](https://img.shields.io/github/stars/kpe/bert-for-tf2.svg)



## other resources for BERT: 

1. [brightmart/bert_language_understanding](https://github.com/brightmart/bert_language_understanding), Pre-training of Deep Bidirectional Transformers for Language Understanding: pre-train TextCNN,
![](https://img.shields.io/github/stars/brightmart/bert_language_understanding.svg)

2. [Y1ran/NLP-BERT--ChineseVersion](https://github.com/Y1ran/NLP-BERT--ChineseVersion), 谷歌自然语言处理模型BERT：论文解析与python代码,
![](https://img.shields.io/github/stars/Y1ran/NLP-BERT--ChineseVersion.svg)

<details>
 
<summary><b> Click to see more </b></summary>


3. [yangbisheng2009/cn-bert](https://github.com/yangbisheng2009/cn-bert), BERT在中文NLP的应用, 语法检查
![](https://img.shields.io/github/stars/yangbisheng2009/cn-bert.svg)

4. [JayYip/bert-multiple-gpu](https://github.com/JayYip/bert-multiple-gpu), A multiple GPU support version of BERT,
![](https://img.shields.io/github/stars/JayYip/bert-multiple-gpu.svg)

5. [HighCWu/keras-bert-tpu](https://github.com/HighCWu/keras-bert-tpu), Implementation of BERT that could load official pre-trained models for feature extraction and prediction on TPU, 
![](https://img.shields.io/github/stars/HighCWu/keras-bert-tpu.svg)

6. [Willyoung2017/Bert_Attempt](https://github.com/Willyoung2017/Bert_Attempt), PyTorch Pretrained Bert,
![](https://img.shields.io/github/stars/Willyoung2017/Bert_Attempt.svg)

7. [Pydataman/bert_examples](https://github.com/Pydataman/bert_examples), some examples of bert, run_classifier.py 是基于谷歌bert实现了Quora Insincere Questions Classification二分类比赛。run_ner.py是基于瑞金医院AI大赛 第一赛季数据和bert写的一个命名实体识别。
![](https://img.shields.io/github/stars/Pydataman/bert_examples.svg)

8. [guotong1988/BERT-chinese](https://github.com/guotong1988/BERT-chinese), BERT: Pre-training of Deep Bidirectional Transformers for Language Understanding 中文 汉语
![](https://img.shields.io/github/stars/guotong1988/BERT-chinese.svg)

9. [zhongyunuestc/bert_multitask](https://github.com/zhongyunuestc/bert_multitask), 多任务task
![](https://img.shields.io/github/stars/zhongyunuestc/bert_multitask.svg)

10. [Microsoft/AzureML-BERT](https://github.com/Microsoft/AzureML-BERT), End-to-end walk through for fine-tuning BERT using Azure Machine Learning , 
![](https://img.shields.io/github/stars/Microsoft/AzureML-BERT.svg)

11. [bigboNed3/bert_serving](https://github.com/bigboNed3/bert_serving), export bert model for serving, 
![](https://img.shields.io/github/stars/nghuyong/ERNIE-Pytorch.svg)

12. [yoheikikuta/bert-japanese](https://github.com/yoheikikuta/bert-japanese), BERT with SentencePiece for Japanese text. 
![](https://img.shields.io/github/stars/bigboNed3/bert_serving.svg)

13. [whqwill/seq2seq-keyphrase-bert](https://github.com/whqwill/seq2seq-keyphrase-bert), add BERT to encoder part for https://github.com/memray/seq2seq-keyphrase-pytorch,
![](https://img.shields.io/github/stars/whqwill/seq2seq-keyphrase-bert.svg)

14. [algteam/bert-examples](https://github.com/algteam/bert-examples), bert-demo, 
![](https://img.shields.io/github/stars/algteam/bert-examples.svg)

15. [cedrickchee/awesome-bert-nlp](https://github.com/cedrickchee/awesome-bert-nlp), A curated list of NLP resources focused on BERT, attention mechanism, Transformer networks, and transfer learning. 
![](https://img.shields.io/github/stars/cedrickchee/awesome-bert-nlp.svg)

16. [cnfive/cnbert](https://github.com/cnfive/cnbert), 中文注释一下bert代码功能, 
![](https://img.shields.io/github/stars/cnfive/cnbert.svg)

17. [brightmart/bert_customized](https://github.com/brightmart/bert_customized), bert with customized features,
![](https://img.shields.io/github/stars/brightmart/bert_customized.svg)


19. [JayYip/bert-multitask-learning](https://github.com/JayYip/bert-multitask-learning), BERT for Multitask Learning, 
![](https://img.shields.io/github/stars/JayYip/bert-multitask-learning.svg)

20. [yuanxiaosc/BERT_Paper_Chinese_Translation](https://github.com/yuanxiaosc/BERT_Paper_Chinese_Translation), BERT: Pre-training of Deep Bidirectional Transformers for Language Understanding 论文的中文翻译。Chinese Translation! https://yuanxiaosc.github.io/2018/12/…, 
![](https://img.shields.io/github/stars/yuanxiaosc/BERT_Paper_Chinese_Translation.svg)

21. [yaserkl/BERTvsULMFIT](https://github.com/yaserkl/BERTvsULMFIT), Comparing Text Classification results using BERT embedding and ULMFIT embedding,
![](https://img.shields.io/github/stars/yaserkl/BERTvsULMFIT.svg)

22. [kpot/keras-transformer](https://github.com/kpot/keras-transformer), Keras library for building (Universal) Transformers, facilitating BERT and GPT models, 
![](https://img.shields.io/github/stars/kpot/keras-transformer.svg)

23. [1234560o/Bert-model-code-interpretation](https://github.com/1234560o/Bert-model-code-interpretation), 解读tensorflow版本Bert中modeling.py数据流
![](https://img.shields.io/github/stars/1234560o/Bert-model-code-interpretation.svg)

24. [cdathuraliya/bert-inference](https://github.com/cdathuraliya/bert-inference), A helper class for Google BERT (Devlin et al., 2018) to support online prediction and model pipelining. 
![](https://img.shields.io/github/stars/cdathuraliya/bert-inference.svg)


25. [gameofdimension/java-bert-predict](https://github.com/gameofdimension/java-bert-predict), turn bert pretrain checkpoint into saved model for a feature extracting demo in java
![](https://img.shields.io/github/stars/gameofdimension/java-bert-predict.svg)

26. [1234560o/Bert-model-code-interpretation](https://github.com/1234560o/Bert-model-code-interpretation), 解读tensorflow版本Bert中modeling.py数据流
![](https://img.shields.io/github/stars/1234560o/Bert-model-code-interpretation.svg)

</details>


## domain specific BERT: 

1. [allenai/scibert](https://github.com/allenai/scibert), A BERT model for scientific text. https://arxiv.org/abs/1903.10676,
![](https://img.shields.io/github/stars/allenai/scibert.svg)

2. [MeRajat/SolvingAlmostAnythingWithBert](https://github.com/MeRajat/SolvingAlmostAnythingWithBert), BioBert Pytorch
![](https://img.shields.io/github/stars/MeRajat/SolvingAlmostAnythingWithBert.svg)

3. [kexinhuang12345/clinicalBERT](https://github.com/kexinhuang12345/clinicalBERT), ClinicalBERT: Modeling Clinical Notes and Predicting Hospital Readmission https://arxiv.org/abs/1904.05342
![](https://img.shields.io/github/stars/kexinhuang12345/clinicalBERT.svg)

4. [EmilyAlsentzer/clinicalBERT](https://github.com/EmilyAlsentzer/clinicalBERT), repository for Publicly Available Clinical BERT Embeddings
![](https://img.shields.io/github/stars/EmilyAlsentzer/clinicalBERT.svg)


## BERT Deploy Tricks:

1. [zhihu/cuBERT](https://github.com/zhihu/cuBERT), Fast implementation of BERT inference directly on NVIDIA (CUDA, CUBLAS) and Intel MKL
![](https://img.shields.io/github/stars/zhihu/cuBERT.svg)

2. [xmxoxo/BERT-train2deploy](https://github.com/xmxoxo/BERT-train2deploy), Bert Model training and deploy, BERT模型从训练到部署, 
![](https://img.shields.io/github/stars/xmxoxo/BERT-train2deploy.svg)


3. [https://github.com/NVIDIA/DeepLearningExamples/tree/master/TensorFlow/LanguageModeling/BERT](https://github.com/NVIDIA/DeepLearningExamples/tree/master/TensorFlow/LanguageModeling/BERT), BERT For TensorFlow, This repository provides a script and recipe to train BERT to achieve state of the art accuracy, and is tested and maintained by NVIDIA.
![](https://img.shields.io/github/stars/NVIDIA/DeepLearningExamples.svg)

4. [qiangsiwei/bert_distill](https://github.com/qiangsiwei/bert_distill), BERT distillation（基于BERT的蒸馏实验 ）, 
![](https://img.shields.io/github/stars/qiangsiwei/bert_distill.svg)

5. [kevinmtian/distill-bert](https://github.com/kevinmtian/distill-bert), Knowledge Distillation from BERT, 
![](https://img.shields.io/github/stars/kevinmtian/distill-bert.svg)





## BERT QA & RC task:

1. [sogou/SMRCToolkit](https://github.com/sogou/SMRCToolkit), This toolkit was designed for the fast and efficient development of modern machine comprehension models, including both published models and original prototypes., 
![](https://img.shields.io/github/stars/sogou/SMRCToolkit.svg)


2. [benywon/ChineseBert](https://github.com/benywon/ChineseBert), This is a chinese Bert model specific for question answering,
![](https://img.shields.io/github/stars/benywon/ChineseBert.svg)

3. [matthew-z/R-net](https://github.com/matthew-z/R-net), R-net in PyTorch, with BERT and ELMo,
![](https://img.shields.io/github/stars/matthew-z/R-net.svg)

4. [nyu-dl/dl4marco-bert](https://github.com/nyu-dl/dl4marco-bert), Passage Re-ranking with BERT,
![](https://img.shields.io/github/stars/nyu-dl/dl4marco-bert.svg)

5. [xzp27/BERT-for-Chinese-Question-Answering](https://github.com/xzp27/BERT-for-Chinese-Question-Answering), 
![](https://img.shields.io/github/stars/xzp27/BERT-for-Chinese-Question-Answering.svg)

6. [chiayewken/bert-qa](https://github.com/chiayewken/bert-qa), BERT for question answering starting with HotpotQA,
![](https://img.shields.io/github/stars/chiayewken/bert-qa.svg)

7. [ankit-ai/BertQA-Attention-on-Steroids](https://github.com/ankit-ai/BertQA-Attention-on-Steroids), BertQA - Attention on Steroids,
![](https://img.shields.io/github/stars/ankit-ai/BertQA-Attention-on-Steroids.svg)

8. [NoviScl/BERT-RACE](https://github.com/NoviScl/BERT-RACE), This work is based on Pytorch implementation of BERT (https://github.com/huggingface/pytorch-pretrained-BERT). I adapted the original BERT model to work on multiple choice machine comprehension.
![](https://img.shields.io/github/stars/NoviScl/BERT-RACE.svg)

9. [eva-n27/BERT-for-Chinese-Question-Answering](https://github.com/eva-n27/BERT-for-Chinese-Question-Answering), 
![](https://img.shields.io/github/stars/eva-n27/BERT-for-Chinese-Question-Answering.svg)

10. [allenai/allennlp-bert-qa-wrapper](https://github.com/allenai/allennlp-bert-qa-wrapper),  This is a simple wrapper on top of pretrained BERT based QA models from pytorch-pretrained-bert to make AllenNLP model archives, so that you can serve demos from AllenNLP.
![](https://img.shields.io/github/stars/allenai/allennlp-bert-qa-wrapper.svg)

11. [edmondchensj/ChineseQA-with-BERT](https://github.com/edmondchensj/ChineseQA-with-BERT), EECS 496: Advanced Topics in Deep Learning Final Project: Chinese Question Answering with BERT (Baidu DuReader Dataset)
![](https://img.shields.io/github/stars/edmondchensj/ChineseQA-with-BERT.svg)

12. [graykode/toeicbert](https://github.com/graykode/toeicbert), TOEIC(Test of English for International Communication) solving using pytorch-pretrained-BERT model.,
![](https://img.shields.io/github/starsgraykode/toeicbert.svg)

13. [graykode/KorQuAD-beginner](https://github.com/graykode/KorQuAD-beginner), https://github.com/graykode/KorQuAD-beginner
![](https://img.shields.io/github/stars/graykode/KorQuAD-beginner.svg)

14. [krishna-sharma19/SBU-QA](https://github.com/krishna-sharma19/SBU-QA), This repository uses pretrain BERT embeddings for transfer learning in QA domain
![](https://img.shields.io/github/stars/krishna-sharma19/SBU-QA.svg)

15. [basketballandlearn/Dureader-Bert](https://github.com/basketballandlearn/Dureader-Bert), BERT Dureader多文档阅读理解 排名第七, 2019 Dureader机器阅读理解 单模型代码。, 
![](https://img.shields.io/github/stars/basketballandlearn/Dureader-Bert.svg)



## BERT classification task:

1. [zhpmatrix/Kaggle-Quora-Insincere-Questions-Classification](https://github.com/zhpmatrix/Kaggle-Quora-Insincere-Questions-Classification), Kaggle新赛(baseline)-基于BERT的fine-tuning方案+基于tensor2tensor的Transformer Encoder方案
![](https://img.shields.io/github/stars/zhpmatrix/Kaggle-Quora-Insincere-Questions-Classification.svg)

2. [maksna/bert-fine-tuning-for-chinese-multiclass-classification](https://github.com/maksna/bert-fine-tuning-for-chinese-multiclass-classification), use google pre-training model bert to fine-tuning for the chinese multiclass classification
![](https://img.shields.io/github/stars/maksna/bert-fine-tuning-for-chinese-multiclass-classification.svg)

3. [NLPScott/bert-Chinese-classification-task](https://github.com/NLPScott/bert-Chinese-classification-task), bert中文分类实践,
![](https://img.shields.io/github/stars/NLPScott/bert-Chinese-classification-task.svg)

4. [Socialbird-AILab/BERT-Classification-Tutorial](https://github.com/Socialbird-AILab/BERT-Classification-Tutorial),
![](https://img.shields.io/github/stars/Socialbird-AILab/BERT-Classification-Tutorial.svg)

5. [fooSynaptic/BERT_classifer_trial](https://github.com/fooSynaptic/BERT_classifer_trial), BERT trial for chinese corpus classfication
![](https://img.shields.io/github/stars/fooSynaptic/BERT_classifer_trial.svg)

6. [xiaopingzhong/bert-finetune-for-classfier](https://github.com/xiaopingzhong/bert-finetune-for-classfier), 微调BERT模型,同时构建自己的数据集实现分类
![](https://img.shields.io/github/stars/xiaopingzhong/bert-finetune-for-classfier.svg)

7. [pengming617/bert_classification](https://github.com/pengming617/bert_classification), 利用bert预训练的中文模型进行文本分类,
![](https://img.shields.io/github/stars/pengming617/bert_classification.svg)

8. [xieyufei1993/Bert-Pytorch-Chinese-TextClassification](https://github.com/xieyufei1993/Bert-Pytorch-Chinese-TextClassification), Pytorch Bert Finetune in Chinese Text Classification,
![](https://img.shields.io/github/stars/xieyufei1993/Bert-Pytorch-Chinese-TextClassification.svg)

9. [liyibo/text-classification-demos](https://github.com/liyibo/text-classification-demos), Neural models for Text Classification in Tensorflow, such as cnn, dpcnn, fasttext, bert ...,
![](https://img.shields.io/github/stars/liyibo/text-classification-demos.svg)

10. [circlePi/BERT_Chinese_Text_Class_By_pytorch](https://github.com/circlePi/BERT_Chinese_Text_Class_By_pytorch), A Pytorch implements of Chinese text class based on BERT_Pretrained_Model,
![](https://img.shields.io/github/stars/circlePi/BERT_Chinese_Text_Class_By_pytorch.svg)

11. [kaushaltrivedi/bert-toxic-comments-multilabel](https://github.com/kaushaltrivedi/bert-toxic-comments-multilabel), Multilabel classification for Toxic comments challenge using Bert,
![](https://img.shields.io/github/stars/kaushaltrivedi/bert-toxic-comments-multilabel.svg)

12. [lonePatient/BERT-chinese-text-classification-pytorch](https://github.com/lonePatient/BERT-chinese-text-classification-pytorch), This repo contains a PyTorch implementation of a pretrained BERT model for text classification.,
![](https://img.shields.io/github/stars/lonePatient/BERT-chinese-text-classification-pytorch.svg)



## BERT Sentiment Analysis

1. [Chung-I/Douban-Sentiment-Analysis](https://github.com/Chung-I/Douban-Sentiment-Analysis), Sentiment Analysis on Douban Movie Short Comments Dataset using BERT.
![](https://img.shields.io/github/stars/Chung-I/Douban-Sentiment-Analysis.svg)

2. [lynnna-xu/bert_sa](https://github.com/lynnna-xu/bert_sa), bert sentiment analysis tensorflow serving with RESTful API
![](https://img.shields.io/github/stars/lynnna-xu/bert_sa.svg)

3. [HSLCY/ABSA-BERT-pair](https://github.com/HSLCY/ABSA-BERT-pair), Utilizing BERT for Aspect-Based Sentiment Analysis via Constructing Auxiliary Sentence (NAACL 2019) https://arxiv.org/abs/1903.09588,
![](https://img.shields.io/github/stars/HSLCY/ABSA-BERT-pair.svg)

4. [songyouwei/ABSA-PyTorch](https://github.com/songyouwei/ABSA-PyTorch), Aspect Based Sentiment Analysis, PyTorch Implementations. 基于方面的情感分析，使用PyTorch实现。,
![](https://img.shields.io/github/stars/songyouwei/ABSA-PyTorch.svg)

5. [howardhsu/BERT-for-RRC-ABSA](https://github.com/howardhsu/BERT-for-RRC-ABSA), code for our NAACL 2019 paper: "BERT Post-Training for Review Reading Comprehension and Aspect-based Sentiment Analysis",
![](https://img.shields.io/github/stars/howardhsu/BERT-for-RRC-ABSA.svg)

6. [brightmart/sentiment_analysis_fine_grain](https://github.com/brightmart/sentiment_analysis_fine_grain), Multi-label Classification with BERT; Fine Grained Sentiment Analysis from AI challenger,
![](https://img.shields.io/github/stars/brightmart/sentiment_analysis_fine_grain.svg)


## BERT  NER  task:  

1. [zhpmatrix/bert-sequence-tagging](https://github.com/zhpmatrix/bert-sequence-tagging), 基于BERT的中文序列标注
![](https://img.shields.io/github/stars/zhpmatrix/bert-sequence-tagging.svg)

2. [kyzhouhzau/BERT-NER](https://github.com/kyzhouhzau/BERT-NER), Use google BERT to do CoNLL-2003 NER ! ,
![](https://img.shields.io/github/stars/kyzhouhzau/BERT-NER.svg)

3. [king-menin/ner-bert](https://github.com/king-menin/ner-bert), NER task solution (bert-Bi-LSTM-CRF) with google bert https://github.com/google-research.
![](https://img.shields.io/github/stars/king-menin/ner-bert.svg)

4. [macanv/BERT-BiLSMT-CRF-NER](https://github.com/macanv/BERT-BiLSMT-CRF-NER), Tensorflow solution of NER task Using BiLSTM-CRF model with Google BERT Fine-tuning  ,
![](https://img.shields.io/github/stars/macanv/BERT-BiLSMT-CRF-NER.svg)

5. [FuYanzhe2/Name-Entity-Recognition](https://github.com/FuYanzhe2/Name-Entity-Recognition), Lstm-crf,Lattice-CRF,bert-ner及近年ner相关论文follow,
![](https://img.shields.io/github/stars/FuYanzhe2/Name-Entity-Recognition.svg)

6. [mhcao916/NER_Based_on_BERT](https://github.com/mhcao916/NER_Based_on_BERT), this project is based on google bert model, which is a Chinese NER
![](https://img.shields.io/github/stars/mhcao916/NER_Based_on_BERT.svg)

7. [ProHiryu/bert-chinese-ner](https://github.com/ProHiryu/bert-chinese-ner), 使用预训练语言模型BERT做中文NER,
![](https://img.shields.io/github/stars/ProHiryu/bert-chinese-ner.svg)

8. [sberbank-ai/ner-bert](https://github.com/sberbank-ai/ner-bert), BERT-NER (nert-bert) with google bert,
![](https://img.shields.io/github/stars/sberbank-ai/ner-bert.svg)

9. [kyzhouhzau/Bert-BiLSTM-CRF](https://github.com/kyzhouhzau/Bert-BiLSTM-CRF), This model base on bert-as-service. Model structure : bert-embedding bilstm crf. ,
![](https://img.shields.io/github/stars/kyzhouhzau/Bert-BiLSTM-CRF.svg)

10. [Hoiy/berserker](https://github.com/Hoiy/berserker), Berserker - BERt chineSE woRd toKenizER, Berserker (BERt chineSE woRd toKenizER) is a Chinese tokenizer built on top of Google's BERT model. ,
![](https://img.shields.io/github/stars/Hoiy/berserker.svg)

11. [Kyubyong/bert_ner](https://github.com/Kyubyong/bert_ner), Ner with Bert,
![](https://img.shields.io/github/stars/Kyubyong/bert_ner.svg)

12. [jiangpinglei/BERT_ChineseWordSegment](https://github.com/jiangpinglei/BERT_ChineseWordSegment),  A Chinese word segment model based on BERT, F1-Score 97%,
![](https://img.shields.io/github/stars/jiangpinglei/BERT_ChineseWordSegment.svg)

13. [yanwii/ChineseNER](https://github.com/yanwii/ChineseNER), 基于Bi-GRU + CRF 的中文机构名、人名识别 中文实体识别, 支持google bert模型
![](https://img.shields.io/github/stars/yanwii/ChineseNER.svg)

14. [lemonhu/NER-BERT-pytorch](https://github.com/lemonhu/NER-BERT-pytorch), PyTorch solution of NER task Using Google AI's pre-trained BERT model.
![](https://img.shields.io/github/stars/lemonhu/NER-BERT-pytorch.svg)


## BERT Text Summarization Task: 

1. [nlpyang/BertSum](https://github.com/nlpyang/BertSum), Code for paper Fine-tune BERT for Extractive Summarization,
![](https://img.shields.io/github/stars/nlpyang/BertSum.svg)

2. [santhoshkolloju/Abstractive-Summarization-With-Transfer-Learning](https://github.com/santhoshkolloju/Abstractive-Summarization-With-Transfer-Learning), Abstractive summarisation using Bert as encoder and Transformer Decoder,
![](https://img.shields.io/github/stars/santhoshkolloju/Abstractive-Summarization-With-Transfer-Learning.svg)

3. [nayeon7lee/bert-summarization](https://github.com/nayeon7lee/bert-summarization), Implementation of 'Pretraining-Based Natural Language Generation for Text Summarization', Paper: https://arxiv.org/pdf/1902.09243.pdf
![](https://img.shields.io/github/stars/nayeon7lee/bert-summarization.svg)

4. [dmmiller612/lecture-summarizer](https://github.com/dmmiller612/lecture-summarizer), Lecture summarizer with BERT
![](https://img.shields.io/github/stars/dmmiller612/lecture-summarizer.svg)




## BERT Text Generation Task: 
1. [asyml/texar](https://github.com/asyml/texar), Toolkit for Text Generation and Beyond https://texar.io, Texar is a general-purpose text generation toolkit, has also implemented BERT here for classification, and text generation applications by combining with Texar's other modules.
![](https://img.shields.io/github/stars/asyml/texar.svg)

2. [voidful/BertGenerate](https://github.com/voidful/BertGenerate), Fine tuning bert for text generation, Bert 做 文本生成 的一些實驗
![](https://img.shields.io/github/stars/voidful/BertGenerate.svg)

3. [Tiiiger/bert_score](https://github.com/Tiiiger/bert_score), BERT score for language generation,
![](https://img.shields.io/github/stars/Tiiiger/bert_score.svg)



## BERT  Knowledge Graph Task : 

1. [lvjianxin/Knowledge-extraction](https://github.com/lvjianxin/Knowledge-extraction), 基于中文的知识抽取，BaseLine：Bi-LSTM+CRF 升级版：Bert预训练
![](https://img.shields.io/github/stars/lvjianxin/Knowledge-extraction.svg)

2. [sakuranew/BERT-AttributeExtraction](https://github.com/sakuranew/BERT-AttributeExtraction), USING BERT FOR Attribute Extraction in KnowledgeGraph. fine-tuning and feature extraction. 使用基于bert的微调和特征提取方法来进行知识图谱百度百科人物词条属性抽取。,
![](https://img.shields.io/github/stars/sakuranew/BERT-AttributeExtraction.svg)

3. [aditya-AI/Information-Retrieval-System-using-BERT](https://github.com/aditya-AI/Information-Retrieval-System-using-BERT),
![](https://img.shields.io/github/stars/aditya-AI/Information-Retrieval-System-using-BERT.svg)

4. [jkszw2014/bert-kbqa-NLPCC2017](https://github.com/jkszw2014/bert-kbqa-NLPCC2017), A trial of kbqa based on bert for NLPCC2016/2017 Task 5  (基于BERT的中文知识库问答实践，代码可跑通），博客介绍 https://blog.csdn.net/ai_1046067944/article/details/86707784  ,
![](https://img.shields.io/github/stars/jkszw2014/bert-kbqa-NLPCC2017.svg)

5. [yuanxiaosc/Schema-based-Knowledge-Extraction](https://github.com/yuanxiaosc/Schema-based-Knowledge-Extraction), Code for http://lic2019.ccf.org.cn/kg 信息抽取。使用基于 BERT 的实体抽取和关系抽取的端到端的联合模型。（将在比赛结束后，完善代码和使用说明）,
![](https://img.shields.io/github/stars/yuanxiaosc/Schema-based-Knowledge-Extraction.svg)

6. [yuanxiaosc/Entity-Relation-Extraction](https://github.com/yuanxiaosc/Entity-Relation-Extraction),  Entity and Relation Extraction Based on TensorFlow. 基于TensorFlow的管道式实体及关系抽取，2019语言与智能技术竞赛信息抽取任务解决方案（比赛结束后完善代码）。Schema based Knowledge Extraction, SKE 2019 http://lic2019.ccf.org.cn,
![](https://img.shields.io/github/stars/yuanxiaosc/Entity-Relation-Extraction.svg)

7. [WenRichard/KBQA-BERT](https://github.com/WenRichard/KBQA-BERT), 基于知识图谱的问答系统，BERT做命名实体识别和句子相似度，分为online和outline模式，博客介绍 https://zhuanlan.zhihu.com/p/62946533  ,
![](https://img.shields.io/github/stars/WenRichard/KBQA-BERT.svg)

8. [zhpmatrix/BERTem](https://github.com/zhpmatrix/BERTem), ACL2019论文实现《Matching the Blanks: Distributional Similarity for Relation Learning》 ,
![](https://img.shields.io/github/stars/zhpmatrix/BERTem.svg)




## BERT  Coreference Resolution 
1. [ianycxu/RGCN-with-BERT](https://github.com/ianycxu/RGCN-with-BERT), Gated-Relational Graph Convolutional Networks (RGCN) with BERT for Coreference Resolution Task
![](https://img.shields.io/github/stars/ianycxu/RGCN-with-BERT.svg)

2. [isabellebouchard/BERT_for_GAP-coreference](https://github.com/isabellebouchard/BERT_for_GAP-coreference),  BERT finetuning for GAP unbiased pronoun resolution
![](https://img.shields.io/github/stars/isabellebouchard/BERT_for_GAP-coreference.svg)



## BERT  visualization toolkit: 
1. [jessevig/bertviz](https://github.com/jessevig/bertviz), Tool for visualizing BERT's attention,
![](https://img.shields.io/github/stars/jessevig/bertviz.svg)


## BERT chatbot :
1. [GaoQ1/rasa_nlu_gq](https://github.com/GaoQ1/rasa_nlu_gq), turn natural language into structured data(支持中文，自定义了N种模型，支持不同的场景和任务),
![](https://img.shields.io/github/stars/GaoQ1/rasa_nlu_gq.svg)

2. [GaoQ1/rasa_chatbot_cn](https://github.com/GaoQ1/rasa_chatbot_cn), 基于rasa-nlu和rasa-core 搭建的对话系统demo,
![](https://img.shields.io/github/stars/GaoQ1/rasa_chatbot_cn.svg)

3. [GaoQ1/rasa-bert-finetune](https://github.com/GaoQ1/rasa-bert-finetune), 支持rasa-nlu 的bert finetune,
![](https://img.shields.io/github/stars/GaoQ1/rasa-bert-finetune.svg)

4. [geodge831012/bert_robot](https://github.com/geodge831012/bert_robot), 用于智能助手回答问题的训练，基于BERT模型进行训练改造
![](https://img.shields.io/github/stars/geodge831012/bert_robot.svg)

5. [yuanxiaosc/BERT-for-Sequence-Labeling-and-Text-Classification](https://github.com/yuanxiaosc/BERT-for-Sequence-Labeling-and-Text-Classification), This is the template code to use BERT for sequence lableing and text classification, in order to facilitate BERT for more tasks. Currently, the template code has included conll-2003 named entity identification, Snips Slot Filling and Intent Prediction.
![](https://img.shields.io/github/stars/yuanxiaosc/BERT-for-Sequence-Labeling-and-Text-Classification.svg)

6. [guillaume-chevalier/ReuBERT](https://github.com/guillaume-chevalier/ReuBERT), A question-answering chatbot, simply.
![](https://img.shields.io/github/stars/guillaume-chevalier/ReuBERT.svg)



## BERT language model and embedding: 

1.  [hanxiao/bert-as-service](https://github.com/hanxiao/bert-as-service),    Mapping a variable-length sentence to a fixed-length vector using pretrained BERT model,
![](https://img.shields.io/github/stars/hanxiao/bert-as-service.svg)

2. [YC-wind/embedding_study](https://github.com/YC-wind/embedding_study), 中文预训练模型生成字向量学习，测试BERT，ELMO的中文效果,
![](https://img.shields.io/github/stars/YC-wind/embedding_study.svg)

3. [Kyubyong/bert-token-embeddings](https://github.com/Kyubyong/bert-token-embeddings), Bert Pretrained Token Embeddings,
![](https://img.shields.io/github/stars/Kyubyong/bert-token-embeddings.svg)

4. [xu-song/bert_as_language_model](https://github.com/xu-song/bert_as_language_model), bert as language model, fork from https://github.com/google-research/bert,
![](https://img.shields.io/github/stars/xu-song/bert_as_language_model.svg)

5. [yuanxiaosc/Deep_dynamic_word_representation](https://github.com/yuanxiaosc/Deep_dynamic_word_representation), TensorFlow code and pre-trained models for deep dynamic word representation (DDWR). It combines the BERT model and ELMo's deep context word representation.,
![](https://img.shields.io/github/stars/yuanxiaosc/Deep_dynamic_word_representation.svg)

6. [imgarylai/bert-embedding](https://github.com/imgarylai/bert-embedding), Token level embeddings from BERT model on mxnet and gluonnlp http://bert-embedding.readthedocs.io/,
![](https://img.shields.io/github/stars/imgarylai/bert-embedding.svg)

7. [terrifyzhao/bert-utils](https://github.com/terrifyzhao/bert-utils), BERT生成句向量，BERT做文本分类、文本相似度计算,
![](https://img.shields.io/github/stars/terrifyzhao/bert-utils.svg)

8. [fennuDetudou/BERT_implement](https://github.com/fennuDetudou/BERT_implement), 使用BERT模型进行文本分类，相似句子判断，以及词性标注,
![](https://img.shields.io/github/stars/fennuDetudou/BERT_implement.svg)

9. [whqwill/seq2seq-keyphrase-bert](https://github.com/whqwill/seq2seq-keyphrase-bert), add BERT to encoder part for https://github.com/memray/seq2seq-keyphrase-pytorch,
![](https://img.shields.io/github/stars/whqwill/seq2seq-keyphrase-bert.svg)

10. [charles9n/bert-sklearn](https://github.com/charles9n/bert-sklearn), a sklearn wrapper for Google's BERT model,
![](https://img.shields.io/github/stars/charles9n/bert-sklearn.svg)


11. [NVIDIA/Megatron-LM](https://github.com/NVIDIA/Megatron-LM), Ongoing research training transformer language models at scale, including: BERT,
![](https://img.shields.io/github/stars/NVIDIA/Megatron-LM.svg)

12. [hankcs/BERT-token-level-embedding](https://github.com/hankcs/BERT-token-level-embedding), Generate BERT token level embedding without pain
![](https://img.shields.io/github/stars/hankcs/BERT-token-level-embedding.svg)

13. [facebookresearch/LAMA](https://github.com/facebookresearch/LAMA), LAMA: LAnguage Model Analysis, LAMA is a set of connectors to pre-trained language models.
![](https://img.shields.io/github/stars/facebookresearch/LAMA.svg)




## BERT Text Match: 

1. [pengming617/bert_textMatching](https://github.com/pengming617/bert_textMatching), 利用预训练的中文模型实现基于bert的语义匹配模型 数据集为LCQMC官方数据
![](https://img.shields.io/github/stars/pengming617/bert_textMatching.svg)

2. [Brokenwind/BertSimilarity](https://github.com/Brokenwind/BertSimilarity), Computing similarity of two sentences with google's BERT algorithm
![](https://img.shields.io/github/stars/Brokenwind/BertSimilarity.svg)

3. [policeme/chinese_bert_similarity](https://github.com/policeme/chinese_bert_similarity), bert chinese similarity
![](https://img.shields.io/github/stars/policeme/chinese_bert_similarity.svg)

4. [lonePatient/bert-sentence-similarity-pytorch](https://github.com/lonePatient/bert-sentence-similarity-pytorch), This repo contains a PyTorch implementation of a pretrained BERT model for sentence similarity task.
![](https://img.shields.io/github/stars/lonePatient/bert-sentence-similarity-pytorch.svg)

5. [nouhadziri/DialogEntailment](https://github.com/nouhadziri/DialogEntailment), The implementation of the paper "Evaluating Coherence in Dialogue Systems using Entailment" https://arxiv.org/abs/1904.03371
![](https://img.shields.io/github/stars/nouhadziri/DialogEntailment.svg)

6. [UKPLab/sentence-transformers](https://github.com/UKPLab/sentence-transformers), Sentence Embeddings with BERT & XLNet, 
Sentence Transformers: Sentence Embeddings using BERT / RoBERTa / XLNet with PyTorch, 
![](https://img.shields.io/github/stars/UKPLab/sentence-transformers.svg)


## BERT tutorials: 

1. [graykode/nlp-tutorial](https://github.com/graykode/nlp-tutorial), Natural Language Processing Tutorial for Deep Learning Researchers https://www.reddit.com/r/MachineLearn…,
![](https://img.shields.io/github/stars/graykode/nlp-tutorial.svg)

2. [dragen1860/TensorFlow-2.x-Tutorials](https://github.com/dragen1860/TensorFlow-2.x-Tutorials), TensorFlow 2.x version's Tutorials and Examples, including CNN, RNN, GAN, Auto-Encoders, FasterRCNN, GPT, BERT examples, etc. TF 2.0版入门实例代码，实战教程。,
![](https://img.shields.io/github/stars/dragen1860/TensorFlow-2.x-Tutorials.svg)


