---
title: "Privacy Policy for Developer for Life"
author: "Jeremy Likness"
date: 2003-06-13T00:00:00.000Z
lastmod: 2019-06-13T10:43:10-07:00
comments: false
toc: false
noads: true
tags: 
    - "privacy"

description: "This is the full privacy policy for Developer for Life. Learn exactly what services are used and what we track."

subtitle: ""

image: "/images/privacy.png"

images:
    - "/images/privacy.png"
---

![Privacy Policy](/images/privacy.png)

Effective date: June 5, 2020

{{<getconsent>}}

Jeremy Likness ("us", "we", or "our") operates the Developer for Life website at https://blog.jeremylikness.com (hereinafter referred to as the "Service").

This page informs you of our policies regarding the collection, use and disclosure of personal data when you use our Service and the choices you have associated with that data.

We use your data to provide and improve the Service. By using the Service, you agree to the collection and use of information in accordance with this policy.

> This Service does not directly collect any personal data. Your choice to opt-in or opt-out will saved to the browser's local storage. This data is not transmitted and, unlike cookies, is not readable by the server. You can view the consent and change or delete it at any time by navigating to local storage and choosing the `consent` key or by tapping the button at the top of this page. Opting out will disable third-party cookies but also results in a more limited experience. For example, online discussions and comments are powered by the third party app Disqus and cannot be accessed without cookies. Twitter integration will also be limited. The remainder of this page outlines the details of our privacy policy and what actions you can take.

### Definitions

* **Service** is the Developer for Life https://blog.jeremylikness.com website operated by Jeremy Likness
* **Personal Data** means data about a living individual who can be identified from those data (or from those and other information either in our possession or likely to come into our possession)
* **Usage Data** is data collected automatically either generated by the use of the Service or from the Service infrastructure itself (for example, the duration of a page visit)
* **Cookies** are small files stored on your device (computer or mobile device).

### Information Collection and Use

We collect several different types of information for various purposes to provide and improve our Service to you.

#### Types of Data Collected

##### Personal Data

We do not directly ask for any personally identifiable information as part of this service. Indirectly collected information may include, but is not limited to:

* Cookies and Usage Data

##### Usage Data

We may also collect information on how the Service is accessed and used ("Usage Data"). This Usage Data may include information such as your computer's Internet Protocol address (e.g. IP address), browser type, browser version, the pages of our Service that you visit, the time and date of your visit, the time spent on those pages, unique device identifiers and other diagnostic data.

##### Tracking & Cookies Data

We use cookies and similar tracking technologies to track the activity on our Service and we hold certain information.

Cookies are files with a small amount of data which may include an anonymous unique identifier. Cookies are sent to your browser from a website and stored on your device. Other tracking technologies are also used such as beacons, tags and scripts to collect and track information and to improve and analyze our Service.

You can instruct your browser to refuse all cookies or to indicate when a cookie is being sent. However, if you do not accept cookies, you may not be able to use some portions of our Service.

Examples of Cookies we use:

* **Advertising Cookies** Advertising Cookies are used to serve you with advertisements that may be relevant to you and your interests.

### Use of Data

Developer for Life uses the collected data for various purposes:

* To provide and maintain our Service
* To gather analysis or valuable information so that we can improve our Service
* To monitor the usage of our Service
* To detect, prevent and address technical issues

### Transfer of Data

Your information, including Personal Data, may be transferred to — and maintained on — computers located outside of your state, province, country or other governmental jurisdiction where the data protection laws may differ from those of your jurisdiction.

If you are located outside United States and choose to provide information to us, please note that we transfer the data, including Personal Data, to United States and process it there.

Your consent to this Privacy Policy followed by your submission of such information represents your agreement to that transfer.

Developer for Life will take all the steps reasonably necessary to ensure that your data is treated securely and in accordance with this Privacy Policy and no transfer of your Personal Data will take place to an organization or a country unless there are adequate controls in place including the security of your data and other personal information.

### Disclosure of Data

#### Legal Requirements

Developer for Life may disclose your Personal Data in the good faith belief that such action is necessary to:

* To comply with a legal obligation
* To protect and defend the rights or property of Developer for Life
* To prevent or investigate possible wrongdoing in connection with the Service
* To protect the personal safety of users of the Service or the public
* To protect against legal liability

### Security of Data

The security of your data is important to us but remember that no method of transmission over the Internet or method of electronic storage is 100% secure. While we strive to use commercially acceptable means to protect your Personal Data, we cannot guarantee its absolute security.

### Service Providers

We may employ third party companies and individuals to facilitate our Service ("Service Providers"), provide the Service on our behalf, perform Service-related services or assist us in analyzing how our Service is used.

These third parties have access to your Personal Data only to perform these tasks on our behalf and are obligated not to disclose or use it for any other purpose.

### Analytics

We may use third-party Service Providers to monitor and analyze the use of our Service.

* **Google Analytics** Google Analytics is a web analytics service offered by Google that tracks and reports website traffic. Google uses the data collected to track and monitor the use of our Service. This data is shared with other Google services. Google may use the collected data to contextualize and personalize the ads of its own advertising network.

    You can opt-out of having made your activity on the Service available to Google Analytics by installing the Google Analytics opt-out browser add-on. The add-on prevents the Google Analytics JavaScript (`ga.js`, `analytics.js` and `dc.js`) from sharing information with Google Analytics about visits activity.  

    For more information on the privacy practices of Google, please visit the Google [Privacy & Terms web page](https://policies.google.com/privacy?hl=en">https://policies.google.com/privacy?hl=en)

* **Disqus** Disqus is a third-party service used to managed comments on the website. Disqus uses data collected to track comments and discussion threads. In some cases, Disqus can be configured to track usage and deliver advertisements. These features have been turned off for our Service.

    For more information on the privacy practices of Disqus, please visit the Disqus [Privacy Policy web page](https://help.disqus.com/en/articles/1717103-disqus-privacy-policy)

### Advertising

We may use third-party Service Providers to show advertisements to you to help support and maintain our Service.

* **Google AdSense & DoubleClick Cookie** Google, as a third party vendor, uses cookies to serve ads on our Service. Google's use of the DoubleClick cookie enables it and its partners to serve ads to our users based on their visit to our Service or other websites on the Internet.

    You may opt out of the use of the DoubleClick Cookie for interest-based advertising by visiting the [Google Ads Settings web page](http://www.google.com/ads/preferences/)

### Links to Other Sites

Our Service may contain links to other sites that are not operated by us. If you click a third party link, you will be directed to that third party's site. We strongly advise you to review the Privacy Policy of every site you visit.

We have no control over and assume no responsibility for the content, privacy policies or practices of any third party sites or services.

### Children's Privacy

Our Service does not address anyone under the age of 18 ("Children").

We do not knowingly collect personally identifiable information from anyone under the age of 18. If you are a parent or guardian and you are aware that your Child has provided us with Personal Data, please contact us. If we become aware that we have collected Personal Data from children without verification of parental consent, we take steps to remove that information from our servers.

### Changes to This Privacy Policy

We may update our Privacy Policy from time to time. We will notify you of any changes by posting the new Privacy Policy on this page.

We will let you know via a prominent notice on our Service, prior to the change becoming effective and update the "effective date" at the top of this Privacy Policy.

You are advised to review this Privacy Policy periodically for any changes. Changes to this Privacy Policy are effective when they are posted on this page.

### Contact Us

If you have any questions about this Privacy Policy, please <i class="fab fa-twitter"></i> [Contact Us](https://twitter.com/JeremyLikness) or [file an issue](https://github.com/JeremyLikness/jeremylikness-blog/issues/new).
