---
title: "After Your Talk 🗣: The Power 💪 of Leverage"
author: "Jeremy Likness"
date: 2019-06-24T13:46:00-07:00
years: "2019"
lastmod: 2019-06-24T13:46:00-07:00

draft: false
comments: true
toc: false

canonicalUrl: "https://dev.to/azure/after-your-talk-the-power-of-leverage-2enj"

subtitle: "After the mic drops"

description: "A guide to building momentum from your technical presentation and transforming a single talk into content that continues to deliver value long after the event is over."

series: "Comprehensive and Practical Guide to Technical Presentations"

tags:
 - Presentation 
 - Productivity
 - Learning

image: "/blog/presenting-1-a-guide-for-everyone-who-wants-to-give-technical-presentations/images/technicalpresentationshero.jpg" 
images:
 - "/blog/presenting-1-a-guide-for-everyone-who-wants-to-give-technical-presentations/images/technicalpresentationshero.jpg" 
 - "/blog/presenting-9-after-talk-power-of-leverage/images/hangingstage.jpg" 
---

## 👆 After the Talk

Let's take a deep breath! _Your talk is finished._ YES! This is the moment you've been waiting for. Enjoy that post-talk flush of energy. 

![NDC Oslo 2019](/blog/presenting-9-after-talk-power-of-leverage/images/hangingstage.jpg)
<figcaption>That feeling when you are presenting in a stadium from a platform that is suspended by cables!</figcaption>
_Photo Credit: [Manuel Sidler](https://twitter.com/manuelsidler)_

Most speakers find the lifecycle of a typical presentation looks something like this:

😕 Hmmm ... wonder if I'll get accepted.
😅 I got accepted!
😱 I have to put a talk together!
😊 My session is done.
😱 I have to present!
😠 This isn't worth it, I'm never speaking again.
😮 (gives talk)
😂🤣 That was awesome, when can I do it again?!

Just because the talk is over doesn't mean its impact has to end. There are a few ways you can continue to drive value and empower developers after the talk. The first, and most obvious, is to send out a link to the presentation materials:

* **Share the presentation deck.** I make mine available under an open source license and welcome others to borrow and reuse for their own presentations. I like to "scale the presentations."
* **Share the repository link.** Bonus points if you put together a detailed `README.md` that steps through each of the demos to make it easier for attendees to duplicate what you presented and other presenters to reuse your content.

{{<customtwitter 1141390186250739717>}}

> ⭐ **Tip:** I find people are more drawn to post-presentation tweets when they can see what the presentation looks like. If they didn't attend the talk, it's a good preview that can help them decide if they want to take the time to download your materials. In PowerPoint, you can use the "Export As" feature to save a video. Set the transitions timing to a low number (I typically use 0.2 or 0.25 seconds). Twitter videos shouldn't be much longer than 2 minutes in duration. I generate low quality to make the file size smaller, but you can use whatever resolution you prefer. I then upload it to <i class="fab fa-twitter"></i> [Twitter studio](https://studio.twitter.com/). I set the call to action to visit a site and paste the link to download the presentation. It can be quite hectic after a talk is finished, so often I will schedule a Tweet to go out 10 minutes after my talk. That way it happens automatically, even if I'm still answering questions.

I also like to capture tweets I wrote along with tweets that reference me during the conference in a Twitter "moment." On the web app, you can click on any tweet and select "Add to new moment" to create a moment. I'll title it with the name of the conference and the year and add all conference-related tweets. When you publish a moment, Twitter automatically creates a tweet you can send out that looks like this:

{{<customtwitter 1142819440792231936>}}
 
If the conference recorded the video, I'll reply to the original link to follow-up and share that the video has been published. This may take several weeks to months after your presentation is done, so patience is required.

I also always follow up with a blog post that relates to the content. It might be a brief review of the topic, like this one:

{{<relativelink "/blog/2019-05-16_managing-data-in-the-cloud-">}}

Or it might be an in-depth article that stands on its own but is based on the steps and demo recordings from my presentation, like this one:

{{<relativelink "/blog/2019-02-05_azure-event-grid-the-whole-story">}}

Finally, I always look for ways to evolve a session. I might start with the presentation and modify it for a different audience, extend it to add new features, or "borrow" the demo but change the story. The sky is truly the limit!

That concludes this practical and comprehensive guide to technical presentations. I hope you enjoyed it, that you received value, and that you share this with your friends, colleagues, and associates who are considering speaking for the first time. It's my desire that this is just the start of a longer conversation, so don't hesitate to share your comments and feel free to <i class="fab fa-twitter"></i> [connect with me on Twitter](https://twitter.com/jeremylikness).

🗣 **Let's discuss** What are some of the techniques you use to maximize the value of your technical presentations?

> I shared a unique video with each article to provide an example of various presentation styles. To conclude the series, I'd like to share with you this <i class="fab fa-youtube"></i> [YouTube collection of technical presentations](https://www.youtube.com/playlist?list=PL1VfiVM16kp-sQ3D3XDLopmScoaOQibFb) that covers all of my sessions and shows that have been published to YouTube.

Regards,

![Jeremy Likness](/images/jeremylikness.gif)
