---
title: "It's Time ⌚ to Talk 🗣! The Day of Your Presentation"
author: "Jeremy Likness"
date: 2019-06-10T13:46:00-07:00
years: "2019"
lastmod: 2019-06-24T13:46:00-07:00

draft: false
comments: true
toc: true

canonicalUrl: "https://dev.to/azure/it-s-time-to-talk-the-day-of-your-presentation-2kpl"

subtitle: "A guide to delivery"

description: "Keys to a successful technical presentation, including your routine the day of, how to handle nerves, ways to start the talk, managing questions and concluding strong."

series: "Comprehensive and Practical Guide to Technical Presentations"

tags:
 - Presentation 
 - Productivity
 - Learning

image: "/blog/presenting-8-delivering-your-talk-day-of/images/heartrate.jpg" 
images:
 - "/blog/presenting-8-delivering-your-talk-day-of/images/dayofprep.jpg" 
 - "/blog/presenting-8-delivering-your-talk-day-of/images/heartrate.jpg" 
 - "/blog/presenting-8-delivering-your-talk-day-of/images/presenting.jpg" 
---

## 👉🏻 The Day of Your Presentation

It's finally happened! The "big day" is here and it's time to deliver your presentation. Here are a few tips to help get you ready for the "day of."

![Breakfast at the conference](/blog/presenting-8-delivering-your-talk-day-of/images/dayofprep.jpg)
<figcaption>My morning meal before speaking at DevLink in 2014</figcaption>

## Routine

It's very important to try to keep to your normal routine as much as possible. This is not the time to suddenly skip breakfast or eat something different. I know that nerves can make it tough to eat, but fainting makes it tough to finish a presentation! Adjust your meals to something smaller and/or more bland if you have a sensitive stomach. My typical scenario looks like this:

* I wake up at the same time (if my talk is early, that means getting up early previous days as well).
* If time permits, I work out as a great way to shed some excess adrenaline and get pumped for the talk.
* I eat my typical breakfast.
* If the talk is later in the day, I eat my normal meals spaced out around the time I'm used to.
* If there is a gap between a meal and my talk, I'll eat a protein bar a few minutes before I start.
* I always use the restroom before my speaking slot even if I don't think I need it.
* I confirm there are water bottles in the room and if not, bring my own water (although I prefer sparkling water, for scientific reasons 😮 I stick to still water before and during presentations).
* Based on the schedule, I arrive as early as permitted. At some conferences, that might be 30 - 45 minutes before the talk. At others it may mean just 10 minutes before the talk.
* I follow my notes and prep my computer for the talk in my hotel room or in the speaker room before I enter the conference room. This way I just open my laptop lid and plug-in, so any extra time can be used to troubleshoot audio or video problems if they happen. You don't want to wait until the last minute to set up!

## Nerves

If you interview one dozen experienced speakers, maybe one or two will tell you they no longer get nervous at all. Most of us still get excited and feel an adrenaline rush. Even when I feel like I'm confident and calm, my heart rate tells a different story. After over a decade of public speaking, this is what my heart rate does when I speak:

![Heart rate day of speaking](/blog/presenting-8-delivering-your-talk-day-of/images/heartrate.jpg)
<figcaption>My heart rate the day of a talk</figcaption>

There are a few things you can do to minimize the impact of being nervous. It's a 🐔 chicken and 🥚 egg scenario. We get nervous because we want the talk to go well, but typically what can derail it is, well, being nervous. So, be sure to get plenty of rest the night before. I personally prefer to bring some Melatonin to help me sleep and avoid staying up running through possibilities in my head.

A few things help me when preparing. I remind myself why I'm doing this and visualize the desired outcome (happy attendees because they learned something new). I remind myself that courage doesn't mean you're not afraid, it means you move forward despite your fear. I keep copies of emails, tweets, or other feedback that one of my talks impacted someone in a positive way. These are not for me to share and brag, but to refer to and remember why it is I do what I do. Knowing someone solved a problem or even made a positive career move as the result of attending a talk is a great motivator and brings me back to that fact it's not really about me, even though I want it to be. It's about the audience.

![Having fun before a presentation](/blog/presenting-8-delivering-your-talk-day-of/images/presenting.jpg)
<figcaption>Having some fun before a presentation</figcaption>

Some speakers find it easier to present after making a connection with attendees. You might walk out into the audience and introduce yourself to audience members. Find out how their day is going, what their expectations are, and generally get comfortable with them. This will make it easier for you to continue the conversation from stage and give you some friendly faces to look at when you're speaking.

Finally, I remember the words a business coach gave me that struck home even though it sounds a bit strange: *You know what you know what you know.* In other words, it's the days of preparation before the event that really impact how well you deliver. There is no new information or magic insights you'll receive in the hours or minutes before to change things, so relax and let it happen. Believe it or not, the people in the audience want you to be successful. They're on your side! So, don't forget to 💧 hydrate and go make a splash!

## The Start Line

Some speakers are perpetually stuck on how to begin a talk. I make sure I have a solid beginning and practice it often. I try to avoid phrases like:

"Well, it looks like it's about time. I think I'm going to start now."

Although I try, I'm only human and don't get it right every time. What is my preferred way to kick things off?

"Hello, everyone! Welcome to Live Coding BBS Systems on the Commodore 64" and jump straight into my slides. If I have something with impact to share, I'll usually open with that before mentioning my name or background. I introduce myself and share a slide with contact information but emphasize everyone is free to meet me *after* the talk so I can move into the content of the talk. I've learned most attendees either don't care who I am or already know, so they receive more value when I spend that extra time on the topic I'm presenting.

I suggest you never apologize before a talk. "This is my first time so sorry if the demos mess up" sets a negative tone. Own the talk and present as if it will go well and handle any hiccups with a sense of purpose. When speakers tell me, "This is usually an x-minute talk, but I've hacked it down for you" it leaves me with a slight sense of loss. What did I miss? Was the talk incomplete? It's OK to trim down a talk and offer it as a complete package. The assumption is you've pulled in the important pieces to make it work and can refer to other documentation or presentations to fill in the gaps.

You can start with a question, a mind-blowing fact, or an engaging story. If you have just under 8 minutes, 👀 look at some actionable tips here:

{{<customtwitter 1131458533055193088>}}

Talks tend to fizzle early when they start with, "Let's see, where are my slides" or a deep sigh followed by, "Let's hope this goes well." The theme here: present with confidence even if you're not feeling it, don't apologize for being you and taking the risk to stand in front of an audience and dive directly into the material. Save small talk for the moments leading up to the start.

> ⭐ **Tip:** There's nothing wrong with getting everyone excited and feeling good at the beginning of the talk. I often ask the audience to thank the sponsors and other speakers or show with applause how they feel about the conference so far. Sometimes I bring a 360° camera and ask if they would "opt-in" to a picture, then request everyone screams and shouts to show a good time. The end result? Everyone has fun, is energized and feels great going in the session. [Check out my 360° conference pictures](https://kuula.co/post/7Phn8/collection/7fy4R).

## Delivery

Delivery is what you've been practicing for. Here are a few things I do during my talk:

* Identify and speak to faces in the audience. I try to engage as many people as possible, and being acknowledged with a smile or nod is always rewarding.
* Gauge the energy of the audience. If it's after lunch and half the attendees are falling asleep, I might modulate my voice, shout a phrase or pivot somehow to re-engage.
* Listen to my own delivery and course-correct if I'm using filler words like "actually" or "basically" too often (the solution is just to pause when pivoting or collecting my thoughts rather than shoving random words into the gap).
* Move around a bit when it makes sense but not to the point it is distracting.
* Use my hands and arms effectively but not over-dramatically to emphasize points.
* Speak to the camera for the offline audience if the session is being recorded.
* Keep tabs on time to ensure I'm on track to conclude at the right time.

For a great series that covers delivery, check out:

{{<iconlink "https://dev.to/azure/use-your-voice-effectively-for-impactful-presentations-4128" "Use Your Voice Effectively for Impactful Presentations">}}

> ⭐ **Tip:** Running long is disrespectful of the audience and the next speaker's time. Be prepared to omit parts of your talk if needed. I usually practice a talk several times for pace and know the areas I can either mention to make the talk faster or dive into more detail if I have extra time. It's fine to end early after you've covered your points and field questions. Few developers will complain about getting some time back on their schedule to catch their breath between sessions. Try not to call attention to the fact you ended early or missed content. Own the presentation and if there is more to share, call it out in a follow-up Tweet or blog post.

## Concluding and Managing Questions

I try to finish as strong as I started. I never liked hearing, "Well, I guess that's all I have," or "I think I'm done." I also don't like choose-your-own-ending, when the speaker says, "We have a few minutes, would you like to see...?" I've done this but it typically goes better when I make the decision up front, and either share the additional content or break for questions.

Managing questions is an art. It's possible to become completely derailed by questions, especially if you have someone who either wants free consulting during your session or is a troll that likes to be heard. I always go into a presentation understanding my approach to questions. If I know I have the time, I'll take them and even ask for them during the presentation, but more often I wait until the end. I don't make any special announcement at the beginning. I also have a tip for conferences: *don't keep your audience captive*. I've seen some great talks that could have had a strong finish fizzle in the 10 minutes of post-talk questions.

My preferred approach now is to finish the talk with a strong summary of what was presented followed by a call to action: "Follow this link to learn more about the 6502 instruction set. The deck will be available by end of day." Then, I make it clear I'm available for questions but everyone else is free to leave. "I'm staying for the rest of the conference and look forward to meeting you! We have about 5 minutes left, so I will remain up front to answer any questions you may have. Thank you for spending your afternoon with me!" This signals everyone to leave but provides an option for those with questions to ask them.

{{<customtwitter 748853991291793408>}}

The other thing I'll do is go ahead and break down my equipment and step off stage. This brings me to the same level as the audience so I'm not answering by "talking down" to anyone, but it does something else too: it gives the next presenter the opportunity to step up and begin their setup. There is nothing more frustrating than to have just minutes before your presentation begins only to find the last speaker is still on stage and surrounding by a line of attendees with questions!

Your mileage may vary, but I've found my talks are paced well and end well if I defer questions to the end and after I've released the audience.

## Networking

If your schedule and work allow it, please try to stay through the entire conference! Presentations deliver tremendous value, but often it's the networking that happens before and after that catalyzes growth and transformation. Here's a few tips for successful networking: 

* Spend some time in the speaker room and get to know the other speakers. Try to avoid staying there the entire time, however, because attendees won't be able to meet you there!
* Introduce yourself to the vendors and sponsors and be sure to thank them, especially when the conference is able to cover your travel expenses (that sponsor is likely where the travel budget came from). 
* Be present and accessible between sessions so that attendees can find you and interact. If you get exhausted from presenting and/or interacting with people, consider taking time during sessions to go into a quiet corner and recharge.
* When there is a lunch or happy hour, I try to avoid gravitating to the people I know and instead either find and open space to build a new group or move to a circle of people I don't know and introduce myself (obviously that requires feeling comfortable doing this, it's something I avoided in the past but started doing in spite of my fears/reservations and now I love the positive interactions that unfold as a result).

{{<customtwitter 1133996319360655360>}}

## Other Sessions

Last, but not least, take some time to attend other sessions! Confused about where to go? Here's some ideas to consider:

* If you have coworkers, colleagues, or friends speaking, consider attending their sessions to offer encouragement, support, and constructive feedback.
* If you are a developer or consultant, look for topics that may either reinforce a technology you are working with or introduce you to a potential new solution you may not have had time to explore on your own. 
* I try to find at least a few talks that cover a topic I know *nothing* about. Sometimes I'm surprised and find myself interested in learning more.
* Sometimes you may learn more from the attendees than the presentation. For example, I always pay attention when someone takes a survey, like "What front end framework do you use?" This helps me track trends. I am also interested in the questions attendees ask and their backstories. You can learn a lot from others' experiences!
* Watching other presentation styles, demos, and slides may help spark new ideas or reveal an approach you hadn't considered before. I learn tons when I see people do things like hand draw their slides or demo IoT devices in creative ways.

> ⭐ **Tip:** most speakers love to document their talks but not everyone is comfortable taking a picture of the audience or a selfie. If you are in a session, why not snap a shot from the back of the room, post it and tag the speaker? They'll likely appreciate you for it and you may gain a new follower or create a networking opportunity as the result. Then you can share this tip and maybe someone will capture and comment on *your* presentation.

    {{<customtwitter 1137034439438061569>}}

## 🎉 Celebrate

The talk is over ... there's more to do (I'll cover that in my next and final installment) but you can breathe a sigh of relief and do a little dance in the corner. If you feel great about the talk, consider taking a selfie or recording a short video sharing what it feels like that you can refer to for motivation before future talks. If you don't feel so great, think about why and put together a plan to let go of the things you cannot change and address, practice, learn or correct the things you can. 

🗣 **Let's discuss** Do you have any tips of your own or personal experiences to share about delivering presentations?

> The "Three D's of Modern Web Development" is a favorite presentation of mine that as recorded at the [Connect.Tech](https://connect.tech) conference. It is a mix of PowerPoint and live coding and fits in a 60-minute "breakout session" slot. The video is free to watch but embedding is turned off so you can access it here: <i class="fab fa-vimeo"></i> [The Three D's of Modern Web Development](https://vimeo.com/303443966).

Regards,

![Jeremy Likness](/images/jeremylikness.gif)
