---
title: "What's in the 💼 Bag? Packing Tips for Technical 🎦 Presentations"
author: "Jeremy Likness"
date: 2019-06-03T13:46:00-07:00
years: "2019"
lastmod: 2019-06-24T13:46:00-07:00

draft: false
comments: true
toc: true

canonicalUrl: "https://dev.to/azure/what-s-in-the-bag-packing-tips-for-technical-presentations-4k6n"

subtitle: "For presentations both near and far"

description: "Don't leave for a technical presentation without considering these key things that will help you whether you are traveling around the block or around the world."

series: "Comprehensive and Practical Guide to Technical Presentations"

tags:
 - Presentation 
 - Productivity
 - Learning
 - Travel

image: "/blog/presenting-7-packing-tips-for-technical-presentations/images/delta.jpg" 
images:
 - "/blog/presenting-7-packing-tips-for-technical-presentations/images/delta.jpg" 
 - "/blog/presenting-7-packing-tips-for-technical-presentations/images/food.jpg" 
---

## 👉🏻 Prepare to Travel

Your presentation may be in the office down the hall. Or it may be on the other side of the world! Preparing for your presentation can be stressful enough without the added overhead of making sure you have everything necessary to pull it off. In this article I'll share with you the tips and techniques I've used to be "presentation ready" whenever, wherever I go. I hope you find it useful and look forward to your feedback and suggestions as well!

![Delta airplane with Mt. Rainier in the distance](/blog/presenting-7-packing-tips-for-technical-presentations/images/delta.jpg)
<figcaption>Waiting to travel to a presentation</figcaption>

## 💻 Computer

This one is obvious: don't forget your computer! This should be the same computer you practiced your presentation on. Some conferences provide a laptop and offer to load your presentations. If that's the case, be sure to arrive early so you can access the machine and confirm everything works fine. You might be surprised how something simple like not having the same fonts can throw a presentation off! 

{{<customtwitter 1099446621908144130>}}

Some speakers prefer to bring a backup laptop. This is a second machine they can turn to in case their primary machine fails (it's not a question of *if* but *when*). I take the risk of only having one machine, only because my second computer is a massive gaming machine that would cause neck injuries if I tried to lug it around.

> ⭐ **Tip**: I save everything to the cloud. My deck is on a cloud storage device and my code is checked into GitHub. If my primary machine fails, I'm only a few pulls and installs away from building a new environment that is presentation ready. I can't over-emphasize how important this is. I use a cloud storage option that supports versioning. I've had PowerPoint presentations end up corrupted and not being able to roll back to previous version can mean hours of unexpected work. Now, if there is an issue, I easily choose the previous version to restore and continue from my last save point.

## 🔌 Adapters and Cables

I always keep several items in my laptop bag. Instead of only packing them when needed, and taking the risk I might forget something, I created the habit of having them available all the time. It turns out that having adapters and cables is a great way to make friends both in the office and out in "the field."

### Always Available

This is the list of items I always take with me. I bring my own pointer, cables, and adapters and never assume that the venue will have them available. This way I'm never caught off guard. I order almost all my items from Amazon.

* My laptop bag of choice is an eBags Professional Slim Laptop backpack
* A BUBM (be unique be myself) cable organizer
* Laser pointer/slides remote (I use the Kiartten Wireless Presenter)
* Mini-display port adapters: HDMI, VGA, and DVI (I keep 2x HDMI because these tend to fail fast)
* Bluetooth Surface Arc Mouse
* Power cable for the laptop
* USB cable for my phone
* USB cable for my fitness watch
* USB plugs
* USB-to-Ethernet dongle
* RAVPower Turbo series USB 3.0 Quick Charge charging brick
* USB 3.0 4-port hub
* Multi-adapter (mini to micro to USB-C etc.)
* HDMI cable (this is great for watching movies on the hotel TV and practicing talks in the room)
* Bose noise cancelling in-ear headphones
* Jabra headset for webinars/team calls on the road

To make life easier, I put together an <i class="fab fa-amazon"></i> [Amazon list](https://amzn.to/2YshuYg) for these items.

### International Travel

The only thing I add for international travel is the transformer and adapter. I recommend the BESTEK 200W Power Converter 3-Outlet and 4-Port USB transformer ... this has every adapter for any country in the world and with one plug I get multiple power outlets and USB. The plugs are all universal, meaning you don't have to use the transformer but can plug your laptop directly into the adapter and the adapter into the wall.

## 🥑 Food

Why do I mention food? Because it's important you are not hungry going into your presentation! I follow a plant-based diet, so I am not always able to eat the food that is offered at meetups and conferences. I try to pack snacks to have on hand in case I'm hungry and add extra items when I travel.

![Various food items](/blog/presenting-7-packing-tips-for-technical-presentations/images/food.jpg)
<figcaption>Various food items</figcaption>

These include protein bars, dried fruit, and nuts. I try to eat every few hours even when I'm not hungry to ensure I have the energy needed to deliver a lively presentation. On longer trips, I also pack protein shakes in individual zip lock bags, put those in a larger bag to minimize risk of powder getting on everything, and bring along a shaker cup.

## 💊 Vitamins and Medication

In my opinion, speakers should always have three key medicines on hand (even when you are just going to the local meetup):

* Ibuprofen for headaches and/or fever
* Bismuth subsalicylate (a common brand of this is Pepto-Bismol) for upset stomach
* Loperamide (common brand is Imodium) to deal with unanticipated gastrointestinal challenges

The first two are to help you feel better, the last one is a stopgap so you can deliver a talk without having to run off stage.

### Prescription Medications

I prefer not to travel with my full prescription and empty most of the bottles, so I just have enough on hand with a buffer. For example, if I'm traveling 5 days, I'll keep about 7 or 8 pills in the original prescription bottle and bring that with me. If it gets lost or stolen, I still have my remaining supply at home, and if I get questions at customs, I can show the original prescription on the bottle.

### Sleep

Melatonin is great to help with sleeping on the road. I've discussed this with many other speakers and there is a consensus it works great for settling down after travel and helping adjust to new time zones.

### Vitamins

I take daily multi-vitamins and believe they are even more important when traveling. I am not a doctor and certainly don't consider my anecdotal experience to be a scientific case study, but here's a fact: it's been over a decade since I caught a cold or other viral infection when traveling (and I travel *all* the time). I've had a few stomach bugs, but that's it! I hear a lot of people prepare for the inevitable, "I'm on a 6-hour flight so I'm going to catch something" and I don't believe it's inevitable at all.

I attribute my success to exercising regularly, eating healthy, and taking multi-vitamins. In my opinion Vitamin C is the most important. I take 1500mg per day and increase this to 2g - 2.5g daily when I travel internationally.

My strategy is to purchase tiny bags large enough to hold a day dose of vitamins and pre-pack each day. Then, on the road, it's as simple as grabbing a bag and keeping it in my pocket until I've taken everything.

If you're curious what vitamins I take, this is my basic daily regimen. I purposefully left off dosages because these vary by individual and you should really research what you are taking.

* Fish oil (yes, this is the exception to plant-based)
* Magnesium - helps with muscle recovery and sleep
* Vitamin C - immune system
* Men's multivitamin - I take this throughout the day because one-a-days are a scam

## 👔 Clothes and Shoes

I tend to wear one pair of running shoes if the event is casual. I keep these loose, so they are easy to slip off and on. If the event is more formal, I'll pack a pair of dressier shoes.

I break my clothes down into four basic categories:

1. **Event clothes** - attire appropriate for the presentation and other days I may be attending
2. **Local clothes** - attire appropriate to the location for casual hanging out (for example, if the venue is in Florida, I'll bring shorts and a short-sleeved shirt)
3. **Workout and swimming clothes** - I always try to work out on the road and bring a pair of swimming clothes in case there's a pool or water event
4. **Travel clothes** - something loose, soft, and comfortable to wear when flying in/out

Remember, you *may* end up acquiring additional clothes at the event.

{{<customtwitter 1012289018296459267>}}

> ⭐ **Tip**: workout clothes are never fun to pack. If you aren't able to launder them before you return, most hotels provide a plastic laundry bag that I re-purpose by stuffing with my workout clothes and sealing them off from the rest of my suitcase when I return home.

## 🚽 Toiletries

The only thing to share here, because everyone is different, is my system to ensure I pack everything. The day before I travel, I go about my business as usual but take everything I use and set it aside on my counter. This ends up being floss, electric toothbrush, etc. By setting it aside I can easily access it the morning of travel and pack it last. This way I know I'm bringing everything I need.

> ⭐ **Tip**: unless you are very attached to your brand of toothpaste, almost every hotel I've ever stayed at had tooth paste available when I asked at check in.

## 👮‍♀️ Understanding Airport Security

If you are flying, you are going to encounter security. I wanted to close with a few brief tips to help expedite the process for you:

* Dress for security! Avoid a lot of layers and have shoes that are easy to slip on/off. I typically put my coat in my suitcase until I clear security. You can always add layers after!
* If you're fortunate to have pre-check you do *not* have to take laptop out of your bag, remove shoes and in most cases can leave your belt on.
* No liquids! Make sure your water bottle is empty. If you have small items with liquids be sure they are in a separate, easy to access bag.
* The only thing you need to keep out is your identification and your ticket. Once you are moved into the security, you can put those away.
* I typically put my watch, phone, and wallet in my laptop bag with an easily accessible pocket to go through the scanner.
* For international travel, assume you will need to remove your laptop from the bag. In some cases, you need to remove cords as well, which is why I keep them in an organizer that is easy to remove.
* Also, always assume you will go through security again when connecting in international flights! I will pack most of my stuff in my bag before landing to expedite the process for my connection.

## 🆗 Now You're Ready

I hope these tips have helped prepare you ... next up, we'll dive into the talk itself and cover the day of your presentation!

🗣 **Let's discuss** What are your "must have" items for your laptop or travel bag?

> The "Three D's of Modern Web Development" is a favorite presentation of mine that as recorded at the [Connect.Tech](https://connect.tech) conference. It is a mix of PowerPoint and live coding and fits in a 60-minute "breakout session" slot. The video is free to watch but embedding is turned off so you can access it here: <i class="fab fa-vimeo"></i> [The Three D's of Modern Web Development](https://vimeo.com/303443966).

Regards,

![Jeremy Likness](/images/jeremylikness.gif)
