---
title: "How to Practice for a Lit 🔥 Presentation"
author: "Jeremy Likness"
date: 2019-05-18T13:46:00-07:00
years: "2019"
lastmod: 2019-06-24T13:46:00-07:00

draft: false
comments: true
toc: true

canonicalUrl: "https://dev.to/azure/how-to-practice-for-a-lit-presentation-51n9"

subtitle: "Light your presentation on fire"

description: "Some strategies and tactical steps that prepare you to deliver your technical presentation."

series: "Comprehensive and Practical Guide to Technical Presentations"

tags:
 - Presentation 
 - Productivity
 - Learning

image: "/blog/presenting-6-how-to-practice-for-a-lit-presentation/images/cheering.jpg" 
images:
 - "/blog/presenting-6-how-to-practice-for-a-lit-presentation/images/cheering.jpg" 
 - "/blog/presenting-6-how-to-practice-for-a-lit-presentation/images/onenote.png" 
---

## 👉🏻 Practice and Feedback

You may have heard the expression *"practice makes perfect."* I don't expect to be perfect, but I do look for progress every time I deliver a technical session. My goal is to feel comfortable with the content, the timing, and any hiccups that may occur every time I step in front of an audience. Getting there requires a bit of practice and, perhaps surprisingly, stepping out of my comfort zone even when I'm alone.

{{<customtwitter 1111338505924276225>}}

This article is about the techniques I've developed to practice delivering technical presentations so I'm just as confident the first time as I am the third or fourth iteration of a talk.

> For most of my career, I was a full-time software developer and/or consultant and prepared/delivered presentations in my "free time" meaning after hours and often at the last minute. Presenting is part of my current role, so I often have more time to practice and prepare than others who are doing it "on the side." I'm sharing all my tips but please don't feel you have to implement everything in your time-constrained schedule. Find what works best, cut the corners that make sense and *thank you* for volunteering your time to the benefit of others.

## ✅ The Check List

A good friend and colleague of mine <i class="fab fa-twitter"></i> [Laurent](https://twitter.com/LBugnion) shared with me a brilliant technique for preparing technical presentations. It's simple but powerful. As you craft your presentation, create a checklist in the app of your choice (I prefer OneNote) with preparation steps. This ensures everything is setup appropriately. As you practice your presentation, you modify the checklist until everything is dialed in. It's not a walk-through of the demo, but setup steps and reminders to ensure everything is prepared.

![Example OneNote checklist](/blog/presenting-6-how-to-practice-for-a-lit-presentation/images/onenote.png)
<figcaption>Example OneNote checklist</figcaption>

I take advantage of [Windows 10 virtual desktops](https://blogs.windows.com/windowsexperience/2015/04/16/virtual-desktops-in-windows-10-the-power-of-windowsmultiplied?utm_source=jeliknes&utm_medium=blog&utm_campaign=link&WT.mc_id=link-blog-jeliknes) to stage my talks. I set up my presentation on the main desktop. I launch an app named Windows Mobility Center that helps with presentation settings by suppressing notifications. I also use a free tool called [ZoomIt](https://docs.microsoft.com/en-us/sysinternals/downloads/zoomit?utm_source=jeliknes&utm_medium=blog&utm_campaign=link&WT.mc_id=link-blog-jeliknes) for zooming and annotating during the presentation. If I need specific reminders, I put them there.

The second desktop is typically where I stage the web browser. In the example talk I show two development environments, so one goes on the third desktop and the last is on the fourth desktop. Staging this way eliminates the need to `ALT+TAB` and find the right window and allows me to stay in presentation mode. I simply `CTRL+Windows+➡` or `CTRL+Windows+⬅` to navigate between desktops.

## All Things the Same

It is very important to practice with the same setup you will use to present. For example, I have a three-screen setup, but when I present, I often must duplicate my desktop. Therefore, I practice with one screen instead of three. Most projectors require 1080p resolution, so I always set my display to 1920x1080. **It is very important to practice with your target resolution!** Some windows may not behave the same in different resolutions and there is nothing more frustrating than opening a page to find part of it doesn't render under the resolution. 

Be sure to set fonts and themes that will be visible from the back of the room under poor lighting conditions. I use ZoomIt to emphasize important areas of the presentation but having a large, visible font is always the best approach. Although dark themes are very popular, they aren't easy to read on projection screens. I always present with a light or high contrast theme unless I know the dark theme colors and font are large enough and have enough contrast to be visible. Some terminals can act wonky when you increase the font size, so practice with the size you will use to present.

## 🎦 Videos

This may come as a surprise to some, but the Wi-Fi and the Internet aren't always available. If your demos depend on the Internet, it's a good idea to record them as a backup. Some presenters don't ever live code and always present recorded content, others like me prefer to do as much live as possible but have the video to fall back on. If there is a process that takes a significant amount of time, I may also record it to compress the waiting periods. If you are already practicing your video, why not record it? Windows 10 has capabilities built-in (it's technically for gaming, but who's keeping track?) by pressing `Windows+G`. I use Camtasia Studio. 

My preference is to record videos with no audio, then practice playing them as part of my presentation. That way I can narrate them live as they play and don't have to worry about whether audio is available at the venue. After the presentation, I can always go back and dub a narrative over the video and publish it for everyone to use.

## 👥 Audience

Most of the time, talking to yourself is frowned upon, but this is when I take exception. I have learned to become comfortable presenting to an empty room (or, in some cases, my German Shepherd who is a very attentive listener). It may seem strange to present to a phantom audience but getting comfortable with this approach can help tremendously. First, going through the actual presentation will give you an idea of what transitions feel like, what technical issues may be present, and above all how long the presentation takes. Everyone is different, but I find I often present a bit faster on my own than in front of an audience, so if my target time slot is 60 minutes I'll shoot for the 50-minute range in personal practice. Others find they practice more slowly because adrenaline and excitement take over during the real presentation.

{{<kuula 7l28V>}}
<figcaption>Getting the audience excited for a talk</figcaption>

> See a [gallery of 360° conference photos](https://kuula.co/explore/collection/7fy4R)

Psychologically, the more comfortable I get presenting by myself, the more confident I am presenting on stage. Your mileage may vary, but I believe it is because doing it without an audience requires me to be more comfortable with, well, me. That, in turn, makes me more comfortable being in front of others. If you choose this route, consider recording the presentation. You can share the recording with others to get feedback and refine your session before the actual event.

Finally, I look for every opportunity to share the presentation with my peers before I stand on stage the first time. I will set up a screen share or webinar and present that way. I prefer when people do *not* mute so I can hear feedback (for example, it's always a positive when you make a joke and are rewarded with laughter). It can be intimidating to present to peers, but I found that they offer a "safe place" for constructive feedback. Being able to refine my talk and address issues builds my confidence and improves the overall quality of the session.

## ⛔ Don't Over Practice

It can be tempting to want to practice every word, gesture, and nuance. For some people, this works well and is the only way to feel confident and ready. If that's you, feel free to ignore my advice. You do you! For me, I found that over-practicing made my presentations feel artificial and more like well-rehearsed pitches. My goal is to make connections, so I want to be as authentic and genuine as possible. Therefore, I only practice a session a few times. This is my typical process:

1. Practice once for timing
2. Add or remove content and address any demo issues
3. Practice live/webinar/record and share for feedback
4. Modify based on feedback
5. Practice one more time to verify the result

The exception to this is when my presentation has lots of live coding. If that's the case, I'll practice several more times to get the timing of the demo portions dialed in.

> There is an art to timing in presentations. I've always been able to come close to my target time. Demos are a great way to manage timeline. If I find I'm running out of time, I'll show a completed product and walk through the code to save time. If I find I'm going too fast, I'll walk through more of the live coding and build more of the app from scratch. Although I personally always try to come within 5 minutes of the target time, leaving time at the end of questions, I'm also careful not to "pad" with extra content that doesn't really fit with the presentation. It's OK to end a bit early if you've covered all the relevant points.

A mentor of mine once told me, "You know what you know what you know." He meant that the key to a good presentation is what you put into it in the weeks leading up to it, not the night before. I rarely practice talks the week of my presentation. This gives me more time to relax and mentally prepare, and I believe provides a more genuine and organic experience. 

🗣 **Let's discuss** What techniques do you use to practice your presentations? What tips would you like to add? Use the comments below!

> I've already shared videos of a user group presentation and a webinar. The example session for this article is a webinar that I presented for a user group. It was a fun, interactive format and allowed me to combine a prepared presentation with live, unscripted dialog.

{{<youtube xrzpYMstTvc>}}

Regards,

![Jeremy Likness](/images/jeremylikness.gif)
