---
title: "The Many Flavors of Technical Presentations"
author: "Jeremy Likness"
date: 2019-04-15T13:46:00-07:00
years: "2019"
lastmod: 2019-06-24T13:46:00-07:00

draft: false
comments: true
toc: true

canonicalUrl: "https://dev.to/azure/the-many-flavors-of-technical-presentations-3fjj"

subtitle: "Oh, how many ways can I present thee?"

description: "A survey of different presentation styles from lightning talks to keynotes and workshops."

series: "Comprehensive and Practical Guide to Technical Presentations"

tags:
 - Presentation 
 - Productivity
 - Learning

image: "/blog/presenting-1-a-guide-for-everyone-who-wants-to-give-technical-presentations/images/technicalpresentationshero.jpg" 
images:
 - "/blog/presenting-1-a-guide-for-everyone-who-wants-to-give-technical-presentations/images/technicalpresentationshero.jpg"
---

![Technical presentations](/blog/presenting-1-a-guide-for-everyone-who-wants-to-give-technical-presentations/images/technicalpresentationshero.jpg)

## 👉🏻 Talk Formats

Did you know there are several different styles (or "types") of presentations? Here are a few popular formats.

## ⚡ Lightning talk 

A personal favorite of mine, these are short (5 - 15 minute) minute presentations designed for maximum impact in minimal time. Stripping your presentation down to a short period captures the essence of what you are trying to convey. It can be easier to prepare and practice these talks as well. **In my opinion, this is the best type of session**. Why? Because people tend to have short attention spans, so I suspect the shorter sessions have more impact.

{{<customtwitter 1039930388942966784>}}

## 🗣 Breakout session 

This is the common format of a classroom-style presentation with you speaking for anywhere from a half hour up to 75 minutes. I personally find that 45 minutes is a "sweet spot" and don't like the longer formats but be prepared for anything in that range.

{{<customtwitter 1049404166026797056>}}

Example of demos with step-by-step instructions for a breakout session:

{{<github "JeremyLikness/blazor-wasm">}}

## 👥👥 Panel

A great way to get in front of an audience for the first time, instead of preparing demos and decks, you can participate in a panel and answer questions based on your insights and expertise. These may be open topics and questions or have a set of prepared questions you can research beforehand.

{{<customtwitter 647835745173012480>}}

## 🗝 Keynote

The keynote is often the first session of the conference or the day, although many events host closing keynotes as well. The keynote is designed to set the tone or mood of the conference and kick everything off in a positive, energetic, and insightful way (or conclude with some powerful parting thoughts). Successful keynote speakers know their audience and build content that appeals to attendees and resonates with the theme of the event.

{{<customtwitter 1116701089909362689>}}

Example keynote content:

{{<customtwitter 1116706599807139840>}}

## 📣 General Session

A general session is like a keynote. Events with multiple tracks will often have a general session that is not called a keynote because it's meant to be more like a breakout session that appeals to everyone.

## 🏗 Workshop

Workshops usually last for hours or days and walk the audience from start to finish through a concept. They are often classroom style and feature hands-on labs that the speaker(s) assist with. If you enjoy teaching and mentoring, you may find you enjoy the workshop format. The caveat is it takes significantly more time to prepare than ordinary talks. For example, if I am doing a day long workshop (typically 6 hours of "active" content, the rest of the time is taken by lunch and breaks) I look at it as preparing 6 talks *plus* being able to follow the lab steps and verify that they work to produce a completed product.

{{<customtwitter 1047138574724943872>}}

Example workshop:

{{<github "brminnick/azure-for-developers-workshop">}}

## 🔬 Lab

Compared to workshops that involve active presenters, labs are typically self-guided activities with proctors to help. The audience is pointed to a resource that contains detailed instructions, and proctors are available to answer questions and help troubleshoot problems.

Example of a hands-on lab:

{{<github "JeremyLikness/azure-fn-file-process-hol">}}

## 👩🏻‍🏫 Open Spaces

I love conferences that provide open spaces! These are ad hoc presentation areas. Usually you sign up for an open space with a presentation or even an idea for discussion. You get assigned a time slot and then anyone interested stops by to collaborate. It's usually more intimate and less pressure than a full presentation. Consider trying these out at a conference if you're not sure you are ready to take the stage. Often, I find topics include support for aspiring speakers.

## 🐦🦜 Birds of a Feather

Another casual way to share your knowledge: with "birds of a feather" you are encouraged to mingle with attendees to answer questions and share your insights. This is often done over lunch, and tables are labeled with either names or topics that people can sit to discuss. Birds of a feather facilitates comfortable and casual interactions.

{{<customtwitter 1103381061873135616>}}

> **Pro-tip** It's fine to share your talk at multiple venues, especially if you are speaking nationally and internationally. Every audience is a fresh opportunity to engage with more developers. I welcome feedback and constructive criticism for my sessions, and often find by taking that feedback and tweaking my talk it is much better on the fifth delivery compared to the first. I will also often craft a talk based on the longest session I'll give (60 or 75 minutes) and then trim it back to create condensed versions for shorter speaking slots.

Hopefully this list helps with your decision!

> The example talk here is a presentation called "Intro to TypeScript" that I delivered to a local user group, The [Atlanta JavaScript Meetup Group](https://www.meetup.com/AtlantaJavaScript/events/245257740/).

{{<youtube kxkzbMCc8Gg>}}

Regards,

![Jeremy Likness](/images/jeremylikness.gif)
