---
title: "How to Choose Where to Give Your Technical Presentation"
author: "Jeremy Likness"
date: 2019-04-08T19:46:00-07:00
years: "2019"
lastmod: 2019-06-24T13:46:00-07:00

draft: false
comments: true
toc: true

canonicalUrl: "https://dev.to/azure/how-to-choose-where-to-give-your-technical-presentation-5g14"

subtitle: "Practical guidance for picking a venue"

description: "A review of different styles of venues for technical presentations. Learn how to narrow down your options and choose the right place to speak."

series: "Comprehensive and Practical Guide to Technical Presentations"

tags:
 - Presentation 
 - Productivity
 - Learning

image: "/blog/presenting-2-how-to-choose-where-to-give-your-technical-presentation/images/meetup.jpg" 
images:
 - "/blog/presenting-2-how-to-choose-where-to-give-your-technical-presentation/images/meetup.jpg"
---

There are a lot of options for speaking and your comfort level may vary. Here are a few ideas of ways to get started.

## 👉🏻 Where to Speak?

![My colleague Cecil Phillip and me at Meetup headquarters](/blog/presenting-2-how-to-choose-where-to-give-your-technical-presentation/images/meetup.jpg)
<figcaption>My colleague Cecil Phillip and me at Meetup headquarters</figcaption>

* **Brown bag sessions** I find sharing sessions internally with my team or other associates at my company is a great way to vet content in front a "safe" audience. I can get great feedback to improve the talk if I deliver it internally first or use my effort to create the content to empower coworkers if it's already been presented. Some people are more intimidated by their peers and may choose a different approach.
* **Webinars** Web-based presentations are great, especially if you're not entirely comfortable in front of an audience. Speaking to a camera with no audience participation can have its own challenges, however. There is something to be said for delivering a presentation from the comfort of your office that may ultimately be seen by thousands of developers around the world.
* **Local schools and colleges** Very early in my career I had the opportunity to work part-time as a computer instructor for a local college. In hindsight I realize it was already "public speaking" but I felt comfortable about it as an instructor. There are lots of opportunities to engage with students and share your knowledge.
* **Meetups and user groups** This is how I started speaking. A fast and easy way to find a local meetup or user group is to head over to [https://meetup.com](https://www.meetup.com/members/10127361/) and search on technology and area. Local groups are a great way to get started because they are often open to new speakers, offer support and guidance for your first talk, and prefer to showcase members of the local community.
* **Code Camps** Code camps are typically day-long community-focused local events. They often happen on a weekend to make it easier to attend. Some code camps attract thousands of developers and speakers from around the world. I find code camps tend to be very supportive of first-time speakers but are happy to host experienced presenters as well.
* **Conferences and trade shows** Conferences and trade shows are what most people think of when they hear, "public speaking." There are conferences focused on industry, languages, platforms, software, culture, gender, and more. They are often multi-day events at large venues and frequently feature "tracks" of sessions aligned on categories like "web" or "front-end development." Most conferences and trade shows organize social events for attendees and speakers to mingle and appreciate the host city.

> Do you have a favorite source for finding events? It would be great if you could share your links in the comments below. Two services I use often are [PaperCall](https://www.papercall.io/speakers/jeremylikness) and [Sessionize](https://sessionize.com/jeremylikness).

## Narrowing it Down

When you have a wide variety of options, how do you choose? There are several ways to can narrow down the right venue.

* **Geography** Location, location, location. I recommend getting comfortable with local venues before you travel to speak.
* **Travel and Expenses** When you are looking at places that require travel, one thing to look for is whether they cover speaker travel. Some events will take care of your airfare and/or hotel. Experienced speakers can even get paid to deliver sessions at some conferences.
* **Audience** It is important to understand the audience. The organizers should be able to help you understand what to expect. Is it a business crowd? Developers? Designers? Junior developers? Seasoned professionals? All the above? Knowing your audience will help you target the right place for the content you've created.
* **Support** I like to reach out to former speakers (you can often find the speaker list from previous years) to get their impression of the event. How much support did they receive? Some events reach out to you well ahead of time, offer templates and tips, give you maps and coordinate travel and outings, provide clear and detailed instructions of what to expect and even cater to any unique dietary preferences you may have. Unfortunately, I've also seen the other extreme and have even been "accepted" without being notified and only found out because someone saw my name on the site and mentioned it on twitter! Mature events take care of speakers. You have enough stress on your plate without having to worry about anything other than showing up and delivering your presentation! Here are some of the speaker amenities I've been offered in the past:
  * Paid travel and hotel
  * VIP speaker dinner
  * Speaker gift (everything from shirts to smart bulbs to Echo)
  * Guided tour of the host city
  * Banner and ad copy to promote sessions
  * Professional photographer
  * Pick-up/drop-off from the airport
  * Local sim card for international destinations
  * ...your mileage may vary but these are some things to consider!
* **Agenda** The agenda can say a lot for an event. Most events keep older years online so you can "look back." Things I look for in an agenda:
  * Is there 15 minutes or more between talks so everyone has enough time to take breaks, move to the next session and network in between?
  * Is there a clear gap between sessions to give speakers enough time to set up for their presentation?
  * Are there open spaces available for impromptu talks, networking, and speaker Q&A?
  * Do any sessions compete with the same topic?
  * If there are tracks, what are the tracks and are the sessions clearly aligned within tracks?
  * Do competing sessions get scheduled at the same time? (For example, a React talk in parallel with an Angular talk makes more sense than two different Angular talks at the same time ... unless, of course, it's an Angular conference)
* **Venue** The venue is very important. It's always interesting when a conference moves to a new venue to see what the experience is. Are the screens clear? Do the projectors support high resolution? Are the rooms long, deep, or wide? Are microphones provided? Is there a good mix of large and small rooms to accommodate the proper demand? How spread out is the venue? If it's large, does the schedule allow plenty of time to move between sessions? Remember, it takes several minutes to set up and get ready to present.

    {{<customtwitter 962312534048075776>}}

* **Speaker Networking** There is tremendous value in networking with other speakers. Does the event provide some events specifically for the speakers? Is there a room set aside to network, unwind, or review your presentation before you go on stage?
* **Attendee Networking** The entire point of delivering sessions is to provide value to attendees. I look for events that encourage interactions and networking. An attendee reception or party is always great. Providing opportunity for speakers to network over lunch and breaks is also key. One event I really enjoyed spaced events apart by 30 minutes and provided a whiteboard with chairs outside of every room so speakers could spend 15 minutes on face-to-face Q&A with attendees.
* **Code of Conduct** A code of conduct is paramount. Our team won't attend events without one. A code of conduct clarifies expectations during the event, should clearly enforce the safety of everyone involved, and have a clear set of actions to take when violations are encountered.
* **Diversity of lineup** Diversity and inclusion are hot topics and can be "hot buttons" for some. The organizers should make every effort for the venue to be open and welcoming to everyone. Our industry has professionals from all walks of life, including different races, cultures, countries, and genders, and a lineup should reflect that. I look for events that consider this as early as planning and committee selection, rather than as an afterthought, i.e. "Wow, we really should have some women on this panel, are you available?"

> **Side bar: The "Speaker gift"** There are a lot of opinions about receiving speaker gifts and benefits. The idea is that if there is budget, why not use it to sponsor underprivileged developers so they can attend? This is something to consider. Personally, I know many speakers travel at their own expense and invest their own time and energy, so they deserve the perks. In my case, my company often covers the cost to travel and I can even produce content on "paid time" so it's more of "what I do." For that reason, I typically inform the organizers that my company will cover costs and ask them to allocate the budget elsewhere. More often than not, they agree and may sponsor a ticket or even cost of travel for an attendee or use the budget to promote community events that happen around the time of the conference.

🗣 **Let's discuss** What are your favorite events? How do you find places to present?

> My example presentation for this article is a lightning talk I gave at Microsoft's [//build conference](https://mybuild.microsoft.com/?utm_source=jeliknes&utm_medium=blog&utm_campaign=link&WT.mc_id=link-blog-jeliknes). I took a 60-minute presentation and condensed it down to 20 minutes focused on as much value as I could deliver in the short period of time. The venue was "theater style" meaning an open platform in a large showroom, so there was a lot of background noise and foot traffic. It was a great learning experience!

{{<youtube tBollT76thk>}}

Regards,

![Jeremy Likness](/images/jeremylikness.gif)
