---
title: "A Guide for Everyone Who Wants to Give Technical Presentations"
author: "Jeremy Likness"
date: 2019-04-08T13:46:00-07:00
years: "2019"
lastmod: 2019-06-24T13:46:00-07:00

draft: false
comments: true
toc: true

canonicalUrl: "https://dev.to/azure/a-guide-for-everyone-who-wants-to-give-technical-presentations-53bo"

subtitle: "Know your why first"

description: "Introduction to a multi-part series about brainstorming, submitting for, building, practicing, delivering, and following up on technical presentations."

series: "Comprehensive and Practical Guide to Technical Presentations"

tags:
 - Presentation 
 - Productivity
 - Learning

image: "/blog/presenting-1-a-guide-for-everyone-who-wants-to-give-technical-presentations/images/technicalpresentationshero.jpg" 
images:
 - "/blog/presenting-1-a-guide-for-everyone-who-wants-to-give-technical-presentations/images/technicalpresentationshero.jpg"
 - "/blog/presenting-1-a-guide-for-everyone-who-wants-to-give-technical-presentations/images/atlantacodecamp.jpg" 
 - "/blog/presenting-1-a-guide-for-everyone-who-wants-to-give-technical-presentations/images/internationalspeakingvenues.jpg" 
---

![Technical presentations](/blog/presenting-1-a-guide-for-everyone-who-wants-to-give-technical-presentations/images/technicalpresentationshero.jpg)

All I remember is a room full of 👀 eyes that were fixed on me. I started to speak but was immediately gripped by fear and forgot the words. All that came out was a weak croak 🐸. I swallowed nervously and began to shake. The faces in the front of the room took on expressions of pity 😞. I felt nauseous and wondered if I was going to pass out, but finally managed to spit out the title of my presentation. I continued to fight, stuttering the words and fumbling on the keyboard to type out the commands. After what felt like an eternity, I reached the end. I finished with the vow, "Never again."

![Atlanta Code Camp 2018 Keynote](/blog/presenting-1-a-guide-for-everyone-who-wants-to-give-technical-presentations/images/atlantacodecamp.jpg)
<figcaption>Atlanta Code Camp 2018 Keynote</figcaption>

Decades later I have spoken hundreds of times in front of audiences as large as thousands of developers. I've delivered everything from user group talks and opening keynotes to breakout sessions, short ⚡ lightning talks, and full day workshops. I've delivered some sessions that were 100% live coding. I gradually moved from regional talks to speaking nationally, then internationally. In 2018 alone I was on the road 100 days, traveling to 35 cities over 11 countries to deliver presentations. Over that time, I've learned a thing or two, and the purpose of this series is sharing those lessons with you. These aren't speaker best practices or secret tips to turn you into a top tier speaker, but practical advice based on personal experience.

![International speaking venues I've been at](/blog/presenting-1-a-guide-for-everyone-who-wants-to-give-technical-presentations/images/internationalspeakingvenues.jpg)
<figcaption>International speaking venues I've been at</figcaption>

My first tip... know why you want to speak!

## 👇🏻 Why Speak?

The first step to identify is your _why_. Don't skip this step! It's incredibly important. Knowing why you want to speak will help you identify the right motivation and inspiration to keep going.

> I think of **motivation** as the internal drive to do something. This will change over time. You might see someone else deliver a talk and be incredibly motivated but find it fades over time. On the other hand, **inspiration** is the external drive that is bigger than you. If you are inspired to make a positive impact on marginalized developers, the tough days won't matter as much because the goal is big enough to carry you over the rough spots. Motivation will win the sprint, but inspiration will keep you going through the marathon.

I started speaking simply because I wanted to be a speaker. I thought it was "cool." I wanted to teach and share but the idea of being a speaker drove me to my first talks. Unfortunately, that was motivation but not inspiration. My breakthrough came in two stages.

## Personal Mission Statement

Several years back I was in a transition between jobs and realized I hadn't stopped to really think about goals. It's easy to get caught up in the day-to-day grind and only look at your next project or promotion. I stepped back to look at the bigger picture and contemplate my passion, motivation, and desires. I chose to create a personal mission statement to drive my career decisions. The statement was simple:

> My mission is to empower developers to be their best.

The two roles I took on after both embraced the mission. First, I led the application development practice for a company and had the opportunity to create jobs, hire and mentor developers, and build their experience with hands-on projects. Second, I moved into developer advocacy and a role that feels like it was custom built to deliver my personal mission. [Microsoft's mission statement](https://www.microsoft.com/en-us/?utm_source=jeliknes&utm_medium=blog&utm_campaign=link&WT.mc_id=link-blog-jeliknes) is no coincidence:

> Microsoft's mission is to empower every person and every organization on the planet to achieve more.

Of course, speaking is a large part of accomplishing _our_ mission.

## 🍺🍻 The Beer Eventuality

A second turning point that helped cement why I do this was a realization one evening after a user group event. Several attendees got together to have a few beers (keep in mind it's entirely fine for this scenario to be played out with root beer or mint green tea, the beer is just a prop). Eventually the conversation turned to passionate topics with a lot of sharing and hand-waving. I realized I enjoy sharing my experiences this way, and why should it be any less comfortable to share them on a larger scale, say, from a stage?

Although this didn't eliminate my fear (more on that later), it did give me a new perspective. I used to think of talks as conflicts and struggles that I had to fight to deliver the perfect words and demos. Now I empathize more with my audience and view each session as an opportunity to connect and grow. It makes it much easier for me to continue delivering talks and I connect with the audience more as the result.

🗣 **Let's Discuss** Why do _you_ want to speak? What is _your_ motivation? How about inspiration?

> Sometimes it helps to see how others present. You can find thousands of presentations online. In this series, I'll share a different style of presentation I've given at the end of each article. This first example is a webinar I gave as part of a virtual online conference. It is code and demo-heavy.

{{<youtube edr6iwUuyWc>}}

Regards,

![Jeremy Likness](/images/jeremylikness.gif)
