---
title: "My New Role as Senior Program Manager for .NET Data"
author: "Jeremy Likness"
date: 2020-03-06T00:32:13-08:00
years: "2020"
lastmod: 2020-03-06T00:32:13-08:00

draft: false
comments: true
toc: false
noads: true

subtitle: "All your data are belong to me"

description: "I recently accepted a new role at Microsoft as Senior Program Manager for .NET Data. This post explains the history behind the decision, what I'll be doing and how you can help."

tags:
 - Microsoft 
 - .NET
 - Data
 - SQL
 - NoSQL 

image: "/blog/new-role-dotnet-data-pm/images/dotnetdatapm.png" 
images:
 - "/blog/new-role-dotnet-data-pm/images/dotnetdatapm.png" 
 - "/blog/new-role-dotnet-data-pm/images/escalator.jpg"
 - "/blog/new-role-dotnet-data-pm/images/advocateteam.png" 
---
I've said that life is like walking up the down escalator: if you stand still, you fall behind.

![Escalator](/blog/new-role-dotnet-data-pm/images/escalator.jpg)

I've never been a fan or member of the "not much club" (membership is simple: meet a friend you haven't seen in a while and reply, "Not much" when they ask, "What's new?"). Recently I had a flagship week with some [life-changing personal news](https://www.strengthwithparkinsons.com/post/finding-strength-in-my-weakness) (I'll write about that in a [separate post](https://www.strengthwithparkinsons.com/post/finding-strength-in-my-weakness)) and some exciting professional news. I'm moving to a new role!

I shared my 2020 goals here:

{{<relativelink "/blog/2019-year-in-review">}}

I stated that in 2020 I will advance my career either via a promotion or a role change. I love being a cloud advocate and the past three years at Microsoft have been some of the best years of my entire career of almost three decades. Several years ago, I wrote a personal mission statement I use as a compass to direct my professional decisions. It is simply:

> _Empower developers to be their best._

As a member of [developer relations](/blog/2017-10-01_what-is-a-cloud-developer-advocate/), I did this through creating and curating content, connecting with community both in person at events and online, and working with product and engineering teams at Microsoft to provide bi-directional feedback. It is an extremely rewarding role and I strongly encourage anyone interested in learning more to comment or reach out to me directly.

I have a deep gratitude for so many individuals who empowered me to step into and master (still a work in progress) the cloud advocate role. The hiring team was willing to invest in my potential. My mentors ([Glenn Condron](https://twitter.com/condrong), [Michael Crump](https://twitter.com/mbcrump), [John Papa](https://twitter.com/John_Papa), and [Donovan Brown](https://twitter.com/DonovanBrown)) and [colleagues](https://twitter.com/i/lists/847470660712505346) gave me invaluable advice for navigating a career at Microsoft. My managers ([Scott Cate](https://twitter.com/ScottCate), [Bruno Borges](https://twitter.com/brunoborges), and [Shayne Boyer](https://twitter.com/spboyer)) proved to be leaders, not just "bosses," and helped support my success and open doors for me. Countless associates and peers (too many to list here) helped my journey, collaborated with me and elevated my experience in developer relations through developed relationships.

![Cloud Advocacy Team](/blog/new-role-dotnet-data-pm/images/advocateteam.png)
> **Thank you all!**

In my desire to continuously challenge myself, I keep an eye out for opportunities both inside and outside of my team to step out of my comfort zone and take on more responsibility. Recently, that opportunity presented itself in a program manager role on the .NET team. The term "program manager" can mean a lot of things and isn't exactly uniform across teams. Instead of defining it in a generic sense, I'll share what I understand my new responsibilities will be.

## Senior Program Manager for .NET Data

The role is focused on data access in the .NET platform. I've worked with .NET for most of my professional career and data encompasses just about everything. This is a unique opportunity to help shape the data access experience. There is a strong tradition of support in .NET for relational data like SQL Server via various frameworks including Entity Framework. I'll focus on understanding those experiences today, the challenges involved, and how to improve them. In addition, I'll look at other types of data as well including storage, Cosmos DB, MongoDB, Redis, and other technologies to ensure we have an amazing story for those as well.

![.NET Data PM](/blog/new-role-dotnet-data-pm/images/dotnetdatapm.png)
_This stretched my sketching capabilities to their utmost limit_

My responsibilities include:

- Learning about data access in other stacks and how they compare with .NET
- Understanding and improving the experience of accessing data (Azure Storage, Cassandra, Cosmos DB, MongoDB, MySQL, PostgreSQL, Redis, SQL, and more) from .NET
- Meeting with existing customers to understand how they use data and how to improve their data experience
- Helping engineering teams, like the Entity Framework team, prioritize features, understand and execute on the desired experience to improve it
- Curating and creating content related to data access
- Building end-to-end demos of applications to demonstrate good practices for consuming data from .NET
- Connecting with the community to share updates and gather feedback
- Collaborating with other Microsoft teams including cloud advocates, program managers, marketing, executives and others to align with and innovate on solutions

Everything about this role connects with "_empowering developers to be their best_." It also allows me to continue doing what I love, including delivering solutions, collaborating across teams and contributing my own hands-on coding. All these activities will be done in the open and as a part of the Open Source Software (OSS) community. I'll still be involved with developer relations and this is still a developer advocate role: in this case, advocating for the best data experience for .NET developers possible. I'll continue [traveling to conferences](/blog/2017-08-17_upcoming-talks/) to meet you where you are at and better understand how I can better serve you.

**Do you write applications? Do those applications deal with data?**

If you answered, "yes," I'd love to hear from you. It doesn't matter if you work on .NET or another platform, because I'm interested in understanding what's great (and not so great) about experiences across the board. Why not comment below or reach out to me via Twitter? If you prefer, my email is my first name and last name separated by a dot at Microsoft.com.

Thank you for all your support and I look forward to serving you in the capacity of my new role!

Regards,

![Jeremy Likness](/images/jeremylikness.gif)