---
title: "Exploring Blazor"
author: "Jeremy Likness"
date: 2019-08-26T07:52:55-07:00
years: "2019"
lastmod: 2019-08-26T07:52:55-07:00

draft: false
comments: true
toc: false

subtitle: "A solution that gives C# developers what they want"

description: "Full presentation video with hands-on demonstration of Blazor, a cross-platform solution for building Single Page Applications using C#. Learn about WebAssembly and how it enables .NET to run in the browser without plugins and see firsthand how fast and easy it is to build web apps."

tags:
 - Blazor 
 - .NET
 - .NET Core
 - Single Page Applications
 - Presentation 

image: "/blog/exploring-blazor/images/exploring-blazor.jpg" 
images:
 - "/blog/exploring-blazor/images/exploring-blazor.jpg" 
---

There’s been a ton of buzz in the .NET community lately around Blazor. Unlike many hyped technologies however, Blazor seems to have earned the attention. It earned it in part by delivering a solution that gives C# developers what they want but doing so in a way that relied on open web standards. In this session, I go deeper into what Blazor is, how it works and how you can use it to build web apps.

{{<youtube BjCgD7sW8FA>}}

<i class="fab fa-youtube"></i> [Watch on YouTube](https://youtu.be/BjCgD7sW8FA)

Access the full source code for all demos here:

{{<github "JeremyLikness/blazor-wasm">}}

Over a decade ago, the first version of Silverlight was released and rapidly became a panacea for C# developers to write client web apps. The combination of plug-in free smartphones and evolving HTML5 standards led to its fast demise. From its ashes a new framework has been born that accomplishes what it could not: running .NET, in every modern desktop and phone browser, without plug-ins. Learn about Blazor, a framework for building Single Page Applications (SPA) that uses the power of WebAssembly to bring .NET apps to your browser.

Enjoy the presentation!

Regards,

![Jeremy Likness](/images/jeremylikness.gif)
