---
title: "2020: The Year of Data"
author: "Jeremy Likness"
date: 2020-12-25T15:33:56-08:00
years: "2020"
lastmod: 2020-12-25T15:33:56-08:00

draft: false
comments: true
toc: true

subtitle: "A new role with the same vision"

description: "An in-depth analysis of goals for 2020, along with statistics across social media, blogs, and my link tracker."

tags:
 - Technology
 - Blazor
 - EF Core
 - .NET Core
  
image: "/blog/2020-year-in-review/images/github2020.png" 
images:
 - "/blog/2020-year-in-review/images/github2020.png" 
---

I've always been happy to share that I embrace change and take on new challenges every year. I started the tradition of celebrating the year and looking back at highlights in a [2015 blog post](https://csharperimage.jeremylikness.com/2015/12/2015-in-review.html). This year I will continue that tradition. Despite the challenges and struggles of 2020 I am hopeful for the future and optimistic about the changes to come. Last year also impacted me in personal ways that inspired me to launch a [separate blog](https://www.strengthwithparkinsons.com).

For my post summarizing 2019, I began by sharing statistics about the exotic locations I traveled to and reflecting on 25 years of professional development. This year, due to the pandemic, the theme was exploring the Pacific Northwest. I also made a major career move early in 2020 and wrote about my new role as [Senior Program Manager for .NET Data](/blog/new-role-dotnet-data-pm/). That checked one of my major goals for 2020. My mission for several years has been:

> Empower developers to be their best.

As a program manager I continue that mission by helping steer the direction of products to address the greatest needs of the developer community.

My other goals were mostly personal, and I reflect on those and share my personal journey in a separate blog post: [2020 Couldn't Shake Me](https://www.strengthwithparkinsons.com/post/2020-could-not-shake-me).

## My Goals for 2021

I have many goals for 2021 and shared my personal ones my other blog. These are my _technology-related_ goals for 2021.

* Continue to advance my career at Microsoft. My goal is to become a principal program manager.
* Resume my news feed of daily relevant updates shared on social media.
* Help the EF Core team release EF Core 6.0.
* Raise awareness and increase adoption of .NET for Apache Spark.
* Understand and implement what's needed to make a great GraphQL story for .NET developers.
* Support local user groups around the world through virtual presentations.

## Open Source

I had more open source contributions in 2020 than 2019, which was also more activity than 2018 and 2017.

![GitHub 2019 Activity](/blog/2020-year-in-review/images/github2020.png)
_GitHub contributions in 2020_

The increase is due to my active involvement with the EF Core team and taking on a major side project with [Expression Power Tools](https://github.com/JeremyLikness/ExpressionPowerTools).

## Twitter in Review

My followers grew from 13,102 in 2019 to 15,101 this year. That's a 15% increase and slightly higher than my growth in 2019 (up from about 4 followers per day to 5). I assume that's mostly due to my association with the EF Core and .NET for Apache Spark teams. The more important number, engagement, was way down. I attribute that mostly to consistency: I stopped regularly posting relevant news items and was more reactive with product-related tweets. It's my goal to change that in 2021, so if you were following me to stay abreast of the latest in the .NET world, I'll be back!

As always, the following stats are based on the last 90 days.

### Demographics

Twitter removed the dashboard for demographics information in early 2020 and I don't use 3rd party tools to analyze these, so I have no updates here.

### Top Tweets

The most impressions for any tweet this year was a reference to a blog post I wrote about [how to connect to Azure Cosmos DB directly from a Blazor WebAssembly client](/blog/ef-core-and-cosmosdb-with-blazor-webassembly/).

{{<customtwitter 1260340804351975424>}}

My top mention was a tweet by [the official .NET Twitter](https://www.twitter.com/dotnet) that featured a blog post of mine about [how to inspect and mutate IQueryable expression trees](/blog/inspect-and-mutate-iqueryable-expression-trees/). 

{{<customtwitter 1296501252919099395>}}

Finally, the top "media tweet" was a post announcing the open source Windows Package Manager, `winget`.

{{<customtwitter 1262777185959542784>}}

That's a wrap for social media. Let's look at my blog.

## Developer for Life in Review

Last year was the first year I _did not_ move my blog to a new platform. I wrote about [migrating from Medium to Hugo](/series/from-medium-to-hugo/) and have continued to update my Hugo version and use CI/CD o build and deploy it.

Last year I received 96,047 visitors over 123,961 sessions, about a 30% increase from the previous year.

This year dropped to 61,930 visitors over 84,376 sessions. In my new role and with my focus split between two blogs, I simply did not write enough fresh content to drive new traffic. I don't have a goal for visitors or sessions, but I do have a mission to empower developers and blog posts are a big part of that. I will do more in 2021.
Almost three-quarters of incoming traffic is from organic search.

### Acquisition for Developer for Life in 2020

Over half of my traffic came from organic searches. The top 10 search phrases covered three broad topics: Blazor, JavaScript, and a one-off blog post I wrote in 2018 that explains [how to run MongoDb in Docker on Windows](/blog/2018-12-27_mongodb-on-windows-in-minutes-with-docker/).

The top three third party referrals came from GitHub, a case study of my site published on [JAMStack.org](https://jamstack.org), and [The Morning Brew](http://blog.cwa.me.uk).

### Most read articles on Developer for Life in 2020

Here are the top five (5) most read articles from 2020:

1. [Build a SPA site with Vanilla.js](/blog/build-a-spa-site-with-vanillajs)
1. [From Angular to Blazor: The Health App](/blog/2019-01-03_from-angular-to-blazor-the-health-app)
1. [Blazor State Management](/blog/blazor-state-management)
1. [MongoDB on Windows in Minutes with Docker](/blog/2018-12-27_mongodb-on-windows-in-minutes-with-docker)
1. [Using LINQ to query dynamic schema-less Cosmos DB documents](/blog/using-linq-to-query-dynamic-schemaless-cosmosdb-documents)

Here are the top five (5) filtered to only those articles I wrote in 2020:

1. [Blazor State Management](/blog/blazor-state-management)
1. [My New Role as Senior Program Manager for .NET Data](/blog/new-role-dotnet-data-pm)
1. [Dynamically Build LINQ Expressions](/blog/dynamically-build-linq-expressions)
1. [Build a Blazor WebAssembly Line of Business App Part 1: Intro and Data Access](/blog/build-a-blazor-webassembly-line-of-business-app)
1. [EF Core and Cosmos DB with Blazor WebAssembly](/blog/ef-core-and-cosmosdb-with-blazor-webassembly)

Because I did not post as much news, I did not use my link tracker as much so I'm skipping statistics for that. I will likely retire the link shortener in 2021 and just post direct links.

## Closing Thoughts

Looking back at previous years, technology trends I identified include:

* **2017** Docker and Serverless - package and scale your code
* **2018** .NET Core - build your code for any platform
* **2019** WebAssembly - target one platform that runs everywhere

2020 was the year of .NET data for me. My new role exposed me to EF Core and .NET for Apache Spark along with technologies like gRPC and GraphQL. Last year I said 2020 would be the year that "WebAssembly and modern JavaScript truly shine." I haven't been plugged into the modern JavaScript world, but Blazor has certainly taken off with the WebAssembly version gaining a strong foothold. I don't know what the "big thing" for 2021 will be overall, but I do know what I will focus on: making data access as great as it can possibly be for .NET developers.

See you in 2021.

![Jeremy Likness](/images/jeremylikness.gif)
