---
title: "Hack Your Career (Part Two of Two)"
author: "Jeremy Likness"
date: 2019-01-29T06:38:16.783Z
years: "2019"
lastmod: 2019-06-13T10:45:29-07:00
toc: true
comments: true
series: "Hack Your Career"

description: "Tips and tricks from 25 years of professional development experience to help you hack your technology career."

subtitle: "More Tips and Tricks from a Software Development Veteran"
tags:
 - Startup 
 - Resume 
 - Career 
 - Development 
 - Tips 

image: "/blog/2019-01-29_hack-your-career-part-two-of-two/images/3.png" 
images:
 - "/blog/2019-01-29_hack-your-career-part-two-of-two/images/1.jpeg" 
 - "/blog/2019-01-29_hack-your-career-part-two-of-two/images/2.jpeg" 
 - "/blog/2019-01-29_hack-your-career-part-two-of-two/images/3.png" 
 - "/blog/2019-01-29_hack-your-career-part-two-of-two/images/4.gif" 


aliases:
    - "/hack-your-career-part-two-of-two-d1f0e5542553"
---

In [part one](https://blog.jeremylikness.com/hack-your-career-part-one-of-two-b0c25ef9d58f) I shared my background and tips that covered doing what you’re told (or not), assumptions, changing your mind, fear, and being you.

_That’s just the beginning!_

Here are a few more tips to help you hack your own career (not to be confused with a career in hacking).

## 6. Raise the Signal-to-Noise Ratio in Your Life

Your time is valuable. You know how much it’s worth.

I once saw a consultant who earns over $100/hour spend an hour arguing over a $5 overcharge. I completely understand the principle behind it, but is it _really_ worth the $5 when you could actively bill another hour instead? Personally, I’d chalk that up as a $95 loss.

![Picture of analog synthesizer](/blog/2019-01-29_hack-your-career-part-two-of-two/images/1.jpeg)

I learned to value my time when I decided to change my life by eating healthier and working out. Like many people, I was under the impression that I just didn’t have enough time. Then I learned the truth:

> You don’t have a time problem. You have a priority problem.

I learned this when I met someone who worked multiple jobs, went to night school, and still found time to prepare meals and workout. We were talking about fitness and they randomly asked me a question about an episode of a television series I was watching. I responded, they nodded, and then hit me with this:

“That’s interesting. I thought you just said you don’t have time to work out. Isn’t that show an hour long?”

It turns out I had a lot of things chipping away at my time. I watched movies. I watched television. I played games. I interacted on social media. And I wasn’t taking care of me.

To change, I didn’t have to give it all up. Instead, I had to change my priorities. I stopped watching full movies every night and made them a reward at the end of the week. I only allowed television _after_ my workouts were complete. Prioritizing time isn’t just important for fitness, but your career as well.

How much drama do you allow in your life? I used to get sucked into online arguments. I had to get in the last word and respond to every reply. A business coach of mine pointed out just how much time I was wasting. He had an expression he liked to share, “You be right. I’ll be rich.” What he meant was that he didn’t have time to argue the right side when he could use that time to build and grow his business.

Have you ever taken stock of how much time you spend on threads that have nothing to do with advancing your career? Are you reading books that are fun to read, or that also help you learn something new you can use at work? When you commute into the office do you listen to the radio or a podcast? If you ride the bus or a train, do you spend the time liking Instagram posts or reading technical articles?

You may be surprised how much time you gain back if you decide to focus on how much _signal_ is in each hour versus how much _noise_ you let in. Small tweaks can go a long way.

Some specific email-related tips that helped my productivity explode:

* Stop reading emails as they come in. Instead, pick a few times per day to catch up.
* Consider creating a folder and an inbox rule to dump emails that don’t explicitly have your name on the _to_ line. These are typically mass/group emails and not as important, so check that folder less frequently.
* Turn off email alerts. If someone really needs you in real-time, let them text or Slack or message you some other urgent way.

If you are curious how I maximize my personal productivity, take a few minutes to read this:

{{<relativelink "/blog/2018-02-22_raise-your-signaltonoise-ratio">}}

## 7. Network FOR REAL

I’ve spent most of my life online. I’m not exaggerating. I was using [Bulletin Board Systems (BBS)](https://en.wikipedia.org/wiki/Bulletin_board_system) in the 1980s to collaborate with people around the world. In the 1990s it was [Internet Relay Chat (IRC)](https://en.wikipedia.org/wiki/Internet_Relay_Chat) (where I also happened to meet my wife), followed by [Friendster](http://web.archive.org/web/20031015211349/http://friendster.com/index.jsp), [MySpace](http://web.archive.org/web/20041001082041/http://www.myspace.com:80/index.cfm?fuseaction=splash), Facebook and Twitter. I get online community.

_It’s no substitute for face-to-face interactions._

I get what it’s like to be an introvert. I know because many years ago, I was convinced that I was just born socially awkward and would never “fit in.” I loathed big crowds and when I sat in a waiting room, I’d stick my nose in a book or other device to avoid interactions. My biggest fear when being introduced to someone was “What do I say next?”

My first steps to transform weren’t related to technology or my job, but my health. I was obese and struggled with various diets and programs. Eventually, I found a system I felt good about but still had serious doubts it would help me. The program featured “before and after” photos with success stories that were inspirational, but I still had my doubts. A work event brought me to the Miami area, and I knew that a man named Jeff who transformed his lifestyle was running a gym there. I stepped out of my comfort zone and scheduled and appointment. Meeting him was the catalyst I needed to believe in what was possible and transform. The books and websites and online pictures just weren’t enough: I had to connect in person.

I hit my goal.

{{<figure src="/blog/2019-01-29_hack-your-career-part-two-of-two/images/2.jpeg" caption="My bodybuilding days" alt="Bodybuilding picture">}}

The changes inspired me to start my own fitness business, and I was forced to transform again when I left the technology industry to focus on personal training full time. Suddenly I had to sell my own services, provide customer support and coach clients. This helped me break further out of my comfort zone and gain a little more confidence interacting with people. After I sold my fitness business and got back into technology, I purposefully focused on fostering “in person” relationships.

It’s not as hard as it may seem. It can be as simple as attending a local user group meeting, traveling to a conference or attending a technology-related event. Having that experience can pay major dividends and create synergy because your return on investment is greater than the energy you put into it.

> “I’m an introvert” may be true (and there is absolutely nothing wrong with that), but “I’m not comfortable around people” is one of those thoughts you just may be able to change.

For example, I was contacted online to be the technical editor for a book. I was on the project for several months when the publisher came to town for a conference and invited me to meet over coffee. We connected in person, and that led to an invitation to write my first book. That led to several other books and a lasting relationship.

At my very first conference I met several individuals in the speaker room whom I only see on the road. Although we only meet once or twice a year, we’ve developed friendships that spanned decades. Some of those speakers later went on to organize their own conferences and reached out for support. That led to further opportunities.

Our team at Microsoft is globally distributed and mostly remote. We all work well together and leverage the latest technology to meet with video and screen sharing. Over time, however, it’s been conferences that have forged the culture and fostered deeper relationships because we have the opportunity to interact face to face. Some of my most productive collaborations have been the direct result of spending time in person with a coworker in the speaker lounge or at the hotel restaurant.

Any time you can take a little extra effort to connect in person will add value to your career, whether it’s for opportunities, references, or just a friend to support you in times of need. This doesn’t mean online interactions don’t count, but it is too easy with modern technology to avoid old fashioned human-to-human interaction. Remember previous tips as well: this is still about being genuinely _you_, even if you are introverted, it’s not about forcing yourself to be an extrovert but building trust and taking some risks.

If it feels like politics, _don’t do it!_ It should be about relationships.

I use [Meetup.com](https://www.meetup.com/members/10127361/) to connect with local developers, and then follow up on [LinkedIn.com](https://linkedin.com/in/jeremylikness) to maintain business relationships over time.

## 8. Pause. Résumé.

By my best estimate I’ve conducted more than 100 interviews over my career and looked at thousands of resumes. I’ve also revised mine over the past 25 years and sat in the interviewee chair many times. Unfortunately, the resume is often the first touch point and filter in the process and a poorly done resume may prevent a perfectly qualified candidate from getting a foot in the door. There are tons of sites that promise to improve your resume, so instead of making this a comprehensive “how to” guide I want to share a few highlights that I believe can make or break a _curriculum vitae_.

First, what is your mission? It’s tough for me to understand this:

> Extremely qualified and experienced professional with amazing skills that has received dozens of industry awards.

OK, that’s great … but why are you submitting your resume to me? Selfishly, I want to know if you are simply looking to check another box on a long list of projects, want to get exposed to new technology or singled out our company and really want to join. I urge you to think about _what you really want_ and declare it on your resume. Not, “This is who I am” but rather, “This is what I’m looking for.”

> Seeking an exciting position in developer relations that will use my extensive experience and skills to drive value by forging deep relationships in the developer community.

For illustration, here’s another example:

> Straight “A” student with three Azure certifications.

How about …

> Passionate developer seeking to partner with a company willing to tap into my enthusiasm and ability to learn new technologies to drive successful cloud adoption.

Don’t worry about the words I use so much, that’s my style, but try to go from “This is who I am” to “This is what I’m seeking and willing to do.” It will make your resume stand out!

Always put your strengths at the top of the resume. If you are newer to the industry and education is your strong point, go with that. In my case, without a college degree, my experience and accolades go on top and a note about my education is at the bottom. Think about someone thumbing through one hundred resumes in one sitting and what you want to jump out at them from the page.

Tie your skills into your experience. There is nothing more frustrating than reading that someone has extensive Web API experience, then finding no mention of it in their job history. When XML and XSLT were important skills (now I’m dating myself again), I didn’t just list “3 years’ experience with XML” … I also demonstrated how I used it:

* Built a mobile device management system that leveraged XML definitions with XSLT transformations to drive a dynamic UI capable of quickly adapting to custom settings

Try to tie your skills into your experience. Speaking of experience, when you are listing history, please list what you did, not what you were supposed to do. Put yourself in a hiring manager’s shoes. You see one resume that looks like this:

> Senior Developer responsible for setting coding standards, mentoring junior developers, and exploring new technologies.

Then another that looks like this:

> As a Senior Developer, successfully established coding standards to accelerate delivery and improve quality. Mentored several junior developers, one who was later promoted to senior. Led the team with successfully transitioning from WCF to REST.

Finally, don’t feel like it must be just about your mainline job duties and accomplishments. I include publications, videos, presentations and projects I worked on. The interview team has a very well-rounded view of my experience, passion, and abilities.

## 9. Just Say “NO.”

Learning to say, “no” may just be the most powerful tool you can add to your arsenal.

The first time I discovered this skill was at my first technology job. I originally was paid hourly. Night shift “bonuses” and overtime all added up to a hefty income for me at the time. That was when the boss called me in to inform me that I was being awarded for my professionalism by being “promoted” to a salaried position. I was assured that my new salary was so significant it required special approval from the company’s president. Unskilled in the art of negotiation, I smiled and said, “Yes!” and left feeling let down. The salary they offered me was about 30% _less_ than I was earning with hourly wages.

After reflection, I turned the “yes” into a “no” and began seeking employment elsewhere. I am grateful to the company for giving me my first programming opportunity, but it was no longer the right fit. I ended up accepting a job in Atlanta and moved shortly thereafter. In Atlanta, it quickly became clear the new role wasn’t a good fit either. Again, I said, “no” and moved onto another role that was crucial for the overall success of my career.

Part of saying, “no” is understanding your priorities and living by them. My family is near the top of my priority list (ahead of job), so I try not to let my work interfere with family. Sometimes that means a firm, “no” when I’m asked to go on trips or take on projects that will cut into that valuable time. It’s not that I’m not a team player; on the contrary I’m always willing to jump in and help in emergencies, but I have no patience for a culture that _thrives_ on emergencies.

I learned early on to value time and focus on maximum return on investment. That means I look for opportunities that reward productivity over activity. I’m far more impressed with someone who has learned to be ultra-efficient and get things done in a sane work week than someone who is always burning the midnight oil and missing out on sleep to get things done. That’s my personal preference and I’ve learned to make it a firm “no” to firms that are more concerned with hours than output.

Ask any of my colleagues at Microsoft. I’m not afraid to say “no” when appropriate.

## 10. It’s not ONLY about the Benjamins.

Have you heard that love makes the world go ‘round? That may be true, but money pays for the trip. There is nothing more annoying than someone who has tons of money proudly declaring that “money isn’t important.” It’s a core part of modern society, but people often forget…

> Money isn’t the **thing**. It’s the thing that gets you the **thing**.

It’s important to understand what the thing is.

Before I started my technology career, I toyed with the idea of becoming a professional pool player. I was in between jobs and couldn’t afford table time, so I got a job at a pool hall. I made $20 a day working an 8-hour shift. $10 went to gas in my car, I saved $5 for rent and $5 for food (I typically walked over to a 7–11 and bought a pressed Cuban sandwich and chips). I lived that way for a year. And guess what? My job gave me free use of the pool hall, so after my shift ended at 4:30 pm in the afternoon I’d often stay until midnight doing what I loved: playing rack after rack of one pocket and 9-ball. It turns out I didn’t need to be rich to play unlimited pool.

I’ve always wanted to travel the world. In one of my early roles I built the software that integrates mainframes with warehouse conveyor belts to route and sort inventory. Many of our customers were international, so I was able to visit the Netherlands, Germany, Belgium, Luxembourg and France. At the time I would have had to save for quite a while to afford those trips on my own, but the job paid for the trip. The _thing_ was the travel, so I didn’t need to be “rich” to get the _thing_.

Understanding this is important because sometimes you must go backwards to move forwards. This is a plot of my salary over my career.

{{<figure src="/blog/2019-01-29_hack-your-career-part-two-of-two/images/3.png" caption="Salary over time" alt="Line chart showing salary over time">}}

Notice the first huge dip. That’s when I took a major risk and started my own business. That career exposed me to the power of coaching and mentoring and helped me become confident speaking in public. I learned major lessons about what it takes to build and scale a company. You can see the first year I had no idea what I was doing but by the third year was earning more than I made in my previous technology role.

The second dip happened when a successful entrepreneur reached out to me to ask if I’d help him build a new software company. My income steadily improved over time, but my quality of life suffered. I was working startup hours five years in and my health was suffering as a result. There is a small dip I didn’t circle that represents a lifestyle change. The company later sold for $1.5 billion, but I got to work from home as a consultant and spend more time with my family than I had in years. That was the _thing_.

The last dip in salary happened as a sacrifice I made for the opportunity to step into my current role in developer relations. My personal mission statement is to empower developers to be their best, and that is the essence of this role and is reflected in the overall mission of our company. The dip was worth it to get paid to do what I love full time, and as a bonus I was promoted within a year anyway.

The first several years I focused on the money and the money came grudgingly. The last several years I focused on what I wanted to do and how I wanted to balance my life, and the money seemed to click into place. Your mileage may vary but please remember it’s not _only_ about the Benjamins. Figure out the thing and focus on it.

## Summary

That’s it! We’ve made it through the ten top tips I believe helped shape my career. I hope they have a positive impact on yours. Did something stand out in particular? Do you disagree with any points? Are there other tips you have or stories you’d like to share? Let me know by sharing in the comments below!

Wishing you the best of success,

![Jeremy Likness](/blog/2019-01-29_hack-your-career-part-two-of-two/images/4.gif)
