---
title: "Hack Your Career (Part One of Two)"
author: "Jeremy Likness"
date: 2019-01-16T19:18:14.941Z
years: "2019"
lastmod: 2019-06-13T10:45:26-07:00
toc: true
comments: true
series: "Hack Your Career"

description: "Five tips to move forward in your technology career from a 25-year professional development veteran."

subtitle: "Tips and Tricks from a Software Development Veteran"
tags:
 - Entrepreneurship 
 - Technology 
 - Careers 
 - Career Advice 
 - Development 

image: "/blog/2019-01-16_hack-your-career-part-one-of-two/images/3.png" 
images:
 - "/blog/2019-01-16_hack-your-career-part-one-of-two/images/1.jpeg" 
 - "/blog/2019-01-16_hack-your-career-part-one-of-two/images/2.png" 
 - "/blog/2019-01-16_hack-your-career-part-one-of-two/images/3.png" 
 - "/blog/2019-01-16_hack-your-career-part-one-of-two/images/4.gif" 


aliases:
    - "/hack-your-career-part-one-of-two-b0c25ef9d58f"
---

In July of 2018 I delivered what I refer to as the most selfish talk of my career. If you have time and are interested, you can view the presentation in its entirety here:

<i class="fab fa-vimeo"></i> [Hack your Career: Tips and Tricks from a 20-Year Veteran | recallact.com](https://www.recallact.com/presentation/hack-your-career-tips-and-tricks-20-year-veteran)

I provided tips and tricks for software developers to excel based on my own experience. It was selfish because I shared a lot about my past and personal history along with many anecdotes, but it also represents the ultimate reason I do what I do today. My personal mission is to empower developers to be their best and I feel these tips will help with that.

![Hack Your Career](/blog/2019-01-16_hack-your-career-part-one-of-two/images/1.jpeg)

I’ve always been into computers. It’s hard to read the text, but below is a photo from a friend’s middle school yearbook (and if you don’t mind I’ll just skip over telling you what year that was). Someone decided to write a phrase across every picture. Some of them were kind, some funny, and some mean. My phrase? “Computer Man.”

![Middle school photo of Jeremy](/blog/2019-01-16_hack-your-career-part-one-of-two/images/2.png)
<figcaption>"Computer Man"</figcaption>

Yes, even in middle school I was a software engineer. As a side note, for the history of languages and platforms I’ve developed on, check out this article:

{{<relativelink "blog/2016-02-28_30-years-of-hello-world">}}

I’ve done very well over the course of my career. What do I mean by “well”? Success means something different to everyone. To me, it’s been a balance of doing what I enjoy and impacting others, while selfishly having more time to spend with family and increasing my income. I’ve left the 100-hour start-up work week far behind, associate with amazing people I learn from every day, and travel around the world to connect with developers where they live.

It’s obviously not where I started. It’s been quite the journey.

> I am a college dropout, and although I went back for a period of time, I never received a degree. I’m not opposed to degrees and they do provide value, but I also believe the notion you must have one to be successful is due to the best for-profit marketing campaign ever run.

After I dropped out of college, I (unfortunately) believed it when people told me, “You’re not going to get paid to write software if you don’t have a degree.” So, I went down a different path. I was a bus boy at a steak house. I worked at a fast food restaurant. I worked in retail (I’d like to say, “selling clothes” but it was really “folding clothes and organizing hangers.”) I worked in a pool (billiards) hall for a year. I tried selling electronics out of the trunk of my car as part of a multi-level marketing opportunity, er, scheme, and failed miserably at it. I worked at a bookstore.

My big break came when I applied for a minimum wage job at an insurance company. I mentioned that I speak Spanish on the application, so they routed me to a different position that paid more and involved taking automobile accident claims over the phone (in Spanish). I was very competitive in my work and when the claims application crashed, it only took a few support calls to figure out the commands they used to restart it. I began recovering the app crashes on my own, and after the IT department realized what was happening they invited me to transfer in.

That was the start of my professional developer career. The year was 1994.

The past quarter century has been very productive. I’ve…

* Led several teams, including directing the IT departments for two companies and running the entire application development practice for another
* Wrote (and more importantly, published and sold) [several books](https://amzn.to/2E7qzjb)
* Visited dozens of countries to [mentor and train developers](/past-presentations-3aa8fe97cf31)
* Ran my own [online business](http://web.archive.org/web/20040404173023/http://www.naturalphysiques.com:80/) for several years
* Joined a start-up as its 3rd employee that later [sold for $1.5 billion](https://washingtonexec.com/2014/01/vmware-announces-acquisition-airwatch-1-5-billion/)
* Created a popular (with Silverlight and Windows Phone developers) open source <i class="fab fa-github"></i> [NoSQL database](https://github.com/jeremylikness/sterlingnosql) that was _almost_ purchased by a large and well-known company

I told you this was a selfish presentation! Seriously, though, the reason I’m sharing these is simply to show the context these tips come out of. My philosophy has always been twofold:

1. Life is like going up the down escalator. If you stand still, you fall behind.
2. I never want to be a member of the “_Not Much Club_.” That’s the club you join then see a friend you haven’t talked to in years, and when they ask, “What’s new?” you reply, “Not much.” I’d rather say, “How much time do you have?”

With that, here are my tips to hack your career (not to be confused with pursuing a career in hacking).

![LinkedIn Profile Image](/blog/2019-01-16_hack-your-career-part-one-of-two/images/3.png)
<figcaption>My <i class="fab fa-linkedin"></i> [LinkedIn](https://linkedin.com/in/jeremylikness) Profile</figcaption>

## 1. Stop Doing What You’re Told

_“You’re a college dropout, so you can’t be a professional developer.”_

Wrong.

_“You don’t have a degree so you’re not qualified to be a manager.”_

Wrong again.

_“This is your first year as a fitness trainer, so you should only bill $25/hour.”_

Nope.

I still remember the response when I told my boss I was going to submit an article to a major magazine about how to manage teams. He raised his eyebrows and said, “You don’t have enough experience. Your article will never get accepted. Even _I_ have __ submitted several times and they won’t publish anything.” A few weeks later I received a check, and with that began my career as a professional writer. It also earned me my manager’s ire.

In early 2000 I lost a lot of weight and became certified as a specialist in performance nutrition and fitness trainer. We were told to start with a low rate ($25/hr) and slowly work our way up. I wasn’t convinced that was the way to go. I knew I had the experience and knowledge to make a valuable impact, so I started with rates at over $100/hr. I was informed it wouldn’t work out, but they were wrong. It did work out because I was able to demonstrate that value and provide results.

You have a choice. You can listen when they say, “No” and “It’s not for you” or “You’re not good enough” or you can stop doing what you’re told and succeed in spite of what everyone thinks.

## 2. Don’t Assume Anything

_“Silverlight will last forever.”_

OK, I didn’t assume that … but I was very much on the “bandwagon.”

{{<customtwitter 63646800371920896>}}

I witnessed a lot of strife from people who did.

The class I enjoyed the least in high school was Spanish. Although I made good grades, I was constantly frustrated and struggled because I couldn’t imagine how it would possibly help a career in computers. I assumed it was a waste of my time!

After I dropped out of college, the first “decent” paying job I received was a fluke. I applied for lower paying job (minimum wage at the time was $4.25/hour), but happened to check the box on the application that I speak Spanish. I was immediately asked to sit in on a different set of interviews. That resulted in my hire as a customer care representative … taking claims in Spanish! I was very competitive, so after a few times calling tech support when my [AS/400](https://search400.techtarget.com/definition/AS-400) [green screen](https://en.wikipedia.org/wiki/Monochrome_monitor) claims entry app crashed, I quickly figured out how to restart it on my own. That led to a discussion with tech support and ended with me transitioning into the computer department.

Forget a computer science degree (I didn’t have one anyway), it’s _Spanish_ that launched my career as a professional developer.

That lesson was very important and helped me later in my career. Five years into a supply chain engineering job I lost over 65 pounds and gained a passion for health and fitness. I came across a “help wanted” ad for a company that had Hispanic-focused diet software. It was written in Spanish and had Spanish cuisines customized for weight loss. They were asking for an intern to help out. I knew I was overqualified for the position, but instead of assuming they wouldn’t be interested, I wrote them a letter.

I shared that I had a strong background in software development, was personally impacted by the importance of health and wellness, and speak Spanish. Within weeks they reached back out, interviewed me, and created a position to hire me. It was my first role as a Director of IT! Through that role I had the opportunity to negotiate phone plans, upgrade our network, co-locate us in data centers and learn many other aspects I never would have been exposed to in my prior role. Thank goodness I didn’t assume!

_Trade assumptions for conviction._

## 3. Change Your Mind

Every day we spend more time in our own thoughts than with anyone else. That inner dialog you have is more important than you may think to yourself (pun intended). My inner dialog was very rough early in my career. I suffered deeply from [impostor syndrome](https://en.wikipedia.org/wiki/Impostor_syndrome). I’d tell myself things like “you’re not good enough” or “you’re going to screw this up” or “no one cares about that blog post so why waste time writing it.” The “not good enough” thought crippled my ability to interact socially.

I still remember my first technical presentation as clearly as if it happened yesterday and not 20 years ago. I stood in front of the audience and tried to start speaking, but the words wouldn’t come out. The fear of screwing up was so strong it choked me. What stands out most clearly in my memory was the look of pity in the eyes of the people sitting in the front row. I eventually forced it out and stammered my way through an hour of sheer torture but when I was done decided I would never do it it again (thank goodness I was wrong!)

What changed?

I learned that thought is creative. As much as we react and respond and form habits, we have this magical innate ability to form new thoughts. It may sound ridiculous, but I never stopped to realize that we can change our thoughts! A business coach of mine encouraged me to listen to my inner dialog and nudge it in the right direction. The thoughts would say, “You’re not good enough.” Then I would disagree. “You are good enough.” The thoughts would say, “You’re fat.” I would say, “Actually, I’m getting fit.” And so forth.

The real breakthrough came when I realized that it didn’t matter if I was “good enough” for speaking or blogging because it’s not about me. It’s about the people I’m connecting with. I stopped thinking, “I’m going to screw this up” and started thinking, “This is exciting to share, I look forward to someone learning something new.” Over time this created new habits and my inner dialog became much more positive. I went from taking Zoloft and anti-anxiety medication just to make it out of bed in the early 90’s to celebrating each and every day without needing medication.

> As a quick note, I’m not against medication and highly advise anyone experiencing depression to seek professional help. Seeing a psychologist and psychiatrist helped me tremendously, and just because I was able to move away from it doesn’t mean battling depression is as simple as “changing your mind.” It’s not — it can be very serious, and working on your inner thoughts is just one of many steps that may help.

It may seem “corny” or awkward at first, but here is my philosophy: I’m always willing to dedicate four weeks to something new to see if it works for me. Commit to changing your inner dialog and replacing negative thoughts with positive ones and see if it makes a difference for you. I know I wouldn’t be where I’m at in my career if I hadn’t decided to focus on moving away from negative thoughts. Looking back, those negative thoughts were just a waste of time and an excuse to feel sorry for myself. I celebrate the positive every day and move on from the negative.

Here’s a thought to wrap your mind around and perhaps try on for size:

“The more I like myself the way I am, the more I am the way I want to be.”

## 4. Fear is Your Compass

In the [Song of Ice and Fire](https://amzn.to/2RrJtre) a son asks his father, “How can a man be brave if he’s afraid?” The father, named Ned Stark, replies, “That is the only time a man _can_ be brave.”

To me, courage is moving forward in spite of fear. If I look back on the major milestones in my career, they all involved fear. I moved to Atlanta, Georgia from St. Petersburg, Florida without knowing anyone. Everything I owned fit into a two-door Honda Civic. Can you imagine what that fear of the unknown was like? When I accepted my first position as Director of IT I barely knew what a data center was and had never negotiated a major contract. I had no clue what I was doing when I started my own business, or wrote my first book, or managed my first multi-million dollar project.

What each of those steps in my career had in common was that I accepted the challenge and moved forward in spite of my fear, gained new experience and leveled up my career. When I struggled to get my first business of the ground, I spent a lot of time interacting with successful business professionals to learn their “secrets.” I noticed that one thing they all had in common was a willingness to take risks. In fact, one of my coaches told me:

> 9 out of 10 home-based businesses fail the first year. Most people fail and say, “I guess this isn’t for me.” When a true entrepreneur fails, they say, “OK, just 8 more tries and I’ll get it right.”

I’m not trying to say that you have to fall on your face multiple times to be successful. What I learned is to embrace fear by putting myself in situations that force me to acknowledge it. I was scared the first time I was asked to write a book, accepted to speak at a conference, and invited to keynote a developer event. In all of those circumstances I said, “Yes” then dealt with the fear and moved forward. What I’ve found is that most of the time, the fear I experience is fear of the unknown, and by allowing myself to move forward I gain knowledge and end up with one less thing to be afraid of.

At the end of it all, will you say, “I wish I had” or “I’m glad I did”?

## 5. Get Out of Your Own Way and Be Genuinely You

In certain business coaching classes I’ve heard the phrase repeated over and over, “Fake it until you make it.”

I took that phrase to heart and failed miserably. I’m not a fake, and trying to be someone I’m not just doesn’t work for me. It took years to figure it out, but I finally learned I need to be me. There are a few ways that plays out:

* In interviews, I show up as me, not as the “ideal candidate” I think they want to hire. This way, a hire means I can be me in my new role, and a rejection means it wouldn’t have been a good fit anyway.
* When speaking, I also show up as me. I study great speakers all the time, but I’m not trying to take over their personalities. I’ll never be as funny or confident or clever as other speakers, and that’s OK. My biggest turning point came when I realized a conference talk is a conversation that reaches more people that a one-on-one session.
* On a team, I show up as me. That includes my weaknesses, blind spots, lack of knowledge in certain areas and vulnerabilities. I’ve learned that the right environments support who I am and are happy to help me out with questions or learning new things.

Faking it makes everyone uncomfortable. Instead, I encourage you to adopt a different phrase that has been more effective in my experience.

“I know what I know what I know.”

All this means is you are the sum of your experiences and personality. In the hours before an interview, there is nothing you can do to change your experience and there is nothing you can do to change as a person in that short period of time. Go into it confident you’ve done all you can.

This doesn’t just work for interviews and conference talks. My writing also improved when I began writing in my own voice, rather than trying to conform to a dry standard. Instead of trying to find the perfect words or use a dry technical voice, I approach blog posts, articles, and books as if I’m having a conversation rather than delivering a paper.

## Conclusion: Part One

I hope you found this first round of advice valuable and that one of my stories resonates with your own experience. I would love to hear your reaction, feedback, and your own stories and advice. Please don’t hesitate to share using the comments below. I still have [five more tips](https://blog.jeremylikness.com/hack-your-career-part-two-of-two-d1f0e5542553) that cover signal-to-noise ratio, networking, resumes, pushing back and money moves. Until then, I wish you the very best of success in your own pursuits.

[Continue to part two](/hack-your-career-part-two-of-two-d1f0e5542553).

Regards,

![Jeremy Likness](/blog/2019-01-16_hack-your-career-part-one-of-two/images/4.gif)
