---
title: "The Year of .NET Core, Angular, and Web API Design: 2018 in Review"
author: "Jeremy Likness"
date: 2018-12-23T21:36:29.418Z
years: "2018"
lastmod: 2019-06-13T10:45:18-07:00
comments: true
toc: true
series: "Year End Summaries"

description: "My personal and technical retrospective and analysis of 2018, using Twitter, blog statistics and link tracking statistics for data."

subtitle: "A look back at tweets, blog posts, and link clicks in 2018 with the stats to prove it."
tags:
 - Social Media 
 - Serverless 
 - Angular 
 - Net Core 
 - Speaking 

image: "/blog/2018-12-23_year-of.net-core-angular-and-web-api-design-2018-in-review/images/1.png" 
images:
 - "/blog/2018-12-23_year-of.net-core-angular-and-web-api-design-2018-in-review/images/1.png" 
 - "/blog/2018-12-23_year-of.net-core-angular-and-web-api-design-2018-in-review/images/2.png" 
 - "/blog/2018-12-23_year-of.net-core-angular-and-web-api-design-2018-in-review/images/3.png" 
 - "/blog/2018-12-23_year-of.net-core-angular-and-web-api-design-2018-in-review/images/4.png" 
 - "/blog/2018-12-23_year-of.net-core-angular-and-web-api-design-2018-in-review/images/5.png" 
 - "/blog/2018-12-23_year-of.net-core-angular-and-web-api-design-2018-in-review/images/6.png" 
 - "/blog/2018-12-23_year-of.net-core-angular-and-web-api-design-2018-in-review/images/7.gif" 


aliases:
    - "/the-year-of-net-core-angular-and-web-api-design-2018-in-review-5e6f4bb36b76"
---

Last year was my first full year at Microsoft. It was a year of change for me as I relocated across the country and traveled around the world.

{{<custominstagram BfssgW-HPGM>}}
<figcaption>A bit of ice on the ole goatee</figcaption>

According to [TripIt](https://tripit.com) I enjoyed 18 ✈ trips, lived out of my 💼 suitcase for 100 days, and acquainted myself with 35 🏙 cities across 11 🌍 different countries (although several of the countries were just layover stops).

New job. New 🏡 home. ❤ I loved it!

Every year I like to reflect on the past 12 months, gather whatever insights I can and focus on the year ahead.

For reference, this was my 2017 post:

🔗 [The Year of Docker, Serverless, and .NET Core: 2017 in Review](/docker-serverless-dotnet-core-2017-in-review-4fca69d50cf8)

How did I do with my goals for 2018? Here are my retrospective comments.

**The Goal:** _Speak internationally (and not just once)_

**The Result: ✅** success! I visited (and spoke in) Bulgaria, Singapore, Poland, Russia, and Switzerland.

**The Goal:** _Find a home and relocate to the Redmond, Washington area_

**The Result: ✅** success! On Twitter, I chronicled my travels across the country to relocate in our new home just north of Redmond. Just click on the tweet below to expand the full thread, or [read it here](https://twitter.com/jeremylikness/status/1017019438367936513).

{{<customtwitter 1017019438367936513>}}

We ended up in an amazing new home. Here’s a view of Mt. Rainier from our front deck:

{{<custominstagram BrAvCpknIBT>}}

**The Goal**: _Engage heavily in the amazing giving opportunities that Microsoft provides its employees_

**The Result**: ✳ close … I definitely engaged with matched donations but can do better in the future.

**The Goal**: _summit a mountain I’ve never hiked before_

**The Result**: ❌ nope! I can’t say I made the summit of anything I’d call a mountain, but I certainly did go on a few good hikes!

Although I didn’t set them as goals, I had three other key accomplishments:

* Gave my first 🗝 keynote at the Atlanta Code Camp
* Authored a short [serverless eBook](https://docs.microsoft.com/en-us/dotnet/architecture/serverless/)
* Gave away my daughter to be married 👰🏻

Wow! What a year.

I am extremely happy that several of my talks were recorded so that I can share them with those who are unable to make it to the conferences. I really enjoyed presenting [The Three D’s of Modern Web Development](https://vimeo.com/303443966). Choose the `Videos` tab on my blog for more presentations.

## My major goals for 2019

* Get back into a regular fitness routine and closer to my “fighting weight” of 200 pounds
* Summit a mountain I haven’t been on before (sound familiar?)
* Ski for the first time in years
* Speak to an audience of more than 1,000 (quantity doesn’t matter, but it’s a bucket list item that makes it easier to speak to larger audiences moving forward)
* Vacation with my wife in a place we haven’t been before
* Increase my giving (not just dollars, but mentoring, community service, etc.)

That’s it for the deep retrospection … let’s move on to the technical statistics and insights!

## Open Source

This year I contributed about 2/3 of what I contributed in 2017.

{{<figure src="/blog/2018-12-23_year-of.net-core-angular-and-web-api-design-2018-in-review/images/1.png" caption="GitHub Contributions in 2018" alt="Screenshot of GitHub Contributions">}}

In 2017 I had closer to 400 contributions. I worked more frequently with docs and traveled less. I don’t contribute to many mainstream open source projects, but I do make all of my demos open source and create online tutorials when I can.

For example in 2018 I created a TypeScript sample to demonstrate how to use decorators for property change notifications on view models ([tsviewmodel](https://github.com/JeremyLikness/tsviewmodel)). My [TypeScript from JavaScript](https://github.com/JeremyLikness/TypeScript-from-JavaScript) repository contains a series of commits that refactor JavaScript code to illustrate firsthand how TypeScript helps find and fix defects up front and makes your code easier to read, build, and maintain. I also recently created a [Blazor Health App](https://github.com/JeremyLikness/BlazorHealthApp) that I’ll blog about in the coming weeks.

I don’t really set goals for OSS contributions because it’s quality over quantity and I want to do what feels natural. We’ll see how that works out in 2019!

## Twitter in Review

Looking back to last year, I went from 9,165 followers in 2016 to 10,103 in 2017. That’s about a 10% increase and an average of about 2–3 new followers per day.

The increased visibility of my new role combined with more presence at conferences around the world resulted in a jump to 11,524 in 2018. That’s a 14% increase and an average of about 4 new followers per day.

My Twitter goals for 2018, with results:

**The Goal**: _continue to deliver a high signal-to-noise ratio of content_

**The Result**: ✅ success! I consistently delivered technical content throughout the year and received positive feedback about my feed.

**The Goal**: _focus on “in person” followers at events such as user group meetups and conferences_

**The Result**: ✅ success! The higher average follow rate can be directly attributed to surges in followers at in person events.

**The Goal**: _interact frequently online through conversations, answering questions, supporting community, etc._

**The Result**: ✅ success! I made an effort every day to engage in conversation. I also opened my direct messages (so anyone can DM me, even if I don’t follow them back) and created many connections through messaging.

The following statistics are based on the last 90 days of activity.

### Demographics

99% of my followers list _technology_ as their top interest, compared to 92% last year. The top five interests of my followers are:

* Technology (99%, compared to 92% last year)
* Science news (99%, compared to tech news at 90% last year)
* Space and astronomy (99%, compared to Windows at 86% last year)
* Tech news (99%, compared to 90% last year and Computer Programming at 83% in the 4th place spot last year)
* Weather (98%, compared to Mobile at 73% last year)

I feel like I may have more followers focused on my core goals (technology and development) but it is interesting to pick up “weather” (shall we talk about the weather?) and, of all things, _dogs_ as a top interest. Sorry, cat lovers!

![Screenshot of Twitter follower interests](/blog/2018-12-23_year-of.net-core-angular-and-web-api-design-2018-in-review/images/2.png)
<figcaption>Twitter follower interests</figcaption>

I am extremely happy about seeing progress in another area. Last year 13% of my followers were female, this year that increased to 20% or 1 in 5. It’s still not representative of what the industry could be, but the increase hopefully reflects that my content and feed are welcoming to everyone. Twitter should provide demographics about who _we_ follow too (does it, and I missed it?) because I’d like to make sure the part I can directly influence — the voices I hear in my own feed based on who I follow — is diverse and not an echo chamber.

I don’t have updated age demographic stats, and my country demographics remained the same (41% United States, 8% United Kingdom, 6% India, 3% Canada, and descending from there). I do know Twitter doesn’t collect the same demographics from every country so those numbers may be skewed.

### Top Tweets

The most impressions for a tweet was about running serverless functions from a Docker image on Kubernetes. It had close to 16,000 impressions.

{{<customtwitter 1057356224990273537>}}

The most (recently) liked tweet ironically had nothing to do with technology at all. It was a picture of a door stop I took that has a bit of a twist/pun related to “[Game of Thrones](https://amzn.to/2SiLwLN).” That tweet earned 70 likes as of this writing.

{{<customtwitter 1067483006812573696>}}

The most clicked link I shared was for a project named “List” for working with immutable lists in JavaScript and TypeScript.

{{<customtwitter 992394166494814210>}}

The second most clicked tweet was a link to the serverless eBook I authored (thanks for your interest and support!).

{{<customtwitter 1014137447813402624>}}

My goals for Twitter in 2019 are the same as 2018 with one addition:

* Increase engagement

Right now followers are high but engagement is low compared to many other people I know on Twitter. I’d like to improve that. Any thoughts how? I’ll brainstorm this and set an action plan to improve my engagement moving forward.

## Developer for Life in Review

Late 2017 I made the decision to move from my legacy blog hosted on Google’s Blogger platform to a new one on Medium. This is the first full year on that platform. I won’t compare to last year because I only had three months of data in 2017, but here are the stats for 2018.

I had 67,884 users visit over 95,150 sessions. The countries of origin align fairly closely to my Twitter demographics:

{{<figure src="/blog/2018-12-23_year-of.net-core-angular-and-web-api-design-2018-in-review/images/3.png" caption="Developer for Life sessions in 2018" alt="Screenshot of Developer for Life sessions in 2018">}}

My blog gained Search Engine Optimization (SEO) over the past year and almost 69% of the traffic came in through search.

{{<figure src="/blog/2018-12-23_year-of.net-core-angular-and-web-api-design-2018-in-review/images/4.png" caption="Developer for Life visitor sources in 2018" alt="Screenshot of Developer for Life visitory sources in 2018">}}

My top three direct referrals were:

1. The Microsoft [ASP.NET](https://www.asp.net) site, mainly via the [community spotlight](https://www.asp.net/community/spotlight)
2. [Alvin Ashcraft](https://twitter.com/alvinashcraft)’s [Dew Drop](https://www.alvinashcraft.com/)
3. A repeat from last year: Chris Alcock’s [Morning Brew](https://blog.cwa.me.uk/)

The top 10 visited pages on the main (non-mobile) website include:

{{<figure src="/blog/2018-12-23_year-of.net-core-angular-and-web-api-design-2018-in-review/images/5.png" caption="Developer for Life top viewed pages" alt="Screenshot of Developer for Life top viewed pages">}}

A little love for serverless and a lot of love for Web API design. This aligns very closely with my Medium statistics that also include mobile devices.

Looks like hot topics include:

* .NET Core
* REST Web API
* MongoDB
* Serverless and Azure Functions

This is what I was seeing coming out of 2017.

## Links and Click Data

I share links using a custom link tracker I built so I can find out what everyone is interested in. In 2018 as of this post I analyzed 222,142 clicks. Looking at where I post links, Twitter continues to be the main source of activity (80% of all clicks) followed by LinkedIn (5.6%) and my blog (4.3%).

{{<figure src="/blog/2018-12-23_year-of.net-core-angular-and-web-api-design-2018-in-review/images/6.png" caption="Redirects by source in 2018" alt="Screenshot of redirects by source in 2018">}}

The majority of clicks happen around lunch time (across all U.S. time zones) but with an international audience there is steady activity around the clock. The most popular day to click was Tuesday followed by Thursday, and the least popular was Sunday.

The top five most clicked links of the year were:

1.  [My serverless eBook](http://docs.microsoft.com/dotnet/standard/serverless-architecture/index)
2.  The video of me presenting [The Three D’s of Modern Web Development](https://vimeo.com/303443966)
3.  The first article in my series [Getting Started with Angular on .NET Core 2.1](https://blog.jeremylikness.com/get-started-with-angular-on-net-core-2-1-part-one-2effcfe8fae9)
4.  The link to a repository for a [JavaScript immutable list library](https://github.com/funkia/list)
5.  A link from my Web API Design series to Microsoft’s API design guidelines covering [response formats](https://github.com/Microsoft/api-guidelines/blob/master/Guidelines.md#710-response-formats)

## Closing Thoughts

I’ve said it before, and I’ll say it again:

> Life is like going up the down escalator. If you stand still, you’ll fall behind.

I am grateful for a bountiful and productive year and eagerly await all of the changes to come in 2019.

Merry Christmas 🎅🎄❄ and Happy New Year!

![Jeremy Likness](/blog/2018-12-23_year-of.net-core-angular-and-web-api-design-2018-in-review/images/7.gif)
