---
title: "Hack Your Career: WeRise"
author: "Jeremy Likness"
date: 2018-07-13T15:00:12.526Z
years: "2018"
lastmod: 2019-06-13T10:45:03-07:00
comments: true

description: "The deck and video for my career hacks talk that I presented at the WeRise Women who Code conference in 2018."

subtitle: "A guide for professional developers from a dude with decades of experience getting paid for code."
tags:
 - Public Speaking 
 - Career 
 - Resume Writing 
 - Technology 
 - Life Lessons 

image: "/blog/2018-07-13_hack-your-career-werise/images/1.png" 
images:
 - "/blog/2018-07-13_hack-your-career-werise/images/1.png" 
 - "/blog/2018-07-13_hack-your-career-werise/images/2.gif" 


aliases:
    - "/hack-your-career-werise-7595277c6bb9"
---

In December of 2017 I received an invitation to return to speak at the [WeRise Technology Conference](https://werise.tech/), hosted by [Women who Code in Atlanta](https://www.womenwhocode.com/atl). I was extremely excited and pleased because I had a very positive experience <i class="fab fa-github"></i> [last year](https://github.com/JeremyLikness/docker-we-rise). I wanted to do a different style talk for this conference and decided instead of focusing on a technology, I would instead share some career advice based on my professional developer experience.

![We Rise Logo](/blog/2018-07-13_hack-your-career-werise/images/1.png)

I am thankful the WeRise organizers were willing to invest in recording and publishing the presentations. You can view the full video of my presentation here…

## Video: Watch the Full Presentation

👀 [Hack your Career: Tips and Tricks from a 20-Year Veteran | recallact.com](https://www.recallact.com/presentation/hack-your-career-tips-and-tricks-20-year-veteran)

I’ve been coding professionally since 1994, have served in both individual contributor and manager roles. During that time I personally reviewed thousands of resumes and hired dozens of developers.

{{<customtwitter 1010246975936237568>}}

I have a much easier time now dealing with [impostor syndrome](https://www.hanselman.com/blog/ImAPhonyAreYou.aspx) before talks than I did earlier in my career because I’ve learned to focus more on the audience and what I can share than making it about me. My career talk was different from my typical sessions because it was a soft skills presentation and I wasn’t sure how it would be received. I was also very sensitive to the fact that the event is focused on women in technology, so it was important to me this message wasn’t received as a lecture or soap box but sincere sharing with a desire to help and drive dialog around topics people may disagree with or have different views based on their personal experiences.

Here is the full deck from my talk (PDF):

⬇ [Hack Your Career: Tips and Tricks from a 20-Year Veteran](https://jlikme.blob.core.windows.net/presentations/HackYourCareer.pdf).

All of the images in the deck are pictures of me or that I have personally taken. It’s one of the rare opportunities to see me with hair. As I experienced the year before, the audience was warm and welcoming and reacted to the talk almost instantly.

{{<customtwitter 1010251049154818049>}}

I received some great feedback …

{{<customtwitter 1010263780310298626>}}

…although Paula may be biased because of the shirt I picked to wear.

{{<customtwitter 1010148954045116416>}}

My first “real” programming was using [6502 assembly](https://en.wikibooks.org/wiki/6502_Assembly) on a [Commodore 64](https://en.wikipedia.org/wiki/Commodore_64), and I’ll never forget the language or the fun I had creating code on a 64 kilobyte machine. I still think the most fun I had as a developer was when [Silverlight] (https://en.wikipedia.org/wiki/Microsoft_Silverlight)was released. Although Silverlight is now, too, a platform for the history books, I won’t forget the exciting challenges I faced learning the platform inside and out to provide cutting edge line of business solutions. It should be no surprise I find a way to work it into every talk.

{{<customtwitter 1010295073525895168>}}

This was a nice tweet posted the day after the talk. In addition to her kind words, the screenshot summarizes my career hacking tips quite well.

{{<customtwitter 1010354333404327936>}}

I admit it can seem awkward for a speaker to post a lot of “self-praising” tweets. This is really my equivalent of a “win wall.” If I’m ever insecure going into a talk, I remind myself first why I do it, and second what the feedback from other talks has been. I had no idea how this talk would be received, so the positive support and feedback is great inspiration for future talks.

{{<customtwitter 1010362065297530880>}}

Overall it was an incredible experience and I highly recommend this conference to anyone who is able to travel to the Atlanta area.

Regards,

![Jeremy Likness](/blog/2018-07-13_hack-your-career-werise/images/2.gif)
