---
title: "Serverless application architecture, patterns, and implementation"
author: "Jeremy Likness"
date: 2018-07-03T13:32:16.557Z
years: "2018"
lastmod: 2019-06-13T10:45:02-07:00
comments: true

description: "Full guide to serverless apps architecture, covering approaches, patterns, business scenarios, and including guidance on how to implement using the Azure platform."

subtitle: "An overview of serverless with implementations using Azure Functions, Logic Apps, and Event Grid."
tags:
 - Serverless 
 - Azure 
 - Azure Functions 
 - Logic Apps 
 - Event Grid 

image: "/blog/2018-07-03_serverless-application-architecture-patterns-and-implementation/images/1.jpeg" 
images:
 - "/blog/2018-07-03_serverless-application-architecture-patterns-and-implementation/images/1.jpeg" 
 - "/blog/2018-07-03_serverless-application-architecture-patterns-and-implementation/images/2.gif" 


aliases:
    - "/serverless-application-architecture-patterns-and-implementation-5aaabb3acda6"
---

I blogged and tweeted about serverless the first time just over a year ago.

{{<customtwitter 850433555830276096>}}

I am amazed how much momentum serverless has gained over time and am very happy with the advanced tools that are available to implement serverless in Azure. There is still a lot of confusion around what serverless is, when to choose it, how to implement it and what scenarios exist that are suited to serverless. To address this knowledge gap over the past several months I’ve been working on a project that I’m happy to announce was released just last night: a free online eBook titled “[Serverless apps: Architecture, patterns, and Azure implementation.](https://docs.microsoft.com/en-us/dotnet/architecture/serverless/)”

[![Image of the Serverless eBook Cover](/blog/2018-07-03_serverless-application-architecture-patterns-and-implementation/images/1.jpeg)](https://docs.microsoft.com/dotnet/architecture/serverless/)

The book starts with an overview of traditional architecture patterns and approaches to deploy applications. The overview is used for context to compare/contrast with serverless. The book then covers serverless architecture, including challenges to consider and various design approaches. I show how to implement serverless using the Azure serverless platform that includes [Azure Functions](https://docs.microsoft.com/en-us/azure/azure-functions/?utm_source=jeliknes&utm_medium=blog&utm_campaign=link&WT.mc_id=link-blog-jeliknes), [Logic Apps](https://docs.microsoft.com/en-us/azure/logic-apps/?utm_source=jeliknes&utm_medium=blog&utm_campaign=link&WT.mc_id=link-blog-jeliknes), and [Event Grid](https://docs.microsoft.com/en-us/azure/event-grid/overview?utm_source=jeliknes&utm_medium=blog&utm_campaign=link&WT.mc_id=link-blog-jeliknes). I conclude with a list of business case and scenarios that link out to samples and hands-on labs.

The book can be browsed online or downloaded in PDF format and will provide you with a starting point to understand the power of serverless computing.

Regards,

![Jeremy Likness](/blog/2018-07-03_serverless-application-architecture-patterns-and-implementation/images/2.gif)
