---
title: "DotNext Piter 2018 Recap"
author: "Jeremy Likness"
date: 2018-05-04T14:06:42.939Z
years: "2018"
lastmod: 2019-06-13T10:44:55-07:00
toc: true
comments: true

description: "My recap of a visit to St. Petersburg, Russia to present Explore the Azure Cosmos DB at the DotNext conference. Includes video and slides."

subtitle: "A .NET-focused conference that is incredibly well organized and valuable to attend."
tags:
 - Conference 
 -  .NET 
 - Cosmosdb 
 - Russia 

image: "/blog/2018-05-04_dotnext-piter-2018-recap/images/5.jpeg" 
images:
 - "/blog/2018-05-04_dotnext-piter-2018-recap/images/1.jpeg" 
 - "/blog/2018-05-04_dotnext-piter-2018-recap/images/2.jpeg" 
 - "/blog/2018-05-04_dotnext-piter-2018-recap/images/3.jpeg" 
 - "/blog/2018-05-04_dotnext-piter-2018-recap/images/4.jpeg" 
 - "/blog/2018-05-04_dotnext-piter-2018-recap/images/5.jpeg" 
 - "/blog/2018-05-04_dotnext-piter-2018-recap/images/6.jpeg" 
 - "/blog/2018-05-04_dotnext-piter-2018-recap/images/7.png" 
 - "/blog/2018-05-04_dotnext-piter-2018-recap/images/8.jpeg" 
 - "/blog/2018-05-04_dotnext-piter-2018-recap/images/9.png" 
 - "/blog/2018-05-04_dotnext-piter-2018-recap/images/10.gif" 


aliases:
    - "/dotnext-piter-2018-recap-91fbd02c67fa"
---

It all started back in November 2017 when I received an email asking whether or not I was interested in going to Russia. The invitation was for a major conference called [DotNext](https://dotnext-piter.ru/en/) that has featured many well-known speakers and has the reputation of catering to experienced .NET developers. I was excited and intrigued and responded with a unambiguous “YES!” What happened next changed everything I thought I knew about conferences and Russia!

![Photo of Jeremy Likness](/blog/2018-05-04_dotnext-piter-2018-recap/images/1.jpeg)

## The Model for Organization

A major motivation for writing this post is to share my deep appreciation for the [organizers](https://dotnext-piter.ru/en/organizers/) of the event. This was one of the most well-organized events I’ve attended. The organizers were in contact every step of the way and made sure I was acutely aware of what to expect. The months leading up to the conference unfolded in several phases.

First, I was invited to a private slack channel for communication with the organizers. They met with me over video chat to talk about my presentation, review the conference, share resources from past conferences and brief me on next steps. This conference is unique in that they request a video of the presentation early on. Many speakers, myself included, tend to prioritize talks based on upcoming dates and may not finalize them until the weeks (or, let’s be honest, days) prior. I made a special effort to prepare this talk in advance so I could submit it for review, and it was worth it.

The team reviewed my video and gave me in-depth feedback ranging from:

* Contrast and size of my slides and examples
* Technical depth or lack thereof of demos
* Flow and transitions between sections of my talk
* Questions about areas that would likely benefit from a deeper dive
* Colloquialisms and expressions that may not translate to an international audience

As a result, I feel it was one of the most polished decks I’ve presented and am thankful for the opportunity to improve my presentation.

In addition, the organizers reached out to assist me with travel. For speakers, they offer to cover lodging and airfare. I used my own travel agency because I was doing a multi-leg trip ([Tech Summit Warsaw](https://twitter.com/i/moments/990597470366437376) was later that same week). They assisted with the visa process and provided the necessary documentation to the consulates to secure my entry. Leading up to the event, the organizers held a video conference to present what to expect and shared documents detailing everything from:

* Transportation (they arranged to pick me up and drop me off from the airport)
* Details for check-in at the hotel
* Invitation to a tour of St. Petersburg (details later)
* Information about equipment check and exact specifications of what the rooms would contain
* Hours of the conference
* Location of the speaker room
* Schedule of dinners and parties related to the event
* Details of my talk on the schedule
* Contact information

The organizers made all of the speakers feel very welcome and introduced us at the beginning of conference.

{{<customtwitter 987952270414409730>}}

The event was my first time traveling to Russia and I didn’t know any other speakers who also went (except online). The organization really helped with my comfort level and reduced my stress by knowing exactly what to expect.

## Getting to Know St. Petersburg

![Panorama of the square](/blog/2018-05-04_dotnext-piter-2018-recap/images/2.jpeg)
<figcaption>Palace Square, with [Raffaele Rialdi](https://twitter.com/raffaeler) in front</figcaption>

The organizers were kind enough to provide the speakers with a sight-seeing tour of St. Petersburg. I learned a lot about the local history and saw some beautiful landmarks, despite the cold rain that followed us throughout the tour and only abated when we were done walking. The local cafe we ate at was able to accommodate my 100% plant-based diet with some delicious salads, soups, and an entree they made custom with potatoes and mushrooms. It was delicious!

![Statue of man on horse](/blog/2018-05-04_dotnext-piter-2018-recap/images/3.jpeg)

![Photo of canal](/blog/2018-05-04_dotnext-piter-2018-recap/images/4.jpeg)

![Photo of church](/blog/2018-05-04_dotnext-piter-2018-recap/images/5.jpeg)

![Photo of building](/blog/2018-05-04_dotnext-piter-2018-recap/images/6.jpeg)

## My Talk

I mentioned that I had tremendous feedback to shape my talk. The process to prepare to speak was awesome as well. The night after our sight-seeing tour, I was able to go to the room I’d be speaking in and test all of my equipment and get a sense for the room. The talks are structured with 30 minutes in between so I had plenty of time to prepare between the keynote and my session (the first of the day).

{{<customtwitter 987986342528405504>}}

It was a fun talk to deliver because the setup was so professional. I had a nice screen facing me that made it easy to see my slides when I walked away from my laptop, and a timer to keep from going long.

{{<customtwitter 987986836122464256>}}

⬇ [Click here](https://jlikme.blob.core.windows.net/presentations/cosmosdb-dotnext.pptx) to download the full deck from my presentation.

Something the DotNext organizers set up that I recommend for all conferences is the concept of a “discussion zone.” This was a great way to break away from the talk and let the next speaker set up. After each talk, a special zone is set up for the speaker to answer further questions. The 30 minutes between each talk gives attendees a full 15 minutes to ask questions and discuss the session before going to the next one. There were chairs and even a whiteboard to draw out concepts.

![Discussing Azure Cosmos DB](/blog/2018-05-04_dotnext-piter-2018-recap/images/7.png)
<figcaption>Discussing Azure Cosmos DB</figcaption>

It was incredibly well done and I connected with a lot of attendees there.

## Attending the Conference

I didn’t just speak at DotNext. I attended every session I could outside of my own. That was a lot of sessions. These included a great keynote by [Dylan Beattie](https://twitter.com/dylanbeattie) that revealed just how much technology is behind the simple things we take for granted every day. I highly recommend carving an hour to <i class="fab fa-youtube"></i> [watch it](https://youtu.be/M5edtzCNACE?t=56m52s) yourself!

{{<customtwitter 987956698383110144>}}

The last session I attended was by [Edwin van Wijk](https://twitter.com/evanwijk) reviewing a full microservices-based application built using .NET Core and Docker.

{{<customtwitter 988416380654505985>}}

The attendee party featured great food, libations, and even some really nerdy music. Here is a snippet of “You give REST a bad name.”

{{<customtwitter 988121094899974144>}}

The conference ended with a speaker and organizer dinner where I made some fantastic new friends from all around the world.

![Speaker dinner celebration](/blog/2018-05-04_dotnext-piter-2018-recap/images/8.jpeg)
<figcaption>Speaker dinner celebration</figcaption>

Follow <i class="fab fa-twitter"></i> [this link](https://twitter.com/i/moments/988001827013709824) to see all of my event-related tweets.

## Summary

This was an incredible event. I have to thank the organizers once again for doing a fantastic job. There were phenomenal speakers covering a variety of very relevant and groundbreaking .NET topics. I believe everyone there had a great time, made new connections and learned something new from every talk. It is now on my bucket list to attend the same conference when they host it in Moscow in the future (but not this year — my [conference list](/upcoming-talks-eaf27ff8a3a7) is pretty full!).

![Photo of crowd of people](/blog/2018-05-04_dotnext-piter-2018-recap/images/9.png)

Regards,

![Jeremy Likness](/blog/2018-05-04_dotnext-piter-2018-recap/images/10.gif)
