---
title: "Raise Your Signal-to-Noise Ratio"
author: "Jeremy Likness"
date: 2018-02-22T14:31:02.360Z
years: "2018"
lastmod: 2019-06-13T10:44:45-07:00
toc: true
canonicalUrl: "https://medium.com/that-conference/raise-your-signal-to-noise-ratio-333ebc8ec49d"

description: "Raise your signal-to-noise ratio and improve your productivity by learning about leverage, focus, the power of three and other tips I use every day to accomplish more output with less input."

subtitle: "A Guide to Getting Things Done"
tags:
 - Productivity 
 - Signal To Noise 
 - Motivation 
 - Organization 
 - Inspiration 

image: "/blog/2018-02-22_raise-your-signaltonoise-ratio/images/1.jpeg" 
images:
 - "/blog/2018-02-22_raise-your-signaltonoise-ratio/images/1.jpeg" 
 - "/blog/2018-02-22_raise-your-signaltonoise-ratio/images/2.png" 
 - "/blog/2018-02-22_raise-your-signaltonoise-ratio/images/3.jpeg" 
 - "/blog/2018-02-22_raise-your-signaltonoise-ratio/images/4.png" 
 - "/blog/2018-02-22_raise-your-signaltonoise-ratio/images/5.png" 
 - "/blog/2018-02-22_raise-your-signaltonoise-ratio/images/6.gif" 


aliases:
    - "/raise-your-signal-to-noise-ratio-333ebc8ec49d"
---

![image](/blog/2018-02-22_raise-your-signaltonoise-ratio/images/1.jpeg)

Last week was abundant for me. I use the word “abundant” instead of “busy” because words have power. Busy is about activity, and I prefer to focus on productivity. Ultimately I could focus on how many miles I ran in a given week, but it’s the _outcome_ of being fit and healthy that keeps me going. Focus on increasing the output, not the input, for a few weeks and see how things change. It’s about eliminating the noise in your life and focusing on the signals that provide value.

I’m often asked how I manage to remain productive at work and keep up with the constantly changing cloud landscape at the same time. It’s not uncommon to have someone ask if I work long hours or cut back on sleep. Increasing productivity in your life (and raising your signal) is more about being smarter and filtering out the noise than working harder or longer.

{{<kuula 7l80t>}}
<figcaption>One of the many things I love to do</figcaption>

It’s an interesting question because I think most people would be surprised to hear that I _don’t_ work an 80-hour work week and I _do_ spend a lot of quality time with my family. Having said that, I’m pretty satisfied with the outcomes from last week. Here’s a few of the things I accomplished (and this isn’t to brag, but to make a point):

* Scanned around 7,000 articles and blog posts throughout the week to curate the outcome of a few hundred posts to <i class="fab fa-twitter"></i> [Twitter](https://twitter.com/jeremylikness), <i class="fab fa-facebook"></i> [Facebook](https://facebook.com/cdaJeremyLikness), and <i class="fab fa-linkedin"></i> [LinkedIn](https://linkedin.com/in/JeremyLikness) — part of my weekly routine
* Presented two talks at a code camp and followed up with a [blog post](/serverless-in-south-florida-2fdc8147d3df)
* Helped a fellow developer troubleshoot some issues they were having
* Provided insights into the event I attended by sharing a trip report with my associates
* Created several demos for upcoming talks, including one that demonstrates a 20-year old web browser, another that revives a 36-year old virtual machine for gaming, and another written in Go that renders three-dimensional graphics using JavaScript
* Finished the PowerPoint deck for an [upcoming talk](/upcoming-talks-eaf27ff8a3a7) and recorded several demos to video (beats broken WiFi every time)
* Presented to a user group over Skype
* Wrote a comprehensive blog post related to a very common business scenario and submitted it to my peers for review
* Interviewed on [AskTHAT](https://www.facebook.com/ThatConference/videos/2000741643287466/)
* Read a [serverless whitepaper](https://github.com/cncf/wg-serverless/tree/master/whitepaper) to improve my knowledge in that area
* Built a Kubernetes cluster using [Azure Kubernetes Services](https://aka.ms/aks-docs) and recorded the process for an upcoming demo
* Started reading the free [Python Data Science Handbook](https://jakevdp.github.io/PythonDataScienceHandbook/)
* Setup an [Azure notebook](https://aka.ms/az-notes) and began running Python examples from the book (but I still don’t feel like a data scientist, what _does_ that feel like anyway?)
* Updated the slide deck and worked on demos for my upcoming [Tech Summit in Switzerland presentation](https://www.microsoft.com/de-ch/events/techsummit.aspx)

I also ran five times, ate dinner with my family every day including a few times out at restaurants, watched some movies, finished several chapters of [Lord of the Rings](http://amzn.to/2HqOKrq), and made it to bed between 10pm and 11pm every night I was home. (Sorry, no more all-night hacker fests for this developer). Oh, and I rarely do work-related activities on weekends unless it’s something fun that I want to do, like writing.

![“I workout”](/blog/2018-02-22_raise-your-signaltonoise-ratio/images/2.png)
<figcaption>“I workout”</figcaption>

The purpose of sharing this is to give you some perspective of what I consider to be an abundant week. If you think that doesn’t seem like much at all, this article may not be for you. If you do a lot more but feel overwhelmed, or consider that to be a lot, read on … because in this article I want to answer that question I receive so often about how I get things done.

## The power of three

I learned early on that no matter how flexible or free my job or schedule is, I always need desired outcomes to focus on. This is what keeps me pointed in the right direction. I like to say, and here I’ll quote myself:

> “Life is like walking up the down escalator. If you stand still, you fall behind.”

I used to do what a lot of people do and list all of my tasks. I’d look at them. Then I’d get overwhelmed. I’d struggle trying to figure out what to do, and often procrastinate and make things worse. It wasn’t fun, and it wasn’t effective. Then I learned about the power of three.

Three is just a number that I picked because it’s easy. Two seems too small and four or more starts to get overwhelming again. Here’s how it works:

1. Every year our family plans ahead and asks, “What three things would we like to have achieved by the end of the year?” For example, in 2018 I’d like to advance my position at Microsoft, relocate to Washington, and summit a peak I’ve never been on before.
2. Every month I ask myself, “What are the three most important things to accomplish this month?” This month, for example, my outcomes are to finish an eBook I’m working on, finish all preparation for my presentations next month and deliver the first draft of a team project.
3. Every week I ask myself, “What are the three most important things to accomplish this week?” The week of me writing this, I have two presentations to give and a demo to wrap up for Switzerland.
4. Every weekday I ask myself, “What are the three most important things I can accomplish today?” Notice I said “weekdays.” I use the weekends to relax, and only work on projects when I want to and know I’ll have fun doing it.

The power of three seems trivial, but it’s amazing how powerful it can be. There are so many distractions in a given day that narrowing it down to three important tasks keeps me focused. In fact, most of the time I can break them down into morning, early afternoon, and evening to block off focus time, although it doesn’t always work out that way. I have a much larger list to accomplish but I always stay focused on three important things.

Of course, it also helps that I eat the frog.

## Eat the frog

I can’t take credit for the phrase. It’s a quote attributed to none other than Mark Twain.

> “Eat a live frog first thing in the morning and nothing worse will happen to you the rest of the day.” — Mark Twain

To me, in a nutshell, it’s quite simple. All things being the same, my next task to tackle is always the one I least want to do. That’s right! It’s too easy to procrastinate and make excuses, so I always go for the tough one first, and it always pays off. It feels _great_ not to procrastinate and to have things done that would otherwise get delayed out of a selfish desire to focus on the “fun stuff.” (And this is all relatively speaking, of course, because most of what I do I consider to be fun.)

## Get a routine

Change is good, but a disciplined routine can help you weather the changes that will inevitably creep into your life and schedule. I have a simple routine that serves me well. I always train first thing in the morning, so I don’t have excuses to put it off later. I always plan out my three important things to do for the day over breakfast, and then I always spend the first hour at my computer scanning RSS feeds, blog posts, tweets and status updates to curate information I want to share with my network and pick up topics I want to learn more about.

![Yeah, it’s like that](/blog/2018-02-22_raise-your-signaltonoise-ratio/images/3.jpeg)
<figcaption>Yeah, it’s like that</figcaption>

I treat that first hour like a well-run stand-up. A stand-up should be time boxed and if other topics come up, they should be deferred to another meeting with the right people and time box. When scanning “what’s new” I look at titles, drill into the interesting ones and skim them, and then flag some to post out to social media. The really interesting articles or videos get tagged for later. But that’s for the next tip.

Here’s a typical day for me:

* **5 am —**punch the lights out of my alarm
* **5:15 am** — workout
* **6:45 am —**breakfast, read some non-fiction, plan three things
* **7:30 am** — parse news feeds, RSS, blogs, etc. and schedule social media updates
* **8:30 am** — write a chapter for my eBook
* **10 am** — take a break, eat a snack, read some non-fiction
* **10:15 am** — work on a presentation
* **11:30 am** — break for lunch
* **12:00 pm** — back to presentation
* **1:30 pm** — step away and read some articles or videos
* **1:45 pm** — work on proof of concept project
* **3:00 pm**— take a break, eat a snack, read some non-fiction
* **3:15 pm**— continue work on proof of concept project
* **4:30 pm**— take the dog out for a walk
* **5:00 pm**— wrap up emails, update status, write down accomplishments and celebrate the day, look at Kanban and see what’s coming up
* **6:00 pm** — dinner with family
* **7:00 pm** — movie or show with family
* **9:00 pm** — reading or work on self-learning or writing or whatever
* **10:30 pm** — zzzzzzzzzzzzzzzzzzzz

Weekends aren’t so structured. That’s when I like to sleep in when I can. Did I mention I get up at 5 am during the week?

## Take breaks

I don’t know about you, but sometimes going heads down writing an article or programming a solution, I reach the point where I stop being productive. Have you ever had that moment where you suddenly feel like you’re forcing yourself to continue and just end up staring at the screen? I’ve learned to pivot on those moments and take a break. I may get up, walk, stretch, or whatever, but then I’ll shift and pick up one of the articles or videos I flagged in the morning and read or watch them. It helps me unplug but I still receive value from that time. I always learn something new. After taking a short break I’m usually refreshed and ready to dive back into whatever it was that I’m working on.

## Kanban

It’s easy to get overwhelmed with a large task list, but it’s also important to keep track of them. In years of managing teams and me, I’ve found the easiest system is a simple Kanban board. I use [Visual Studio Team Services](https://aka.ms/Tun3ev) because I have so many other projects there, but there are many tools that do the same thing.

![An example of my upcoming tasks](/blog/2018-02-22_raise-your-signaltonoise-ratio/images/4.png)
<figcaption>An example of my upcoming tasks</figcaption>

The key is that it should be extremely, incredibly, superbly _easy_ to:

* Add a task
* Know which tasks are coming up soon
* Update the status of a task
* Mark it done

I have buckets for approved (I’m going to work on it), committed (it has a deadline) and working (I’m on it!). I use tags to apply dates because some tasks have multiple milestones so I can see multiple dates. At a glance, it’s easy for me to drag and drop the tiles to order them based on what I need to focus on next. I’m not sweating the tasks that are farther down the queue, and instead use the ones at top to create my daily and weekly three.

## Output more, input less with leverage

I ran my own fitness business for a few years. I was a certified trainer and nutritionist. I became passionate about fitness after losing a lot of weight. The changes I experienced in mindset empowered me to accomplish new goals, including writing my first book.

![My first book (cover reprinted here with permission by, well, me)
](/blog/2018-02-22_raise-your-signaltonoise-ratio/images/5.png)
<figcaption>My first book (cover reprinted here with permission by, well, me)</figcaption>

One thing I learned during my time in that business was the power of leverage. My first year was an unsuccessful struggle because I knew nothing about starting a business and had no experience with leverage. I was trading time for dollars, so the only way to give myself a raise was by working more hours. That wasn’t fun at all. Fortunately I had the wisdom and humility to hire coaches to learn from their success, and they taught me about the power of leverage.

Here’s an example of leverage from my training days: I would give a live paid seminar and invest in a production company to record video of the presentation. Then I’d have the video professionally edited and transferred to DVDs that I sold on-demand through a publishing company. I spent a little more for each DVD than if I purchased in bulk, but it was a “serverless approach” because I only had to pay if someone actually purchased it, and all shipping and billing was handled by the company. Every sale was pure profit, as opposed to having to manage inventory. I simply collected a check at the end of each month.

The DVDs were my leverage. After they were produced, I no longer had to do any work on work them again. They would sell, print, and ship without me lifting a finger. I leveraged the one-time seminar to produce an ongoing income stream. I had a portfolio with a book, several audio CDs and multiple DVDs that did quite well.

I learned to do the same thing in my technical career. Solving a particularly tough problem at work provided the material for a detailed blog post. After I give a presentation, I always blog about it afterwards. I often produce videos walking through the demos and sometimes create blog posts to explain the topic in more detail. I leverage that time and knowledge to increase my productivity. Here the payoff isn’t in dollars, but having materials that continue to reach and impact developers beyond just that single talk.

## The blink of an eye

OK, this tip is the hardest for most people to swallow. I hate that it’s the most difficult one to implement, because it is the single most important factor I contribute to my personal success. Did that grab your attention? I wouldn’t be where I am today without this. It’s simple:

> You must be able to make decisions in the blink of an eye.

I know, that sounds horrible, doesn’t it? What about proper vetting, and planning, and caution, and risk analysis? The truth is, those are all still important, but not the way you might think. A very good mentor of mine once shared with me a phrase that may sound confusing at first:

> “You know what you know what you know…”

It really means “trust in what you know _right now_ and don’t “cram for the test.” It had profound implications to me. For example, I realized that I don’t have to stress about a presentation the night before and lose sleep because there is no way I’m going to become somehow smarter, wiser, or gain some powerful knowledge in that short time. I already know what I know, so I need to go on stage with confidence and let it happen. This really applies to all aspects of life.

Most of the time when you are faced with choices, you have everything you need to make a decision. Sometimes that decision is to defer making a commitment until you have more information, but it’s important to know when you are procrastinating or if you truly need more data.

For example, have you ever had someone ask you if you could attend a meeting, and you simply sit on the email because you debate whether or not you can make the time to attend? That’s an example of procrastination. The reality is, you _already know_ and are either waiting to talk yourself out of your decision or find some justification you feel you need. I’ve learned to respond to meeting invites immediately. If I know I’m not really going to make it, it’s a polite decline. If I know I’ll attend, it’s an immediate accept. Otherwise, I choose “tentative” and keep it on my calendar as a reminder.

The same thing happens for requests to speak. If I find myself hesitating to say, “yes” then it’s probably because, subconsciously, I know I’m overloaded. I’ve learned to make those a fast “no” or if the talk is important enough, a fast “yes” and then just do what it takes to get it done. I strive to maintain an inbox with zero to just a handful of items. I keep it that way because I make decisions fast. If it’s something I need to think about, it becomes a task and the email is filed. If it feels like too much overhead to create a task then it’s probably a “no” anyway, isn’t it? Most emails get a fast reply or just get filed because they are information. The ones with noise get deleted, and it I get repeated noise from a source I mute it with a rule.

This also happens when I’m scanning articles to decide what to share with my network. I can quickly eliminate articles based on a quick glance or impression, and decide some articles definitely need to get shared. The ones that need a closer look I tag and come back to. Sometimes I get it wrong and post a link to lackluster content, but that’s the exception and not the rule. Part of fast decision-making is accepting a bit of risk and recognizing that the increased productivity you gain as a result far outweighs the few hiccups you may run into.

This is why I am considered by many to be a prolific writer. Whether it’s personal blog posts or professional, paid freelance articles, I rarely go through multiple revisions. I write while I’m passionate about the topic, and when I’m finished I walk away for awhile. The passion is important because it’s a window of opportunity to be productive. After a short break, I come back and give it one more run through. I don’t agonize over it being perfect, because I was also given this piece of important advice and it led to me writing my first published book:

> Don’t get it perfect. Just get it going.

Perfection is a form of procrastination. The faster you can decide to write, to post, to share, the more productive you’ll be. Of course, a paid article requires more in depth fact checking and understanding the publisher’s desires, but that doesn’t mean I have to spin through exhaustive cycles to get to the finished product. It is an art, but with practice you can balance your life and compromise between time and perfection.

## Celebrate

Now you’ve become a productive machine smashing through your goals and achieving new heights of accomplishment. Congratulations! Take time to celebrate. Every day worth living is worth celebrating. Our team shares our weekly accomplishments with everyone and sometimes my list feels relatively large. It’s not because I’m doing more than anyone else, but often I find people tend to treat the report as an exercise in looking back. “What _did_ I do this week?” It’s easy to miss things when you accomplish so much in a week!

I take time at the end of _every_ _day_ to ask myself not what I _did_ (wrote this, tweeted that, coded something else) but what I _accomplished_. If I didn’t hit my three goals, I think about why and adjust for the next day. I always write down what I achieved and save it every day, so it’s “cut and paste” to send out the weekly report (and then I have that). At the end of each week I look back, and each month, and each year. As I’m writing down what I accomplished, I celebrate it. This usually means my day ends on a great note with me in a fantastic mood.

If you haven’t tried that before, you should start now. You’ll be amazed first at how much you actually accomplished, then by how motivating it is to go into the next week with a mindset of celebration. This energy feeds into the next week and helps you achieve new levels by riding on the momentum of past accomplishments. Personally, I never want to be a card-carrying member of the “not much club.” You know, that club people join so when they catch up with friends they haven’t seen in years, they can answer “not much” to the question, “What’s new?”

Forget that!

I led my first team when JavaScript was just a few weeks old. It’s been a minute. That’s over two decades of managing, mentoring, and leading teams. Every time I see someone who has great potential get stuck in the mire, it’s because they haven’t mastered The [Power of Focus](http://amzn.to/2Ctt5Ll) and they let too much noise into their lives. Noise can come from distracting debates on social media, water cooler talk, pointless TV shows or just self-made nonsensical activities you create to avoid doing the “real” work. It is my sincere belief that if you follow even a few of the tips I shared in this post, and do it consistently for at least a few weeks, you will find that your signal-to-noise ratio rises to new levels.

Best of success to you.

Regards,

![Jeremy Likness](/blog/2018-02-22_raise-your-signaltonoise-ratio/images/6.gif)
