---
title: "The Year of Docker, Serverless, and .NET Core: 2017 in Review"
author: "Jeremy Likness"
date: 2017-12-27T13:27:40.931Z
years: "2017"
lastmod: 2019-06-13T10:44:30-07:00
comments: true
toc: true
series: "Year End Summaries"

description: "A recap of activity from 2017 with statistics that focuses on popular tweets, articles, and clicks to uncover trends including serverless, Docker containers, .NET Core 2.0 and more."

subtitle: "A look back at 2017 with the stats to prove it."
tags:
 - Social Media 
 - Trends 
 - Technology 
 - Programming 
 - Analytics 

image: "/blog/2017-12-27_year-of-docker-serverless-and-.net-core-2017-in-review/images/3.png" 
images:
 - "/blog/2017-12-27_year-of-docker-serverless-and-.net-core-2017-in-review/images/1.png" 
 - "/blog/2017-12-27_year-of-docker-serverless-and-.net-core-2017-in-review/images/2.png" 
 - "/blog/2017-12-27_year-of-docker-serverless-and-.net-core-2017-in-review/images/3.png" 
 - "/blog/2017-12-27_year-of-docker-serverless-and-.net-core-2017-in-review/images/4.png" 
 - "/blog/2017-12-27_year-of-docker-serverless-and-.net-core-2017-in-review/images/5.png" 
 - "/blog/2017-12-27_year-of-docker-serverless-and-.net-core-2017-in-review/images/6.png" 
 - "/blog/2017-12-27_year-of-docker-serverless-and-.net-core-2017-in-review/images/7.png" 
 - "/blog/2017-12-27_year-of-docker-serverless-and-.net-core-2017-in-review/images/8.png" 
 - "/blog/2017-12-27_year-of-docker-serverless-and-.net-core-2017-in-review/images/9.png" 
 - "/blog/2017-12-27_year-of-docker-serverless-and-.net-core-2017-in-review/images/10.gif" 


aliases:
    - "/docker-serverless-dotnet-core-2017-in-review-4fca69d50cf8"
---

I am a firm believer that it is difficult, if not impossible, to make progress without having a baseline to measure from. That is why every year I like to pause and review my accomplishments before setting goals for the new year (I don’t just do this every year — I’m a fan of setting daily, weekly, monthly, quarterly, and yearly goals). I also have said before:

> Life is like walking up the down escalator: if you stand still, you fall behind.

That’s my way of saying that I believe every year should be different from the last and involve new learning and challenges. Have you heard the exchange before when someone asks an old friend, “What’s new?” and they reply, “Not much?” I don’t want to be a member of the _“not much”_ club. In this post I capture a few personal accomplishments and goals, then sort through the analytics I have from my various blogs, social media, and click tracking tools.

On a personal note, key accomplishments this year were:

* Sent my daughter to college (we’re now “empty nesters”)
* Helped my wife recover from a major back surgery
* [Visited Italy](https://kuula.co/explore/collection/7fy4p) for the first time
* Started my new role as a [cloud developer advocate](/what-is-a-cloud-developer-advocate-f7606b5a9a08) at Microsoft

My goals for 2018 include:

* Speak internationally (and not just once)
* Find a home and relocate to the Redmond, Washington area
* Engage heavily in the amazing [giving opportunities](https://www.microsoft.com/philanthropies/employee-engagement) that Microsoft provides its employees
* Summit a mountain I’ve never hiked before

I made a short video to share that I believe captures the essence of what I love about being a developer. The music and dancing ninjas are from a “demo” program I wrote on the Commodore 64 in 1988 at the age of 13. The main programming feat for that particular section of the demo is reading the sound registers on the [SID chip](https://www.c64-wiki.com/wiki/SID) so that I can swap the ninja image and create the illusion of “dancing” to the beat. The plasma effect is a challenge I took on a few years ago to take a common demo effect and implement it in JavaScript, and the raccoon is “Bit” or the mascot for all [developer advocates](https://developer.microsoft.com/en-us/advocates/).

{{<youtube D04QWI9JPLI>}}

For reference, this was my 2016 in review post:

🔗 [2016 in Review](https://csharperimage.jeremylikness.com/2016/12/2016-in-review.html)

When I moved to this blog, I also took an “all-time” snapshot of my legacy blog, and wrote about that here:

🔗 [Reflecting on 15 Years of Blogging](/reflecting-on-15-years-of-blogging-dc008ee71053)

This tweet captures what I feel are the highlights from 2017 and what I look forward to in 2018.

{{<customtwitter 942843348913704960>}}

In addition, I also believe that I will see and learn a lot more Artificial Intelligence and Machine Learning in the year to come.

There is a lot of data in this post, so if you have specific interests, feel free to jump around!

## Twitter in Review

I ended 2016 with 9,165 followers and as of this post have 10,103. That’s a gain of around 1,000 followers or about 2–3 per day for the year. Although that may sound impressive to some, the total count is less important to me than the engagement and interest level. My goal with twitter is to reach developers, so followers who don’t _really_ follow or interact don’t help with community reach.

In general, despite a large following, I didn’t receive as much engagement as I’d like. For comparison, some accounts with far fewer followers receive hundreds of likes, re-tweets, and other forms of engagement. My goal for 2018 is to continue to improve engagement through several means:

1. Continue to deliver a high signal-to-noise ratio of content (see below)
2. Focus on “in person” followers at events such as user group meetups and conferences
3. Interact frequently online through conversations, answering questions, supporting community, etc.

For the “signal-to-noise ratio” I currently review anywhere between 500–1500 items daily to curate what I believe are the top 5–10 noteworthy items to share with my followers. This is in addition to content I author myself. See the links and click data section to learn more.

The following stats are from the most recent three months (90 days) of Twitter.

### Demographics

92% of my followers list _technology_ as their top interest, which is a good thing because my Twitter feed is almost exclusively developer focused. The top five interests of my followers are:

* Technology — 92%
* Tech news — 90%
* Windows — 86%
* Computer programming — 83%
* Mobile — 73%

I have to give _open source_ an honorable mention at sixth place and 69%.

![Twitter follower interests](/blog/2017-12-27_year-of-docker-serverless-and-.net-core-2017-in-review/images/1.png)
<figcaption>Twitter follower interests</figcaption>

13% of my followers are female. That is up from less than 10% last year, but still shows that I have some work to do in order to reach and engage with a more diverse audience.

The top age category of followers is 25–34 or so-called _millennials_. Thank you for following a Generation X-er!

41% of my followers are in the United States, followed by the United Kingdom (8%) and Canada (3%).

### Top Tweets

The most eyeballs landed on a post I shared about building a web service with F# in .NET Core. It was viewed 16,213 times.

{{<customtwitter 913374382910820352>}}

The most liked tweet was one I shared to demonstrate how to install a Chrome extension that blurs sensitive information in the Azure portal while giving presentations or sharing your desktop.

{{<customtwitter 922806397586345985>}}

The most re-tweets I had was a tie between the previous tweet and the link I shared to the Azure Kubernetes Service (AKS) documentation.

{{<customtwitter 922863240077553664>}}

The tweet about the Chrome extension also had the most link clicks (159). Second place at 118 was this status about debugging ASP. NET Core on Linux:

{{<customtwitter 930125127718785025>}}

Finally, looking back at my most popular tweets based on engagement, the topics followers found most interesting were:

* Azure
* .NET Core
* Linux
* MVP program
* Virtual Desktops
* Windows Subsystem for Linux (WSL)
* F#
* REST API Design

I also experimented a little bit with sharing some of my non-technology related hobbies, like hiking. I was surprised and pleased to see the pictures of my hike to [Ramsey cascades](https://www.nps.gov/grsm/planyourvisit/ramsey-cascades.htm) was one of my more popular tweets (and no one complained that is wasn’t about software development!)

{{<customtwitter 929458361950720010>}}

## Legacy (C#:er Image) Blog in Review

In 2017 my legacy blog was visited by around 50,000 users over 70,000 sessions.

I had visitors from around the world, but as usual the vast majority were from the United States.

![C#er: IMage sessions in 2017](/blog/2017-12-27_year-of-docker-serverless-and-.net-core-2017-in-review/images/2.png)
<figcaption>C#er: IMage sessions in 2017</figcaption>

The majority of visitors found my site through organic search. This reinforces the philosophy, “Don’t break the Internet.” People are finding my old pages on search engines so I’m happy I chose to keep them available.

![C#er: IMage visitor sources in 2017](/blog/2017-12-27_year-of-docker-serverless-and-.net-core-2017-in-review/images/3.png)
<figcaption>C#er: IMage visitor sources in 2017</figcaption>

Almost all of the top search queries included some variation of MVVM, or “Model-View-ViewModel.” Those queries landed the majority of visitors on an article I wrote [almost a decade ago](https://csharperimage.jeremylikness.com/2010/04/model-view-viewmodel-mvvm-explained.html) that explains the pattern in detail (at the time, it was in the context of Silverlight, but ironically what makes MVVM unique is the data-binding aspect that ties it to modern day frameworks like Angular and Vue.js).

There were three main topics covered by the top viewed pages:

* Angular
* MVVM
* Segoe UI icons

The Angular pages were mostly an older “top five mistakes” series I wrote about Angular 1.x, but there was one more recent article that made the cut at 1,847 views. Due to its popularity, I ported it to this blog:

🔗 [Create a Serverless Angular App with Azure Functions and Blob Storage](/create-a-serverless-angular-app-with-azure-functions-and-blob-storage-20164c083c88)

Based on these statistics, I’m seriously considering writing an updated version of the MVVM article that tackles modern JavaScript frameworks and redirects from the old blog. Only time will tell if I end up doing that in 2018 — we’ll call it a “stretch goal.”

## Developer for Life in Review

I made the transition to this new blog in August 2017, so statistics presented here are for slightly less than five months as compared to the full year for my legacy blog.

I had 12,450 users visit over 16,430 sessions. The geographic distribution of visitors to the new blog is significantly different than my legacy blog.

![Developer for Life sessions in 2017](/blog/2017-12-27_year-of-docker-serverless-and-.net-core-2017-in-review/images/4.png)
<figcaption>Developer for Life sessions in 2017</figcaption>

Not surprisingly, visitors came from very different sources. New sites take awhile to build search engine momentum, so the majority of visitors found the new blog through referrals and social media.

![Developer for Life visitor sources in 2017](/blog/2017-12-27_year-of-docker-serverless-and-.net-core-2017-in-review/images/5.png)
<figcaption>Developer for Life visitor sources in 2017</figcaption>

My top three referrers were:

1. Chris Alcock’s [Morning Brew](http://blog.cwa.me.uk/) (thanks, Chris!) — if you want a great source of information, check it out for yourself
2. <i class="fab fa-twitter"></i> Twitter
3. <i class="fab fa-reddit"></i> [Reddit](https://www.reddit.com/) thanks mainly to a post in [/r/programming](https://www.reddit.com/r/programming/) about my blog post “[.NET Core 2.0 is Ready and Sterling Proves It!](https://www.reddit.com/r/programming/comments/6vvogu/net_core_20_is_ready_and_sterling_proves_it/)”

I was happy for those referrals because they were all completely organic and I hope to see more.

Raw analytics from Google breaks down my top pages like this, but because my blog is on Medium there are a lot of visitors on mobile devices that don’t get counted on the main website.

![Developer for Life top viewed pages (Google Analytics) in 2017](/blog/2017-12-27_year-of-docker-serverless-and-.net-core-2017-in-review/images/6.png)
<figcaption>Developer for Life top viewed pages (Google Analytics) in 2017</figcaption>

Moving over to Medium and looking at the past 90 days gives me this breakdown — the order is the same but the views are much higher:

![Top pages in 2017 per Medium](/blog/2017-12-27_year-of-docker-serverless-and-.net-core-2017-in-review/images/7.png)
<figcaption>Top pages in 2017 per Medium</figcaption>

These statistics are helpful and show the blog move was net positive because I’m getting significantly more reads — 3,600 read an entire 7-minute article as opposed to 1,800 who viewed a page on my old blog and may or may not have even read it. I do like that Medium tracks where users are on the page and attempts to estimate who truly reads the full article.

Breaking down the popular topics I’ve blogged yields this short list:

* .NET Core 2.0
* REST Web API
* 🌍 CosmosDB
* &lt;⚡&gt; Serverless and Azure Functions

I did migrate a few articles from my old site, but they didn’t even come close to making the top read pages.

## Links and Click Data

Perhaps the most useful data I have is around link clicks. The previous statistics just cover my own universe — the “Jeremy Likness echo chamber” — and don’t truly reveal overall trends or what people are generally interested in (only what they are interested in that I also happen to write about). Earlier this year I built a link shortening tool so that I could track links I share across various social media sites, on my blog, in <i class="fab fa-github"></i> [GitHub](https://github.com/JeremyLikness) and on <i class="fab fa-youtube"></i> [YouTube](https://www.youtube.com/user/MrLikness). You can read about it here:

🔗 [Build a Serverless Link Shortener with Analytics Faster than Finishing your Latte](/build-a-serverless-link-shortener-with-analytics-faster-than-finishing-your-latte-8c094bb1df2c)

And get the latest code that populates Cosmos DB with statistics here:

<i class="fab fa-github"></i> [JeremyLikness/jlik.me](https://github.com/JeremyLikness/jlik.me)

Using data I started collecting in September, just shortly after launching my new blog, I was able to track engagement to not just my own content, but other sites as well. I regularly publish content to my <i class="fab fa-twitter"></i> [Twitter](https://twitter.com/JeremyLikness) and <i class="fab fa-linkedin"></i> [LinkedIn](https://linkedin.com/in/JeremyLikness) profiles along with my <i class="fab fa-facebook"></i> [Facebook page](http://facebook.com/cdaJeremyLikness). I used to leverage Google+ but phased that out due to lack of engagement: despite thousands of followers I only had one or two users click through content.

Out of over 30,000 clicks tracked in 2017, the vast majority of engagement happened on Twitter:

![Redirects by source in 2017](/blog/2017-12-27_year-of-docker-serverless-and-.net-core-2017-in-review/images/8.png)
<figcaption>Redirects by source in 2017</figcaption>

I only recently created a Facebook page to publish technical content to, so narrowing data to the past month puts Facebook on the map:

![Redirects by source in December 2017](/blog/2017-12-27_year-of-docker-serverless-and-.net-core-2017-in-review/images/9.png)
<figcaption>Redirects by source in December 2017</figcaption>

The least popular day to click on content was Sunday. The most popular day was Thursday.

Almost nobody clicks links in my network between 7:00 pm Eastern Time and 8:00 am. I also rarely tweet during that period, which implies that most clicks are “real-time” in that users see the content posted and click when it appears, rather than scrolling through and engaging with content after it’s posted.

Almost 10% of all clicks happened between 12:00 pm and 1:00 pm Eastern Time. Second and third place were the 11:00 am — 12:00 pm and 1:00 pm — 2:00 pm time slots. My theory is that people are generally working and don’t have much time for Twitter but click and read content over lunch.

Outside of generic clicks to my blog, the top five clicked links overall last year were:

1. [Exploring the CosmosDB with Power BI](/exploring-cosmosdb-with-powerbi-9192317087d8)
2. [Five REST Web API Designs in .NET Core Part 4: Optimistic Concurrency](/5-rest-api-designs-in-dot-net-core-4-8ac863e961e4)
3. [Documentation for Azure Kubernetes Services (AKS)](https://docs.microsoft.com/azure/aks/?WT.mc_id=jeremylikness-blog-jeliknes)
4. [Expanding Azure Functions to the CosmosDB](/expanding-azure-functions-to-the-cosmos-423d0cb920a)
5. [Debugging ASP .NET Core on Linux with Visual Studio 2017](https://blogs.msdn.microsoft.com/premier_developer/2017/11/10/debugging-asp-core-on-linux-with-visual-studio-2017/)

Of course, one important reason for tracking links is to better understand what’s _not_ popular so I don’t waste your time. The least clicked topics included some of my conference recaps, and most links to documentation that were for broad topics rather than specific pages of information. It’s also interesting to note that clicks vary by medium (i.e. LinkedIn are interested in different topics compared to Twitter) but I’m still working on building out the right reports to pull insights from that data.As you can see, measuring data provides useful insights and helps me optimize where I spend my time and what topics to focus on. Although there is plenty of bias from my work and what I’m interested in, the trending topics this year definitely seemed to focus on containers, serverless, and .NET Core 2.0. Probably the only other major topic that didn’t get captured in my network because I know the least about it (and is a goal to learn more about in 2018) is Blockchain.

Thanks for taking the time to read these insights. As always I’d love to hear your feedback. Feel free to leave a comment on this blog or <i class="fab fa-twitter"></i> [Direct Message me](https://twitter.com/messages/compose?recipient_id=jeremylikness) on Twitter!

Regards,

![Jeremy Likness](/blog/2017-12-27_year-of-docker-serverless-and-.net-core-2017-in-review/images/10.gif)
