---
title: "Get Started with CosmosDB SQL API"
author: "Jeremy Likness"
date: 2017-12-18T13:58:08.158Z
years: "2017"
lastmod: 2019-06-13T10:44:26-07:00
comments: true

description: "Video walk through shows how to create an Azure Cloud-based NoSQL database with CosmosDB and connect from a .NET application using the SQL API in under 5 minutes."

subtitle: "Launch your first .NET project in under five minutes"
tags:
 - Programming 
 - NoSQL 
 - Azure 
 - Cloud 
 - Cosmosdb 

image: "/blog/2017-12-18_get-started-with-cosmosdb-sql-api/images/1.png" 
images:
 - "/blog/2017-12-18_get-started-with-cosmosdb-sql-api/images/1.png" 
 - "/blog/2017-12-18_get-started-with-cosmosdb-sql-api/images/2.gif" 


aliases:
    - "/getting-started-with-cosmosdb-sql-api-da52719f30de"
---

CosmosDB is a globally distributed, multi-model document database. Multi-model empowers you to choose the API you will use to interact with the database.

![Creating a new CosmosDB account](/blog/2017-12-18_get-started-with-cosmosdb-sql-api/images/1.png)
<figcaption>Creating a new CosmosDB account</figcaption>

As of this writing, there are five supported models:

* The [SQL API](https://docs.microsoft.com/en-us/azure/cosmos-db/create-sql-api-dotnet?utm_source=jeliknes&utm_medium=blog&utm_campaign=link&WT.mc_id=link-blog-jeliknes) (based on the DocumentDB interface)
* [MongoDB](https://docs.microsoft.com/en-us/azure/cosmos-db/create-mongodb-dotnet?utm_source=jeliknes&utm_medium=blog&utm_campaign=link&WT.mc_id=link-blog-jeliknes)
* [Graph API](https://docs.microsoft.com/en-us/azure/cosmos-db/create-graph-dotnet?utm_source=jeliknes&utm_medium=blog&utm_campaign=link&WT.mc_id=link-blog-jeliknes)
* [Table API](https://docs.microsoft.com/en-us/azure/cosmos-db/create-table-dotnet?utm_source=jeliknes&utm_medium=blog&utm_campaign=link&WT.mc_id=link-blog-jeliknes)
* [Cassandra](https://docs.microsoft.com/en-us/azure/cosmos-db/create-cassandra-dotnet?utm_source=jeliknes&utm_medium=blog&utm_campaign=link&WT.mc_id=link-blog-jeliknes)

The easiest way to get started is to follow the excellent [quick start document](https://docs.microsoft.com/en-us/azure/cosmos-db/create-sql-api-dotnet?WT.mc_id=link-blog-jeliknes). To make it even easier, I recently spent some time in the Channel 9 studios to record this walk through that demonstrates CosmosDB with the SQL (formerly DocumentDB) API in less than five minutes.

{{<youtube Nccze3seDc0>}}

The portal has changed a little since I recorded this (Cassandra was added and the DocumentDB interface renamed to SQL API) but otherwise you should be able to follow along to get up and running in minutes.

Learn more about CosmosDB by reading the [official CosmosDB documentation](https://docs.microsoft.com/en-us/azure/cosmos-db/introduction?WT.mc_id=link-blog-jeliknes).

Regards,

![Jeremy Likness](/blog/2017-12-18_get-started-with-cosmosdb-sql-api/images/2.gif)
