---
title: "The San Francisco/Bay Area Serverless Tour 2017"
author: "Jeremy Likness"
date: 2017-10-22T15:31:57.535Z
years: "2017"
lastmod: 2019-06-13T10:44:15-07:00
comments: true

description: "Summary of my San Francisco and Mountain View tour sharing serverless  Azure Functions, Logic Apps, and Application Insights with West Coast developers."

subtitle: "A great time discussing Azure Functions, Logic Apps, and Application Insights with West Coast developers."
tags:
 - Serverless 
 - Azure 
 - Azure Functions 
 - JavaScript 
 - Nodejs 

image: "/blog/2017-10-22_san-franciscobay-area-serverless-tour-2017/images/1.jpeg" 
images:
 - "/blog/2017-10-22_san-franciscobay-area-serverless-tour-2017/images/1.jpeg" 
 - "/blog/2017-10-22_san-franciscobay-area-serverless-tour-2017/images/2.jpeg" 
 - "/blog/2017-10-22_san-franciscobay-area-serverless-tour-2017/images/3.gif" 


aliases:
    - "/the-san-francisco-bay-area-serverless-tour-2017-9883b43aa9f3"
---

I spent the past week embarking on an exciting journey across Silicon Valley. I had the opportunity to connect with several meetup groups and present talks covering my favorite Azure feature: serverless! Although the tour was based on talks I previously gave in Atlanta, this was a great opportunity to connect with new venues and meet new developers. I always enjoy a visit to San Francisco, even though it was a bit smoky due to nearby fires. This was the view from my hotel the first morning.

![San Francisco, looking from Union Square, October 2017](/blog/2017-10-22_san-franciscobay-area-serverless-tour-2017/images/1.jpeg)
<figcaption>San Francisco, looking from Union Square, October 2017</figcaption>

I uploaded the full deck and related demos for anyone to view.

{{<slideshare GMV0N151WPFcMo "jeremylikness/code-first-with-serverless-azure-functions-81068288">}}

The deck itself has embedded videos for the demo portions, so you can watch those, too. They are all hosted in my YouTube channel for Azure:

{{<youtube "ekczxSwlNMA?list=PL1VfiVM16kp-DicjpTzyXuRWXekuypu26">}}
<figcaption>Azure Series of Videos</figcaption>

The first group I met with was [Cloud Storage and Lambda Compute — Bay Area](https://www.meetup.com/Cloud-Storage-Bay-Area/) at the [Pivotal Office](https://www.google.com/maps/place/Pivotal/@37.7834656,-122.4068843,18z/data=!4m8!1m2!2m1!1spivotal+san+francisco!3m4!1s0x808580887d690df7:0x108e933f003c99e3!8m2!3d37.7818416!4d-122.403956). Everyone was very welcoming. I arrived an hour early to make sure everything was set up and working (it was).

{{<customtwitter 920445234235899905>}}

A few Microsoft employees in the area stopped by along with one gentlemen who said he knew me from my _cough_ Silverlight _cough_ days. This was the longest time slot I had and they were kind enough to record it live (yes, this is live, so there aren’t any edited transitions from speaking to slides).

🎦 [Video of presentation](https://www.facebook.com/Minio.io/videos/1514474255313061/)

Oh, and thanks, Victor, for the kind words. I’m pretty sure he was trying to _shout out_ and not _shut out_ here.

{{<customtwitter 920489093045174272>}}

Here’s one more action picture. Thanks, Neil, it was great to meet you!

{{<customtwitter 920467613435564032>}}

The next meetup was held for [SF Microservices](https://www.meetup.com/SF-Microservices/events/243921541/) at the [Adobe office](https://www.google.com/maps/place/Adobe+-+San+Francisco/@37.771136,-122.4038287,17z/). This was another great venue.

{{<customtwitter 920815956951101440>}}

We had a very solid turnout.

{{<customtwitter 920827006467502080>}}

I presented a more condensed version of the talk and received some good questions about how usage is charged, what types of events can trigger functions, and how they can be tested and deployed. There were two more serverless talks after mine that covered similar concepts leveraging [Cloud Foundry](https://www.cloudfoundry.org/) and later [Kubeless](http://kubeless.io/).

I realized what a small world it is: I gave a talk at Pivotal, the next day someone from Pivotal followed my talk at Adobe, and the third speaker demoed Kubeless using [Minio](https://minio.io/), an open source object storage platform I learned about the night before because a former Microsoft employee who now works at Minio gave a talk on it.

I’ll just let that sink in for a moment. Moving along …

You can view live recording of my presentation, along with the other two presentations, at the following link (disclaimer: it does require installing some software to view).

[SF Microservices Meetup - Oct 18, 2017](https://my.adobeconnect.com/pve9jldkwita/)
The final meetup was in beautiful Mountain View for [Microservices and Cloud Native Apps](https://www.meetup.com/microservices/events/243498016/) at the [Microsoft Silicon Valley conference center](https://www.google.com/maps/place/Microsoft/@37.3706966,-122.0459336,13z/). The room itself was large with three screens.

![Microsoft Silicon Valley Conference Room](/blog/2017-10-22_san-franciscobay-area-serverless-tour-2017/images/2.jpeg)
<figcaption>Microsoft Silicon Valley Conference Room</figcaption>

The attendees were incredibly energetic, as evidenced by my 360° photo. You may have to rotate it to see the audience.

{{<kuula 7lJ9p>}}

We had a great evening with some good questions and feedback.

{{<customtwitter 921401301992275968>}}

{{<customtwitter 921404239775129600>}}

I stayed for the presentation after mine that was focused on Kubernetes, then headed out. I had a great surprise that evening, because the Microsoft campus there is lit beautifully at night.

{{<custominstagram BadPzpUlFUr>}}

Finally, I went to bed early to wake up for a 6:35 am flight back to Atlanta. Yet another surprise was in store for me as I witnessed the sun rising over Silicon Valley.

{{<custominstagram BafDhiclXdU>}}

It was a beautiful end to a very fun trip. I appreciate my warm Silicon Valley welcome and look forward to coming back in the future! I’m excited that I was able to share the power of serverless with so many, and look forward to everyone’s feedback and success stories. As a reminder:

* The full deck and video demonstrations are available here: [Code First in the Cloud: Serverless Azure Functions](https://www.slideshare.net/jeremylikness/code-first-with-serverless-azure-functions-81068288).
* Read the full [Azure Documentation](https://docs.microsoft.com/en-us/azure/?utm_source=jeliknes&utm_medium=presentation&utm_campaign=sfotour17&WT.mc_id=sfotour17-presentation-jeliknes) online.
* Get started with [Functions for Free](https://functions.azure.com/ng-min/try?trial=true&utm_source=jeliknes&utm_medium=powerpoint&utm_campaign=sfotour2017&WT.mc_id=sfotour2017-powerpoint-jeliknes)!

Until the next time,

![Jeremy Likness](/blog/2017-10-22_san-franciscobay-area-serverless-tour-2017/images/3.gif)
