---
title: "What is a Cloud Developer Advocate?"
author: "Jeremy Likness"
date: 2017-10-01T15:05:17.157Z
years: "2017"
lastmod: 2019-06-13T10:44:02-07:00
comments: true
toc: true

description: "This post articulates what it means to be a cloud developer advocate and links to tweets, articles, podcasts, and blog posts to share several perspectives."

subtitle: "The scoop on Cloud Developer Advocates … in our own words."
tags:
 - JavaScript 
 - Cloud 
 - Developer 
 - Advocacy 
 - Microsoft 

image: "/blog/2017-10-01_what-is-a-cloud-developer-advocate/images/2.jpeg" 
images:
 - "/blog/2017-10-01_what-is-a-cloud-developer-advocate/images/1.png" 
 - "/blog/2017-10-01_what-is-a-cloud-developer-advocate/images/2.jpeg" 
 - "/blog/2017-10-01_what-is-a-cloud-developer-advocate/images/3.jpeg" 
 - "/blog/2017-10-01_what-is-a-cloud-developer-advocate/images/4.gif" 


aliases:
    - "/what-is-a-cloud-developer-advocate-f7606b5a9a08"
---

## TL;DR;

[Cloud Developer Advocates](https://aka.ms/advocates) advocate for developers to solve problems with the cloud. OK, so I’m not allowed to just flip the phrase and get away with it. No problem. We are a [globally distributed](https://developer.microsoft.com/en-us/advocates/map?utm_source=jeliknes&utm_medium=blog&utm_campaign=cda&WT.mc_id=cda-blog-jeliknes) team of engineers with diverse areas of focus ranging from Open Source Software (OSS), container technology, the Go language, Java, front-end web development, gaming, machine learning and artificial intelligence to platform-oriented groups like .NET. Our goal is to empower developers to do more with the cloud. I believe we accomplish that goal by focusing on three key areas:

1. **Community**— you’ll see us in groups both offline (whether it’s conferences, meetups, and user groups) and online (from forums to open source projects and social media outlets) meeting and collaborating with you _where you are at_.
2. **Content**— we believe in the power of _good_ documentation. We all contribute to one of the largest open source projects on GitHub, namely our own [Microsoft documentation](http://docs.microsoft.com/?utm_source=jeliknes&utm_medium=blog&utm_campaign=cda&WT.mc_id=cda-blog-jeliknes). We also author blog posts, write articles, create videos, contribute to and even create our own open source projects.
3. **Connect to Engineering** — at the end of the day, we are all engineers. We connect with developers in the field, foster strong relationships with teams at Microsoft, and work together to improve the experience of building solutions in the cloud.

That’s my take, and I’m sticking to it! Please share your own thoughts in the comments below.

![Cloud Developer Advocates](/blog/2017-10-01_what-is-a-cloud-developer-advocate/images/1.png)
Illustration: [Ashley McNamara](https://github.com/ashleymcnamara/Developer-Advocate-Bit/)

## Now for the Long Part

I recently joined several co-workers, scores of Microsoft employees and over 25,000 customers at the [Microsoft Ignite event](https://myignite.microsoft.com/?utm_source=jeliknes&utm_medium=blog&utm_campaign=cdapost&WT.mc_id=cdapost-blog-jeliknes) in Orlando. During my visit I had the opportunity to network with technology professionals and customers from around the world, assist with Hands-on Labs, connect with fellow [MVPs and RDs](https://mvp.microsoft.com/) (technically I am no longer an MVP as a Microsoft employee, but after eight years I’m still welcomed as part of the group), and explore a massive expo hall I’m confident was large enough to hold several [C-130 Hercules](https://en.wikipedia.org/wiki/Lockheed_C-130_Hercules).

![List of Cloud Developer Advocates as of October 2017](/blog/2017-10-01_what-is-a-cloud-developer-advocate/images/2.jpeg)
<figcaption>List of Cloud Developer Advocates as of October 2017</figcaption>

Our team is mostly remote so it was great to meet in person, get to know each other better and have some fun. Here we are on stage at the keynote. A “green screen” may have been involved in this picture.

![Bernd Verst, Jeremy Likness, and Aaron Wislang](/blog/2017-10-01_what-is-a-cloud-developer-advocate/images/3.jpeg)
<figcaption>Bernd Verst, Jeremy Likness, and Aaron Wislang</figcaption>

Yeah, I’m the bald “short” one in the middle.

One of the most common questions I’m asked is, “What is a cloud developer advocate?” It’s a great question. A little over one week after my own start date, an industry analyst firm published an article about this “hot streak”:

{{<customtwitter 888096965447307264>}}

Our team has been growing steadily since my start date in early July 2017, with diverse hires that continue to spark interest and speculation. Recently the public learned that high profile Linux and container expert <i class="fab fa-twitter"></i> [Jessie Frazelle](https://twitter.com/jessfraz) joined our team.

{{<customtwitter 905437789319294976>}}

This was followed by an article about how we’ve become the “destination for a new generation of open source developers”:

🔗 [How Microsoft become a destination for a new generation of open-source developers](https://www.geekwire.com/2017/microsoft-become-destination-new-generation-open-source-developers/amp/)

And, “observations on \[our\] new competence”:

🔗 [Adron's Composite Code](http://blog.adron.me/articles/the-developer-advocate-observations-of-microsofts-new-competence/)

The buzz is there, but what’s the buzz really all about?

## Getting to Know Us

Although I considered writing this article in the past, each time someone new joined they posted or interviewed and shared some insights and wisdom that I felt captured the essence of our team perfectly. In fact, so much information is out there I wrote this post to catalog and organize the content. First and foremost, I encourage you to visit our page and get to know our full team.

🔗 [Microsoft Cloud Developer Advocates](https://developer.microsoft.com/en-us/advocates/?utm_source=jeliknes&utm_medium=blog&utm_campaign=cdapost&WT.mc_id=cdapost-blog-jeliknes)

One of the first posts to go viral about our team that describes it so well was by <i class="fab fa-twitter"></i> [Ashley McNamara](https://twitter.com/ashleymcnamara).

{{<customtwitter 880509730703134720>}}

My favorite quote (she even highlights it) is:

> If your Developer Advocate doesn’t have a direct line to product managers and the ability to suggest changes based on developer/customer feedback, you’re doing it wrong.

Another very important point:

> The culture within Microsoft is changing as we speak. Linux expertise is spreading across the company and Open Source is no longer a dirty word at Microsoft.

That expertise has spread to our team, as evidenced by many of the advocates with Linux, Go, Containers, and other open source backgrounds. I learned more about how Linux works on Windows in one blog post than I had the entire year prior.

Although the industry focus and excitement has mainly been around traditionally “non-Microsoft” open source, our team is very much aligned around the more traditional Microsoft technologies like .NET and SQL Server as well. Long-time friend and fellow (former) MVP <i class="fab fa-twitter"></i> [Laurent Bugnion](https://twitter.com/LBugnion), perhaps best known for his [MVVM Light Toolkit](http://www.mvvmlight.net/), recently joined and shared his own perspective.

{{<customtwitter 892331970482638848>}}

His succinct take on what we do:

> This group is helping to redefine how we engage with developers on a big scale and be an empathetic advocate to the product engineers building the tools, services, APIs and other tech you use on a daily basis!

Enter <i class="fab fa-twitter"></i> [Cecil Phillip](https://twitter.com/cecilphillip), who also focuses on .NET:

{{<customtwitter 888148983385907200>}}

He captures it here:

> The idea of developer advocacy is something I’d become very curious about for the past year or so. It brings together a lot of what I was already doing outside of regular my work with regards to content creation, public speaking and teaching. I love that part of the industry, and you’re telling I can do that with the support of one of the most influential company in the world?? I can do this, and I can do this well.

We represent locations like New York.

{{<customtwitter 889893642349023233>}}

Countries like Canada.

{{<customtwitter 886938604341268481>}}

I love his motivation in this quote:

> Microsoft today is focused on making things better for everyone. Every time I hear Satya talk, I hear that change. Every time I meet with product teams? I see that change … Microsoft’s vision is aligned with what I believe. It’s a simple as that.

We’re even overseas in places like London.

{{<customtwitter 855043556100231168>}}

I’ve mentioned Linux, Go, and .NET, but what about Java? We are truly committed to reaching _all_ developers on _all_ platforms. Listen to <i class="fab fa-twitter"></i> [Brian Benz](http://twitter.com/bbenz) share his thoughts on a recent podcast:

🔗 [Brian Benz, Senior Developer Advocate for Microsoft](https://advancetechmedia.org/episode-006-brian-benz/)

You can also get a good sense of this openness in <i class="fab fa-twitter"></i> [Erik St. Martin](https://twitter.com/erikstmartin)’s post.

{{<customtwitter 913521961594126336>}}

He highlights …

> Our primary goal is to help the open-source community and to help make Azure a place they want to run their code, whether it be by contributing to open-source projects, creating demo applications, writing tutorials about open-source projects, hearing about and understanding the types of things developers in the communities we represent are building and the problems they face, then trying to come up with solutions.

… and clarifies:

> The advocacy actually works in reverse; we advocate to the product and documentation teams on behalf of the communities we represent. The value this adds is that we can help the product teams and documentation teams offer a better product for everyone.

By now, you should have a much better idea of what a cloud developer advocate is. To summarize, however …

## So, What IS a Cloud Developer Advocate?

I hope that hearing and reading other insights and perspectives has helped paint a better picture of who we are and what we do. I believe my friends and associates did a great job of detailing this position so I only have a little bit of my own perspective to add.

Several years ago I was ready to transition from the role I was in to something new. There were many options available to me and I had to make a decision. I realized that I hadn’t really articulated what I am passionate about or why, so I created a personal mission statement. I was surprised how easy it and simple it turned out.

> My personal mission is to empower developers to be their best.

I’ve used that simple statement to determine the positions I’ve interviewed for and drive my day-to-day decisions since I created it. To me, this team is the penultimate realization of my mission. I still remember when I applied what feels like ages ago and was asked, “Why do you want to be a cloud developer advocate?”

My answer was to reiterate my mission statement and share that I can’t think of a better way to have a broader impact or ability to empower developers than through this role at Microsoft.

At the end of the day, you only have to reverse our title to understand what we do.

> We **advocate** for **developers** with a focus on the **cloud**.

Please don’t confuse what we do with traditional evangelism. Evangelism is about conversion. We advocate, and advocating is about support. Our goal is to support developers in the field regardless of what platform or language they use. This is why it shouldn’t be a surprise to find us at places like the Google Developer Group in Atlanta.

🔗 [Google Developer Group Atlanta: Serverless Node.js Functions](/google-developer-group-atlanta-serverless-node-js-functions-2ec8d987a4b1)

We support you by doing things like:

* Ensuring you have the [best possible documentation](https://docs.microsoft.com/en-us/azure/?utm_source=jeliknes&utm_medium=presentation&utm_campaign=atlcodecamp&WT.mc_id=atlcodecamp-presentation-jeliknes) available
* Sharing our knowledge with you at [user groups and conferences](/upcoming-talks-eaf27ff8a3a7)
* Learning from you at user groups and conferences
* Writing blog posts and articles about topics we believe will help you accomplish more
* Connecting with you over social media
* Volunteering at events like Ignite
* Taking your feedback back to the product teams who can make a difference
* Listening and growing, every day

More importantly, we are part of a bigger vision to reach individuals across the globe. I’m excited and confident you’ll see and learn more about efforts by our team to mentor students, support women in technology, advocate for diversity and inclusion for developers around the globe and champion causes that have the potential to transform the world. After all, we are but a small part of a larger company with a even larger mission.

> **Microsoft**’**s** **mission** is to empower every person and every organization on the planet to achieve more.

We’re here to help catalyze that mission and I encourage you to challenge us to keep the bar high. We do promise to have a little fun along the way!

{{<customtwitter 913561384717373441>}}
<figcaption>Cloud Developer Advocates: Paige Bailey, Christina Warren, Jeremy Likness, Bernd Verst and Damian Brady</figcaption>

I was only able to share a few of many tweets, posts, pictures and stories so please don’t hesitate to visit the official [Cloud Developer Advocates](https://developer.microsoft.com/en-us/advocates/?utm_source=jeliknes&utm_medium=blog&utm_campaign=cdapost&WT.mc_id=cdapost-blog-jeliknes) page to learn more about _all_ of us.

Let me know what you think and how I can help.

_Your_ advocate,

![Jeremy Likness](/blog/2017-10-01_what-is-a-cloud-developer-advocate/images/4.gif)
