---
title: "Connect.Tech 2017: Node.js and TypeScript"
author: "Jeremy Likness"
date: 2017-09-22T12:01:49.515Z
years: "2017"
lastmod: 2019-06-13T10:44:01-07:00
comments: true

description: "Introduction to Node.js, how to deploy Node.js apps to Azure and connect to CosmosDB, the benefits of TypeScript and how TypeScript works with Node.js projects."

subtitle: "Recap of my full day Node.js workshop and TypeScript for Node.js talk at Connect.Tech 2017."
tags:
 - Nodejs 
 - Presentation 
 - Typescript 
 - Azure 
 - JavaScript 

image: "/blog/2017-09-22_connect.tech-2017-node.js-and-typescript/images/1.jpeg" 
images:
 - "/blog/2017-09-22_connect.tech-2017-node.js-and-typescript/images/1.jpeg" 
 - "/blog/2017-09-22_connect.tech-2017-node.js-and-typescript/images/2.gif" 


aliases:
    - "/connect-tech-2017-node-js-and-typescript-8419b0e4d689"
---

This year [Connect.Tech](http://connect-js.com/) was incredible, as always, and I had the privilege of presenting twice. The first day, Wednesday, September 20th, 2017, I presented a workshop focused on Node.js development.

![Getting Ready for the Introduction to Node.js Workshop](/blog/2017-09-22_connect.tech-2017-node.js-and-typescript/images/1.jpeg)
<figcaption>Getting Ready for the Introduction to Node.js Workshop</figcaption>

This is a workshop that starts with the basics then quickly evolves to cover real-time communication, Azure deployments and cloud-based document database storage using [CosmosDB](/explore-the-cosmos-db-with-net-core-2-0-aab48423dcdc). I had a very enthusiastic and attentive group with diverse backgrounds who asked great questions and gave me lots of feedback. You can follow the workshop yourself by downloading the GitHub repository here:

{{<github "JeremyLikness/NodeCamp">}}

The workshop is divided into six phases. Each phase has a [Reveal.js](https://github.com/hakimel/reveal.js/) presentation and a subfolder that contains markdown instructions for the labs, code snippets to help out with the labs, and in most cases a before/after project structure so you can see what to expect. The markdown files contain mixed markdown and HTML, so I recommend [this Chrome extension](https://chrome.google.com/webstore/detail/markdown-viewer/ckkdlimhmcjmikdlpkmbgfkaikojcbjk) to make it easier to view.

The segments include:

* Introduction to Node.js
* Introduction to Express
* Building the Backend
* Creating the UI
* Connecting the Frontend to the Backend
* Deploying to the Cloud

Be sure to check the option to enable access to local files so you can simply double-click on the file to read it.

Learn more about: [Azure for Node.js](https://docs.microsoft.com/en-us/azure/developer/javascript/?view=azure-node-latest&utm_source=jeliknes&utm_medium=presentation&utm_campaign=connecttech2017&WT.mc_id=connecttech2017-presentation-jeliknes&viewFallbackFrom=azure-node-2.0.0).

## TypeScript for Node.js

The second session on Thursday, September 21st, 2017 was a presentation about TypeScript for Node.js. This talk focuses on the benefits TypeScript provides while adhering to the JavaScript specification and enabling all of the native functionality you want. The room was full and everyone had fun participating in a 360 ° photo.

{{<kuula 7lvsz>}}
<figcaption>TypeScript for Node.js at Connect.Tech 2017</figcaption>

I was happy to see <i class="fab fa-twitter"></i> [David Neal](https://twitter.com/reverentgeek) in the audience, but had no idea he was taking “visual notes” of the presentation. These were cool. How is the likeness of Likness?

{{<customtwitter 910931932778778624>}}

Wow! What an honor! I was a little rushed at the end of the presentation and didn’t get to do a full demonstration of creating a TypeScript for Node.js presentation “from scratch,” so I recorded this short video:

{{<youtube 7pvk_zflkwU>}}
<figcaption>Create your first Node.js with TypeScript Project</figcaption>

The completed project, examples that I demonstrated, and Reveal.js presentation are all available here:

{{<github "JeremyLikness/typescript-for-node">}}

I even included some easy-to-use snippets for building the sample project. I really enjoyed my time at the event and appreciate everyone who helped make it happen, including the volunteers, organizers, sponsors, speakers, and of course attendees. Thanks, everyone!

![Jeremy Likness](/blog/2017-09-22_connect.tech-2017-node.js-and-typescript/images/2.gif)
