---
title: "Reflecting on 15 Years of Blogging"
author: "Jeremy Likness"
date: 2017-08-20T14:26:14.747Z
years: "2017"
lastmod: 2019-06-13T10:43:35-07:00
comments: true
toc: true

description: "Jeremy Likness reflects on his personal history of blogging for over 15 years, shares why he moved to medium, and stats from over 8 years of his old blog."

subtitle: "Jeremy shares a personal history of blogging and stats on his legacy C#er : IMage blog after moving to Medium as a new platform."
tags:
 - Tech 
 - Blog 
 - Blogger 

image: "/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/10.png" 
images:
 - "/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/1.png" 
 - "/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/2.png" 
 - "/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/3.png" 
 - "/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/4.png" 
 - "/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/5.png" 
 - "/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/6.png" 
 - "/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/7.png" 
 - "/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/8.png" 
 - "/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/9.png" 
 - "/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/10.png" 
 - "/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/11.png" 
 - "/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/12.png" 
 - "/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/13.png" 
 - "/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/14.png" 
 - "/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/15.png" 
 - "/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/16.png" 
 - "/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/17.png" 
 - "/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/18.gif" 


aliases:
    - "/reflecting-on-15-years-of-blogging-dc008ee71053"
---

Recently I decided to make a major change. After over one million user visits, I decided to retire the technology blog I maintained for almost nine years. [C#er: IMage](http://csharperimage.jeremylikness.com) will live on as an archive, but moving forward things will change. I’m not quitting blogging, but I _am_ changing the medium (see what I did there?) that I use to blog. One decision everyone must make when moving to a new blog platform is whether to migrate their old content or start fresh. I decided to start fresh.

## TL;DR;

I’ve moved to Medium for blogging. My old blog, C#er : IMage will remain online as an archive. If you have some time and a fresh cup of coffee, you can read on about why I moved my blog, why I didn’t migrate my old blog, how many horrible designs I came up with for my old blogs over 15 years and at the end you will be rewarded with amazing charts and graphs detailing the demographics and behavior of the 600,000+ unique visitors I’ve been blessed to reach over the years.

This feels like the perfect time to transition, considering the recent change in my life.

{{<customtwitter 884522810663510017>}}

It’s been over a month since I started, and it _still_ seems surreal!

## Why Move

There are several reasons I made the decision to move my blog.

### Tired Design

The old blog has a clean, simple design. And a tired one. I switched to the current format in 2015. I often share with people that I am aesthetically challenged. I’ve wanted to update my template and even invest in someone with the skills to do it for me for some time, but [Blogger](https://blogger.com) is an old engine and doesn’t have the support other, more modern, engines do. I frankly was tired of not being satisfied with my own look and feel. Here’s a snapshot for posterity. Isn’t the sample post cool?

![C#er : IMage circa 2015](/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/1.png)
<figcaption>C#er : IMage circa 2015</figcaption>

### Complicated URL

There is no way I can convince anyone to remember a blog with as long a name as “see sharper image dot jeremy likness dot com.” It’s difficult enough for developers to learn how to spell and pronounce my last name correctly. If you’re wondering, the correct way to pronounce it is “lickness”. Hey, [it’s Norwegian](https://en.wikipedia.org/wiki/Liknes). Some immigration agent over a century ago at Ellis Island spelled it wrong. It usually helps people remember when I tell them “lickness” without the “c” rather than “likeness” without the “e.”

{{<gmap "https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d8381.598197866766!2d6.949622251611749!3d58.31918680106871!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x4639d10073b0e4b1%3A0x4f7cd8f70a37a376!2s4480+Liknes%2C+Norway!5e0!3m2!1sen!2sus!4v1561671088780!5m2!1sen!2sus">}}

### No SSL

The current engine doesn’t support it. I kind of need it. Some browsers are going to scare users when they visit sites without it, and I can’t reach you if you’re scared. Don’t worry. This new blog has the reassuring lock right there in your address bar. We’re covered.

> Update: SSL is now supported, and is enforced.

### Poor Name Choice

At the time, naming it after my language of choice and making a play on the word “IMage” as an “interface to mage” (hey, I bet some of you didn’t catch that, did you?) seemed like a cool geeky thing to do. “Come here for C# magic.”

Now that I’m older and wiser, I realize that I enjoy dozens of languages. It is a little awkward to ask someone to visit a C# blog to read about TypeScript. Fortunately, I’m fairly confident the brand I built resonates more around the content than the name of the blog.

## Why Medium

So why did I turn to Medium? (And keep the theme now that I'm on Hugo).

### Fresh Look

I mean, check this out. This right here. What you’re reading. I like the look and feel and the best part is that I didn’t even have to deal with [CSS](https://www.w3.org/Style/CSS/specs.en.html). It’s all taken care of for me. I like that. A lot. Plus it automatically looks great on mobile and there is even [an app for it](https://play.google.com/store/apps/details?id=com.medium.reader&hl=en). What’s that? You have one of _those_? Well, no worries. There is also [an app for you](https://itunes.apple.com/us/app/medium/id828256236).

### Less Effort

Did I mention I didn’t have to deal with CSS? Not only does Medium have a phenomenal online interface that is easy and intuitive, it also makes embedding links a breeze. They use a tool called [Embedly](http://embed.ly/) and it supports just about everything, including this cool 360° photo I took at the Vatican:

{{<kuula 7lmLC>}}

Seriously, videos and tweets are all fair game. It “just works” for me!

### Simpler Name and URL

I’ve never had a clever “handle” or nickname to use, so my brand has always been around my name. Therefore, what URL is easier to remember than, well, my “blog” and “blog dot my name dot com.”? I changed the name to Developer for Life. It doesn’t tie me to a language, technology, or platform and reflects my passion that has been consistent since the [Space Shuttle Colombia](https://en.wikipedia.org/wiki/Space_Shuttle_Columbia) was first launched into space. (It wasn’t the launch that got me into programming, but I’m guessing more people remember the shuttle launch than the fact I started writing code then). I’ve developed most of my life and plan to be developing for a lot longer. Even after people start saying, “Remember when we used to have write code instead of just telling the computer what we want it to do?”

### Preserve the Old

Medium has an awesome [import tool](https://medium.com/p/import). I used it for a few key articles and can bring old content forward from the old website as needed.

## Why Not Migrate

I know. Migrating would be the cool thing. I can even export my blog, process it through a widget that will auto-update URLs and permalinks and make it magic. I could use a static blog generator and stand up my own cloud-based site like all of the cool kids do. I thought about it. I really did. But sometimes, it’s time to move on. I believe that time is now.

I joined Microsoft as a Cloud Developer Advocate to realize a personal mission statement I created several years ago: to empower developers to be their best. As part of that mission, I want to shake off the old “[here’s how to hack JavaScript in IE 6.0](http://csharperimage.jeremylikness.com/2009/05/jquery-ie6-and-could-not-set-selected.html)” articles and start new. There’s some good news: the majority of traffic to my old blog articles comes from organic search and lands on old content I’m not longer interested in. The newer articles are mostly driven by social media, so pointing people to the new blog will not be a challenge.

## A Look Back: A Brief History of Blogs

No, not _all_ blogs. Just _my_ blogs.

I was introduced to the Internet in 1993. In 2000, two major events transformed my life. My daughter, who now runs her own [much more interesting and well-designed blog](https://wanderingthegap.com/), was born. The second event? I lost a ton a weight. Well, not a ton. But a lot. I even wrote a book about it:

📕 [Lose Fat, Not Faith: A Transformation Guide](http://amzn.to/2fVUBeT)

Losing weight made me realize I could probably accomplish a lot of things I told myself not to bother with before. I was afraid of public speaking and didn’t think my writing would be worthy of anyone reading it, and shedding the weight gave me the confidence to reconsider those self-sabotaging thoughts.

Although I worked full-time as a “software engineer” as we loved to call ourselves back then, I started a side business to help others lose weight. I learned through my own struggles that weight loss isn’t about a diet or exercise plan, but about the right mindset. When your mind is made up, there are a lot of different plans that will work, but if it’s not, nothing will work.

My side business was an Internet-based coaching practice. I developed the software for the website (if you’re curious, I started with ASP and VBScript but ended up on PHP), but as you can see, even then I desperately needed a good designer.

![Peak Physiques, an online business in 2001](/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/2.png)
<figcaption>Peak Physiques, an online business in 2001</figcaption>

The business was moderately successful and I used cutting edge methods to reach my audience. Things like _email_, _podcasts_, and even writing my own macros to generate _PDF documents_. Are you impressed yet? About 140 million people used the Internet from the United States in 2001, compared to over twice that number today. However, in 2001 there were “only” 30 million websites compared to over a billion today. Those were good odds.

My very first blog started sometime between the launch of Peak Physiques and 2003. Apparently I thought people would think me throwing up angry shirtless pictures and describing my workouts _ad nauseam_ was interesting.

![The Weight Loss Vault in 2003](/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/3.png)
<figcaption>The Weight Loss Vault in 2003</figcaption>

I’m not sure if someone gave me feedback or I just changed my mind, but the next blog took an entirely different turn. I don’t know what I was thinking other than perhaps it would be easier to read if the blog looked like ink on weathered parchment. Of course you can’t help but get drawn in by the awesome shiny “Rich Site Summary” logo. Developers back then just _knew_ that XML was going to solve _everything_!

![Golden Summit Inc. blog in 2006](/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/4.png)
<figcaption>Golden Summit Inc. blog in 2006</figcaption>

“Golden Summit Incorporated” was the parent company for my website properties. I left the corporate IT world to focus on my business full-time a few years after launching Peak Physiques. The name was taken by another business, so I changed it to _Natural_ Physiques to emphasize my focus on whole foods and mindset over supplements. My wife and I decided that I could run an online business from anywhere, so why not move to the Black Hills of South Dakota?

🖼 [View from Harney Peak Summit](https://1drv.ms/i/s!ApayHNtRQ5bgiKwpD94isuww5GMUGg)

The town we moved to, Lead, was just a stone’s throw from Deadwood, the city that was made [famous by HBO](http://www.hbo.com/deadwood/). Lead wasn’t named for pencils, but rather a leading edge of quartz, or “lead,” that marks potential gold finds. Lead was the site of the [Homestake Mine](https://en.wikipedia.org/wiki/Homestake_Mine_%28South_Dakota%29) that closed shortly before we moved there. The house we lived in was over 100 years old and most of the deeds back then described properties based on their location relative to well-known mining shafts. Ours was located near the Golden Summit shaft, and that’s how my first corporation got its name.

Around 2008 I finally broke down and paid a designer to update my site. I thought they did well (stop judging, this was _lit_ for 2008):

![The Natural Physiques “Road to Ultra” blog circa 2008](/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/5.png)
<figcaption>The Natural Physiques “Road to Ultra” blog circa 2008</figcaption>

My blog at the time was called “The Road to Ultra” because I had the crazy idea I was going to train for and run an ultramarathon. I’m still crazy, just not about that idea anymore. A year later I accepted the opportunity to go all-in with a well known entrepreneur to start a new business back in Atlanta, so I sold my fitness properties and jumped into start-up mode. That marked my return to a technology-focused career, but what I learned as an entrepreneur, business owner, coach and motivational speaker permanently transformed how I approached the development universe.

In 2009 I decided the problems I was solving at the startup were important enough to share with and help other developers, so I launched C#er : IMage.

![One of the first C#er : IMage posts in 2009](/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/6.png)
<figcaption>One of the first C#er : IMage posts in 2009</figcaption>

I’m fairly certain there are easier ways to find an integer in JavaScript, but that was a fun blog post anyway. By the way, can I just mention that the “Unity Framework” in the description probably isn’t what you think it is? If you’re curious, just ask. Many of you remember it, before people associated the name with game development.

Five years at a startup was rough on my family and me, so I decided to make a lifestyle change and left the startup to go into consulting. The business grew from three employees including me to somewhere between 60 and 80 by the time I left. It also happened to sell for 1.5 billion a few years later. I think we were on to something!

My new career in consulting resulted in a slight re-brand of the blog. I desperately wanted to prove just how inept I am at design.

![C#er : IMage in 2010](/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/7.png)
<figcaption>C#er : IMage in 2010</figcaption>

You know you just can’t resist clicking on that left-side slider tab to reveal my mind-blowing tweets, like the one I used to introduce the object-oriented database I wrote for Silverlight and Windows Phone apps:

{{<customtwitter 17600489674>}}

I wrote a bit more about Sterling in my blog:

{{<relativelink "blog/2017-04-05_celebrating-twenty-years-of-open-source">}}
 
An [MCTS certification](https://www.microsoft.com/en-us/learning/mcts-certification.aspx), [Microsoft MVP award](https://mvp.microsoft.com/), and XBox avatar all conspired to participate in a new blog banner I made in 2011.

![C#er : IMage in 2011](/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/8.png)
<figcaption>C#er : IMage in 2011</figcaption>

It turned out that Silverlight wasn’t the answer to [life, the universe, and everything](https://en.wikipedia.org/wiki/Life,_the_Universe_and_Everything) so the web moved on to HTML5 while JavaScript gained momentum. I felt so guilty writing front-end code on a C# branded blog that I decided the header needed some JavaScript unit testing code a la [Jasmine](https://jasmine.github.io/).

![C#er : IMage with a JavaScript (Jasmine) Test in 2014](/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/9.png)
<figcaption>C#er : IMage with a JavaScript (Jasmine) Test in 2014</figcaption>

At the company I worked for before Microsoft I had the opportunity to build an application development practice and grow a team of developers. It was a great, rewarding experience with a phenomenal group of people. Only a few years later, however, that I noticed something strange happening on the Internet. It started with this:

{{<customtwitter 832706103343341569>}}

… and was followed by myriad similar proclamations. The following tweet not only became incredibly popular and famous, but also explained the position so well I just point people here when they ask what I do.

{{<customtwitter 880509730703134720>}}

I knew something special was happening, but ironically my first thought was, “good for them, that looks exciting.” That’s when I received an email from a Microsoft recruiter. The rest, as they say, was history. I’m not quite sure who “they” are, but they seem to show up often.

Someday over beers, cider, or seltzer water, I’ll share with you the story about the process I went through that involved global flights, jet lag and fortune cookies. Seriously. Right now, however, this post has gone long and I want to get into my massive retrospective and share some raw facts before this jumps the shark.

## The Raw Facts

Let’s cut to the chase. Enough about me (OK, I know I waited a long time to say that), what about you? Here’s what I know.

![C#er : IMage All-time Statistics](/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/10.png)
<figcaption>C#er : IMage All-time Statistics</figcaption>

There is no doubt that Silverlight is the topic that drove my blog’s popularity. The largest spike of sessions in one day came from an article I wrote about my (incorrect) opinion on the [future of Silverlight and HTML5](http://csharperimage.jeremylikness.com/2010/10/so-whats-fuss-about-silverlight.html). It sparked heated debates and comments. It turns out I was too focused on the technology and what it could do, as opposed to understanding the nuances of politics and the reality of economics.

The next surge came from a post that attempted to dispel widespread confusion over [the differences between versions of Windows 8 and the chips (Intel vs. ARM)](http://csharperimage.jeremylikness.com/2012/12/the-mixed-bag-of-windows-8-chips.html) that supported it. The last large spike was for a series I wrote detailed the [Top 5 Mistakes AngularJS Developers Make](http://csharperimage.jeremylikness.com/2014/11/the-top-5-mistakes-angularjs-developers.html). That was about the previous version of Angular, by the way.

Before I get to the posts you liked to read, let me share a bit more about where the 664,634 visitors came from over several years. Readers browsed my blog from around the world:

![Location of C#er : IMage Readers](/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/11.png)
<figcaption>Location of C#er : IMage Readers</figcaption>

![Readers by Country](/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/12.png)
<figcaption>Readers by Country</figcaption>

For the first half of my blog’s lifespan, more people used Internet Explorer than any other browser, with Firefox trailing behind at a distant second place. That quickly changed over the past few years and resulted in this breakdown for all time:

![Readers by Browser](/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/13.png)
<figcaption>Readers by Browser</figcaption>

As you can see, Chrome took the lion’s share by far.

The vast majority of visitors came to the site via search engines. My RSS feed accounted for what I believe were the majority of my repeat visitors, followed by activity on forums and article sites. I also had a lot of promotion from the consulting company I worked at for several years. Twitter made the top ten sources of traffic.

![Top Sources of Traffic](/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/14.png)
<figcaption>Top Sources of Traffic</figcaption>

I built my fitness business through an aggressive campaign of syndication, and at the time fitness articles were hard to come by. Literally dozens of sites jumped at the opportunity to publish my content with a link back to my site. This resulted in massive organic search engine traffic and allowed me to generate a steady revenue stream through both sales and advertising on my site.

The same strategy didn’t drive nearly as much traffic in the technology world, but it is interesting to see the sites most referrals came from.

![Website Referrals](/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/15.png)
<figcaption>Website Referrals</figcaption>

Forum activity drove a substantial amount of traffic, as did Twitter. Having a <i class="fab fa-github"></i> [popular open source framework](https://github.com/JeremyLikness/Jounce) didn’t hurt. The next list focuses specifically on social media:

![Social Media Referrals](/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/16.png)
<figcaption>Social Media Referrals</figcaption>

The 80/20 rule informs me that staying active on [StackOverflow] (https://stackoverflow.com/users/228918/jeremy-likness) and continuing to <i class="fab fa-twitter"></i> [tweet](https://twitter.com/jeremylikness)are both good strategies to drive traffic, no?

Last but not least, here are the top ten articles of all time by views:

![Top 10 Articles Read (All Time)](/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/17.png)
<figcaption>Top 10 Articles Read (All Time)</figcaption>

Of course, the home page takes first place. Or does it?

* An article I wrote in 2010 to [explain the Model-View-ViewModel pattern](http://csharperimage.jeremylikness.com/2010/04/model-view-viewmodel-mvvm-explained.html) has three times more views than the next read article and exceeds even the home page in hits (it is shown as two articles because after some time I got smart and changed the title to put the blog name last instead of first). It was heavily syndicated and linked to and appeared high in search results for people looking to understand what the heck MVVM is.
* 🅰 Angular is a framework I gravitated to because it embraces the same patterns like dependency injection, test-driven development, and data-binding I feel made Silverlight successful. It’s no coincidence that my Angular articles were extremely popular as well compared to other topics.
* Many of my heavily read articles attempt to simplify the explanation of patterns like dependency injection and MVVM. This is the case with the MVVM, PRISM, and MEF articles you see listed ([PRISM](https://msdn.microsoft.com/en-us/library/gg406140.aspx)is a prescriptive framework for building certain types of apps).
* The Windows 8 Icons article was a fluke in my opinion. It was a short post that explained how to browse a font to pull icons out for apps. It turns out that “windows 8 icons” was an extremely popular search phrase and often listed my post on the first page of organic search results. It’s also one of my shortest blog posts.Wow. That was fun. I’m amazed you’re still reading this. If you even are. Are you? I feel like I can write some random gibberish right here, like:

> _Ash nazg durbatulûk, ash nazg gimbatul,  
> Ash nazg thrakatulûk agh burzum-ishi krimpatul._

… and most of you won’t even read it. If you do, drop a note in the comments. I suspect if you were willing and patient enough to read this far, there’s probably a good chance you know that wasn’t gibberish and can name where it came from and even what the English translation is.

## What’s Next

As much as I love the look and feel of the new blog, it lacks a decent avatar and header. I’m working with some artists to figure out how to remedy that and hope to update the site soon. As always, however, my primary focus is content and creating posts, articles, and videos to make your life easier. I will continue to do so, and promise not to wrote too many posts in the future that are this long. It’s an exciting time to be a developer and I’m thankful for the opportunity to share my thoughts with you and continue to follow my dream to empower developers to be their best. After all, code is a large part of who I am and how I live today.

![Jeremy Likness](/blog/2017-08-20_reflecting-on-15-years-of-blogging/images/18.gif)
