---
title: "Presentations Archive"
author: "Jeremy Likness"
date: 2017-08-17T16:03:00.620Z
years: "2017"
lastmod: 2019-06-13T10:43:31-07:00
toc: false

description: "This article contains descriptions of presentations Jeremy Likness gave in the past, including any videos and links to assets such as decks and source code."

subtitle: "Comprehensive list of presentations by Jeremy Likness with links to decks, videos, and source code."
tags:
 - JavaScript 
 - Presentation 

image: "/blog/2017-08-17_presentations-archive/images/1.jpeg" 
images:
 - "/blog/2017-08-17_presentations-archive/images/1.jpeg" 
 - "/blog/2017-08-17_presentations-archive/images/2.jpeg" 

aliases:
    - "/past-presentations-3aa8fe97cf31"
    - "/past-presentations/home"
---

I’ve been delivering technical presentations for a decade now. My passion is empowering developers to be their best and speaking around the world is one way I’ve been able to connect. This article contains descriptions and links to videos of presentations I’ve done in the past, including assets such as decks and source code. Please don’t hesitate to contact me if you are interested in me speaking at your event. The easiest way is to [direct message me on Twitter](https://twitter.com/jeremylikness). I accept DMs even if I’m not following you back yet.

🗣 [View my papercall.io profile](https://www.papercall.io/speakers/jeremylikness)

🗣 [View my sessionize profile](https://sessionize.com/jeremylikness)

🎥 [Watch recorded presentations on YouTube](https://www.youtube.com/playlist?list=PL1VfiVM16kp-sQ3D3XDLopmScoaOQibFb) | [Channel 9 Shows](https://channel9.msdn.com/niners/jeremylikness)

🔎 [Read Presentation Recaps and Trip Reports](/tags/presentation)

![Image of Jeremy Giving a Talk](/blog/2017-08-17_presentations-archive/images/1.jpeg)

## MSHOWTO | .NET for Apache Spark w/ Jeremy Likness

_Virtual (December 11, 2020)_

{{<youtube D0-03zBaiOM>}}

## Orlando .NET User Group | What's New in EF Core 5.0

_Virtual (December 10, 2020)_

{{<youtube noavrHvdlqs>}}

## .NET Conf 2020 | The Missing Piece - Diving into the World of Big Data with .NET for Apache Spark

_Virtual (November 13, 2020)_

{{<youtube wRN6ExbW7kA>}}

## .NET Conf 2020 | Entity Framework Core: The Next Generation for Data Access

_Virtual (November 12, 2020)_

{{<youtube BIImyq8qaD4>}}

## Atlanta .NET User Group 2020

_Virtual (October 26, 2020)_

* [EF Core Queries from Blazor WebAssembly](https://www.meetup.com/Atlanta-Net-User-Group/events/273639506/)

{{<youtube GE8_E8-KxBY>}}

## &lt;TDevConf/>

_Virtual (October 3, 2020)_

* [Inside IQueryable: The Power of .NET Expressions](https://github.com/jeremylikness/iqueryableexpressionexamples)

## DevNexus 2020

_Atlanta, GA (February 20 - 21, 2020)_

{{<customtwitter 1231985226106036224>}}

{{<customtwitter 1230626891121467393>}}

## Azure in the ATL 2020

_Alpharetta, GA (February 19, 2020)_

* Stateful Serverless Workflows with Durable Functions

## Microsoft Ignite | The Tour London

_London, UK (January 16 - 17, 2020)_

* Enhancing Web Applications with Cloud Intelligence
* Debugging and Interacting with Cloud Applications in Production

## Nottingham IoT Nottingham, United Kingdom

_Nottingham, UK (January 15, 2020)_ 

[Nottingham IoT](https://www.meetup.com/Nottingham-IoT-Meetup/)

* [WebAssembly and WASI: One Platform to Rule Them All](https://www.meetup.com/Nottingham-IoT-Meetup/events/266776343/)

{{<customtwitter 1217555471994933249>}}

## .NET Conf "Focus on Blazor" Webinar

_January 14, 2020_

* [State Management in Blazor Apps](https://www.youtube.com/watch?v=zjlUstW7ISU)

{{<youtube zjlUstW7ISU>}}

## Tech Webinar Nepal (Series 12)

_December 29, 2019_

* [Blazor: .NET in your Browser](https://www.youtube.com/watch?v=glU0SOfHEag)

{{<youtube glU0SOfHEag>}}

## Microsoft Ignite 2019

_Orlando, FL (November 4 - 8, 2019)_

* Introduction to Azure Tools and Utilities

## GLUGNet User Group

_Lansing, MI (October 17, 2019)_

* The Durable Dungeon: Stateful Serverless Workflows

## VS Live! Chicago 2019

_Chicago, IL (October 7-10, 2019)_

* WebAssembly: Your Browser is the OS
* What's new with Bootstrap 4

## VS Live! San Diego 2019

_San Diego, CA (October 1-3, 2019)_

* WebAssembly: Your Browser is the OS
* Advanced Stateful Workflows with Durable Functions

{{<customtwitter 1179774010101391360>}}

## .NET Conf 2019

_Redmond, WA (September 23, 2019)_

* Lightning Talk: Durable Functions

{{<customtwitter 1176198208407498753>}}

## THAT Conference 2019

_Wisconsin Dells, WI (August 6, 2019)_

* WebAssembly: The Swiss Army Knife of Browser Apps 

{{<customtwitter 1158861556526080008>}}

## .NET Developers Association (Eastside and Westside) 2019

_Redmond, WA (July 1, 2019)_

* Bare Metal Web Assembly

    ⬇[Download presentation deck](https://jlikme.blob.core.windows.net/presentations/Likness-WebAssembly-BareMetal.pptx)

## NDC Oslo 2019

_Oslo, Norway (June 17-21, 2019)_

<i class="fab fa-twitter"></i> [Twitter highlights](https://twitter.com/i/moments/1141302379285045249)

* Advanced Serverless Workflows with Durable Functions
    {{<customtwitter 1141390186250739717>}}

Watch the related article (includes full video of presentation):

{{<relativelink "/blog/stateful-serverless-long-running-workflows-with-durable-functions">}}

## Refactr.Tech 2019

_Atlanta, GA (Jun 7-8, 2019)_

* WebAssembly: Your Browser is the New OS
    {{<customtwitter 1137041533625032704>}}

## Microsoft Ignite | The Tour 2018-2019

I had the opportunity to travel to several cities, including Toronto, Johannesburg, Hong Kong, Amsterdam, and Mumbai. I presented two sessions at each stop.

### Designing Resilient Cloud Applications

{{<youtube iEjdmG9cNH4>}}

### Investing in Serverless: Less Servers, More Code

{{<youtube NZYSID8snjI>}}

## Inaugural .NET South Conference 2019  

_Atlanta, GA (May 13–14, 2019)_

<i class="fab fa-twitter"></i> [Twitter Highlights](https://twitter.com/i/moments/1129119097461985280)

{{<relativelink "/blog/2019-05-16_managing-data-in-the-cloud-">}}

* .NET is now your Browser OS With Blazor
    
    <i class="fab fa-vimeo"></i> [Watch Presentation](https://www.recallact.com/presentation/net-now-your-browser-os-blazor)
    
    {{<customtwitter 1128366868966793216>}}


## CodeStock 2019  

_Knoxville, TN (April 12–13, 2019)_

* Keynote
    {{<customtwitter 1116706599807139840>}}
    {{<customtwitter 1116698835588399106>}}
* WebAssembly: The Browser _is_ Your OS (with Blazor)
    {{<customtwitter 1117068673003544577>}}

## DEVIntersection and Microsoft Azure and AI Conference 2018

_Las Vegas, CA (December 3–7, 2018)_

* What’s New with ASP.NET Core
* Enterprise Serverless
* Say “Yes” to NoSQL for the .NET SQL Developer 

## DevReach 2019 

_Sofia, Bulgaria (November 13-14, 2018)_

* Enterprise Serverless
    {{<customtwitter 1062682236506509313>}}
* (Hitch) Hiker's Guide to the Cosmos (DB)
    {{<customtwitter 1062324380938702848>}}

## Connect.Tech 2018

_Atlanta, GA (October 18-19, 2018)_

* TypeScript from JavaScript
    {{<customtwitter 1053360382826360832>}}
* The Three D's of Modern Web Development
    {{<customtwitter 1052937597058613248>}}
    View the video of this presentation: [<i class="fab fa-vimeo"></i> https://vimeo.com/303443966](https://vimeo.com/303443966)

## Azure in the ATL October 2018

_Atlanta, GA (October 16, 2018)_

* A Lap Around Azure Storage
    {{<customtwitter 1052381006022541312>}}

## Angular Air episode: Angular on .NET

{{<youtube ipEC6aDGJeM>}}

## TechBash 2018

_Pocono Manor, PA (October 3 - 5, 2018)_

* 🔗 [Enterprise Serverless](https://blog.jeremylikness.com/enterprise-serverless-acc826616d4c)
* 🔗 [Say “Yes” to NoSQL for .NET SQL Developers](https://blog.jeremylikness.com/say-yes-to-nosql-for-net-sql-developers-74391f785133)

## Visual Studio Live! Chicago 2018

_Chicago, IL (September 17-20, 2018)_

Delivered two sessions: Event Grid and overview of Azure Serverless

## Atlanta Code Camp 2018

_Atlanta, GA (September 15, 2018)_

{{<customtwitter 1040943070827700225>}}

* Atlanta Code Camp 2018 Keynote: [https://twitter.com/i/moments/1040961613099089921](https://twitter.com/i/moments/1040961613099089921)

## .NET Conference 2018

_(September 12, 2018)_

* Serverless .NET from Surface Book to Azure Cloud
    {{<customtwitter 1039930388942966784>}}

## ngHouston Meetup

🔗 [Get Started with Angular on .NET Core 2.1 (Part One)](https://blog.jeremylikness.com/get-started-with-angular-on-net-core-2-1-part-one-2effcfe8fae9)

## THAT Conference 2018

_Wisconsin Dells, WI (August 8, 2018)_

* (Hitch) Hiker's Guide to the Cosmos (DB)
    {{<customtwitter 1027185811555536896>}}

## Kansas City Developer Conference (KCDC)

_Kansas City, MO (July 12, 2018)_

* Cloud Native Azure Cosmos DB for NoSQL at Scale
    {{<customtwitter 1017603515450118146>}}

## WeRise Women in Tech Conference 2018 

_Atlanta, GA_

🔗 [Hack Your Career: WeRise](https://blog.jeremylikness.com/hack-your-career-werise-7595277c6bb9)

### Google Developer’s Group Atlanta Meetup

_Atlanta, GA_

🔗 [Docker Containers and Orchestration](https://www.meetup.com/gdg-atlanta/events/250791821/)

{{<customtwitter 1009256118588239872>}}

### Music City Code 2018

_Nashville, TN (June 2, 2018)_

{{<customtwitter 1003010769703833601>}}

### //Build 2018

_Seattle, WA (May 7-9, 2018)_

* [NoSQL and Azure Cosmos DB in 20 Minutes](https://blog.jeremylikness.com/nosql-and-azure-cosmos-db-in-20-minutes-9d0c3e0279dc)
* [Connect Anything to Everything: Event Grid at Build 2018](https://blog.jeremylikness.com/connect-anything-to-everything-event-grid-at-build-2018-963b9001a3db)

## Microsoft Tech Summit Poland 2018

_Warsaw, Poland (April 29, 2018)_

{{<customtwitter 990661206020009985>}}

## DotNext Piter 2018

_St. Petersburg, Russia (April 22-23, 2018)_

🔗 [DotNext Piter 2018 Recap](https://blog.jeremylikness.com/dotnext-piter-2018-recap-91fbd02c67fa)

## My JavaScript Story

🔗 [MJS 052: Jeremy Likness | Devchat.tv](https://devchat.tv/my-javascript-story/mjs-052-jeremy-likness)

## DevIntersection Orlando 2018

_Orlando, FL (March 27, 2018)_

{{<customtwitter 978661365647904771>}}

## Tech Summit Switzerland 2018

_Zurich, Switzerland (February 2018)_

🔗 [Tech Summit Switzerland 2018 Higlights](https://twitter.com/i/moments/969571614617632768)

## Azure Zurich User Group

_Zurich, Switzerland (February 28, 2018)_

{{<customtwitter 968773402617171968>}}

## DevNexus 2018

_Atlanta, GA_

🔗 [Docker Management and Kubernetes Orchestration](https://blog.jeremylikness.com/docker-management-and-kubernetes-orchestration-2b7baf60a704)

## Azure in the ATL 2018

_Atlanta, GA_

🔗 [Azure Event Grid: Glue for the Internet](https://blog.jeremylikness.com/azure-event-grid-glue-for-the-internet-e770d94cc29)

## South Florida Code Camp 2018

_Davies, FL_

🔗 [Serverless in South Florida](https://blog.jeremylikness.com/serverless-in-south-florida-2fdc8147d3df)

## Atlanta JavaScript User Group January 2018

_Atlanta, GA_

🔗 [Presentation: Introduction to TypeScript](https://blog.jeremylikness.com/presentation-introduction-to-typescript-a655df16c8e6)

## PASS Summit 2017

_Seattle, WA_

{{<github "JeremyLikness/PASS-2017">}}

## Bay Area Serverless Tour 2017

🔗 [The San Francisco/Bay Area Serverless Tour 2017](https://blog.jeremylikness.com/the-san-francisco-bay-area-serverless-tour-2017-9883b43aa9f3)

## Women who Code

🔗 [Interview: Women Tech Talk with Alicia Carr](https://blog.jeremylikness.com/interview-women-tech-talk-with-alicia-carr-df189fa6659a)

## Microsoft Community Connections

_Charlotte, NC_

🔗 [Microsoft Community Connections Charlotte 2017](https://blog.jeremylikness.com/microsoft-community-connections-charlotte-2017-54e30eb4a43e)

## Connect.Tech 2017

_Atlanta, GA_

🔗 [Connect.Tech 2017: Node.js and TypeScript](https://blog.jeremylikness.com/connect-tech-2017-node-js-and-typescript-8419b0e4d689)

## Google Developer User Group Atlanta

_Atlanta, GA_

🔗 [Google Developer Group Atlanta: Serverless Node.js Functions](https://blog.jeremylikness.com/google-developer-group-atlanta-serverless-node-js-functions-2ec8d987a4b1)

## .NET Rocks Podcast

🔗 [.NET Rocks: Migrating to .NET Core 2.0](https://blog.jeremylikness.com/net-rocks-migrating-to-net-core-2-0-72203276a698)

## Atlanta Code Camp 2017

_Atlanta, GA_

🔗 [Atlanta Code Camp 2017: Serverless .NET](https://blog.jeremylikness.com/atlanta-code-camp-2017-serverless-net-da640edd59e9)

## JavaScript Jabber

🔗 [Web Apps on Linux: JavaScript Jabber](https://blog.jeremylikness.com/web-apps-on-linux-javascript-jabber-84da7d62cc6)

## Atlanta Docker User Group

_Atlanta, GA_

🔗 [Herding Cattle with the Azure Container Service (ACS)](https://blog.jeremylikness.com/herding-cattle-with-the-azure-container-service-acs-e329e7def93e)

## Music City Code 2017

_Nashville, TN_

🔗 [Music City Code 2017](https://blog.jeremylikness.com/music-city-code-2017-e78e6279a60b)

## WeRise.Tech 2017

_Saturday, June 24th, 2017 — Atlanta, GA_

🔗 [We Rise Women in Technology](https://werise.tech/) 

{{<github "JeremyLikness/docker-we-rise" "Code, Deck, and Step-by-Step Instructions">}}

## Code Career Academy

_Thursday, March 23rd, 2017 — Lawrenceville, GA_

* TypeScript: JavaScript's Safety Harness

{{<github "jeremylikness/typescript-cca" "Code and Deck">}}

## Gwinnett Georgia Microsoft User Group (GGMUG)

_Thursday, March 9th, 2017 — Lawrenceville, GA_

* Contain your Excitement: Docker for Developers

## DevNexus

_Wednesday, February 22, 2017 — Atlanta, GA (Georgia World Congress Center)_

* Angular (2.X) and TypeScript Workshop

{{<github "jeremylikness/ng2ts-workshop-v2" "Full Workshop, Projects, and Deck">}}

## Atlanta Code Camp 2016

_Saturday, October 15, 2016 — Marietta, GA (Kennesaw State University Marietta Campus)_

* Upgrading Angular.js to Angular 2.x apps
    {{<github "jeremylikness/ATLCodeCamp2016" "Deck and Code">}}
* Cross-platform Angular 2 with TypeScript Development
    {{<github "jeremylikness/ATLCodeCamp2016" "Deck and Code">}}

## Microsoft Ignite 2016

_Sunday, September 25, 2016 — Atlanta, GA (Georgia World Congress Center)_

* DevOps Hackathon
    {{<github "oguzpastirmaci/ignite-2016-hackathon">}}

## Microsoft DevOps Container Camp

_Wednesday, August 25, 2016 — Alpharetta, GA (Microsoft Technology Center)_

{{<github "tripdubroot/ContainerCamp">}}

## Macon .NET User Group

_Thursday, July 21, 2016 — Macon, GA_

* TypeScript for Enterprise Scale JavaScript Apps

👀 [View the deck](http://www.slideshare.net/jeremylikness/typescript-for-enterprise-scale-javascript-apps)

## Atlanta Angular.js Meetup

_Wednesday, July 20, 2016 — Atlanta, GA_

* Back to the ngFuture

👀 [View the deck, live examples, and source](http://csharperimage.jeremylikness.com/2016/07/back-to-ngfuture.html)

## CodeStock 2016

_July 15-16, 2016 — Knoxville, GA_

* Cross-platform Development with Angular 2 and TypeScript

    👀 [View the deck](http://www.slideshare.net/jeremylikness/cross-platform-angular-2-and-typescript-development)
* Cross-platform Agile DevOps with Visual Studio Team Services

## Atlanta JavaScript Meetup

_Monday, May 16, 2016 — Atlanta, GA_

* The Angular 2 CLI and TypeScript

{{<youtube 8GX5gKiLLfU>}}

## //Build recap

_Monday, April 4, 2016 — Alpharetta, GA_

## Atlanta .NET User Group

_Monday, January 25, 2016 — Alpharetta, GA_

* Angular 2.0 and TypeScript

## Atlanta Angular.js Meetup January 2016

_January 21, 2016 — Atlanta, GA_

* Angle Forward with TypeScript

    👀 [View the Deck](http://www.slideshare.net/jeremylikness/angle-forward-with-typescript)

## Telerik Next 2015

_May 4, 2015 — Boston, MA_

* C.R.U.D. with ASP.NET MVC, Web API, Entity Framework and Kendo UI

{{<youtube zxlqN6CDfrU>}}

* Kendo UI and Angular.js

{{<youtube fWB38DYbLM0>}}

## Webinar: Single Page Apps (SPA): Your Browser is the OS

_March 25, 2015_

{{<github "JeremyLikness/SPAAppsExplained">}}

<i class="fab fa-vimeo"></i>[Watch the Video](https://vimeo.com/123883668)

## Gwinnett Microsoft .NET User Group Meetup

_March 13, 2015 — Lawrenceville, GA_

* C# async/await Explained

{{<github "JeremyLikness/AsyncAwaitExplained">}}

## Microsoft Virtual Academy

_February 4, 2015 — Redmond, WA_

* Web API Design 

{{<github "MicrosoftLearning/WebAPIDesign">}}

* 👀 [View the Course on Channel 9](https://channel9.msdn.com/Series/Web-API-Design)
  * [Introduction](https://channel9.msdn.com/Series/Web-API-Design/01)
  * [Basic Design](https://channel9.msdn.com/Series/Web-API-Design/02)
  * [Configuration](https://channel9.msdn.com/Series/Web-API-Design/03)
  * [Validation and Error Handling](https://channel9.msdn.com/Series/Web-API-Design/04)
  * [Security](https://channel9.msdn.com/Series/Web-API-Design/05)
  * [Advanced Design](https://channel9.msdn.com/Series/Web-API-Design/06)

## Atlanta JavaScript Meetup October 2014

_October 20, 2014 — Atlanta, GA_

* Angular.js from a Different Angle

{{<youtube l-Vm4q4ioBw>}}

## Atlanta Code Camp 2014

_October 11, 2014 — Marietta, GA_

* Angular Health App

    {{<github "JeremyLikness/AngularHealthApp">}}

## Webinar: ALM with TFS: From the Drawing Board to the Cloud

_September 17, 2014 — Atlanta, GA_

## DevLink 2014

_August 27, 2014 — Chattanooga, TN_

* Advanced Angular.js Tips and Tricks

    {{<github "JeremyLikness/AngularTipsAndTricks">}}

* Learn Zone.js

    {{<github "JeremyLiknes/learnzonejs">}}

## CodeStock 2014

_July 11, 2014 — Knoxville, TN_

* Thread Local Storage Execution Contexts in JavaScript with Zone.js

    {{<github "jeremylikness/zonejs">}}

## Re//Build

_May 24, 2014 — Alpharetta, GA_

* What's New with Win.js 

    👀 [interactive slide presentation](http://jeremylikness.github.io/RebuildWinJSWeb/default.html) written in WinJS.

## LinkedIn .NET User Group (LIDNUG)

_May 22, 2014_

* Enterprise TypeScript

{{<youtube UspdjzPyOB4>}}

## Atlanta .NET User Group April 2014

_April 7, 2014 — Alpharetta, GA_

* Windows 8.1 Sockets

    👀 [View the Deck](https://www.slideshare.net/jeremylikness/windows-81-sockets)

## Chattanooga .NET User Group December 2013

_December 10, 2013 — Chattanooga, TN_

* The Windows Runtime and the Web

    👀 [View the Deck](https://www.slideshare.net/jeremylikness/likness-win-rt-and-the-web)

## Gwinnett Georgia Microsoft User Group (GGMUG) October 2013

_October 10, 2013 — Lawrenceville, GA_

* My XML is Alive! An Intro to XAML

    👀 [View the Deck](https://www.slideshare.net/jeremylikness/ggmug-likness-my-xml-is-alive-intro-to-xaml)

## DevLink 2013 

_August 30, 2013 — Chattanooga, TN_

* WinRT and the Web (Keeping Windows Store Apps Alive and Connected)

    👀 [View the Deck](http://www.slideshare.net/jeremylikness/winrt-and-the-web-keeping-windows-store-apps-alive-and-connected)

* Angular.js and TypeScript for Modern Web App Development

    👀 [View the Deck](http://www.slideshare.net/jeremylikness/dev-link-likness-angularjs-and-typescript)

## Gwinnett Georgia Microsoft User Group (GGMUG) January 2013

_January 10, 2013 — Lawrenceville, GA_

* Introduction to TypeScript

    👀 [View the Slide Deck](http://www.slideshare.net/jeremylikness/introduction-to-typescript)

## DevScovery 2012 

_October 3, 2012_ — _Houston, TX_  

* Enterprise JavaScript (OxyMoron?)

    👀 [View the Slide Deck Part 1](http://www.slideshare.net/jeremylikness/wintellect-devscovery-enterprise-javascript-development-1-of-2)  

    👀 [View the Slide Deck Part 2](http://www.slideshare.net/jeremylikness/wintellect-devscovery-enterprise-javascript-development-2-of-2)

* The Portable Class Library (PCL): Building Tomorrow's Applications, Today

    👀 [View the Slide Deck](http://www.slideshare.net/jeremylikness/wintellect-devscovery-portable-class-library)

## DevLink 2012 

_August 30, 2012_ — _Chattanooga, TN_

* Windows 8 for the Silverlight and WPF Developer

    👀 [View the Slide Deck](http://www.slideshare.net/jeremylikness/wintellect-windows-8-for-the-silverlight-and-wpf-developer-jeremy-likness)

## LinkedIn .NET User Group (LIDNUG) July 2012

_July 18, 2012_

* Windows 8: A Tale of Two Stacks

{{<youtube rgCAgotLdGA>}}

## LinkedIn .NET User Group (LIDNUG) June 2012

_June 20, 2012_

* The Top 11 Features Windows 8 Metro Developers will Love

{{<youtube -30y-2gZhfo>}}

## CodeStock 2012

_June 15, 2012 — Knoxville, TN_

* MVVM for Modern Application Development

## Atlanta XAML Meetup January 2012

_January 18, 2012_ — _Atlanta, GA_

* Designing Silverlight Business Applications

## Atlanta .NET User Group September 2011

_September 26, 2011 —_ _Alpharetta, GA_

* //Build recap

## DevLink 2011 

_August 17, 2011 — Chattanooga, TN_

* Sterling for Windows Phone 7

## ReMix South 2011

_August 6, 2011_ — _Atlanta, GA_

* Tablet Development with Silverlight

## Microsoft Worldwide Partner Conference (WPC) 2011

_July 13, 2011_ — _Los Angeles, CA_

* The Consumerization of IT

## CodeStock 2011

_June 3, 2011_ — _Knoxville, TN_

* Silverlight 5 for Line of Business Applications

{{<youtube QWELU7v5GxA>}}

## MSDN GeekSpeak 2011

_April 20, 2011_

* Project Sterling

## Atlanta Silverlight Meetup February 2011

_February 23, 2011_ — _Atlanta, GA_

* Introduction to MEF for Silverlight 

## Atlanta Silverlight Meetup January 2011

_January 31, 2011 — Alpharetta, GA_

* Silverlight's Visual State Manager

## PDC Recap 2010

_October 29, 2010 — Alpharetta, GA_

* Ask the Experts Q&A

## LinkedIn .NET User Group (LIDNUG) October 2010

_October 20, 2010_

* Isolated Storage for Object-oriented Databases in Silverlight and Windows Phone 7 Applications

## Atlanta Silverlight Meetup September 2010

_September 22, 2010 — Atlanta, GA_

* Intro to MVVM

## Gwinnett .NET User Group (GGMUG) August 2010

_August 12, 2010 — Duluth, GA_

* MVVM and MEF for Silverlight

## MSDN Fridays July 2010

_July 20, 2010_

* MEF for LOB Applications in .NET 4.0

## CodeStock 2010

_June 25, 2010 — Knoxville, TN_

* Advanced Silverlight Applications using the Managed Extensibility Framework

## Atlanta .NET User Group June 2010

_June 7, 2010 — Alpharetta, GA_

* The Managed Extensibility Framework for Line of Business Applications in .NET 4.0

## MSDN GeekSpeak February 2010

_February 25, 2010_

* Silverlight Unit Testing Framework

    👀 [View Interview](https://channel9.msdn.com/shows/geekSpeak/geekSpeak-Recording-Silverlight-Testing-with-Jeremy-Likness/)

## Atlanta Silverlight User Group January 2010

_January 20, 2010 — Atlanta, GA_

* Silverlight Business Applications

## Gwinnett Georgia .NET User Group January 2010

_January 19, 2010 — Duluth, GA_

* Managed Extensibility Framework