---
title: "The Three D’s of Modern Web Development"
author: "Jeremy Likness"
date: 2018-11-29T00:00:00.000Z
years: "2018"
lastmod: 2019-06-13T10:43:12-07:00
comments: true

description: "Learn the history of and decompose modern JavaScript frameworks like Angular, React, and Vue by learning about dependency injection, declarative syntax, and data-binding."

subtitle: "You know what the popular SPA frameworks are, this series explains why."
tags:
 - JavaScript 
 - Typescript 
 - Angular 
 - React 
 - Vuejs 

image: "/blog/2016-04-24_three-ds-of-modern-web-development/images/1.png" 
images:
 - "/blog/2016-04-24_three-ds-of-modern-web-development/images/1.png" 
 - "/blog/2016-04-24_three-ds-of-modern-web-development/images/2.gif" 


aliases:
    - "/the-three-ds-of-modern-web-development-55d69fe048da"
---

Modern web development using JavaScript has evolved over the past decade to embrace patterns and good practices that are implemented through various libraries and frameworks. Although it is easy to get caught up in the excitement of frameworks like 🅰 [Angular](https://angular.io), it is important to remember the fundamental patterns and repeatable practices that make development easier. In fact, it is difficult to make a qualified decision about your development stack without understanding “how” and “why” a particular tool, library, or framework may benefit the application and, more importantly, your team.

![Three D's of Modern Web Dev](/blog/2016-04-24_three-ds-of-modern-web-development/images/1.png)

In 2018, I gave a presentation based on these principles. 

<i class="fab fa-vimeo"></i> [Click here to view the full presentation on Vimeo](https://vimeo.com/303443966).

I recently authored a series of articles for the former “Telerik Developer Network” that covers what I believe are three fundamental concepts that have revolutionized modern web app development.

You can read the series here:

1. [Declarative vs. Imperative](http://developer.telerik.com/featured/three-ds-of-web-development-1-declarative-vs-imperative/)
2. [Data-Binding](http://developer.telerik.com/featured/three-ds-of-web-development-data-binding/)
3. [Dependency Injection](http://developer.telerik.com/featured/three-ds-web-development-3-dependency-injection/)

The three D’s are just a few of the reasons why JavaScript development drives so many consumer and enterprise experiences today. Although the main point of this series was to demonstrate the maturity of front-end development and the reason why JavaScript development at enterprise scale is both relevant and feasible today, it is also the answer to a question I often receive. “Why use Angular 2 and TypeScript?” My answer is this: together, Angular and TypeScript provide a modern, fast, and practical implementation of the three D’s of modern web development.

Regards,

![Jeremy Likness](/blog/2016-04-24_three-ds-of-modern-web-development/images/2.gif)