
package com.android.tools.build.bundletool.commands;

import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_CommandHelp_FlagDescription extends CommandHelp.FlagDescription {

  private final String flagName;
  private final boolean optional;
  private final String description;
  private final Optional<String> exampleValue;

  private AutoValue_CommandHelp_FlagDescription(
      String flagName,
      boolean optional,
      String description,
      Optional<String> exampleValue) {
    this.flagName = flagName;
    this.optional = optional;
    this.description = description;
    this.exampleValue = exampleValue;
  }

  @Override
  String getFlagName() {
    return flagName;
  }

  @Override
  boolean isOptional() {
    return optional;
  }

  @Override
  String getDescription() {
    return description;
  }

  @Override
  Optional<String> getExampleValue() {
    return exampleValue;
  }

  @Override
  public String toString() {
    return "FlagDescription{"
        + "flagName=" + flagName + ", "
        + "optional=" + optional + ", "
        + "description=" + description + ", "
        + "exampleValue=" + exampleValue
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CommandHelp.FlagDescription) {
      CommandHelp.FlagDescription that = (CommandHelp.FlagDescription) o;
      return (this.flagName.equals(that.getFlagName()))
           && (this.optional == that.isOptional())
           && (this.description.equals(that.getDescription()))
           && (this.exampleValue.equals(that.getExampleValue()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.flagName.hashCode();
    h *= 1000003;
    h ^= this.optional ? 1231 : 1237;
    h *= 1000003;
    h ^= this.description.hashCode();
    h *= 1000003;
    h ^= this.exampleValue.hashCode();
    return h;
  }

  static final class Builder extends CommandHelp.FlagDescription.Builder {
    private String flagName;
    private Boolean optional;
    private String description;
    private Optional<String> exampleValue = Optional.empty();
    Builder() {
    }
    @Override
    CommandHelp.FlagDescription.Builder setFlagName(String flagName) {
      if (flagName == null) {
        throw new NullPointerException("Null flagName");
      }
      this.flagName = flagName;
      return this;
    }
    @Override
    CommandHelp.FlagDescription.Builder setOptional(boolean optional) {
      this.optional = optional;
      return this;
    }
    @Override
    CommandHelp.FlagDescription.Builder setDescription(String description) {
      if (description == null) {
        throw new NullPointerException("Null description");
      }
      this.description = description;
      return this;
    }
    @Override
    CommandHelp.FlagDescription.Builder setExampleValue(String exampleValue) {
      if (exampleValue == null) {
        throw new NullPointerException("Null exampleValue");
      }
      this.exampleValue = Optional.of(exampleValue);
      return this;
    }
    @Override
    CommandHelp.FlagDescription build() {
      String missing = "";
      if (this.flagName == null) {
        missing += " flagName";
      }
      if (this.optional == null) {
        missing += " optional";
      }
      if (this.description == null) {
        missing += " description";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_CommandHelp_FlagDescription(
          this.flagName,
          this.optional,
          this.description,
          this.exampleValue);
    }
  }

}
