﻿// Copyright (c) 2019 Javier Cañon 
// https://www.javiercanon.com 
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
using System.IO;
using System.Reflection;

namespace SO.SalesDemo.Model {
    public static class ModelAssemblyHelper {
        static Assembly modelAssembly = null;
        public static Assembly ModelAssembly {
            get {
                if(modelAssembly == null)
                    modelAssembly = typeof(ModelAssemblyHelper).Assembly;
                return modelAssembly;
            }
        }
        static string[] resourceNames = null;
        public static string GetResourcePath(string resourceName) {
            if(resourceNames == null)
                resourceNames = ModelAssembly.GetManifestResourceNames();
            foreach(string name in resourceNames)
                if(name.EndsWith(resourceName))
                    return name;
            return null;
        }
        public static Stream GetResourceStream(string resourceName) {
            return ModelAssembly.GetManifestResourceStream(GetResourcePath(resourceName));
        }
    }
}
