CREATE TABLE `{$tableName}`  (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '{\"mode\":\"auto\"}',
  `title` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '{\"type\":\"text\"}',
  `content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '{\"type\":\"editor\",\"required\":false}',
  `attachment` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '{\"type\":\"attachment\",\"required\":false,\"has_upload\":true,\"extra\":{\"partner\":\"content\"}}',
  `order` int(11) NULL DEFAULT 0 COMMENT '{\"mode\":\"manual\",\"required\":false,\"format\":\"int\"}',
  `time` datetime NULL DEFAULT NULL COMMENT '{\"type\":\"datetime\",\"format\":\"datetime\",\"hidden\":[\"add\"]}',
  `lang` tinyint(4) NULL DEFAULT 0 COMMENT '{\"mode\":\"manual\",\"required\":false,\"format\":\"int\"}',
  `published` tinyint(4) NULL DEFAULT 0 COMMENT '{\"type\":\"switch\",\"required\":false,\"format\":\"int\"}',
  `deleted` tinyint(4) NULL DEFAULT 0 COMMENT '{\"mode\":\"manual\",\"required\":false,\"format\":\"int\"}',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `a_delete`(`deleted`, `lang`, `published`) USING BTREE,
  INDEX `a_time`(`time`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = DYNAMIC;