<?php
namespace Jtbc;
use Jtbc\Jtbc\Codename;
use Jtbc\Jtbc\JtbcReader;
use Jtbc\Jtbc\JtbcWriter;
use Jtbc\Exception\ErrorException;
use Jtbc\Exception\ErrorCollector;
use App\Common\Form\FieldTextGenerator;
use App\Console\Common\BasicSubstance;
use App\Console\Common\Ambassador;
use App\Console\Common\Traits\Action;
use App\Console\Log\Logger;
use App\Universal\Upload\UploadedStatus;

class Diplomat extends Ambassador {
  use Action\Typical\Upload;

  public function edit()
  {
    $bs = new BasicSubstance($this);
    $lang = $this -> guard -> role -> getLang();
    $attachmentFieldText = new Substance(FieldTextGenerator::generate('attachment'));
    $bs -> data -> data = JSON::decode(Jtbc::take('index.content', 'lng', false, null, Env::getLanguageByID($lang)));
    $bs -> data -> attachmentFieldText = strval($attachmentFieldText -> text);
    return $bs -> toJSON();
  }

  public function actionEdit(Request $req)
  {
    $code = 0;
    $message = '';
    $ss = new Substance();
    $lang = $this -> guard -> role -> getLang();
    $reqContent = strval($req -> post('content'));
    $reqAttachment = strval($req -> post('attachment'));
    if ($this -> guard -> role -> checkPermission('edit'))
    {
      $hookResult = $this -> hook -> beforeAutoSave -> spark($req, 'edit');
      if (is_null($hookResult))
      {
        $associatedId = $lang;
        $genre = $this -> getParam('genre');
        $language = Env::getLanguageByID($lang);
        $codename = new Codename('index.content', 'lng');
        $filePath = $codename -> getFilepath();
        if (!JtbcReader::hasField($filePath, $language))
        {
          $language = JtbcReader::getDefaultNodeName(strval(JtbcReader::getConfigure($filePath, 'field')));
        }
        if (Validation::isEmpty($language))
        {
          $code = 4444;
        }
        else
        {
          $wroteStatus = JtbcWriter::putNodeContent($filePath, 'lng', 'content', JSON::encode(['content' => $reqContent, 'attachment' => $reqAttachment]), $language);
          if ($wroteStatus === true)
          {
            $code = 1;
            $message = Jtbc::take('::communal.save-done', 'lng');
            $this -> hook -> afterAutoSave -> trigger($associatedId, 'edit');
            Logger::log($this, '::communal.log-edit', ['id' => $associatedId]);
            UploadedStatus::reset($genre, $associatedId);
            UploadedStatus::update($genre, $associatedId, $reqAttachment);
          }
          else
          {
            $code = 4444;
          }
        }
      }
      else
      {
        if ($hookResult instanceof ErrorCollector)
        {
          $code = $hookResult -> firstCode;
          $message = $hookResult -> firstMessage;
          $ss -> errorTips = $hookResult -> error;
        }
        else
        {
          throw new ErrorException('Return value must be an instanceof of ErrorCollector', 50405);
        }
      }
    }
    else
    {
      $code = 4403;
      $message = Jtbc::take('::communal.text-tips-error-4403', 'lng');
    }
    $ss -> code = $code;
    $ss -> message = Jtbc::take($this -> getParam('basename') . '.text-edit-code-' . $code, 'lng') ?: $message;
    $result = $ss -> toJSON();
    return $result;
  }
}