import { Sheet } from "../pages/WhiteBoardPage"
import { inferChord } from "./helper"

const jingoBellSheet: Sheet = {
    title: "Jingo Bell",
    key: "G",
    mode: 0,
    lastEdit:(new Date()).toString(),
    bars: [
        {
            totalBeats: 4,
            beats: [
                {
                    chord: inferChord("Gmaj7").chord,
                    chordDisplay: inferChord("Gmaj7").chordDisplay,
                    duration: 4,
                    lyrics: "Dashing through the",
                }
            ]
        },
        {
            totalBeats: 4,
            beats: [
                {
                    chord: undefined,
                    chordDisplay: inferChord("").chordDisplay,
                    duration: 3,
                    lyrics: "snow,",
                },
                {
                    chord: inferChord("D7#5").chord,
                    chordDisplay: inferChord("D7#5").chordDisplay,
                    duration: 1,
                    lyrics: "in a",
                }
            ]
        },
        {
            totalBeats: 4,
            beats: [
                {
                    chord: inferChord("Gmaj7").chord,
                    chordDisplay: inferChord("Gmaj7").chordDisplay,
                    duration: 2,
                    lyrics: "one horse",
                },
                {
                    chord: inferChord("Dm7").chord,
                    chordDisplay: inferChord("Dm7").chordDisplay,
                    duration: 1,
                    lyrics: "o -",
                },
                {
                    chord: inferChord("Db9#11").chord,
                    chordDisplay: inferChord("Db9#11").chordDisplay,
                    duration: 1,
                    lyrics: "pen",
                }
            ]
        },
        {
            totalBeats: 4,
            beats: [
                {
                    chord: inferChord("Cmaj7").chord,
                    chordDisplay: inferChord("Cmaj7").chordDisplay,
                    duration: 3,
                    lyrics: "sleigh,",
                },
                {
                    chord: undefined,
                    chordDisplay: inferChord("").chordDisplay,
                    duration: 1,
                    lyrics: "and",
                }
            ]
        }, {
            totalBeats: 4,
            beats: [
                {
                    chord: inferChord("Am7").chord,
                    chordDisplay: inferChord("Am7").chordDisplay,
                    duration: 4,
                    lyrics: "o'er the fields we",
                }
            ]
        }, {
            totalBeats: 4,
            beats: [
                {
                    chord: inferChord("D7").chord,
                    chordDisplay: inferChord("D7").chordDisplay,
                    duration: 4,
                    lyrics: "go",
                }
            ]
        }, {
            totalBeats: 4,
            beats: [
                {
                    chord: inferChord("Am7").chord,
                    chordDisplay: inferChord("Am7").chordDisplay,
                    duration: 2,
                    lyrics: "laughing",
                },
                {
                    chord: inferChord("D7").chord,
                    chordDisplay: inferChord("D7").chordDisplay,
                    duration: 2,
                    lyrics: "all the",
                }
            ]
        }, {
            totalBeats: 4,
            beats: [
                {
                    chord: inferChord("Gmaj7").chord,
                    chordDisplay: inferChord("Gmaj7").chordDisplay,
                    duration: 3,
                    lyrics: "way.",
                },
                {
                    chord: inferChord("D7#5").chord,
                    chordDisplay: inferChord("D7#5").chordDisplay,
                    duration: 1,
                    lyrics: "",
                }
            ]
        }, {
            totalBeats: 4,
            beats: [
                {
                    chord: inferChord("Gmaj7").chord,
                    chordDisplay: inferChord("Gmaj7").chordDisplay,
                    duration: 4,
                    lyrics: "Bells on bobtail",
                }
            ]
        }, {
            totalBeats: 4,
            beats: [
                {
                    chord: undefined,
                    chordDisplay: inferChord("").chordDisplay,
                    duration: 3,
                    lyrics: "ring,",
                },
                {
                    chord: inferChord("D7#5").chord,
                    chordDisplay: inferChord("D7#5").chordDisplay,
                    duration: 1,
                    lyrics: "",
                }
            ]
        }, {
            totalBeats: 4,
            beats: [
                {
                    chord: inferChord("Gmaj7").chord,
                    chordDisplay: inferChord("Gmaj7").chordDisplay,
                    duration: 2,
                    lyrics: "making",
                },
                {
                    chord: inferChord("Dm7").chord,
                    chordDisplay: inferChord("Dm7").chordDisplay,
                    duration: 1,
                    lyrics: "spi -",
                },
                {
                    chord: inferChord("Db9#11").chord,
                    chordDisplay: inferChord("Db9#11").chordDisplay,
                    duration: 1,
                    lyrics: "rits",
                }
            ]
        },
        {
            totalBeats: 4,
            beats: [
                {
                    chord: inferChord("Cmaj7").chord,
                    chordDisplay: inferChord("Cmaj7").chordDisplay,
                    duration: 3,
                    lyrics: "bright,",
                },
                {
                    chord: undefined,
                    chordDisplay: inferChord("").chordDisplay,
                    duration: 1,
                    lyrics: "What",
                }
            ]
        }, {
            totalBeats: 4,
            beats: [
                {
                    chord: inferChord("Am7").chord,
                    chordDisplay: inferChord("Am7").chordDisplay,
                    duration: 2,
                    lyrics: "fun it",
                },
                {
                    chord: inferChord("D7").chord,
                    chordDisplay: inferChord("D7").chordDisplay,
                    duration: 2,
                    lyrics: "is to",
                }
            ]
        }, {
            totalBeats: 4,
            beats: [
                {
                    chord: inferChord("Am7").chord,
                    chordDisplay: inferChord("Am7").chordDisplay,
                    duration: 2,
                    lyrics: "ride and",
                },
                {
                    chord: inferChord("E7").chord,
                    chordDisplay: inferChord("E7").chordDisplay,
                    duration: 2,
                    lyrics: "sing a",
                }
            ]
        }, {
            totalBeats: 4,
            beats: [
                {
                    chord: inferChord("Am7").chord,
                    chordDisplay: inferChord("Am7").chordDisplay,
                    duration: 2,
                    lyrics: "sleighing",
                },
                {
                    chord: inferChord("D7").chord,
                    chordDisplay: inferChord("D7").chordDisplay,
                    duration: 2,
                    lyrics: "song to",
                }
            ]
        }, {
            totalBeats: 4,
            beats: [
                {
                    chord: inferChord("G6").chord,
                    chordDisplay: inferChord("G6").chordDisplay,
                    duration: 2,
                    lyrics: "night!",
                },
                {
                    chord: inferChord("D7#5").chord,
                    chordDisplay: inferChord("D7#5").chordDisplay,
                    duration: 2,
                    lyrics: "",
                }
            ]
        }, {
            totalBeats: 4,
            beats: [
                {
                    chord: inferChord("Gmaj7").chord,
                    chordDisplay: inferChord("Gmaj7").chordDisplay,
                    duration: 2,
                    lyrics: "Jingle",
                },
                {
                    chord: inferChord("G6").chord,
                    chordDisplay: inferChord("G6").chordDisplay,
                    duration: 2,
                    lyrics: "bells,",
                }
            ]
        }, {
            totalBeats: 4,
            beats: [
                {
                    chord: inferChord("Gmaj7").chord,
                    chordDisplay: inferChord("Gmaj7").chordDisplay,
                    duration: 2,
                    lyrics: "jingle",
                },
                {
                    chord: inferChord("G6").chord,
                    chordDisplay: inferChord("G6").chordDisplay,
                    duration: 2,
                    lyrics: "bells,",
                }
            ]
        }, {
            totalBeats: 4,
            beats: [
                {
                    chord: inferChord("Gmaj7").chord,
                    chordDisplay: inferChord("Gmaj7").chordDisplay,
                    duration: 2,
                    lyrics: "jingle",
                },
                {
                    chord: inferChord("G6").chord,
                    chordDisplay: inferChord("G6").chordDisplay,
                    duration: 2,
                    lyrics: "all the",
                }
            ]
        }, {
            totalBeats: 4,
            beats: [
                {
                    chord: inferChord("Gmaj7").chord,
                    chordDisplay: inferChord("Gmaj7").chordDisplay,
                    duration: 2,
                    lyrics: "way.",
                },
                {
                    chord: inferChord("G7").chord,
                    chordDisplay: inferChord("G7").chordDisplay,
                    duration: 2,
                    lyrics: "",
                }
            ]
        }, {
            totalBeats: 4,
            beats: [
                {
                    chord: inferChord("C6").chord,
                    chordDisplay: inferChord("C6").chordDisplay,
                    duration: 4,
                    lyrics: "Oh, what fun it",
                }
            ]
        }, {
            totalBeats: 4,
            beats: [
                {
                    chord: inferChord("Cdim/Gb").chord,
                    chordDisplay: inferChord("Cdim/Gb").chordDisplay,
                    duration: 1,
                    lyrics: "is",
                },
                {
                    chord: inferChord("Gmaj7").chord,
                    chordDisplay: inferChord("Gmaj7").chordDisplay,
                    duration: 1,
                    lyrics: "to",
                },
                {
                    chord: inferChord("Em7").chord,
                    chordDisplay: inferChord("Em7").chordDisplay,
                    duration: 2,
                    lyrics: "ride in a",
                }
            ]
        }, {
            totalBeats: 4,
            beats: [
                {
                    chord: inferChord("A7").chord,
                    chordDisplay: inferChord("A7").chordDisplay,
                    duration: 4,
                    lyrics: "one horse open",
                }
            ]
        }, {
            totalBeats: 4,
            beats: [
                {
                    chord: inferChord("D7").chord,
                    chordDisplay: inferChord("D7").chordDisplay,
                    duration: 2,
                    lyrics: "sleigh!",
                },
                {
                    chord: inferChord("D7#5").chord,
                    chordDisplay: inferChord("D7#5").chordDisplay,
                    duration: 2,
                    lyrics: "",
                }
            ]
        }, {
            totalBeats: 4,
            beats: [
                {
                    chord: inferChord("Gmaj7").chord,
                    chordDisplay: inferChord("Gmaj7").chordDisplay,
                    duration: 2,
                    lyrics: "Jingle",
                },
                {
                    chord: inferChord("G6").chord,
                    chordDisplay: inferChord("G6").chordDisplay,
                    duration: 2,
                    lyrics: "bells,",
                }
            ]
        }, {
            totalBeats: 4,
            beats: [
                {
                    chord: inferChord("Gmaj7").chord,
                    chordDisplay: inferChord("Gmaj7").chordDisplay,
                    duration: 2,
                    lyrics: "jingle",
                },
                {
                    chord: inferChord("G6").chord,
                    chordDisplay: inferChord("G6").chordDisplay,
                    duration: 2,
                    lyrics: "bells,",
                }
            ]
        }, {
            totalBeats: 4,
            beats: [
                {
                    chord: inferChord("Gmaj7").chord,
                    chordDisplay: inferChord("Gmaj7").chordDisplay,
                    duration: 2,
                    lyrics: "jingle",
                },
                {
                    chord: inferChord("G6").chord,
                    chordDisplay: inferChord("G6").chordDisplay,
                    duration: 2,
                    lyrics: "all the",
                }
            ]
        }, {
            totalBeats: 4,
            beats: [
                {
                    chord: inferChord("Gmaj7").chord,
                    chordDisplay: inferChord("Gmaj7").chordDisplay,
                    duration: 2,
                    lyrics: "way.",
                },
                {
                    chord: inferChord("G7").chord,
                    chordDisplay: inferChord("G7").chordDisplay,
                    duration: 2,
                    lyrics: "",
                }
            ]
        }, {
            totalBeats: 4,
            beats: [
                {
                    chord: inferChord("C6").chord,
                    chordDisplay: inferChord("C6").chordDisplay,
                    duration: 4,
                    lyrics: "Oh, what fun it",
                }
            ]
        }, {
            totalBeats: 4,
            beats: [
                {
                    chord: inferChord("Cdim/Gb").chord,
                    chordDisplay: inferChord("Cdim/Gb").chordDisplay,
                    duration: 1,
                    lyrics: "is",
                },
                {
                    chord: inferChord("Gmaj7").chord,
                    chordDisplay: inferChord("Gmaj7").chordDisplay,
                    duration: 1,
                    lyrics: "to ride",
                },
                {
                    chord: inferChord("G#dim7").chord,
                    chordDisplay: inferChord("G#dim7").chordDisplay,
                    duration: 2,
                    lyrics: "in a",
                }
            ]
        }, {
            totalBeats: 4,
            beats: [
                {
                    chord: inferChord("Am7").chord,
                    chordDisplay: inferChord("Am7").chordDisplay,
                    duration: 2,
                    lyrics: "one horse",
                },
                {
                    chord: inferChord("D7").chord,
                    chordDisplay: inferChord("D7").chordDisplay,
                    duration: 2,
                    lyrics: "open",
                }
            ]
        }, {
            totalBeats: 4,
            beats: [
                {
                    chord: inferChord("G6").chord,
                    chordDisplay: inferChord("G6").chordDisplay,
                    duration: 4,
                    lyrics: "sleigh!",
                },
            ]
        }
    ]
}
export { jingoBellSheet }