import Head from 'next/head'
import Link from 'next/link'


export default function Home() {
  return (
    <div className="container">
      <Head>
        <title>Koma Next</title>
        <link rel="icon" href="/favicon.ico" />
      </Head>

      <main>
        <h1 className="title">
          Komaroad{' '}
          <Link href="https://github.com/Ivan-Corporation/React-Komaroad">
            <a>Github!</a>
          </Link>
        </h1>

        <p className="description">
          Ссылки на другие адресные строки, созданные в NextJS:
        </p>

        <div className="grid">
          <Link href="/posts/first-post">
            <a className="card">
              <h3>Первый пост &rarr;</h3>
              <p>Первый пост, созданный с помощью Link</p>
            </a>
          </Link>

          <Link href="/posts/image">
            <a className="card">
              <h3>Изображение &rarr;</h3>
              <p>Тестим изображение и его стилизацию в NextJS</p>
            </a>
          </Link>

          <Link href="/about">
            <a
              className="card"
            >
              <h3>О нас &rarr;</h3>
              <p>Описание нашей компании и всех наших достижений</p>
            </a>
          </Link>

          <Link href="/posts/paintings">
            <a className="card"
            >
              <h3>Картины &rarr;</h3>
              <p>
                Здесь у нас будут две картины... И всё...
              </p>
            </a>
          </Link>

          <Link href="/posts/test">
            <a className="card"
            >
              <h3>Тест &rarr;</h3>
              <p>
                Тест
              </p>
            </a>
          </Link>

        </div>
      </main>

      <footer>
        <a
          href="https://github.com/Ivan-Corporation/React-Komaroad"
          target="_blank"
          rel="noopener noreferrer"
        >
          Powered by{' '} Komaroad
          <img src='/favicon.ico' alt="Koma" className="logo" />
        </a>

      </footer>





      <style jsx>{`
        .container {
          min-height: 100vh;
          padding: 0 0.5rem;
          display: flex;
          flex-direction: column;
          justify-content: center;
          align-items: center;
        }

        main {
          padding: 5rem 0;
          flex: 1;
          display: flex;
          flex-direction: column;
          justify-content: center;
          align-items: center;
        }

        footer {
          width: 100%;
          height: 100px;
          border-top: 1px solid #eaeaea;
          display: flex;
          justify-content: center;
          align-items: center;
        }

        footer img {
          margin-left: 0.5rem;
        }

        footer a {
          display: flex;
          justify-content: center;
          align-items: center;
        }

        a {
          color: inherit;
          text-decoration: none;
        }

        .title a {
          color: #0070f3;
          text-decoration: none;
        }

        .title a:hover,
        .title a:focus,
        .title a:active {
          text-decoration: underline;
        }

        .title {
          margin: 0;
          line-height: 1.15;
          font-size: 4rem;
        }

        .title,
        .description {
          text-align: center;
        }

        .description {
          line-height: 1.5;
          font-size: 1.5rem;
        }

        code {
          background: #fafafa;
          border-radius: 5px;
          padding: 0.75rem;
          font-size: 1.1rem;
          font-family: Menlo, Monaco, Lucida Console, Liberation Mono,
            DejaVu Sans Mono, Bitstream Vera Sans Mono, Courier New, monospace;
        }

        .grid {
          display: flex;
          align-items: center;
          justify-content: center;
          flex-wrap: wrap;

          max-width: 800px;
          margin-top: 3rem;
        }

        .card {
          margin: 1rem;
          flex-basis: 45%;
          padding: 1.5rem;
          text-align: left;
          color: inherit;
          text-decoration: none;
          border: 1px solid #eaeaea;
          border-radius: 10px;
          transition: color 0.15s ease, border-color 0.15s ease;
        }

        .card:hover,
        .card:focus,
        .card:active {
          color: #0070f3;
          border-color: #0070f3;
        }

        .card h3 {
          margin: 0 0 1rem 0;
          font-size: 1.5rem;
        }

        .card p {
          margin: 0;
          font-size: 1.25rem;
          line-height: 1.5;
        }

        .logo {
          height: 1em;
        }

        @media (max-width: 600px) {
          .grid {
            width: 100%;
            flex-direction: column;
          }
        }
      `}</style>

      <style jsx global>{`
        html,
        body {
          padding: 0;
          margin: 0;
          font-family: -apple-system, BlinkMacSystemFont, Segoe UI, Roboto,
            Oxygen, Ubuntu, Cantarell, Fira Sans, Droid Sans, Helvetica Neue,
            sans-serif;
        }

        * {
          box-sizing: border-box;
        }
      `}</style>
    </div>
  )
}
