# GDPR Checklist for Websites & Mobile Applications
The General Data Protection Regulation (GDPR) is a regulation by which the European Parliament, the Council of the European Union, and the European Commission intend to strengthen and unify data protection for all individuals within the European Union. The proposed new EU data protection regime extends the scope of the EU data protection law to all foreign companies processing data of EU residents.

## Checklist
- [ ] The application has a [privacy statement](#privacy-statement).
- [ ] The application does not collect or process more data or for a longer duration than is strictly necessary for the intended purpose as communicated to the user.
- [ ] The end users has explicitly agreed with the [processing](#processing) of [personal data](#personal-data). (Pre-ticked boxes are not permitted.)
- [ ] The application provides contact information on the [controller](#controller) that is easy to find.
- [ ] The application has a separate checkbox on the registration form for each particular processing activity.
- [ ] It is clear to the end user on what he/she gives permission for. This is explained transparently, concisely and understandably. Visual support is used where relevant. Especially when information is intended for a child.
- [ ] If applicable, it is stated that a child may only give permission if he/she is 16 years of age or older. Otherwise, the permission of a parent is needed. It should be reasonably demonstrated that a parent has given permission.
- [ ] If the application includes decision-making, it should be clear how that decision is taken. [(Example)](#decision-making)
- [ ] If the application includes programmatic advertisements it must be clearly authorised by the user.
- [ ] The application allows end users to view and adjust data that is actively shared (by the user).
- [ ] An appropriate assessment has been made when data is [pseudonymized](#pseudonymisation) and this process is tuned. [(Example)](#pseudonymised-data)
- [ ] Appropriate technical and organizational measures are taken to ensure a level of security appropriate to the risk, including inter alia as appropriate:
  * the pseudonymisation and encryption of personal data.
  * the ability to ensure the ongoing confidentiality, integrity, availability, and resilience of processing systems and services.
  * the ability to restore the availability and access to personal data in a timely manner in the event of a physical or technical incident.
  * a process for regularly testing, assessing and evaluating the effectiveness of technical and organizational measures for ensuring the security of the processing.


## Rights of the data subject
**Right of access by the data subject** <br />
The data subject has the right to obtain confirmation from a controller that data is being processed about him. In that case, the following information must be provided:
* the purpose of the processing
* which categories of personal data are processed
* which third parties have also received this personal data

In addition, it is the intention that the person concerned gains 'access' to the data processed about him. This could be done, for example, by exporting the file that was created about the person concerned.

**Right to rectification** <br />
The data subject has the right to have his data rectified if they are not correct or incomplete. If you have shared this information with third parties as controller, then you must inform these parties about this rectification if possible.

**Right to erasure ('right to be forgotten')** <br />
Due to the right to erasure, also known as the 'right to be forgotten', the data subject has the right to request the removal of his data. The right can be used in the following cases:
* the data is no longer needed in relation to the purpose of the processing
* the data subject withdrew his consent to the processing
* the data subject objects to the processing, and there is no demonstrable legitimate interest to continue this processing
* the data has been processed unlawfully
* the data must be removed because of a legal obligation

**Right to restriction of processing** <br />
The data subject can request a blocking of the processing. This means that except that the data is retained, no other processing may take place (including no deletion).

**Right to data portability** <br />
The data subject has the right to receive the personal data he has made available to the controller, in a structured and widely used format (this format must be machine readable, for example a csv file or in JSON format). He has the right to transfer this data to another controller.

**Right to object** <br />
The data subject may object to the processing of his data if the processing has been effected on the basis of the following points:
* Processing is necessary for a general interest task or for a task in the exercise of the public authority entrusted to the controller
* The processing is necessary for the representation of the legitimate interests of the controller or of a third party

If the objection of a data subject is well-founded, the processing must be discontinued, unless you can prove that there are demonstrable legitimate reasons for continuing with the processing, or because the data are necessary for legal claims. If it concerns an objection related to direct marketing, the processing must be stopped at the moment the objection comes in.


## Important information for [the controller](#controller)
* If an end user has made the request to delete the data, the controller is responsible for deleting the data from itself and other parties.
* If the controller pursues a different purpose with the data then has been reported in advance, this must be communicated to the end user before commencing the processing of data for that purpose.
* In the case of a [personal data breach](#personal-data-breach), the controller shall without undue delay and, where feasible, not later than 72 hours after having become aware of it, notify the personal data breach to the supervisory authority.
* The controller needs to take appropriate technical and orgiastic measures and should be able to demonstrate that the processing is carried out in accordance with this regulation.
* The [processor](#processor) does not employ another processor without the prior written consent of the controller.
* [Processing](#processing) of [personal data](#personal-data) from [special categories](#special-categories) are prohibited unless the person has explicitly given permission for confidentiality of the personal data for one or more well-defined purposes or the data apparently made public by the person himself.


## Definitions & Examples
#### Privacy Statement
A privacy statement must comply with the following characteristics:
* short
* transparent
* understandable
* easily accessible

The privacy statement must at least contain the following information:
* Identity and contact information of the [controller](#controller) that will allow users to raise any questions that they may have in relation to their privacy protection or to exercise their rights to access, correct and delete their data, and their right to data portability
* A clear description of the purposes for which personal data will be processed
* The legitimate interests of the controller (if applicable)
* Any recipients (or categories of recipients) of the personal data (for example possible processors like [third parties](#third-parties))
* Information about the forwarding of the personal data to a third country (outside the EU), if applicable
* The retention period, or the criteria by which the retention period is determined
* The person concerned must be informed of the rights he has
* The person concerned must be informed of the right to withdraw his consent to the processing
* The person concerned must be informed of his right to lodge a complaint with the supervisor
* If automated decision making is used, this should be mentioned
* Personal data may not be stored for longer than strictly necessary for the purpose for which these data were originally processed. If there is no 'hard' storage period to determine, then the privacy statement must specify the criteria that determine the retention period.

#### Special Categories
* Racial or ethnic origination
* Political opinions
* Religious or philosophical convictions
* Memberships of trade-unions
* Genetics
* Biometrics (where used for ID purposes)
* Health
* Sexual behavior or sexual orientation

#### Third Parties
Any persons, public authorities or agencies other than the end user, controller or processor that are authorized to process personal data. Think about:
* Google Analytics
* Hotjar
* Mailchimp
* etc.

#### Decision Making
In the case of a mortgage application where the user fills in several data and then the system decides whether or not the user is eligible for a mortgage. How that decision came about must be transparent.

#### Pseudonymised Data
After an end user has not logged in for half a year, the data, for example, their results of a test, is [pseudonymized](#pseudonymisation).

#### Personal Data
Any form of information relating to an identified or identifiable natural person ('data subject'). Think of the name, an identification number, location data, an online identifier, but also factors specific to the physical, physiological, genetic, mental, economic, cultural or social identity of that natural person.

#### Pseudonymisation
The processing of personal data in such a manner that the personal data can no longer be attributed to a specific person without the use of additional information.

#### Controller
The natural or legal person, public authority, agency or other body which, alone or jointly with others, determines the purposes and means of the processing of personal data.

#### Processor
A natural or legal person, public authority, agency or other body which processes personal data on behalf of the controller;

#### Processing
Any operation or set of operations which is performed on personal data or on sets of personal data.

#### Personal data breach
A breach of security leading to the accidental or unlawful destruction, loss, alteration, unauthorized disclosure of, or access to, personal data transmitted, stored or otherwise processed.
