# 정보처리기사 *(실기)* 커리큘럼

# 목표
- [자체 작성 문제 1000문 풀이](./exam.md)
- 오답노트 작성

# 참고사항
- NCS를 분석할 것
- 문제 유형을 파악하는 것보다 핵심적인 내용을 이해할 것

# 목차별 정리
## 프로그래밍 언어 활용
### 데이터 타입 B
> 변수(Variable)에 저장될 데이터의 형식

- 데이터 타입의 유형

  |유형|기능|예|
  |----|----|--|
  |정수 타입|소수점이 없는 숫자인 정수를 저장할 때 사용|1,-1,10,100|
  |부동 소수점 타입|소수점 이하가 있는 실수를 저장할 때 사용|0.123x10^2, -1.6x2^3|
  |문자 타입|한 문자를 저장할 때 사용<br>작은따옴표 안에 표시|'A','a','1','*'|
  |문자열 타입|문자열을 저장할 때 사용<br>큰따옴표 안에 표시|"Hello!","1+2=3"|
  |불린 타입|조건의 참, 거짓 여부를 판단하여 저장할 때 사용<br>기본값은 거짓|true, false|
  |배열 타입|같은 타입의 데이터 집합을 만들어 저장할 때 사용<br>데이터는 중괄호 안에 콤마로 구분하여 값을 나열|{1,2,3,4,5}|

- C/C++ 데이터 타입 크기 및 기억 범위
  - 문자
    - char : 1Byte, -128 ~ 127
  - 부호없는 문자형
    - unsigned char : 1Byte, 0 ~ 255
  - 정수
    - short : `2Byte`, `-32,768 ~ 32,767`
    - int : `4Byte`, `-2,147,483,648 ~ 2,147,438,647`
    - long : `4Byte`, `-2,147,483,648 ~ 2,147,438,647`
    - long long : `8Byte`, `-9,223,372,036,854,775,808 ~ 9,223,372,036,854,775,807`
  - 부호없는 정수형
    - unsigned short : `2Byte`, `0 ~ 65,535`
    - unsigned int : `4Byte`, `0 ~ 4,294,967,295`
    - unsigned long : `4Byte`, `0 ~ 4,294,967,295`
  - 실수
    - float : `4Byte`, `1.2x10^-38 ~ 3.4x10^38`
    - double : `8Byte`, `2.2x10^-308 ~ 1.8x10^308`
    - long double : `8Byte`, `2.2x10^-308, 1.8x10^308`

- Java 데이터 타입 크기 및 기억 범위
  - 문자
    - char : `2Byte`, `0 ~ 65,535`
  - 정수
    - byte : `1Byte`, `-128 ~ 127`
    - short : `2Byte`, `-32,768 ~ 32,767`
    - int : `4Byte`, `-2,147,483,648 ~ 2,147,438,647`
    - long : `8Byte`, `-9,223,372,036,854,775,808 ~ 9,223,372,036,854,775,807`
  - 실수
    - float : `4Byte`, `1.4x10^-45 ~ 3.4x10^38`
    - double : `8Byte`, `4.9x10^-324 ~ 1.8x10^308`
  - 논리
    - boolean : 1Byte, true 또는 false

- Python 데이터 타입 크기 및 기억 범위
  - 문자
    - str : `무제한`, `무제한`
  - 정수
    - int : `무제한`, `무제한`
  - 실수
    - float : `8Byte`, `4.9x10^-324 ~ 1.8x10^308`
    - complex : `16Byte`, `4.9x10^-324 ~ 1.8x10^308`

- 부호없는 정수형
  - `unsigned`가 붙은 부호없는 정수형은 음수를 표현하지 않음으로써 양수의 표현 범위를 2배로 증가시킨 자료형임
    - 2Byte 크기를 갖는 `short`는 -32,768 ~ 32,767까지 표현 가능
    - `unsigned short`는 음수를 제외하고 양수만 표현함으로써 0부터 65,535까지 표현 가능

- complex(complex number)
  - 복소수를 의미하며 실수(8Byte)와 허수(8Byte)의 합으로 이루어진 숫자 표현

<br>

### 변수 A
> 값을 저장하기 위한 공간으로 변할 수 있는 값을 의미
> - 정수형, 실수형, 문자형, 포인터형 등으로 구분

- 변수명 작성 규칙
  - 영문자, 숫자, _(under bar) 사용 가능
  - 첫 글자는 영문자나 _로 시작해야 하며, 숫자는 올 수 없음
  - 글자 수에 제한 없음
  - 공백, *, +, -, / 등의 특수문자는 사용 불가능
  - 대소문자 구분
  - 예약어를 변수명으로 사용할 수 없음
  - 변수 선언 시 문장 끝에는 세미콜론을 붙임
    - Python은 예외

- 예약어
  - 정해진 기능을 수행하도록 이미 정해진 단어
  - 변수나 다른 용도로 사용 불가능
  - for, case, break, char, auto, const 등

- 기억 클래스
  - 변수 선언 시 메모리 내에 변수의 값을 저장하기 위한 기억영역이 할당됨
  - 할당되는 기억영역에 따라 사용 범위에 제한이 있으며, 기억 영역을 결정하는 작업을 기억 클래스라고 함
  - 자동 변수
    - 함수나 블록 내에서 선언되는 변수
    - 함수나 블록이 실행되는 동안에만 존재하며 이를 벗어나면 자동으로 소멸
    - 초기화하지 않으면 쓰레기값이 저장됨
  - 외부변수
    - 현재 혹은 다른 파일에서 선언된 변수나 함수를 참조하기 위한 변수
    - 외부 변수는 함수 밖에서 선언
    - 함수가 종료된 뒤에도 값이 소멸되지 않음
    - 다른 파일에 선언된 변수는 초기화할 수 없음
  - 정적 변수
    - 내부 정적 변수 : 선언한 함수나 블록 내에서만 사용할 수 있음
    - 외부 정적 변수 : 모든 함수에서 사용 가능
    - 두 변수 모두 함수나 블록이 종료된 뒤에도 값이 소멸되지 않음
    - 초기화는 변수 선언 시 한 번만 할 수 있으며 초기화를 생략하면 0으로 자동 초기화
  - 레지스터 변수
    - 메모리가 아닌 CPU 내부의 레지스터에 기억영역을 할당받는 변수
    - 자주 사용되는 변수를 레지스터에 저장해 처리 속도를 높이기 위해 사용
    - 함수나 블록이 실행되는 동안에만 존재하며 이를 벗어나면 자동으로 소멸
    - 레지스터의 사용 개수는 한정되어 있어 저장할 레지스터가 없으면 자동 변수로 취급되어 메모리에 할당
    - CPU에 저장되므로 메모리 주소를 가지지 않기에 주소 연산자(&)를 사용할 수 없음

- 단정도 / 배정도
  - float 자료형은 단정도형, double과 long 자료형은 배정도형이라고 표현
  - 1.23e-2 : e는 10의 지수승을 의미하므로 1.23 x 10^-2, 즉 0.0123을 의미

<br>

### 데이터 입출력 A
> 표준 입출력 함수 : 키보드로 입력받아 화면으로 출력할 때 사용하는 함수
> - scanf(), getchar(), gets(), printf(), putchar(), puts() 등이 존재 *(C언어)*

- scanf(서식 문자열, 주소) 함수 : C언어의 표준 입력 함수
  - 특징
    - 입력받을 데이터의 자료형, 자릿수 등을 지정할 수 있음
    - 한 번에 여러 개의 데이터를 입력 받을 수 있음
    - 서식 문자열과 변수의 자료형은 일치해야 함
  - 서식 문자열

    |서식문자열|의미|
    |----------|----|
    |%d|정수형 10진수를 입출력하기 위해 지정|
    |%u|부호없는 정수형 10진수를 입출력하기 위해 지정|
    |%o|정수형 8진수를 입출력하기 위해 지정|
    |%x|정수형 16진수를 입출력하기 위해 지정|
    |%c|문자를 입출력하기 위해 지정|
    |%s|문자열을 입출력하기 위해 지정|
    |%f|소수점을 포함하는 실수를 입출력하기 위해 지정|
    |%e|지수형 실수를 입출력하기 위해 지정|
    |%ld|long형 10진수를 입출력하기 위해 지정|
    |%lo|long형 8진수를 입출력하기 위해 지정|
    |%lx|long형 16진수를 입출력하기 위해 지정|
    |%p|주소를 16진수로 입출력하기 위해 지정|

- printf(서식 문자열, 변수) 함수 : C언어의 표준 출력 함수
  - 주요 제어문자

    |문자|의미|기능|
    |----|----|----|
    |\n|new line|커서를 다음 줄 앞으로 이동|
    |\b|backspace|커서를 왼쪽으로 한 칸 이동|
    |\t|tab|커서를 일정 간격 띄움|
    |\r|carriage return|커서를 현재 줄의 처음으로 이동|
    |\0|null|널 문자를 출력|
    |\'|single quote|작은따옴표 출력|
    |\"|double quote|큰따옴표 출력|
    |\a|alert|스피커로 벨 소리를 출력|
    |\\|backslash|역 슬래시를 출력|
    |\f|form feed|한 페이지를 넘김|

- 기타 표준 입출력 함수
  - 입력
    - getchar()
      - 키보드로 한 문자를 입력받아 변수에 저장하는 함수
    - gets()
      - 키보드로 문자열을 입력받아 변수에 저장하는 함수
      - Enter를 누르기 전까지를 하나의 문자열로 인식하여 저장
  - 출력
    - putchar()
      - 인수로 주어진 한 문자를 화면에 출력하는 함수
    - puts()
      - 인수로 주어진 문자열을 화면에 출력한 후 커서를 자동으로 다음 줄 앞으로 이동하는 함수

<br>

### 연산자 A
- 산술 연산자 : 산술 계산에 사용되는 연산자

  |연산자|의미|
  |------|----|
  |+|덧셈|
  |-|뺄셈|
  |*|곱셈|
  |/|나눗셈|
  |%|나머지|
  |++|증가 연산자|
  |--|감소 연산자|

  - 전치 : 먼저 변수의 값을 증감시킨 후 변수를 연산에 사용
    - ++a, --a
  - 후치 : 먼저 변수를 연산에 사용한 후 변수의 값을 증감
    - a++, a--

- 관계 연산자 : 두 수의 관계를 비교하여 참 또는 거짓을 결과로 얻는 연산자

  |연산자|의미|
  |------|----|
  |==|같다|
  |!=|같지 않다|
  |>|크다|
  |>=|크거나 같다|
  |<|작다|
  |<=|작거나 같다|

- 비트 연산자 : 비트별(0, 1)로 연산하여 결과를 얻는 연산자

  |연산자|의미|비고|
  |------|----|----|
  |&|and|모든 비트가 1일때만 1|
  |^|xor|모든 비트가 같으면 0, 하나라도 다르면 1|
  |`|`|or|모든 비트 중 한 비트라도 1이면 1|
  |~|not|각 비트의 부정, 0이면 1, 1이면 0|
  |<<|왼쪽 시프트|비트를 왼쪽으로 이동|
  |>>|오른쪽 시프트|비트를 오른쪽으로 이동|

- 논리 연산자 : 두 개의 논리 값을 연산하여 참 또는 거짓을 결과로 얻는 연산자

  |연산자|의미|비고|
  |------|----|----|
  |!|not|부정|
  |&&|and|모두 참이면 참|
  |`||`|or|하나라도 참이면 참|

- 대입 연산자 : 연산 후 결과를 대입하는 연산식을 간략하게 입력할 수 있게 하는 연산자

  |연산자|예|의미|
  |------|--|----|
  |+=|a += 1|a = a + 1|
  |-=|a -= 1|a = a - 1|
  |*=|a *= 1|a = a * 1|
  |/=|a /= 1|a = a / 1|
  |%=|a %= 1|a = a % 1|
  |<<=|a <<= 1|a = a << 1|
  |>>=|a >>= 1|a = a >> 1|

- 조건 연산자 : 조건에 따라 서로 다른 수식을 수행
  > 조건 ? 수식1 : 수식2

- 연산자 우선순위
  - 증감 연산자
  - 산술 연산자 * / 
  - 산술 연산자 + -
  - 시프트 연산자
  - 관계 연산자 < <= >= >
  - 관계 연산자 == !=
  - 비트 연산자 &
  - 비트 연산자 ^
  - 비트 연산자 |
  - 논리 연산자 &&
  - 논리 연산자 ||
  - 조건 연산자
  - 대입 연산자
  - 순서 연산자

<br>

### 제어문 A
> 프로그램의 순서를 변경할 때 사용하는 명령문

- 단순 if문
  - 형식1, 조건이 참일 때만 실행
  - 형식2, 조건이 참일 때와 거짓일 때 실행

- 다중 if문
  - 조건이 여러 개일 때 사용

- switch문
  - 조건에 따라 분기할 곳이 여러 곳일 때 사용
  - case문의 레비을은 한 개의 상수만 지정하고, int, char, enum형 상수만 가능
  - default문은 가장 마지막에 사용되고 다음 문자에서 바로 종료되므로 break를 사용할 필요가 없음

- goto문
  - 현재 위치에서 원하는 다른 문장으로 건너뛰어 수행을 계속하기 위해 사용
  - 많이 사용하면 프로그램의 이해와 유지 보수가 어려워저 거의 사용하지 않음

<br>

### 반복분 A
> 제어문의 한 종류로 일정한 횟수를 반복하는 명령문

- for문
  - 초기값, 최종값, 증가값을 지정하는 수식을 이용해 정해진 횟수를 반복
  - 최종값에 대한 조건이 참인 동안 실행할 문장을 반복 수행
  - for( ; ; )와 같이 조건에 참여하는 수식을 모두 생략하면 for문을 무한 반복
  - 처음부터 최종값에 대한 조건식을 만족하지 못하면 한 번도 수행하지 않음
  - 문자도 for문을 수행할 수 있음

- while문
  - 조건이 참인 동안 실행할 문장을 반복 수행
  - 조건이 처음부터 거짓이면 한 번도 사용하지 않음

- do~while문
  - while문과 같은 동작
  - 단, 실행할 문장을 무조건 한 번 실행한 다음 조건을 판단하여 탈출 여부를 결정

- break, continue
  - switch문과 반복문의 실행을 제어하기 위해 사용되는 예약어
  - break : switch문이나 반복문 내부에서 break가 나오면 블록을 벗어남
  - continue
    - continue 이후의 문장을 실행하지 않고 제어를 반복문의 처음으로 이동
    - 반복문에서만 사용

<br>

### 배열과 문자열 A
> 동일한 데이터의 유형의 여러 변수들을 조합해서 하나의 이름으로 정의해 사용하는 것

- 개요
  - 배열에서 개별적인 요소들의 위치는 첨자를 이용하여 지정
  - 배열은 변수명 뒤에 대괄호 []를 붙이고 그 안에 사용할 개수를 지정
  - 배열에서는 행 우선으로 데이터가 기억장소에 할당
  - C언어의 배열 위치는 0부터 시작
  - C언어에서 배열 위치를 나타내는 첨자 없이 배열 이름을 사용하면 배열의 첫 번째 요소의 주소를 지정하는 것과 같음

- 1차원 배열
  - 일직선상의 개념으로 조합한 배열

- 2차원 배열
  - 행과 열로 조합한 배열

- 배열으 ㅣ초기화
  - 배열 선언 시 초기값 지정 가능
  - 배열 선언 시 배열의 크기를 생략하면 반드시 초기값을 지정하여야 해당 개수 만큼의 배열이 선언
  - 배열의 초기값을 '숫자,'로 지정하면 배열의 첫 번째 요소에는 지정한 숫자, 나머지 요소에는 0이 입력

- 배열 형태의 문자열 변수
  - C언어에서 큰따옴표(" ")로 묶인 글자는 글자 수에 관계없이 문자열로 처리
  - C언어에는 문자열을 저장하는 자료형이 없어 배열 또는 포인터를 이용하여 처리
    - `char 배열이름[크기] = "문자열"`
  - 배열에 문자열을 저장하면 문자열의 끝을 알리기 위한 널 문자('\0')가 문자열 끝에 자동 삽입
    - 따라서 널 문자까지 고려하여 배열 크기를 지정해야 함
    - `char a[5] = "love" [l],[o],[v],[e],[\0]`
  - 배열에 문자열을 저장할 때는 배열 선언 시 초기값으로 지정하고, 이미 선언된 배열에는 문자열을 저장할 수 없음

<br>

### 포인터 A
> 변수의 주소이며, C언어에서는 주소를 제어할 수 있는 기능

- 개요
  - C언어에서 변수의 주소를 저장할 때 사용하는 변수를 포인터 변수라고 함
  - 포인터 변수를 선언할 때는 자료형을 먼저 쓰고, 변수명 앞에 간접 연산자 *를 붙임(`int *a;`)
  - 포인터 변수에 주소를 저장하기 위해 변수의 주소를 알아낼 때는 변수 앞에 번지 연산자 &를 붙임(`a = &b;`)
  - 실행문에서 포인터 변수에 간접 연산자(*)를 붙이면 해당 포인터 변수가 가리키는 곳의 값을 말함(`c = *a;`)
  - 필요에 의해 동적으로 할당되는 메모리 영역인 힙 영역에 접근하는 동적 변수
  - 용도
    - 연결된 자료 구조를 구성하기 위해 사용
    - 동적으로 할당된 자료 구조를 지정하기 위해 사용
    - 배열을 인수로 전달하기 위해 사용
    - 문자열을 표현하기 위해 사용
    - 커다란 배열에서 요소를 효율적으로 저장하기 위해 사용
    - 메모리에 직접 접근하기 위해 사용

- 포인터와 배열 : 배열을 포인터 변수에 저장한 후 포인터를 이용해 배열의 요소에 접근할 수 있음
  - 배열 위치를 나타내는 첨자를 생략하고 배열의 대표명만 지정하면 배열의 첫번째 요소 주소를 지정하는 것과 같음
  - &연산자를 사용
  - 배열 a에 대한 표기 방법
    - 배열 : a[0], a[1], a[2], a[3], a[4]
    - 포인터 : *(a+0), *(a+1), *(a+2), *(a+3), *(a+4)

<br>

### 사용자 정의 함수 A
> 사용자가 필요한 기능을 취향대로 만들어 사용할 수 있는 함수
> - 프로그램 구조가 간단해지고 이해하기 쉬워짐
> - 동일한 코드를 반복 입력하는 수고를 줄일 수 있음

<br>

### Java의 클래스와 메소드 A
> 클래스 : 객체 생성을 위한 필드(속성)과 메소드(함수)를 정의하는 설계도

- 클래스를 만들어 사용하는 순서
  - 클래스를 명명하고, 필드와 메소드를 정의
  - 클래스를 이용해 명령어 new를 사용하여 객체를 생성
  - 생서된 객체로 프로그래밍 진행

<br>

### Python의 기초 A
- 기본 문법
  - 변수의 자료형에 대한 선언이 없음
  - 세미콜론(;)을 사용할 필요가 없음
  - 변수에 연속하여 값을 저장하는 것이 가능
  - 코드 블록은 콜론(:)과 여백으로 구분
    - 여백은 일반적으로 4칸 또는 한 개의 탭만큼 띄워야 함
    - 같은 수준의 코드들은 반드시 동일한 여백을 가져야 함

- Python의 데이터 입출력 함수
  - input() 함수
    - 키보드로 입력받아 변수에 저장하는 함수
    - 입력되는 값은 문자열로 취급되어 저장

      ```py
      # 형식 1
      변수 = input(출력문자)

      # 형식 2
      변수1, 변수2 = input(출력문자).split(분리문자)
      ```
    - map() 함수 *( map(자료형, input().split()) )*
      - input().split()을 통해 입력받은 2개 이상의 값을 원하는 자료형으로 변환할 때 사용

  - print() 함수

    ```py
    # 형식 1
    print(출력값1, 출력값2, ..., sep = 분리문자, end = 종료문자)
  
    # 형식 2
    print(서식 문자열 % (출력값1, 출력값2, ...))
    ```

- Python의 문자열
  - 작은따옴표(' '), 큰따옴표(" "), 3개의 작은 따옴표(''' '''), 3개의 큰따옴표(""" """)로 묶어 표현
  - char 자료형이 없으므로 작은따옴표와 큰따옴표를 자유롭게 사용 가능
  - 3개의 따옴표를 사용하면 문자열 내에서 작은따옴표와 큰따옴표를 자유롭게 문자로 사용할 수 있음
  - 제어문자(커서의 이동이나 탭, 줄 나눔 등을 표현하는 문자) 사용 가능
  - 주요 메소드

    |형식|내용|
    |---|---|
    |upper()|대문자로 변경|
    |lower()|소문자로 변경|
    |capitalize()|문자열 첫 글자는 대문자, 나머지는 소문자로 변경|
    |title()|각 단어의 첫 글자만 대문자로 변경|
    |replace(값1, 값2)|문자열에서 값1을 찾아 값2로 교체|
    |split(값)|값을 기준으로 문자열을 분리하여 리스트로 반환<br>값을 생략하면 공백으로 문자열 분리|
    |count(값)|문자열에서 값의 개수를 반환|
    |find(값)|문자열에서 처음 검색되는 값의 위치를 반환<br>찾지 못하면 -1을 반환|
    |index(값)|문자열에서 처음 검색되는 값의 위치를 반환<br>찾지 못하면 오류 발생|

- 리스트(List)
  - Python은 배열(Array)을 제공하지 않음
  - 리스트를 선언할 때 크기를 적지 않음
  - 하나의 리스트에 정수, 실수, 문자열 등 다양한 자료형을 섞어 저장할 수 있음
  - 1차원 리스트

    ```py
    # 형식 1
    리스트명 = [ 값1, 값2, ... ]
    # 형식 2
    리스트명 = list([ 값1, 값2, ... ])

    # 리스트의 마지막에 값 추가 : append() 메소드
    a.append('B class')
    # 리스트의 중간에 값을 삽입 : insert() 메소드
    a.insert(1, 'Brown')
    # 리스트의 위치를 기준으로 요소를 삭제할 때 : del 메소드
    del a[3]
    # 값을 기준으로 요소를 삭제할 때 : remove() 메소드
    a.remove('mike')
    ```

  - 2차원 리스트 : 리스트에 리스트를 저장하는 방식

    ```py
    # 형식 1
    리스트명 = [
      [ 값1, 값2, 값3 ],
      [ 값4, 값5, 값6 ]
    ]
    # 형식 2
    리스트A = [ 값1, 값2, 값3 ]
    리스트B = [ 값4, 값5, 값6 ]
    리스트명 = [ 리스트A, 리스트B ]
    ```

    - 리스트 관련 주요 메소드

      |형식|내용|
      |---|---|
      |pop(위치)|리스트의 위치에 있는 값을 출력하고 해당 요소 삭제|
      |index(값)|리스트에서 값이 저장된 요소의 위치를 반환|
      |count(값)|리스트에서 값이 저장되어 있는 요소들의 개수를 반환|
      |extend(리스트)|리스트의 끝에 새로운 리스트를 추가하여 확장|
      |reverse()|리스트의 순서를 역순으로 뒤집음|
      |sort()|리스트를 정렬하며, 오름차순이 기본값<br>reverse 속성을 이용하여 정렬 방식을 지정할 수 있음<br>`[ 2, 1, 3 ].sort(reverse = True)`|
      |copy()|리스트를 복사|

- Range
  - 연속된 숫자를 생성하는 것으로 리스트, 반복문 등에서 많이 사용

    ```py
    # 형식 1, 0에서 최종값 -1까지 연속된 숫자 생성
    range(최종값)
    # 형식 2, 초기값에서 최종값 -1까지 연속된 숫자 생성
    range(초기값, 최종값)
    # 형식 3, 초기값에서 최종값 -1까지 증가값만큼 연속된 숫자 생성
    # 증가값이 음수라면 초기값에서 최종값 +1까지 증가값만큼 감소하면서 생성
    range(초기값, 최종값, 증가값)
    ```

- 슬라이스(Slice)
  - 문자열이나 리스트와 같은 순차형 객체에서 일부를 잘라 반환하는 기능

    ```py
    # 형식 1, 초기위치에서 최종위치 -1까지의 요소들을 가져옴
    객체명[초기위치:최종위치]
    # 형식 2, 초기위치에서 최종위치 -1까지 증가값만큼 해당 위치의 요소들을 가져옴
    # 증가값이 음수라면 초기위치에서 최종위치 +1까지 증가값만큼 감소하면서 가져옴
    객체명[초기위치:최종위치:증가값]
    
    # 일부 인수를 생략하여 사용할 경우
    ## 객체의 모든 요소 반환
    객체명[:] 또는 객체명 [::]
    ## 객체의 초기위치에서 마지막 위치까지 요소들 반환
    객체명[초기위치:]
    ## 객체의 0번째 위치에서 최종위치 -1까지 요소들 반환
    객체명[:최종위치]
    ## 객체의 0번째 위치에서 마지막까지 증가값만큼 해당 위치의 요소들 반환
    객체명[::증가값]
    ```

<br>

### Python의 활용 A
- if문

  ```py
  # 형식 1, 조건이 참일 때만 실행
  if 조건:
    실행할 문장

  # 형식 2, 조건이 참일 때와 거짓일 때 실행
  if 조건:
    실행할 문장 1
  else:
    실행할 문장 2

  # 형식 3, 조건이 여러 개이고, 조건마다 실행할 문장이 다름
  if 조건 1:
    실행할 문장 1
  elif 조건 2:
    실행할 문장 2
  elif 조건 3:
    실행할 문장 3
  else:
    실행할 문장 4

  # 형식 4, if문 안에 if문이 포함
  if 조건 1:
    if 조건 2:
      실행할 문장 1
    else:
      실행할 문장 2
  else:
    실행할 문장 3
  ```

- for문

  ```py
  # 형식 1, range를 이용한 방식
  for 변수 in ragne(최종값):
    실행할 문장
  
  # 형식 2, 리스트(List)를 이용한 방식
  for 변수 in 리스트
    실행할 문장
  ```

- while문
  ```py
  while 조건:
    실행할 문장
  ```

- 클래스
  ```py
  # 정의 형식
  class 클래스명:
    실행할 문장
    def 메소드명(self, 인수):
      실행할 문장
      return 값

  # 객체의 선언 형식
  변수명 = 클래스명()
  ```

<br>

### 라이브러리 B
> 자주 사용하는 함수나 데이터들을 미리 만들어 모아 놓은 집합체

- 개요
  - 자주 사용하는 함수들의 반복적인 코드 작성을 피하기 위해 미리 만들어 놓은 것
  - 필요할 때 언제든 호출하여 사용 가능
  - 표준 라이브러리
    - 프로그래밍 언어에 기본적으로 포함되어 있는 라이브러리
    - 여러 종류의 모듈이나 패키지 형태
  - 외부 라이브러리
    - 개발자들이 필요한 기능들을 만들어 인터넷 등에 공유해 놓은 것
    - 외부 라이브러리를 다운받아 설치한 후 사용

- C언어의 대표적인 표준 라이브러리
  - 라이브러리를 헤더 파일로 제공하며 `#include <stdio.h>`와 같이 include문으로 선언 후 사용

    |헤더 파일|기능|
    |---------|----|
    |stdio.h|데이터의 입출력에 사용되는 기능들을 제공<br>주요 함수 : `printf`, `scanf`, `fprintf`, `fscanf`, `fclose`, `fopen`|
    |math.h|수학 함수 제공<br>주요 함수 : `sqrt`, `pow`, `abs`|
    |string.h|문자열 처리 함수 제공<br>주요 함수 : `strlen`, `strcpy`, `strcmp`|
    |stdlib.h|자료형 변환, 난수 발생, 메모리 할당에 사용되는 기능 제공<br>`atoi`, `atof`, `srand`, `rand`, `malloc`, `free`|
    |time.h|시간 처리에 사용되는 기능 제공<br>주요 함수 : `time`, `clock`|

- Java의 대표적인 표준 라이브러리
  - 라이브러리를 패키지에 포함하여 제공하며 `import java.util`과 같이 import문으로 선언 후 사용
  - 패키지 안에 있는 클래스의 메소드를 사용할 때는 클래스와 메소드를 마침표(.)로 구분하여 사용

    |패키지|기능|
    |------|----|
    |java.lang|Java에 기본적으로 필요한 인터페이스, 자료형, 예외 처리 등에 관련된 기능 제공<br>import문 없이도 사용 가능<br>주요 클래스 : String, System, Process, Runtime, Math, Error|
    |java.util|날짜 처리, 난수 발생, 복잡한 문자열 처리 등에 관련된 기능 제공<br>주요 클래스 : Date, Calender, Random, StringTokenizer|
    |java.io|파일 입출력과 관련된 기능 및 프로토콜 제공<br>주요 클래스 : InputStream, OutputStream, Reader, Writer|
    |java.net|네트워크와 관련된 기능 제공<br>Socket, URL, InetAddress|
    |java.awt|사용자 인터페이스(UI)와 관련된 기능 제공<br>Frame,Panel, Dialog, Button, Checkbox|

- Python의 대표적인 표준 라이브러리
  - 라이브러리를 패키지로 제공하며 `import random`과 같이 선언 후 마침표(.)로 구분하여 사용

    |클래스|기능|
    |------|----|
    |내장 함수|Python의 기본적인 인터페이스로 import문이나 클래스명 없이 사용 가능<br>주요 메소드 : abs(), slice(), pow(), print()|
    |os|운영체제와 상호 작용하기 위한 기능 제공<br>주요 메소드 : getcwd(), chdir(), system()|
    |re|고급 문자열 처리를 위한 기능 제공<br>주요 메소드 : findall(), sub()|
    |math|복잡한 수학 연산을 위한 기능 제공<br>주요 메소드 : cos(), log()|
    |random|무작위 선택을 위한 기능 제공<br>주요 메소드 : choice(), sample(), random(), randrange()|
    |statistics|통계값 산출을 위한 기능 제공<br>주요 메소드 : mean(), median(), variance()|
    |datetime|날짜와 시간 조작을 위한 기능 제공<br>주요 메소드 : today(), date(), strftime()|

<br>

### 절차적 프로그래밍 언어 C

<br>

### 객체지향 프로그래밍 언어 C

<br>

### 스크립트 언어 C

<br>

### 선언형 언어 C

<br>

### 예외 처리 C

<hr>
<br>

## 요구사항 확인
### 현행 시스템 파악 C

<br>

### 개발 기술 환경 파악 C

<br>

### 요구사항 정의 B
> 소프트웨어 서비스에 대한 설명과 정상적으로 운영되는데 필요한 제약조건 등

- 개요
  - 소프트웨어 개발, 유지 보수 과정에서 필요한 기준과 근거를 제공
  - 개발에 참여하는 이해관계자들 간의 의사소통을 원활하게 함
  - 요구사항이 제대로 정의되어야만 이후 과정의 목표와 계획을 수립할 수 있음

- 요구사항의 유형

  |유형|내용|
  |---|---|
  |기능 요구사항(Functional requirement|시스템이 무엇을 하는지, 어떤 기능을 하는지에 대한 사항<br>시스템의 입력이나 출력으로 무엇이 포함되어야 하는지, 시스템이 어떤 데이터를 저장하거나 연산을 수행해야 하는 기능<br>시스템이 반드시 수행해야 하는 기능<br>사용자가 시스템을 통해 제공받기를 원하는 기능|
  |비기능 요구사항(Non-functional requirement)|시스템 장비 구성 요구사항 : 하드웨어, 소프트웨어, 네트워크 등의 시스템 장비 구성에 대한 요구사항<br>성능 요구사항 : 처리 속도 및 시간, 처리량, 동적/정적 적용량, 가용성 등 성능에 대한 요구사항<br>인터페이스 요구사항 : 시스템 인터페이스와 사용자 인터페이스에 대한 요구사항으로 다른 소프트웨어, 하드웨어 및 통신 인터페이스, 다른 시스템과의 정보 교환에 사용되는 프로토콜과의 연계도 포함하여 기술<br>데이터 요구사항 : 초기 자료 구축 및 데이터 변환을 위한 대상, 방법, 보안이 필요한 데이터 등 데이터를 구축하기 위해 필요한 요구사항<br>테스트 요구사항 : 도입되는 장비의 성능 테스트(BMT)나 구축된 시스템이 제대로 운영되는지를 테스트하고 점검하기 위한 테스트 요구사항<br>보안 요구사항 : 시스템의 데이터 및 기능, 운영 접근을 통제하기 위한 요구사항<br>품질 요구사항 : 관리가 필요한 품질 항목, 품질 평가 대상에 대한 요구사항으로 가용성, 정합성, 상호 호환성, 대응성, 신뢰성, 사용성, 유지/관리성, 이식성, 확장성, 보안성 등으로 구분하여 기술<br>제약사항 : 시스템 설계, 구축, 운영과 관련하여 사전에 파악된 기술, 표준, 업무, 법/제도 등의 제약조건<br>프로젝트 관리 요구사항 : 프로젝트의 원활한 수행을 위한 관리 방법에 대한 요구사항<br>프로젝트 지원 요구사항 : 프로젝트의 원활한 수행을 위한 지원 사항이나 방안에 대한 요구사항|
  |사용자 요구사항(User requirement)|사용자 관점에서 본 시스템이 제공해야 할 요구사항<br>사용자를 위한 것으로 친숙한 표현으로 이해하기 쉽게 작성|
  |시스템 요구사항(System requirement)|개발자 관점에서 본 시스템 전체가 사용자와 다른 시스템에 제공해야 할 요구사항<br>사용자 요구사항에 비해 전문적이고 기술적인 용어로 표현<br>소프트웨어 요구사항이라고도 함|

- 요구사항 개발 프로세스


<br>

### 요구사항 분석 기법 C

<br>

### 요구사항 확인 기법 C

<br>

### UML A
> 시스템 개발자와 고객 또는 개발자 상호 간의 의사소통이 원활하게 이루어지도록 표준화한 대표적인 객체지향 모델링 언어

- 개요
  - UML은 공통된 표현법을 사용해 개발할 대상물을 다이어그램으로 표현하는 도구
  - 객체 기술에 관한 국제표준화기구 OMG에서 표준으로 지정
  - 시스템의 구조를 표현하는 6개의 구조 다이어그램과 시스템의 동작을 표현하는 7개의 행위 다이어그램을 작성할 수 있음
  - UML의 구성요소로 사물, 관계, 다이어그램 등이 존재

- 사물
  - 다이어그램 안에서 관계가 형성될 수 있는 대상들

  |사물|내용|
  |---|---|
  |구조 사물|시스템의 개념적, 물리적 요소를 표현<br>클래스, 유스케이스, 컴포넌트, 노드|
  |행동 사물|시간과 공간에 따른 요소들의 행위를 표현<br>상호작용, 상태 머신|
  |그룹 사물|요소들을 그룹으로 묶어서 표현<br>패키지|
  |주해 사물|부가적인 설명이나 제약조건 등을 표현<br>노트|

- 관계
  - 사물과 사물 사이의 연관성을 표현하는 것으로 연관, 집합, 포함, 일반화, 의존, 실체화 관계 등이 존재
  - 연관 관계
    - 2개 이상의 사물이 서로 관련되어 있음을 표현
    - 사물 사이를 실선으로 연결하여 표현하고 방향성은 화살표로 표현
    - 연관에 참여하는 객체의 개수를 의미하는 다중도를 선 위에 표기
  - 집합 관계
    - 하나의 사물이 다른 사물에 포함되어 있는 관계를 표현
    - 포함하는 쪽과 포함되는 쪽은 서로 독립적
    - 포함되는 쪽에서 포함하는 쪽으로 속이 빈 마름모를 연결하여 표현
  - 포함 관계
    - 포함하는 사물의 변화가 포함되는 사물에게 영향을 미치는 관계
    - 포함하는 쪽과 포함되는 쪽은 서로 독립될 수 없고 생명주기를 함께 함
    - 포함되는 쪽에서 포함하는 쪽으로 속이 채워진 마름모를 연결하여 표현
  - 일반화 관계
    - 하나의 사물이 다른 사물에 비해 더 일반적인지 구체적인지를 표현
  - 의존 관계
    - 사물 사이에 서로 연관은 있으나 필요에 의해 서로에게 영향을 주는 짧은 시간 동안만 연관을 유지하는 관계를 표현
  - 실체화 관계
    - 사물이 할 수 있거나 해야 하는 기능(행위, 인터페이스)으로 서로를 그룹화 할 수 있는 관계를 표현

- 다이어그램
  - 사물과 관계를 도형으로 표현
  - 시스템을 가시화한 뷰를 제공
  - 주로 정적 모델링에서는 구조적 다이어그램을, 동적 모델링에서는 행위 다이어그램을 사용
  - 구조적 다이어그램의 종류

    |종류|설명|
    |---|---|
    |클래스 다이어그램|클래스와 클래스가 가지는 속성, 클래스 사이의 관계를 표현|
    |객체 다이어그램|클래스에 속한 사물, 인스턴스를 특정 시점의 객체와 객체 사이의 관계로 표현|
    |컴포넌트 다이어그램|실제 구현 모듈인 컴포넌트 간의 관계나 컴포넌트 간의 인터페이스를 표현|
    |배치 다이어그램|결과물, 프로세스, 컴포넌트 등 물리적 요소들의 위치를 표현|
    |복합체 구조 다이어그램|클래스나 컴포넌트가 복합 구조를 갖는 경우 그 내부 구조를 표현|
    |패키지 다이어그램|유스케이스나 클래스 등의 모델 요소들을 그룹화한 패키지들의 관계를 표현|

  - 행위 다이어그램의 종류

    |종류|설명|
    |---|---|
    |유스케이스 다이어그램|사용자의 요구를 분석하는 것으로 기능 모델링 작업에 사용|
    |시퀀스 다이어그램|상호 작용하는 시스템이나 객체들이 주고받는 메시지를 표현|
    |커뮤니케이션 다이어그램|시퀀스 다이어그램과 같으나 메시지 뿐만 아니라 객체들 간의 연관 관계까지 표현|
    |상태 다이어그램|하나의 객체가 자신이 속한 클래스의 상태 변화 혹은 다른 객체와의 상호 작용에 따라 상태가 어떻게 변화하는지를 표현|
    |활동 구조 다이어그램|시스템이 어떤 기능을 수행하는지 객체의 처리 로직이나 조건에 따른 처리의 흐름을 순서에 따라 표현|
    |상호작용 개요 다이어그램|상호작용 다이어그램 간의 제어 흐름을 표현|
    |타이밍 다이어그램|객체 상태 변화와 시간 제약을 명시적으로 표현|

<br>

### 유스케이스 다이어그램 A
> 개발될 시스템을 이용해 수행할 수 있는 기능을 사용자의 관점(View)에서 표현한 것
> - 외부 요소와 시스템 간의 상호 작용을 확인할 수 있음
> - 요구사항을 분석하기 위한 도구로 사용
> - 시스템의 범위를 파악할 수 있음

- 기능 모델링의 개요
  - 사용자가 요구한 기능들이 어떻게 작동하는지를 설명하기 위해 구현될 모습을 그림으로 표현
  - 개발될 시스템의 전반적인 형태를 기능에 초점을 맞춰 표현
  - UML의 기능 모델링에는 유스케이스 다이어그램과 액티비티 다이어그램이 존재

- 유스케이스 다이어그램의 구성 요소
  - 시스템/시스템 범위
    - 시스템 내부에서 수행되는 기능들을 외부 시스템과 구분하기 위해 시스템 내부의 유스케이스들을 사각형으로 묶어 시스템의 범위를 표현
  - 액터
    - 시스템과 상호작용을 하는 모든 외부 요소로, 사람이나 외부 시스템을 의미
    - 시스템에 대해 수행할 수 있는 역할을 의미하기도 함
    - 액터 이름이 구체적이면 안 됨(구체적이면 액터의 대상이 하나로 고정되기 때문)
    - 주액터와 부액터가 존재
      - 주액터 : 시스템을 사용함으로써 이득을 얻는 대상. 사람에 해당되며 주로 시스템의 왼쪽에 배치
      - 부액터 : 주액터의 목적 달성을 위해 시스템에 서비스를 제공하는 외부 시스템, 조직이나 기관에 해당되며 주로 시스템의 오른쪽에 배치, 시스템명을 사각형으로 묶은 후 상단에 `<<Actor>>`라고 표기
  - 유스케이스
    - 사용자가 보는 관점에서 시스템이 액터에게 제공하는 서비스 또는 기능을 표현한 것
    - 타원으로 표현하며 타원 안쪽이나 아래쪽에 유스케이스 이름을 기술
  - 관계
    - 액터와 유스케이스, 유스케이스와 유스케이스 사이에서 나타날 수 있으며 3종류의 관계가 존재
    - 포함 관계
      - 두 개 이상의 유스케이스에 공통적으로 적용되는 기능을 별도로 분리하여 유스케이스를 만든 경우 원래의 유스케이스와 새롭게 분리된 유스케이스와의 관계를 포함 관계라고 함
      - 점선 화살표를 연결한 후 화살표 위에 `<<include>>`라고 표기
    - 확장 관계
      - 유스케이스가 특정 조건에 부합되어 유스케이스의 기능이 확장 될 때 원래의 유스케이스와 확장된 유스케이스와의 관계를 확장 관계라고 함
      - 점선 화살표를 연결한 후 화살표 위에 `<<extends>>`라고 표기
    - 일반화 관계
      - 유사한 액터나 유스케이스를 하나의 그룹으로 묶고 싶을 때 그보다 일반적인 액터나 유스케이스를 만들어 이들을 연결하여 표현하는 관계를 일반화 관계라고 함
      - 하위 액터나 유스케이스가 상위 액터나 유스케이승게 역할이나 기능을 상속받는 관계
      - 속이 빈 삼각형 화살표를 실선으로 연결

- 유스케이스 명세서(기술서)
  - 유스케이스 안에서의 액터와 시스템 간의 상호 작용 과정을 글로 자세히 표현한 것
  - 모든 유스케이스에 대해 개별적으로 작성해야 함
  - 사건의 흐름을 참고하여 활동 다이어그램을 작성

<br>

### 활동 다이어그램 B
### 클래스 다이어그램 A
> 시스템을 구성하는 클래스, 클래스의 특성인 속성과 오퍼레이션, 속성과 오퍼레이션에 대한 제약조건, 클래스 사이의 관계를 표현한 것
> - 시스템을 구성하는 요소에 대해 이해할 수 있는 구조적 다이어그램
> - 시스템 구성 요소를 문서화하는 데 사용

- 정적 모델링의 개요
  - 사용자가 요구한 기능을 구현하는데 필요한 자료들의 논리적인 구조를 표현한 것
  - 시스템에 의해 처리되거나 생성될 객체들 사이에 어떤 관련이 있는지를 구조적인 관점에서 표현
  - 객체들을 클래스로 추상화하여 표현
  - UML을 이용한 정적 모델링의 대표적인 것이 클래스 다이어그램임

- 클래스
  - 각각의 객체들이 갖는 속성과 오퍼레이션(동작)을 표현
  - 일반적으로 3개의 구획인 이름, 속성, 오퍼레이션을 표기
  - 속성과 오퍼레이션은 생략할 수 있으나 이름은 반드시 명시
    - 생략된 경우 구획선을 그리지 않음
  - 속성 : 클래스의 상태나 정보를 표현
    - 접근제어자 : 속성과 오퍼레이션을 어느 정도까지 클래스 외부에 노출시킬지를 제어
    - 속성명 : 속성의 이름으로, 사용자가 임의로 작성
    - 자료형 : UML에서 기본적으로 제공하는 자료형 또는 사용자가 필요에 의해 새롭게 정의한 자료형을 사용할 수 있음
    - 다중성 : 동일한 속성명으로 여러 개의 속성 값을 가질 수 있는 것으로, 배열과 같은 의미
    - 초기값 : 데이터를 입력하지 않았을 때 기본적으로 입력되는 값을 지정
  - 오퍼레이션 : 클래스가 수행할 수 있는 동작으로 함수라고도 함
    - 오퍼레이션명 : 사용자가 임의로 작성
    - 매개변수 : 해당 오퍼레이션 수행에 필요한 값을 전달하기 위해 사용
    - 반환자료형 : 오퍼레이션 수행 후에 반환되는 값에 대한 자료형으로 반환되는 값이 없으면 반환자료형을 void로 지정

- 제약조건
  - 속성에 입력될 값에 대한 제약조건이나 오퍼레이션 수행 전후에 지정해야 할 조건이 있다면 이를 작성
  - 주석 도형 안에 제약조건을 작성한 후 제약조건이 적용될 속성이나 오퍼레이션을 점선으로 연결
  - 클래스 안에 제약조건을 작성할 때는 중괄호 {}를 이용

- 관계
  - 클래스와 클래스 사이의 연관성을 표현
  - 관계에 참여하는 객체의 수(다중도)를 연관 관계 선 위에 표기
  - 연관 관계
    - 두 클래스가 서로 연관 관계에 있을 때는 클래스 안에 연관된 클래스를 이용하여 객체 변수를 생성할 수 있음
  - 집합 관계
    - 두 클래스가 서로 집합 관계에 있을 때 집합 관계에 있는 클래스의 객체 변수를 매개변수로 사용할 수 있음
  - 포함 관계
    - 두 클래스가 서로 포함 관게에 있을 때는 포함 관계에 있는 클래스를 이용하여 생성된 객체 변수를 이용하여 새로운 객체 변수를 생성할 수 있음
  - 일반화 관계
    - 일반적인 개념을 상위(부모) 클래스, 구체적인 개념을 하위(자식) 클래스라고 부름
    - 두 클래스가 서로 일반화 관계에 있을 때 하위 클래스가 상위 클래스의 속성이나 메소드를 사용할 수 있음
  - 의존 관계
    - 두 클래스가 서로 의존 관계에 있을 때는 영향을 주는 클래스(이용자)의 특정 오퍼레이션(메소드)이 수행 될 때만 영향을 받는 클래스(제공자)가 사용

<br>

### 시퀀스 다이어그램 B

<br>

### 커뮤니케이션 다이어그램 B

<br>

### 상태 다이어그램 B

<hr>
<br>

## 데이터 입출력 구현
### 데이터 모델의 개념 B

<br>

### 이상/함수적 종속/정규화 A
- 이상
  - 테이블에서 일부 속성들의 종속으로 인해 데이터의 중복이 발생하고, 중복으로 인해 테이블 조작 시 문제가 발생하는 현상
  - 테이블 조작 중에 발생하는 이상의 종류
    - 삽입 이상 : 테이블에 데이터를 삽입할 때 의도와는 상관없이 원하지 않은 값들로 인해 삽입할 수 없게 되는 현상
    - 삭제 이상 : 테이블에서 한 튜플을 삭제할 때 의도와는 상관없는 값들도 함께 삭제되는, 연쇄 삭제가 발생하는 현상
    - 갱신 이상 : 테이블에서 튜플에 있는 속성 값을 갱신할 때 일부 튜플의 정보만 갱신되어 정보에 불일치성이 생기는 현상

- 함수적 종속
  - 데이터의 의미를 표현하는 것으로 현실 세계를 표현하는 제약 조건이 되는 동시에 데이터베이스에서 항상 유지되어야 할 조건
  - 테이블 R에서 X와 Y를 각각 R의 속성 집합의 부분 집합이라고 할 때, 속성 X의 값 각각에 대해 시간 관계 없이 항상 속성 Y의 값이 오직 하나만 연관되어 있을 때 Y는 X에 함수적 종속 또는 X가 Y를 함수적으로 결정한다고 하며 `X->Y`라고 표기
    - `X->Y`의 관계에서, X를 결정자, Y를 종속자라고 표현

- 정규화
  - 테이블의 속성들이 상호 종속적인 관계를 갖는 특성을 이용해 테이블을 무손실 분해하는 과정
  - 가능한 한 중복을 제거하여 삽입, 삭제, 갱신 이상의 발생 가능성을 줄이는 것
  - 정규화 과정
    - 제 1정규형 : 테이블 R에 속한 모든 속성의 도메인이 원자 값만으로 되어 있는 정규형
    - 제 2정규형 : 기본키가 아닌 모든 속성이 기본키에 대하여 완전 함수적 종속을 만족하는 정규형
    - 제 3정규형 : 기본키가 아닌 모든 속성이 기본키에 대해 이행적 함수적 종속을 만족하지 않는 정규형
    - BCNF : 모든 결정자가 후보키인 정규형
    - 제 4정규형 : 테이블 R의 모든 속성이 A에 함수적 종속 관계를 만족하는 정규형
    - 제 5정규형 : 테이블 R의 모든 조인 종속이 R의 후보키를 통해서만 성립되는 정규형

<br>

### 논리 데이터 모델의 물리 데이터 모델로 변환 A
- 테이블(Table) : 데이터를 저장하는 데이터베이스의 가장 기본적인 오브젝트
  - 컬럼(Column, 열), 로우(Row, 행)로 구성되며, 컬럼에는 지정된 유형에 따라 데이터가 저장
  - 구성 요소

    |요소|설명|
    |---|---|
    |로우(Row)|튜플, 인스턴스, 어커런스라고도 함|
    |컬럼(Column)|각 속성 항목에 대한 값을 저장|
    |기본키(Primary key)|기본키는 후보키 중에서 선택한 주키(Main key)<br>한 릴레이션에서 특정 튜플을 유일하게 구별할 수 있는 속성|
    |외래키(Foreign key)|다른 릴레이션의 기본키를 참조하는 속성 또는 속성들의 집합을 의미<br>한 릴레이션에 속한 속성 A와 참조 릴레이션의 기본키인 B가 동일한 도메인 상에서 정의되었을 때의 속성 A를 외래키라고 함|

- 엔티티를 테이블로 변환
  - 논리 데이터 모델에서 정의된 엔티티를 물리 데이터 모델의 테이블로 변환
  - 엔티티를 테이블로 변환한 후 테이블 목록 정의서를 작성
    - 테이블 목록 정의서 : 전체 테이블을 목록으로 요약 관리하는 문서로 테이블 목록이라고도 함
  - 변환 규칙

    |논리적 설계(데이터 모델링)|물리적 설계|
    |--------------------|--------|
    |엔티티(Entity)|테이블(Table)|
    |속성(Attribute)|컬럼(Column)|
    |주 식별자(Primary Identifier)|기본키(Primary Key)|
    |외부 식별자(Foreign Identifier)|외래키(Foreign Key)|
    |관계(Relationship)|관계(Relationship)|

  - 변환 시 규칙
    - 테이블과 엔티티 명칭은 동일할 것을 권고
    - 엔티티는 주로 한글명, 테이블은 영문명
    - 메타 데이터 관리 시스템에 표준화된 용어가 있다면 메타에 등록된 단어를 사용하여 명명

- 슈퍼타입/서브타입을 테이블로 변환
  - 슈퍼타입 기준 테이블 변환 : 서브 타입을 슈퍼타입에 통합하여 하나의 테이블로 생성
    - 서브타입에 속성이나 관계가 적을 경우에 적용하는 방법
      - 하나로 통합된 테이블에는 서브타입의 모든 속성이 포함되어야 함
    - 장점
      - 데이터의 액세스가 상대적으로 용이
      - 뷰를 이용하여 각각의 서브타입만을 액세스하거나 수정 가능
      - 서브타입 구분이 없는 임의 집합에 대한 처리 용이
      - 여러 테이블을 조인하지 않으므로 수행 속도 증가
      - SQL 문장 구성이 단순
    - 단점
      - 디스크 저장 공간 증가
      - 처리마다 서브타입에 대한 구분(Type)이 필요한 경우가 많이 발생
      - 인덱스 크기의 증가로 인덱스 효율이 떨어짐
  - 서브타입 기준 테이블 변환 : 슈퍼타입 속성들을 각각의 서브타입에 추가하여 서브타입들을 개별적인 테이블로 생성
    - 서브타입에 속성이나 관계가 많이 포함된 경우 적용
    - 장점
      - 각 서브타입 속성들의 선택 사양이 명확한 경우 유리
      - 처리할 때마다 서브타입 유형 구분 없음
      - 테이블을 통합하므로 테이블당 크기가 감소하여 전체 테이블 스캔 시 유리
    - 단점
      - 수행 속도가 감소
      - 복잡한 처리를 하는 SQL 통합이 어려움
      - 부분 범위에 대한 처리 곤란
      - 여러 테이블을 통합한 뷰는 조회만 가능
      - UID(Unique Identifier, 식별자)의 유지 관리가 어려움
  - 개별타입 기준 테이블 변환 : 슈퍼타입과 서브타입들을 각각의 개별적인 테이블로 변환
    - 슈퍼타입과 서브타입 테이블 사이에는 1:1 관계 형성
    - * 스캔(Scan) 방식
      - 테이블의 데이터를 검색할 때 앞에서부터 순차적으로 행(Row)을 비교하여 원하는 데이터를 가져오는 접근 방법
      - 전체 스캔(Full Scan)은 전체 테이블을, 범위 스캔(Range Scan)은 테이블의 특정 부분만을 검색
    - 개별타입 기준 테이블 변환을 적용하는 경우
      - 전체 데이터에 대한 처리가 빈번함
      - 서브타입의 처리가 대부분 독립적으로 발생함
      - 통합하는 테이블의 컬럼 수가 많음
      - 서브타입의 컬럼 수가 많음
      - 트랜잭션이 주로 슈퍼타입에서 발생함
      - 슈퍼타입의 처리 범위가 넓고 빈번하게 발생하여 단일 테이블 클러스터링이 필요함
    - 장점
      - 저장 공간이 상대적으로 작음
      - 슈퍼타입 또는 서브타입 각각의 테이블에 속한 정보만 조회하는 경우 문장 작성이 용ㅇ이
    - 단점
      - 슈퍼타입 또는 서브타입의 정보를 같이 처리하면 항상 조인이 발생하여 성능 저하

- 속성을 컬럼으로 변환
  - 논리적 데이터 모델에서 정의한 속성을 물리 데이터 모델의 컬럼으로 변환
  - 일반 속성 변환
    - 속성과 컬럼은 의사소통을 위해 표준화된 약어를 사용하여 일치시킬 것
    - 컬럼명은 SQL 예약어(Reserved Word)를 피할 것
    - 컬럼명은 가독성을 위해 짧게 지정할 것
    - 복합 단어를 컬럼명으로 사용할 경우 정의된 표준을 따를 것
    - 컬럼을 정의했다면 샘플 데이터를 작성하여 컬럼 정합성을 검증할 것
  - Primary UID를 기본키로 변환
    - 논리적 데이터 모델의 Primary UID는 물리적 데이터 모델의 기본키로 생성
  - Primary UID(관계의 UID Bar)를 기본키로 변환
    - 다른 엔티티와의 관계로 인해 생성된 Primary UID는 물리 데이터 모델의 기본키로 생성
  - Secondary(Alternate) UID를 유니크키로 변환
    - 논리 모델링에서 정의된 Secondary UID 및 Alternate Key는 물리 모델에서 유니크키로 생성

- 관계를 외래키로 변환
  - 논리 데이터 모델에서 정의된 관계는 기본키와 이를 참조하는 외래키로 변환
  - 1:1 관계 : 개체 A의 기본키를 개체 B의 외래키로 추가하거나 개체 B의 기본키를 개체 A의 외래키로 추가하여 표현
  - 1:M 관계 : 개체 A의 기본키를 개체 B의 외래키로 추가하여 표현하거나 별도의 테이블로 표현
  - N:M 관계 : 릴레이션 A와 B의 기본키를 모두 포함한 별도의 릴레이션으로 표현
    - 이때 생성된 별도의 릴레이션을 교차 릴레이션 또는 교차 엔티티라고 함
  - 1:M 순환 관계 : 개체 A에 개체 A의 기본키를 참조하는 외래키 컬럼을 추가하여 표현
    - 데이터 계층 구조를 표현하기 위해 주로 사용

- 관리 목적의 테이블/컬럼 추가
  - 논리 데이터 모델에는 존재하지 않는 테이블/컬럼을 데이터베이스의 관리 혹은 데이터베이스를 이용하는 프로그래밍의 수행 속도를 향상시키기 위해 물리 데이터 모델에 추가할 수 있음
    - 예 : 시스템 등록 일자, 시스템 번호 등

- 데이터 타입 선택
  - 논리 데이터 모델에서 정의된 논리적인 데이터 타입을 물리적 DBMS의 물리적 특성과 성능을 고려하여 최적의 데이터 타입과 데이터의 최대 길이를 선택
    - Oracle에서 자주 사용되는 데이터 유형
      - CHAR : 고정길이 문자열 Data, 최대 2,000Byte까지 저장 가능
      - VARCHAR2 : 가변길이 문자열 Data, 최대 4,000Byte까지 저장 가능
      - NUMBER : 38자릿수의 숫자 저장 가능
      - DATE : 날짜 저장

<br>

### 반정규화 B

<br>

### 인덱스 설계 A
> 데이터 레코드를 빠르게 접근하기 위해 <키 값, 포인터> 쌍으로 구성되는 데이터 구조

- 개념
  - 데이터가 저장된 물리적 구조와 밀접한 관계
  - 레코드가 저장된 물리적 구조에 접근하는 방법을 제공
  - 파일의 레코드에 대한 액세스를 빠르게 수행
  - 레코드의 삽입/삭제가 수시로 일어나는 경우 인덱스의 개수를 최소로 하는 것이 효율적
  - 인덱스가 없으면 특정한 값을 찾기 위해 모든 데이터 페이지를 확인하는 Table Scan 발생
    - Table Scan : 테이블에 있는 모든 레코드를 순차적으로 읽는 것
      - Full Table Scan 이라고도 함
      - 일반적으로 적용 가능한 인덱스가 없거나 분포도가 넓은 데이터를 검색할 때 사용
  - 기본키를 위한 인덱스를 기본 인덱스, 기본 인덱스가 아닌 인덱스들을 보조 인덱스라고 함
    - 대부분의 RDBMS는 모든 기본키에 대해서 자동적으로 기본 인덱스를 생성
  - 레코드의 물리적 순서가 인덱스의 엔트리 순서와 일치하게 유지되도록 구성되는 인덱스를 클러스터드(Clustered) 인덱스라고 함
  - 트리 기반 인덱스, 비트맵 인덱스, 함수 기반 인덱스, 비트맵 조인 인덱스, 도메인 인덱스 등으로 분류

- 클러스터드/넌 클러스터드 인덱스
  - 클러스터드 인덱스(Clustered Index)
    - 인덱스 키의 순서에 따라 데이터가 정렬되어 저장되는 방식
    - 실제 데이터가 순서대로 저장되어 인덱스를 검색하지 않아도 원하는 데이터를 빠르게 찾을 수 있음
    - 데이터 삽입, 삭제 발생 시 순서를 유지하기 위해 데이터를 재정렬
    - 한 개의 릴레이션에 하나의 인덱스만 생성 가능
  - 넌 클러스터드 인덱스(Non-Clustered Index)
    - 인덱스의 키 값만 정렬되어 있을 뿐 실제 데이터는 정렬되어 있지 않음
    - 먼저 인덱스를 검색하여 실제 데이터의 위치를 확인해야 하므로 클러스터드 인덱스에 비해 검색 속도가 떨어짐
    - 한 개의 릴레이션에 여러 개의 인덱스 생성 가능

- 트리 기반 인덱스
  - 인덱스를 저장하는 블록들이 트리 구조를 이루고 있는 것으로 상용 DBMS에서는 B+ 트리 인덱스를 주로 활용
  - B 트리 인덱스
    - 루트에서 하위 노드로 키 값의 크기를 비교해 나가면서 단말 노드에서 찾고자 하는 데이터를 검색
    - 키 값과 레코드를 가리키는 포인터들이 트리 노드에 오름차순으로 저장
    - 모든 리프 노드는 같은 레벨에 있음
  - B+ 트리 인덱스
    - B 트리의 변형으로 노드로 구성된 인덱스 세트(Index Set)와 단말 노드로만 구성된 순차 세트(Sequnece Set)로 구분
    - 인덱스 세트의 노드들은 단말 노드에 있는 키 값을 찾아갈 수 있는 경로로만 제공
      - 순차 세트의 단말 노드가 해당 데이터 레코드의 주소를 가리킴
    - 인덱스 세트에 있는 모든 키 값이 단말 노드에 다시 나타나므로 단말 노드만을 이용한 순차 처리가 가능

- 비트맵 인덱스
  - 인덱스 컬럼의 데이터를 Bit 값인 0 또는 1로 변환하여 인덱스 키로 사용하는 방법
  - 키 값을 포함하는 로우(Row)의 주소를 제공하는 것이 목적
    - 로우의 주소 : 비트맵에서 비트의 위치는 테이블에서 로우의 상대적인 위치를 의미, 해당 테이블이 시작되는 물리적인 주소를 기반으로 실제 로우의 물리적 위치를 계산 가능
  - 분포도가 좋은 컬럼에 적합하며 성능 향상 효과를 기대할 수 있음
  - 효율적인 논리 연산이 가능하고 저장 공간이 작음
  - 다중 조건을 만족하는 튜플의 개수 계산에 적합
  - 동일한 값이 반복되는 경우가 많아 압축 효율이 적음

- 함수 기반 인덱스
  - 컬럼의 값 대신 컬럼에 특정 함수(Function)나 수식(Expression)을 적용하여 산출된 값을 사용
  - B+ 트리 인덱스 또는 비트맵 인덱스를 생성하여 사용
  - 데이터 입력/수정 시 함수를 적용하므로 부하 발생 가능
  - 사용자 정의 함수일 경우 시스템 함수보다 부하가 큼
  - 대소문자, 띄어쓰기 등에 상관없이 조회할 때 유용
  - 적용 가능한 함수 종류
    - 산술식(Arithmetic Expression), 사용자 정의 함수, PL/SQL Function, SQL Function, Package, C callout

- 비트맵 조인 인덱스
  - 다수의 조인된 객체로 구성된 인덱스
  - 비트맵 인덱스와 물리적 구조가 동일

- 도메인 인덱스
  - 개발자가 필요한 인덱스를 직접 만들어 사용하는 것으로 확장형 인덱스(Extensible Index)라고도 함

- 인덱스 설계
  - 기본적인 인덱스를 지정한 후 개발 단계에서 필요한 인덱스의 설계를 반복적으로 진행
  - 설계 순서
    - 인덱스의 대상 테이블이나 컬럼 등을 선정
    - 인덱스의 효율성을 검토하여 인덱스 최적화를 수행
    - 인덱스 정의서를 작성

- 인덱스 대상 테이블 선정 기준
  - Multi Block Read 수에 따라 판단
    - Multi Block Read : 테이블 엑세스 시 메모리에 한 번에 읽어 들일 수 있는 블록의 수
    - 예 : 16이면 테이블 크기가 16블록 이상일 경우 인덱스 필요
  - 랜덤 엑세스가 빈번한 테이블
  - 특정 범위나 특정 순서로 데이터 조회가 필요한 테이블
  - 다른 테이블과 순차적 조인이 발생하는 테이블

- 인덱스 대상 컬럼 선정 기준
  - 인덱스 컬럼 분포도가 10~15% 이내인 컬럼
    - 분포도 = (컬럼값의 평균 Row 수 / 테이블의 총 Row 수) X 100
  - 분포도가 10~15% 이상이어도 부분 처리를 목적으로 하는 컬럼
  - 입출력 장표 등에서 조회 및 출력 조건으로 사용되는 컬럼
  - 인덱스가 자동 생성되는 기본키와 Unique 키 제약 조건을 사용한 컬럼
  - 수정이 빈번하지 않은 컬럼
  - Order by, Group by, Union이 빈번한 컬럼
  - 분포도가 좁은 컬럼은 단독 인덱스로 생성
  - 인덱스들이 자주 조합되어 사용되는 경우 하나의 결합 인덱스(Concatenate Index)로 생성

- 인덱스 설계 시 고려사항
  - 새로 추가되는 인덱스는 기존 액세스 경로에 영향을 미침
  - 인덱스를 지나치게 많이 만들면 오버헤드가 발생
  - 넓은 범위를 인덱스로 처리하면 많은 오버헤드 발생
  - 인덱스를 생성하면 추가적인 저장 공간이 필요
  - 인덱스와 테이블 데이터의 저장 공간이 분리되도록 설계

<br>

### 뷰 설계 A
> 사용자에게 접근이 허용된 자료만을 제한적으로 보여주기 위해 하나 이상의 기본 테이블로부터 유도된 이름을 가지는 가상 테이블

- 개요
  - 저장장치 내에 물리적으로 존재하지 않지만 사용자에게는 있는 것처럼 간주
  - 데이터 보정 작업, 처리 과정 시험 등 임시적인 작업을 위한 용도로 활용
  - 조인문의 사용 최소화로 사용상의 편의성을 최대화
  - 뷰를 생성하면 뷰 정의가 시스템 내에 저장되었다가 생성된 뷰 이름을 질의어(SQL 등)에서 사용할 경우 질의어가 실행될 때 뷰에 정의된 기본 테이블로 대체되어 기본 테이블에 대해 실행

- 뷰의 특징
  - 기본 테이블로부터 유도되어 기본 테이블과 같은 형태의 구조이며 조작이 거의 동일
  - 가상 테이블이므로 물리적으로 구현되어 있지 않음
  - 데이터의 논리적 독립성을 제공
  - 관리가 용이하고 명령문이 간단
  - 뷰를 통해 데이터에 접근하면 뷰에 나타나지 않는 데이터를 안전하게 보호 가능
  - 기본 테이블의 기본키를 포함한 속성(열) 집합으로 뷰를 구성해야만 삽입, 삭제, 갱신 연산이 가능
  - 정의된 뷰는 다른 뷰의 정의에 기초가 될 수 있음
  - 뷰가 정의된 기본 테이블이나 뷰를 삭제하면 그 테이블이나 뷰를 기초로 한 다른 뷰도 자동으로 삭제

- 뷰의 장단점
  - 장점
    - 논리적 데이터 독립성 제공
    - 동일 데이터에 대해 동시에 여러 사용자의 상이한 응용이나 요구 지원
    - 사용자의 데이터 관리를 용이
    - 접근 제어를 통한 자동 보안 제공
  - 단점
    - 독립적인 인덱스를 보유하지 못함
    - 뷰의 정의를 변경할 수 없음
    - 뷰로 구성된 내용에 대한 삽입/삭제/갱신 연산에 제약

- 뷰 설계 순서
  - 대상 테이블 선정
    - 외부 시스템과 인터페이스에 관여하는 테이블
    - CURD 매트릭스를 통해 여러 테이블이 동시에 자주 조인되어 접근되는 테이블
    - SQL문 작성 시 거의 모든 문장에서 인라인 뷰(FROM절 안에 사용되는 서브 쿼리) 방식으로 접근되는 테이블
  - 대상 컬럼 선정
    - 보안 유지가 필요한 컬럼은 주의하여 선별
  - 정의서 작성

- 뷰 설계 시 고려사항
    - 테이블 구조가 단순화 될 수 있도록 반복적으로 조인을 설정하여 사용하거나 동일한 조건절을 사용하는 테이블을 뷰로 생성
    - 동일한 테이블이라도 업무에 따라 테이블을 이용하는 부분이 달라질 수 있으므로 사용할 데이터를 다양한 관점에서 제시
    - 데이터의 보안 유지를 고려하여 설계

<br>

### 클러스터 설계 A
> 데이터의 액세스 효율을 향상시키기 위해 동일한 성격의 데이터를 동일한 데이터 블록에 저장하는 물리적 저장 방법
> - 클러스터링키로 지정된 컬럼 값의 순서대로 저장되고, 여러 개의 테이블이 하나의 클러스터에 저장

- 클러스터링키
  - 클러스터링된 테이블에서 각각의 행을 접근할 때 기준ㅇ ㅣ되는 열
  - 데이터를 조회하면 클러스터링키로 지정된 필드에서 시작하여 클러스터링된 테이블의 데이터를 조회

- 클러스터(Cluster)의 특징
  - 데이터 조회 속도는 향상되나 데이터 입력/수정/삭제에 대한 성능은 저하
  - 데이터의 분포도가 넓을수록 유리
  - 저장 공간 절약
  - 대용량 처리 트랜잭션은 풀 테이블 스캔이 빈번하여 클러스터링을 지양
  - 처리 범위가 넓은 경우 단일 테이블 클러스터링, 조인이 많이 발생하는 경우 다중 테이블 클러스터링 사용
  - 파티셔닝 된 테이블에는 클러스터링 불가
  - 디크스 I/O 감소
  - 클러스터링된 테이블에 클러스터드 인덱스를 생성하면 접근 성능 향상

- 클러스터 대상 테이블
  - 분포도가 넓은 테이블
  - 대량의 범위를 자주 조회하는 테이블
  - 입력/수정/삭제가 자주 발생하지 않는 테이블
  - 자주 조인되어 사용되는 테이블
  - Order by, Group by, UNION이 빈번한 테이블

<br>

### 파티션 설계 A
> 대용량의 테이블이나 인덱스를 작은 논리적 단위인 파티션으로 나누는 것

- 개요
  - 대용량 DB의 경우 중요한 몇 개의 테이블에만 집중되어 데이터가 증가
    - 해당 테이블을 작은 단위로 나눠 분산시키면 성능 저하를 방지하고 데이터의 관리가 용이해짐
  - 파티션키 또는 인덱스키에 따라 물리적으로 별도의 공간에 데이터가 저장
  - 데이터 처리는 테이블 단위로, 데이터 저장은 파티션별로 수행

- 파티션의 장단점
  - 장점
    - 데이터의 접근 시 액세스 범위가 줄어 쿼리 성능 향상
    - 데이터가 분산되어 저장되므로 디스크의 성능 향상
    - 파티션별로 백업 및 복구를 수행하므로 속도가 빠름
    - 시스템 장애 시 데이터 손상 정도를 최소화
    - 데이터 가용성 향상
    - 파티션 단위로 I/O 분산
  - 단점
    - 하나의 테이블을 세분화하므로 세심한 관리 요구
    - 테이블간 조인에 대한 비용 증가
    - 용량이 작은 테이블에 파티셔닝을 수행하면 성능 저하

- 파티션의 종류
  - 범위 분할
    - 지정한 열의 값을 기준으로 분할
      - 일별, 월별, 분기별 등
  - 해시 분할
    - 해시 함수를 적용한 결과 값에 따라 데이터를 분할
    - 특정 파티션에 데이터가 집중되는 범위 분할의 단점을 보완
      - 데이터를 고르게 분산할 때 유용
    - 특정 데이터가 어디에 있는지 판단 불가
      - 고객번호, 주민번호 등과 같이 데이터가 고른 컬럼에 효과적
  - 조합 분할
    - 범위 분할로 분할한 다음 해시 함수를 적용하여 다시 분할
    - 범위 분할한 파티션이 너무 커서 관리가 어려울 때 유용

- 파티션키 선정 시 고려사항
  - 테이블 접근 유형에 따라 파티셔닝이 이뤄지도록 선정
  - 데이터 관리의 용이성을 위해 이력성 데이터는 파티션 생성주기와 소멸주기를 일치시켜야 함
  - 파티션키 선정 대상
    - 매일 생성되는 날짜 컬럼
    - 백업의 기준이 되는 날짜 컬럼
    - 파티션 간 이동이 없는 컬럼
    - I/O 병목을 줄일 수 있는 데이터 분포가 양호한 컬럼

- 인덱스 파티션
  - 파티션된 테이블의 데이터를 관리하기 위해 인덱스를 나눈 것
  - 파티션 된 테이블의 종속 여부에 따라 분류
    - 로컬 파티션 인덱스 : 테이블 파티션과 인덱스 파티션이 1:1 대응
    - 글로벌 파티션 인덱스 : 테이블 파티션과 인덱스 파티션이 독립적으로 구성
    - * 로컬 파티션 인덱스가 글로벌 파티션 인덱스에 비해 데이터 관리가 쉬움
  - 파티션키 컬럼의 위치에 따라 분류
    - 프리픽스 파티션 인덱스 : 인덱스 파티션키와 인덱스 첫 번째 컬럼이 동일
    - 논 프리픽스 파티션 인덱스 : 인덱스 파티션키와 인덱스 첫 번째 컬럼이 상이

<br>

### 데이터베이스 용량 설계 C

<hr>
<br>

## 통합 구현
### 연계 요구사항 분석 C

<br>

### 연계 데이터 식별 및 표준화 C

<br>

### 연계 메커니즘 정의 B

<br>

### 연계 장애 및 오류처리 구현 C

<br>

### 연계 데이터 보안 적용 C

<br>

### 연계 모듈 구현 환경 C

<br>

### XML B

<br>

### 연계 테스트 C

<hr>
<br>

## 서버 프로그램 구현
### 개발 환경 구축 B

<br>

### 모듈 A
> 모듈화를 통해 분리된 시스템의 각 기능
> - 서브루틴, 서브시스템, 소프트웨어 내의 프로그램, 작업 등과 같은 의미

- 개요
  - 모듈은 단독으로 컴파일이 가능하며 재사용할 수 있음
  - 모듈은 하나의 기능만을 수행하고 다른 모듈과의 과도한 상호작용을 배제함으로써 이루어짐
  - 독립성이 높은 모듈일수록 모듈을 수정해도 다른 모듈들에게 거의 영향을 주지 않으며 오류가 발생해도 쉽게 발견하고 해결 가능
  - 독립성은 결합도와 응집도에 의해 측정
    - 독립성을 높이려면 모듈의 결합도를 약하게 응집도를 강하게, 모듈의 크기는 작게 만들어야 함

- 결합도(Coupling)
  - 모듈 간에 상호 의존정도 또는 두 모듈 사이의 연관 관계를 의미
  - 결합도가 약할수록 품질이 높고, 강할수록 품질이 낮음
  - 결합도가 강하면 시스템 구현 및 유지보수 작업이 어려움
  - 결합도의 정도(위에서 아래로 결합도 약함 ↔ 결합도 강함)
    - 자료 결합도(Data Coupling)
    - 스탬프 결합도(Stamp Coupling)
    - 제어 결합도(Control Coupling)
    - 외부 결합도(External Coupling)
    - 공통 결합도(Common Coupling)
    - 내용 결합도(Content Coupling)
  - 자료 결합도
    - 모듈 간의 인터페이스가 자료 요소로만 구성될 때의 결합도
    - 어떤 모듈이 다른 모듈을 호출하면서 매개 변수나 인수로 데이터를 넘겨주고, 호출 받은 모듈은 받은 데이터에 대한 처리 결과를 다시 돌려주는 방식
    - 모듈 간의 내용을 전혀 알 필요가 없는 상태로 한 모듈의 내용을 변경하더라도 다른 모듈에는 전혀 영향을 미치지 않는 가장 바람직한 결합도
  - 스탬프(검인) 결합도
    - 모듈 간의 인터페이스로 배열이나 레코드 등의 자료 구조가 전달될 때의 결합도
    - 두 모듈이 동일한 자료 구조를 조회하는 경우의 결합도이며 자료 구조의 어떤 변화, 즉 포맷이나 구조의 변화는 그것을 조회하는 모든 모듈 및 변화되는 필드를 실제로 조회하지 않는 모듈에까지도 영향을 미치게 됨
  - 제어 결합도
    - 어떤 모듈이 다른 모듈 내부의 논리적인 흐름을 제어하기 위해 제어 신호를 이용하여 통신하거나 제어 요소(Function Code, Swtitch, Tag, Flag)를 전달하는 결합도
    - 한 모듈이 다른 모듈의 상세한 처리 절차를 알고 있어 이를 통제하는 경우나 처리 기능이 두 모듈에 분리되어 설계된 경우에 발생
    - 하위 모듈에서 상위 모듈로 제어 신호가 이동하여 하위 모듈이 상위 모듈에게 처리 명령을 내리는 권리 전도현상이 발생
  - 외부 결합도
    - 어떤 모듈에서 선언한 데이터(변수)를 외부의 다른 모듈에서 참조할 때의 결합도
    - 참조되는 데이터의 범위를 각 모듈에서 제한 가능
  - 공통(공유) 결합도
    - 공유되는 공통 데이터 영역을 여러 모듈이 사용할 때의 결합도
    - 공통 데이터 영역의 내용을 조금만 변경하더라도 이를 사용하는 모든 모듈에 영향을 미치므로 모듈의 독립성을 약하게 함
  - 내용 결합도
    - 한 모듈이 다른 모듈의 내부 기능 및 내부 자료를 직접 참조하거나 수정할 때의 결합도
    - 한 모듈에서 다른 모듈의 내부로 제어가 이동하는 경우에도 내용 결합도에 해당

- 응집도
  - 정보 은닉 개념을 확장한 것으로 명령어나 호출문 등 모듈의 내부 요소들의 서로 관련되어 있는 정도
    - 모듈이 독립적인 기능으로 정의되어 있는 정도를 의미
  - 응집도가 강할수록 품질이 높고, 약할수록 품질이 낮음
  - 응집도의 정도(위에서 아래로 응집도 약함 ↔ 응집도 강함)
    - 기능적 응집도(Functional Cohesion)
    - 순차적 응집도(Sequential Cohesion)
    - 교환적 응집도
    - 절차적 응집도
    - 시간적 응집도
    - 논리적 응집도
    - 우연적 응집도
  - 기능적 응집도
    - 모듈 내부의 모든 기능 요소들이 단일 문제와 연관되어 수행될 경우의 응집도
  - 순차적 응집도
    - 모듈 내 하나의 활동으로부터 나온 출력 데이터를 그 다음 활동의 입력 데이터로 사용할 경우의 응집도
  - 교환(통신)적 응집도
    - 동일한 입력과 출력을 사용하여 서로 다른 기능을 수행하는 구성 요소들이 모였을 경우의 응집도
  - 절차적 응집도
    - 모듈이 다수의 관련 기능을 가질 때 모듈 안의 구성 요소들이 그 기능을 순차적으로 수행할 경우의 응집도
  - 시간적 응집도
    - 특정 시간에 처리되는 몇 개의 기능을 모아 하나의 모듈로 작성할 경우의 응집도
  - 논리적 응집도
    - 유사한 성격을 갖거나 특정 형태로 분류되는 처리 요소들로 하나의 모듈이 형성되는 경우의 응집도
  - 우연적 응집도
    - 모듈 내부의 각 구성 요소들이 서로 관련 없는 요소로만 구성된 경우의 응집도

- 팬인(Fan-In)/팬아웃(Fan-Out)
  - 팬인 : 모듈에 들어오는 것, 어떤 모듈을 제어(호출)하는 모듈의 수
  - 팬아웃 : 모듈에서 나가는 것, 어던 모듈에 의해 제어(호출)되는 모듈의 수
  - 팬인/팬아웃을 분석하여 시스템의 복잡도를 알 수 있음
  - 팬인이 높다는 것은 재사용 측면에서 설계가 잘 되어있다고 볼 수 있음
    - 그러나 단일 장애점이 발생할 수 있으므로 중점적인 관리 및 테스트가 필요
    - 단일 장애점 : 시스템의 구성 요소 중 동작하지 않으면 전체 시스템이 중단되어 버리는 요소
  - 팬아웃이 높은 경우 불필요하게 다른 모듈을 호출하고 있는지 검토
    - 이를 단순화시킬 수 있는지 여부에 대한 검토 필요
  - 시스템의 복잡도를 최적화하려면 팬인은 높게, 팬아웃은 낮게 설계

<br>

### 공통 모듈 C

<br>

### DBMS 접속 B

<br>

### 서버 개발 C

<br>

### 서버 개발 과정 A
> DTO/VO, SQL, DAO, Service, Controller를 각각 구현하는 과정을 통해 이루어짐

- 서버 개발
  - 구현 순서는 개발자가 임의로 변경 가능
  - 개발하려는 서버 프로그램은 통합되거나 세분화될 수 있음
  - 모든 과정에서 보안 약점이 발생하지 않도록 소프트웨어 개발 보안 가이드를 참고

- DTO(Data Transfer Object)/VO(Value Object) 구현
  - 데이터 교환을 위해 사용할 객체를 만드는 과정
    - DTO : 데이터 교환을 위해 생성되는 객체
    - VO : DTO와 동일하나 읽기만 가능하며 변경이 불가능 
  - 변수 및 객체를 송수신할 데이터의 자료형(Data Type)에 맞게 생성
  - 알고리즘 등의 로직은 구현하지 않고 변수와 데이터를 저장하고 반환하는 메소드만 구현

- SQL 구현
  - 데이터의 삽입/변경/삭제 등의 작업을 수행할 SQL문을 생성하는 과정
  - 소스 코드 내에 직접 입력하거나 별도의 XML 파일로 저장하여 관리
  - XML 파일로 SQL문을 관리하는 경우 중복되는 SQL문을 최소화하고 유지보수가 용이

- DAO(Data Access Object) 구현
  - 데이터베이스에 접근하고 SQL을 활용하여 데이터를 실제로 조작하는 코드를 구현하는 과정

- Service 구현
  - 사용자의 요청에 응답하기 위한 로직을 구현하는 과정

- Controller 구현
  - 사용자의 요청에 적절한 서비스를 호출하여 그 결과를 사용자에게 반환하는 코드를 구현하는 과정
  - 스택 트레이스(Stack Trace) : 오류가 발생한 위치를 추적하기 위해 소프트웨어가 실행 중에 호출한 메소드의 리스트를 기록한 것

<br>

### 배치 프로그램 B

<hr>
<br>

## 화면 설계
### 사용자 인터페이스 A
> 사용자와 시스템 간의 상호작용이 원활하게 이뤄지도록 도와주는 장치나 소프트웨어
   
- 사용자 인터페이스의 세 가지 분야
  - 정보 제공과 전달을 위한 물리적 제어
  - 콘텐츠의 상세적인 표현과 전체적인 구성
  - 모든 사용자가 편리하고 간편하게 사용하도록 하는 기능

- 사용자 인터페이스의 구분
  - CLI(Command Line Interface) : 텍스트 환경의 인터페이스
  - GUI(Graphical User Interface) : 그래픽 환경의 인터페이스   
  - NUI(Natural User Interface) : 사용자의 말, 행동으로 조작하는 인터페이스

- 사용자 인터페이스의 기본 원칙
  - 직관성 : 누구나 쉽게 사용할 수 있는가?
  - 유효성 : 사용자의 목적을 정확히 이해했는가?
  - 학습성 : 누구나 쉽게 배울 수 있는가?
  - 유연성 : 사용자의 실수가 최소화되고 요구사항을 최대한 수용하는가?

- 사용자 인터페이스의 설계 지침
  - 사용자 중심
  - 일관성
  - 단순성
  - 결과 예측 가능
  - 가시성
  - 표준화
  - 접근성
  - 명확성
  - 오류 발생 해결

- UI 설계 도구

  |도구|개요|
  |---|---|
  |와이어프레임(Wireframe)|기획 단계의 초기에 제작|
  |목업(Mockup)|실제 화면과 유사하게 만든 정적인 형태의 모형|
  |스토리보드(Story Board)|콘텐츠에 대한 설명, 페이지 간 이동 흐름 등을 추가한 문서|
  |프로토타입(Prototype)|실제 구현된 것처럼 테스트가 가능한 동적인 형태의 모형|
  |유스케이스(Use Case)|사용자가 원하는 목표를 달성하기 위해 수행할 내용을 기술|

<br>

### UI 표준 및 지침 B
> 기술의 중립성(웹 표준), 보편적 표현 보장성(웹 접근성), 기능의 호환성(웹 호환성)이 고려되었는지 확인

- UI 표준 : 전체 시스템에 포함된 모든 UI에 공통적으로 적용될 내용으로 화면 구성이나 화면 이동 등이 포함
- UI 지침 : UI 요구사항, 구현 시 제약사항 등 UI 개발 과정에서 꼭 지켜야 할 공통의 조건

- 웹의 3요소
  - 웹 표준(Web Standards)
    - 웹 사이트 작성 시 이용하는 HTML, JavaScript 등에 대한 규정
    - 웹 페이지가 다른 기종이나 플랫폼에서도 구현되도록 제작하는 기법 등
  - 웹 접근성(Web Accessibility)
    - 누구나, 어떠한 환경에서도 웹 사이트에서 제공하는 모든 정보를 접근하여 이용할 수 있도록 보장
  - 웹 호환성(Cross Browsing)
    - 하드웨어나 소프트웨어 등이 다른 환경에서도 모든 이용자에게 동등한 서비스를 제공하는 것을 의미

- UI 스타일 가이드 작성
  - 구동환경 정의
    - 컴퓨터 OS, 웹 브라우저, 모니터 해상도, 프레임 세트 등을 사용 환경에 적합하도록 규정하는 단계
    - 프레임 세트 :업무 처리의 편의성이나 속도를 고려해 화면을 Top, Left, Contents 등의 영역으로 프레임을 구분해 적용
  - 레이아웃 정의
    - 화면 구조를 정의하고 각 영역의 메뉴를 구성하는 단계
    - 상단 메뉴 : 필수 영역으로 시스템 전체 페이지에 동일하게 적용
      - 시스템 로고, 로그인 사용자, 바로 가기 메뉴, 주 메뉴 등
    - 좌측 메뉴 : 선택 영역으로 서브 페이지에 선택적으로 적용
      - 서브 메뉴, 배너 등
    - 내용 구성 : 필수 영역으로 시스템의 전체 컨셉을 나타내는 메인 이미지와 시스템 별로 필요한 콘텐츠를 표시하는 부분
      - 메인 이미지, 시스템별 구성 콘텐츠 등
    - 하단 메뉴 : 선택 영역으로 회사 상황에 따라 표시 여부를 결정
      - 회사 CI(Corporate Identity), Copyright 등
  - 네비게이션 정의
    - 네비게이션의 메뉴 타입을 선택하여 적용하는 단계
  - 기능 정의
    - 시스템에 적용할 업무 과정에서 일어나는 모든 활동이나 필요한 데이터 간의 관계 등을 논리적 모델로 상세화하는 단계
    - 프로세스 모델링 정의
      - 시스템에 적용할 업무에서 발생할 수 있는 모든 활동들을 쉽게 파악할 수 있도록 업무 기능 모델링을 정의
    - 데이터 모델 정의
      - 업무 처리 과정에서 필요한 데이터를 엔티티로 정의하고, 이를 기반으로 엔티티 간의 관계를 논리적 데이터 모델로 정의
  - 구성 요소 정의
    - 화면에 표시할 그리드나 버튼 등을 정의하는 단계
    - 그리드 : 데이터를 테이블 형식으로 쉽게 표시할 수 있도록 해주는 도구로 그리드를 이용하여 화면에 표시할 데이터를 정의
    - 버튼 : 기능, 검색, 그리드 관련, 기타 버튼 4가지로 구분하여 정의

<br>

### UI 요구사항 확인 B
> 새로 개발할 시스템에 적용할 UI 관련 요구사항을 조사해서 작성하는 단계

- UI 요구사항 확인 순서
  - 목표 정의
    - 사용자들을 대상으로 인터뷰를 진행한 후 사용자들의 의견이 수렴된 비즈니스 요구사항을 정의
    - 인터뷰 진행 시 유의사항
      - 인터뷰는 가능하면 개별적으로 진행
      - 가능한 많은 사람을 인터뷰하여 다양한 의견을 수렴하되 개인의 중요한 의견을 놓치지 않도록 주의
      - 인터뷰는 한 시간을 넘지 않도록 함
      - 인터뷰 진행은 반드시 사용자 리서치를 시작하기 전에 진행
      - 리서치(Research) : 사용자들의 요구사항이나 불편사항 등을 파악하기 위해 진행되는 것으로 설문자소, 개인 인터뷰 등이 있음
  - 활동 정의
    - 조사한 요구사항을 토대로 해야 할 활동 사항을 정의
    - 내용
      - 사용자와 회사의 비전을 일치시키는 작업을 정의
      - 리서치 규모, 디자인 목표 등 각각에 필요한 예산과 일정 결정
      - 기술의 발전 가능성과 UI 디자인의 방향을 제시
      - 인터뷰 내용을 기반으로 프로젝트에 대해 정확히 이해하고 협의하도록 도움
      - 사업 전략 및 목표, 프로세스 책임자 선정, 회의 일정 및 게획 작성, 우선 순위 선정, 개별 단위 업무 구분
  - UI 요구사항 작성
    - 여러 경로를 통해 수집된 사용자들의 요구사항을 검토하고 분석하여 UI 개발 목적에 맞게 작성해야 함
    - 내용
      - 반드시 실사용자 중심으로 작성
      - 여러 사람의 인터뷰를 통해 다양한 의견을 수렴하여 작성
      - 해당 내용을 바탕으로 UI의 전체적인 구조 파악 및 검토
    - 작성 순서
      - 요구사항 요소 확인
      - 정황 시나리오 작성
      - 요구사항 작성

- 요구사항 요소 확인
  - 데이터 요구
    - 사용자가 요구하는 모델과 객체들의 특성을 기반으로 데이터 객체 정리
    - 인터페이스 구성에 영향을 미치므로 반드시 초기에 확인
      - 예 : 이메일의 메시지 속성은 제목, 발신일, 발신인, 참조인, 답변 등
  - 기능 요구
    - 사용자의 목적 달성을 위해 무엇을 실행해야 하는지를 동사형으로 설명
    - 기능 요구 리스트는 최대한 철저하게 정리
      - 예 : 사용자는 이메일의 메시지를 읽거나 삭제하고, 일정한 양식으로 다른 메시지와 함께 보관
  - 제품/서비스 품질
    - 데이터 및 기능 요구 외에 제품의 품질, 서비스, 감성적인 품질 등을 고려하여 작성
      - 예 : 시스템이 파일을 얼마나 빠르게 처리할 수 있는지 여부 등 정량화가 가능한 요구사항들을 확인
  - 제약 사항
    - 제품 완료 데드라인, 전체 개발 및 제작에 필요한 비용, 시스템 준수에 필요한 규제 포함
    - 사전에 제약사항의 변경 가능 여부를 확인

- 정황 시나리오 작성
  - 사용자의 요구사항을 도출하기 위해 작성하는 것으로 사용자가 목표를 달성하기 위해 수행하는 방법을 순차적으로 묘사한 것
    - 요구사항 정의에 사용되는 초기 시나리오
    - 개발하는 서비스의 모습을 상상하는 첫 번째 단계로 사용자 관점에서 시나리오를 작성
    - 사용자가 주로 사용하는 기능 위주로 작성하고, 함께 발생되는 기능들은 하나의 시나리오에 통합
    - 육하원칙에 따라 간결하고 명확하게 작성
    - 작성된 시나리오는 외부 전문가 또는 경험이 풍부한 사람에게 검토를 의뢰

- 요구사항 작성
  - 정황 시나리오를 토대로 작성

<br>

### UI 프로토타입 제작 및 검토 A
> 사용자 요구사항을 기반으로 실제 동작하는 것처럼 만든 테스트가 가능한 동적인 형태의 모형
> - 최종적으로 구현할 화면의 주요 기능을 직접 실행해 볼 수 있도록 미리 만든 임시 화면

- 개요
  - 검증하기 위한 것으로 최대한 간단하게 만들어야 한다.
  - 핵심적인 기능만을 제공하나 필요한 기능은 반드시 포함되어야 한다.
  - 계속하여 개선하고 보완해야한다.
  - 실제 사용자를 대상으로 테스트하는 것이 좋다.

- 장점 및 단점
  - 사용자를 설득하고 이해시키기 쉽다.
  - 요구사항과 기능의 불일치 등을 줄여 개발 시간을 줄일 수 있다.
  - 사전에 오류를 발견하여 개선할 수 있다.
  - 반복적인 개선 및 보완 작업 때문에 작업 시간이 증가되거나 필요 이상의 자원이 소모된다.
  - 누락시키는 프로토타이핑이 발생하여 중요한 작업이 생략될 수 있다.

- 프로토타이핑의 종류

  |프로토타이핑|개요|
  |--------|----|
  |페이퍼 프로토타입(Paper Prototype)|손으로 직접 작성하는 방법|
  |디지털 프로토타입(Digital Prototype)|프로그램을 사용하여 작성하는 방법|

- UI 프로토타입 제작 단계

  |단계|개요|
  |---|---|
  |1단계|요구사항 분석|
  |2단계|프로토타입 개발|
  |3단계|사용자의 확인|
  |4단계|개발에 대한 수정|

<br>

### UI 흐름 설계 B
> 업무의 진행 과정이나 수행 절차에 따른 흐름을 파악하여 화면과 폼을 설계하는 단계

- UI 흐름 설계 순서
  - 기능 작성
    - 화면에 표현할 기능을 작성하는 단계
    - 기능적 요구사항
      - 시스템의 입력으로 무엇이 포함되어야 하는가?
      - 시스템의 출력으로 무엇이 포함되어야 하는가?
      - 시스템이 어떤 데이터를 저장해야 하는가?
      - 시스템이 어떤 연산을 수행해야 하는가?
    - 비기능적 요구사항
      - 사용성, 효율성, 신뢰성, 유지 보수성, 재사용성 등 품질에 관한 요구사항으로 어떤 것들이 있는지 검토
      - 플랫폼, 사용 기술 등 시스템 환경에 관한 요구사항으로 어떤 것들이 있는지 분석
  - 입력 요소 확인
    - 화면에 표현되어야 할 기능을 확인한 수 화면에 입력할 요소를 확인하는 단계
  - 유스케이스 설계
    - UI 요구사항을 기반으로 UI 유스케이스를 설계하는 단계
  - 기능 및 양식 확인
    - 분석한 기능을 토대로 텍스트 박스, 콤보 박스, 라디오 박스, 체크 박스 등을 확인하고 규칙 정의

<br>

### UI 상세 설계 B
> 실제 설계 및 구현을 위해 모든 화면에 대해 자세하게 설계를 진행하는 단계

- UI 상세 설계 순서
  - 요구사항 확인
    - UI 상세 설계를 위한 요구사항을 최종적으로 확인하는 단계
  - UI 설계서 표지 및 개정 이력 작성
    - 다른 문서와 혼동되지 않도록 프로젝트명이나 시스템명을 포함시켜 작성
  - UI 구조 설계
    - UI 요구사항과 UI 프로토타입에 기초하여 UI 구조를 설계하는 단계
  - 메뉴 구조 설계
    - 사이트 맵 구조를 통해 사용자 기반 메뉴 구조를 설계하는 단계
  - 화면 설계
    - UI 프로토타입과 UI 프로세스를 참고하여 필요한 화면을 페이지별로 설계하는 단계

<hr>
<br>

## 에플리케이션 테스트 관리
### 애플리케이션 테스트 B
> 애플리케이션에 잠재되어 있는 결함을 찾아내는 일련의 행위 또는 절차
> - 확인(Validation) : 개발된 소프트웨어가 고객의 요구사항을 만족시키는가?
> - 검증(Verification) : 소프트웨어가 기능을 정확히 수행하는가?

- 애플리케이션 테스트의 기본 원리
  - 완벽한 테스트 불가능
    - 완벽한 소프트웨어 테스팅은 불가능
  - 결함 집중
    - 애플리케이션의 20%에 해당하는 코드에서 전체 결함 80%가 발견된다고 하여 파레토 법칙을 적용하기도 함
  - 살충제 패러독스
    - 동일한 테스트 케이스로 동일한 테스트를 반복하면 더 이상 결함이 발견되지 않으므로 테스트 케이스를 지속적으로 보완 및 개선해야 함
  - 정황 의존
    - 소프트웨어 특징, 테스트 환경, 테스터 역량 등 정황(Context)에 따라 테스트 결과가 달라질 수 있으므로 정황에 따라 테스트를 다르게 수행해야 함
  - 오류-부재의 궤변
    - 소프트웨어의 결함을 모두 제거해도 사용자의 요구사항을 만족시키지 못하면 해당 소프트웨어는 품질이 높다고 말할 수 없음
  - 위험 반비례
    - 테스트를 많이 하면 할 수록 미래에 발생할 위험을 줄일 수 있음
  - 점진적 확대
    - 작은 부분에서 시작해 점점 확대하며 진행해야 함
  - 별도 팀 수행
    - 개발자와 관계없는 별도의 팀에서 수행해야 함

<br>

### 애플리케이션 테스트의 분류 B
- 프로그램의 실행 여부에 따른 분류
  - 정적 테스트
    - 프로그램을 실행하지 않고 명세서나 소스 코드를 대상으로 분석하는 테스트
    - 소프트웨어 개발 초기에 결함을 발견할 수 있어 소프트웨어 개발 비용을 낮추는데 도움이 됨
    - 종류 : 워크스루, 인스펙션, 코드 검사 등
  - 동적 테스트
    - 프로그램을 실행하여 오류를 찾는 테스트로 소프트웨어 개발의 모든 단계에서 테스트를 수행할 수 있음
    - 종류 : 블랙박스 테스트, 화이트박스 테스트

- 테스트 기반에 따른 테스트
  - 명세 기반 테스트
    - 사용자의 요구사항에 대한 명세를 빠짐없이 테스트 케이스로 만들어 구현하고 있는지 확인하는 테스트
    - 종류 : 동등 분할, 경계 값 분석 등
  - 구조 기반 테스트
    - 소프트웨어 내부의 논리 흐름에 따라 테스트 케이스를 작성하고 확인하는 테스트
    - 종류 : 구문 기반, 결정 기반, 조건 기반, 결정 기반 등
  - 경험 기반 테스트
    - 유사 소프트웨어나 기술 등에 대한 테스트의 경험을 기반으로 수행하는 테스트
    - 사용자의 요구사항에 대한 명세구 불충분하거나 테스트 시간에 제약이 있는 경우 수행하면 효과적
    - 종류 : 에러 추정, 체크 리스트, 탐색적 테스팅

- 시각에 따른 테스트
  - 검증(Verification) 테스트
    - 개발자의 시각에서 제품의 생산 과정을 테스트하는 것으로 제품이 명세대로 완성되었는지 테스트
  - 확인(Validation) 테스트
    - 사용자의 시각에서 생산된 제품의 결과를 테스트하는 것으로, 사용자가 요구한대로 제품이 완성되었는지, 정상적으로 동작하는지 테스트

- 목적에 따른 테스트
  - 회복(Recovery) 테스트
    - 시스템에 여러 결함을 주어 실패하도록 한 후 올바르게 복구되는지를 확인하는 테스트
  - 안전(Security) 테스트
    - 시스템에 설치된 시스템 보호 도구가 불법적인 침입으로부터 시스템을 보호할 수 있는지 확인하는 테스트
  - 강도(Stress) 테스트
    - 시스템에 과도한 정보량이나 빈도 등을 부과하여 과부하 시에도 소프트웨어가 정상적으로 실행되는지를 확인하는 테스트
  - 성능(Performance) 테스트
    - 소프트웨어의 실시간 성능이나 전체적인 효율성을 진단하는 테스트로, 소프트웨어의 응답 시간, 처리량 등을 테스트
  - 구조(Structure) 테스트
    - 소프트웨어 내부의 논리적인 경로, 소스 코드의 복잡도 등을 평가하는 테스트
  - 회귀(Regression) 테스트
    - 소프트웨어의 변경 또는 수정된 코드에 새로운 결함이 없음을 확인하는 테스트
  - 병행(Parallel) 테스트
    - 변경된 소프트웨어와 기존 소프트웨어에 동일한 데이터를 입력하여 결과를 비교하는 테스트

<br>

### 테스트 기법에 따른 애플리케이션 테스트 A
> 화이트박스 테스트 : 내부의 논리적인 경로를 테스트
> - 선택, 반복 등의 분기점 부분들을 수행함으로써 논리적인 경로를 제어

- 화이트박스 테스트의 종류

  |테스트 종류|개요|
  |--------|---|
  |기초 경로 검사|대표적인 화이트 테스트 기법|
  |제어 구조 검사|조건 검사, 루프 검사, 데이터 흐름 검사|

  - 조건 검사(Contition Testing) : 논리적 조건 테스트
  - 루프 검사(Loop Testing) : 반복 구조 테스트
  - 데이터 흐름 검사(Data Flow Testing) : 변수 등의 데이터 제어 테스트

- 화이트박스 테스트의 검증 기준
  - 문장 검증 기준 : 소스 코드의 모든 구문이 한 번 이상 수행되는 테스트 케이스
  - 분기 검증 기준 : 소스 코드의 모든 조건문이 한 번 이상 수행되는 테스트 케이스
  - 조건 검증 기준 : 소스 코드의 모든 조건문이 true 와 false 일 때 한 번 이상 수행되는 테스트 케이스
  - 분기/조건 기준 : 소스 코드의 모든 조건문과 각 조건문의 조건식 결과가 true 와 false 일 때 한 번 이상 수행되는 테스트 케이스

- 검증 기준의 종류
  - 기능 기반 커버리지 : 실제 테스트가 수행된 기능의 수 / 전체 기능의 수
  - 라인 커버리지 : 테스트 시나리오가 수행한 소스 코드의 라인 수 / 전체 소스 코드의 라인 수
  - 코드 커버리지 : 소스 코드의 구문, 분기, 조건 등의 구조 코드 자체가 얼마나 테스트 되었는지 측정한 수

> 블랙박스 테스트 : 각 기능이 완전히 작동되는 것을 입증하는 기능 테스트
> - 사용자의 요구사항 명세를 보면서 테스트하며 주로 구현된 기능을 확인

- 블랙박스 테스트의 종류
  - 동치 분할 검사 : 입력 자료에 초점을 두는 테스트 케이스
  - 경계값 분석 : 입력 조건의 경계값으로 확인하는 테스트 케이스
  - 원인-효과 그래프 검사 : 입력 데이터 간의 관계와 출력을 확인하는 테스트 케이스
  - 오류 예측 검사 : 과거의 경험이나 확인자의 감각을 초점에 두는 테스트 케이스
  - 비교 검사 : 여러 버전의 프로그램에 동일한 테스트 자료를 제공하여 동일한 결과가 나오는지 확인하는 테스트 케이스

<br>

### 개발 단계에 따른 애플리케이션 테스트 A
> 소프트웨어 개발 단계에서부터 테스트를 수행
> - 소프트웨어에 포함된 코드 상의 오류 및 요구 분석의 오류, 설계 인터페이스 오류 등도 발견
> - V-모델 : 애플리케이션 테스트와 소프트웨어 개발 단계를 연결하여 표현한 것

- 애플리케이션 테스트의 순서
  - 단위 테스트 : 모듈에 대한 테스트
  - 통합 테스트 : 모듈을 결합하여 시스템으로 완성시키는 과정에서의 테스트
  - 시스템 테스트 : 시스템에서 정상적으로 수행되는지를 확인하기 위한 테스트
  - 인수 테스트 : 사용자에게 인도하기 전에 수행하는 테스트

- 단위 테스트(Unit Test)
  - 모듈이나 컴포넌트에 초점을 맞춰 테스트하는 것
  - 사용자의 요구사항을 기반으로 한 기능성 테스트를 최우선으로 수행

    |테스트 방법|테스트 내용|테스트 목적|
    |--------|--------|---------|
    |구조 기반 테스트|화이트박스 테스트 시행|제어 흐름, 조건 결정|
    |명세 기반 테스트|블랙박스 테스트 시행|동등 분할, 경계 값 분석|

- 통합 테스트(Intergration Test)
  - 단위 테스트과 완료된 모듈들을 결합하여 시행하는 테스트
  - 상호 작용 오류를 검사

- 시스템 테스트(System Test)
  - 개발된 소프트웨어가 완벽하게 수행되는가를 점검하는 테스트

    |테스트 방법|테스트 내용|
    |--------|--------|
    |기능적 요구사항|블랙박스 테스트 시행|
    |비기능적 요구사항|화이트박스 테스트 시행|

- 인수 테스트(Acceptance Test)
  - 사용자의 요구사항을 충족하는지에 중점을 두고 테스트
  - 사용자가 직접 테스트

    |테스트 종류|테스트 내용|
    |--------|--------|
    |사용자 인수 테스트|사용자가 시스템 사용의 적절성 여부 테스트|
    |운영자 인수 테스트|시스템 관리자가 시스템 인수 시 수행하는 테스트|
    |계약 인수 테스트|계약상의 인수/검수 조건을 준수하는지 테스트|
    |규정 인수 테스트|정부 지침, 법규, 규정 등에 맞게 개발되었는지 테스트|
    |알파 테스트|사용자와 개발자가 함께 확인하며 기록하는 테스트|
    |베타 테스트|실업무를 통해 사용자가 직접 테스트|

<br>

### 통합 테스트 A
> 단위테스트가 끝난 모듈을 통합하는 과정에서 발생하는 오류 및 결함을 찾는 테스트 기법

|통합 테스트 방법|개요|
|------------|---|
|비점진적 통합 방식|규모가 작은 소프트웨어 유리하며 단시간 내에 테스트가 가능하며 빅뱅 통합 테스트가 존재|
|점진적 통합 방식|모듈 단위로 단계적 통합을 거쳐 테스트하는 방법으로 하향식, 상향식, 혼합식 통합 방식이 존재|

- 하향식 통합 테스트
  - 상위 모듈에서 하위 모듈 방향으로 통합하면서 테스트
  - 테스트 초기부터 사용자에게 시스템 구조를 보여줄 수 있음
  - 깊이 우선 통합법 : 주요 제어 모듈을 중심으로 해당 모듈에 종속된 모든 모듈을 통합
  - 넓이 우선 통합법 : 구조의 수평을 중심으로 해당하는 모듈을 통합
  - 테스트 스텁 : 일시적으로 필요한 조건만을 가지고 있는 시험용 모듈
  - 회귀 테스트 : 이미 테스트된 프로그램의 테스팅을 반복

- 상향식 통합 테스트
  - 하위 모듈에서 상위 모듈 방향으로 통합하면서 테스트
  - 데이터의 입출력을 확인하기 위해 드라이버를 작성

- 혼합식 통합 테스트
  - 하위 수준에서 상향식 통합, 상위 수준에서 하향식 통합을 사용하여 최적의 테스트를 지원하는 방식
  - 샌드위치식 통합 테스트 방법이라고도 함

- 회귀 테스팅
  - 이미 테스트된 프로그램의 테스팅을 반복
  - 시간과 비용이 많이 필요
  - 선정 방법
    - 모든 애플리케이션의 기능을 수행할 수 있는 대표적인 테스트 케이스를 선정
    - 파급 효과가 높은 부분이 포함된 테스트 케이스를 선정
    - 실제 수정이 발생한 모듈 또는 컴포넌트에서 시행하는 테스트 케이스를 선정

<br>

### 애플리케이션 테스트 프로세스 B
> 개발된 소프트웨어가 사용자의 요구대로 만들어졌는지, 결함은 없는지 등을 테스트하는 절차

- 테스트 프로세스
  - 테스트 게획
    - 프로젝트 계획서, 요구 명세서 등을 기반으로 테스트 목표를 정의하고 테스트 대상 및 범위를 결정
    - 테스트 시작 및 종료 조건을 정의
      - 테스트 시작 조건 : 모든 조건이 만족되거나 만족되지 않아도 테스트를 시작하도록 지정
      - 테스트 종료 조건 : 정상적으로 테스트를 완료한 경우, 테스트 일정이 만료된 경우, 테스트 비용이 모두 소진된 경우 등 테스트 종료 조건을 다르게 지정
  - 테스트 분석 및 디자인
    - 테스트의 목적과 원칙을 검토하고 사용자의 요구사항을 분석
    - 테스트 데이터
      - 실제 데이터 : 선행된 연산에 의해 만들거나 실제 운영되는 데이터를 복제한 데이터
      - 가상 데이터 : 스크립트를 통해서 인위적으로 만든 데이터
  - 테스트 케이스 및 시나리오 작성
    - 테스트 케이스의 설계 기법에 따라 테스트 케이스를 작성하고 검토 및 확인 후 테스트 시나리오를 작성
    - 테스트용 스크립트를 작성하기도 함
  - 테스트 수행
    - 테스트 환경을 구축한 후 테스트를 수행
    - 하드웨어, 소프트웨어, 가상 시스템 등
  - 테스트 결과 평가 및 리포팅
    - 테스트 결과를 비교 분석하여 테스트 결과서를 작성
  - 결함 추적 및 관리
    - 테스트를 수행한 후 결함이 어디에서 발생했는지, 어떤 종류의 결함인지 등을 추적하고 관리
    - 결함 관리 프로세스
      - 에러 발견 : 에러가 발견되면 테스트 전문가와 프로젝트팀이 논의
      - 에러 등록 : 발견된 에러를 결함 관리 대장에 등록
      - 에러 분석 : 등록된 에러가 실제 결함인지 아닌지를 분석
      - 결함 확정 : 등록된 에러가 실제 결함이면 결함 확정 상태로 설정
      - 결함 할당 : 결함을 해결할 담당자에게 결함을 할당하고 결함 할당 상태로 설정
      - 결함 조치 : 결함을 수정하고, 수정이 완료되면 결함 조치 상태로 설정
      - 결함 조치 검토 및 승인 : 수정이 완료된 결함에 대해 확인 테스트를 수행하고, 이상이 없으면 결함 조치 완료 상태로 설정

<br>

### 테스트 케이스 / 테스트 시나리오 / 테스트 오라클 B
- 테스트 케이스
  - 구현된 소프트웨어가 사용자의 요구사항을 정확하게 준수했는지를 확인하기 위해 설계된 입력 값, 실행 조건, 기대 결과 등으로 구성된 테스트 항목에 대한 명세서
  - 명세 기반 테스트의 설계 산출물에 해당
  
- 테스트 케이스 작성 순서
  - 테스트 계획 검토 및 자료 확보
    - 시스템 요구사항과 기능 명세서를 검토하고 테스트 대상 시스템의 정보를 확보
  - 위험 평가 및 우선순위 결정
    - 결함의 위험 정도에 따른 우선순위 및 어느 부분에 초점을 맞춰 테스트할 것인지 결정
  - 테스트 요구사항 정의
    - 시스템에 대한 사용자 요구사항이나 테스트 대상을 재검토하고, 테스트 특성, 조건, 기능 등을 분석
  - 테스트 구조 설계 및 테스트 방법 결정
    - 테스트 케이스의 형식과 분류 방법을 결정
    - 테스트 절차, 장비, 도구, 테스트 문서화 방법을 결정
  - 테스트 케이스 정의
    - 요구사항에 따라 테스트 케이스를 작성하고 입력 값과 실행 조건, 예상 결과 등을 기술
  - 테스트 케이스 타당성 확인 및 유지 보수
    - 소프트웨어의 기능 또는 환경 변화에 따라 테스트 케이스를 갱신
    - 테스트 케이스의 유용성 검토

- 테스트 시나리오
  - 테스트 케이스를 적용하는 순서에 따라 여러 개의 테스트 케이스를 묶은 집합

- 테스트 시나리오 작성 시 유의사항
  - 시스템별, 모듈별, 항목별 등과 같이 여러 개의 시나리오로 분리하여 작성
  - 사용자의 요구사항과 설계 문서 등을 토대로 작성
  - 테스트 항목은 식별자 번호, 순서 번호, 테스트 데이터, 테스트 케이스, 예상 결과, 확인 등을 포함하여 작성
  - 유스케이스 간 업무 흐름이 정상적인지를 테스트할 수 있도록 작성
  - 개발된 모듈 또는 프로그램 간의 연계가 정상적으로 동작하는지 테스트할 수 있도록 작성

- 테스트 오라클
  - 테스트 결과가 올바른지 판단하기 위해 사전에 정의된 참 값을 대입하여 비교하는 기법 및 활동
  - 특징
    - 제한된 검증 : 테스트 오라클은 모든 테스트 케이스에 적용할 수 없음
    - 수학적 기법 : 테스트 오라클의 값을 수학적 기법을 이용하여 구할 수 있음
    - 자동화 기능 : 테스트 대상 프로그램의 실행, 결과 비교, 커버리지 측정 등을 자동화할 수 있음

- 테스트 오라클의 종류
  - 참 오라클
    - 항공기, 은행, 발전소 소프트웨어 등 미션 크리티컬한 업무에 사용
    - 모든 테스트 케이스의 입력 값에 대해 기대하는 결과를 제공하는 오라클
    - 발생된 모든 오류를 검출할 수 있음
  - 샘플링 오라클
    - 일반적인 업무, 게임, 오락 등에 사용
    - 특정한 몇몇 테스트 케이스의 입력 값들에 대해서만 기대하는 결과를 제공하는 오라클
  - 추정 오라클
    - 샘플링 오라클을 개선한 오라클
    - 특정 테스트 케이스의 입력 값에 대해 기대하는 결과를 제공하고, 나머지 입력 값들에 대해서는 추정으로 처리하는 오라클
  - 일관성 검사 오라클
    - 애플리케이션의 변경이 있을 때, 테스트 케이스의 수행 전과 후의 결과 값이 동일한지를 확인하는 오라클

<br>

### 테스트 자동화 도구 B
> 사람이 반복적으로 수행하던 테스트 절차를 스크립트 형태로 구현하는 자동화 도구를 적용함으로써 쉽고 효율적으로 테스트를 수행
> - 테스트 자동화 도구를 사용함으로써 휴먼 에러(Human Error)를 줄이고 테스트의 정확성을 유지하면서 테스트의 품질을 향상

- 테스트 자동화 도구의 장단점
  - 장점
    - 인력 및 시간 절약
    - 향상된 테스트 품질 보장
    - 사용자 요구사항 검증
    - 테스트 결과의 객관적인 평가 기준 제공
    - 테스트 결과를 다양한 표시 형태로 제공
    - UI가 없는 서비스도 정밀 테스트 가능
  - 단점
    - 테스트 자동화 도구의 사용 방법에 대한 교육 및 학습 필요
    - 자동화 도구를 프로세스 단계별로 적용하기 위한 시간, 비용, 노력 필요
    - 비공개 상용 도구의 경우 고가의 추가 비용이 필요

- 테스트 자동화 도구의 유형
  - 정적 분석 도구
    - 프로그램을 실행하지 않고 분석하는 도구
    - 테스트를 수행하는 사람이 작성된 소스 코드를 이해하고 있어야만 분석이 가능
  - 테스트 실행 도구
    - 스크립트 언어를 사용하여 테스트를 실행하는 방법
    - 데이터 주도 접근방식
      - 스프레드시트에 테스트 데이터를 저장하고 이를 읽어 실행하는 방식
      - 다양한 테스트 데이터를 동일한 테스트 케이스로 반복하여 실행 가능
      - 미리 작성된 스크립트에 테스트 데이터만 추가하여 테스트 가능
    - 키워드 주도 접근방식
      - 스프레드시트에 테스트를 수행할 동작을 나타내는 키워드와 테스트 데이터를 저장하여 실행하는 방식
      - 키워드를 이용하여 테스트 정의 가능

<br>

### 결함 관리 B
> 결함 : 소프트웨어가 개발자의 설계한 바와 다르게 동작하거나 다른 결과가 발생하는 것

- 결함 관리 프로세스
  - 결함 관리 계획 : 전체 프로세스에 대한 결함 관리 일정, 인력, 업무 프로세스 등을 확보하여 계획을 수립하는 단계
  - 결함 기록 : 테스터는 발견된 결함을 결함 관리 DB에 등록
  - 결함 검토 : 테스터, 프로그램 리더, 품질 관리(QA) 담당자 등은 등록된 결함을 검토하고 결함을 수정할 개발자에게 전달
  - 결함 수정 : 개발자는 전달받은 결함을 수정한다.
  - 결함 재확인 : 테스터는 개발자가 수정한 내용을 확인하고 다시 테스트를 수행
  - 결함 상태 추적 및 모니터링 활동 : 결함 관리 DB를 이용하여 프로젝트별 결함 유형, 발생률 등을 한눈에 볼 수 있는 대시보드 또는 게시판 형태의 서비스를 제공
  - 최종 결함 분석 및 보고서 작성 : 발견된 결함에 대한 정보와 이해관계자들의 의견이 반영된 보고서를 작성하고 결함 관리를 종료

- 결함 상태 추적
  - 테스트에서 발견된 결함은 지속적으로 상태 변화를 추적하고 관리
    - 발견된 결함에 대해 결함 관리 측정 지표의 속성 값들을 분석하여 향후 결함이 발견될 모듈 또는 컴포넌트를 추정 가능
  - 결함 관리 측정 지표
    - 결함 분포 : 모듈 또는 컴포넌트의 특정 속성에 해당하는 결함 수 측정
    - 결함 추세 : 테스트 진행 시간에 따른 결함 수의 추이 분석
    - 결함 에이징 : 특정 결함 상태로 지속되는 시간 측정

- 결함 추적 순서
  - 결함 등록(Open) : 테스터와 품질 관리(QA) 담당자에 의해 발견된 결함이 등록된 상태
  - 결함 검토(Reviewed) : 등록된 결함을 테스터, 품질 관리(QA) 담당자, 프로그램 리더, 담당 모듈 개발자에 의해 검토된 상태
  - 결함 할당(Assigned) : 결함을 수정하기 위해 개발자와 문제 해결 담당자에게 결함이 할당된 상태
  - 결함 수정(Resolved) : 개발자가 결함 수정을 완료한 상태
  - 결함 조치 보류(Deferred) : 결함의 수정이 불가능해 연기된 상태로, 우선순위, 일정 등에 다라 재오픈을 준비중인 상태
  - 결함 종료(Closed) : 결함이 해결되어 테스터와 품질 관리(QA) 담당자가 종료를 승인한 상태
  - 결함 해제(Clarified) : 테스터, 프로그램 리더, 품질 관리(QA) 담당자가 종료 승인한 결함을 검토하여 결함이 아니라고 판명한 상태

- 결함 분류
  - 시스템 결함
    - 시스템 다운, 애플리케이션의 작동 정지, 종료, 응답 시간 지연, 데이터베이스 에러 등 주로 애플리케이션 환경이나 데이터베이스 처리에서 발생된 결함
  - 기능 결함
    - 사용자의 요구사항 미반영/불일치, 부정확한 비즈니스 프로세스, 스크립트 오류, 타 시스템 연동 시 오류 등 애플리케이션의 기획, 설계, 업무 시나리오 등의 단계에서 유입된 결함
  - GUI 결함
    - UI 비일관성, 데이터 타입의 표시 오류, 부정확한 커서/메시지 오류 등 사용ㅈ, 화면 설계에서 발생된 결함
  - 문서 결함
    - 사용자의 요구사항과 기능 요구사항의 불일치로 인한 불완전한 상태의 문서, 사용자의 온라인/오프라인 매뉴얼의 불일치 등 기획자, 사용자, 개발자 간의 의사소통 및 기록이 원활하지 않아 발생된 결함

- 테스트 단계별 유입 결함
  - 기획 시 유입되는 결함 : 사용자 요구사항의 표준 미준수로 인한 테스트 불가능, 요구사항 불명확/불완전/불일치 결함 등
  - 설계 시 유입되는 결함 : 설계 표준 미준수로 인한 테스트 불가능, 기능 설계 불명확/불완전/불일치 결함 등
  - 코딩 시 유입되는 결함 : 코딩 표준 미준수로 인한 기능의 불일치/불완전, 데이터 결함, 인터페이스 결함 등
  - 테스트 부족으로 유입되는 결함 : 테스트 수행 시 테스트 완료 기준의 미준수, 테스트팀과 개발팀의 의사소통 부족, 개발자의 코딩 실수로 인한 결함 등

- 결함 심각도
  - 애플리케이션에 발생한 결함이 전체 시스템에 미치는 치명도
  - 결함 심각도 우선순위
    - High : 핵심 요구사항 미구현, 장시간 시스템 응답 지연, 시스템 다운 등과 같이 더 이상 프로세스를 진행할 수 없도록 만드는 결함
    - Medium : 부정확한 기능이나 데이터베이스 에러 등과 같이 시스템 흐름에 영향을 미치는 결함
    - Low : 부정확한 GUI 및 메시지, 에러 시 메시지 미출력, 화면상의 문법/철자 오류 등과 같이 시스템 흐름에는 영향을 미치지 않는 결함

- 결함 우선순위
  - 발견된 결함 처리에 대한 신속성을 나타내는 척도
  - 결정적(Critical), 높음(High), 보통(Medium), 낮음(Low), 즉시해결, 주의 요망, 대기, 개선 권고 등

- 결함 관리 도구
  - Mantis : 결함 및 이슈 관리 도구로 소프트웨어 설계 시 단위별 작업 내용을 기록할 수 있어 결함 추적도 가능한 도구
  - Trac : 결함 추적은 물론 결함을 통합하여 관리할 수 있는 도구
  - Redmine : 프로젝트 관리 및 결함 추적이 가능한 도구
  - Bugzilla : 결함 신고, 확인, 처리 등 결함을 지속적으로 관리할 수 있는 도구로, 결함의 심각도와 우선순위를 지정 가능

<br>

### 애플리케이션 성능 분석 C

<br>

### 애플리케이션 성능 개선 C

<hr>
<br>

## SQL응용
### SQL : DDL C

<br>

### SQL : DCL C

<br>

### SQL : DML B
> 데이터베이스 사용자가 응용 프로그램이나 질의어를 통해 저장된 데이터를 실질적으로 관리하는데 사용되는 언어

- DML 유형
  - SELECT : 테이블에서 튜플을 검색
  - INSERT : 테이블에 새로운 튜플을 삽입
  - DELETE : 테이블에서 튜플을 삭제
  - UPDATE : 테이블에서 튜플의 내용을 갱신

- 삽입문(INSERT INTO)
  - 대응하는 속성과 데이터는 개수와 데이터 유형이 일치
  - 기본 테이블의 모든 속성을 사용할 때는 속성명 생략 가능
  - SELECT문을 사용하여 다른 테이블의 검색 결과를 삽입 가능

- 삭제문(DELETE FROM)
  - 모든 레코드를 삭제할 때는 WHERE절을 생략
  - 모든 레코드를 삭제하더라도 테이블 구조는 남아있음
    - 디스크에서 테이블을 완전히 제거하는 DROP과는 다름 

<br>

### DML : SELECT 1 A
> 일반형식, 기본 검색, 조건 지정 검색, 정렬 검색, 하위 질의, 복수 테이블 질의

- DISTINCT : 중복된 튜플 중 첫 번째 한 개만 검색
- DISTINCTROW : 중복된 튜플을 제거하고 한 개만 검색하나 선택된 속성의 값이 아니라 튜플 전체를 대상으로 함
- ORDER BY 절 : ASC 는 오름차순, DESC 는 내림차순, 생략하면 오름차순으로 지정
- 날짜 데이터는 숫자로 취급하지만 ' ' 또는 # #으로 묶어줌

<br>

### DML : SELECT 2 A
- WINDOW 함수 : GROUP BY 절을 이용하지 않고 속성의 값을 집계할 함수를 기술
  - PARTITION BY : WINDOW 함수가 적용될 범위로 사용할 속성을 지정

|그룹함수|개요|
|-----|----|
|COUNT(속성명)|그룹별 튜플 수를 구함|
|SUM(속성명)|그룹별 합계를 구함|
|AVG(속성명)|그룹별 평균을 구함|
|MAX(속성명)|그룹별 최대값을 구함|
|MIN(속성명)|그룹별 최소값을 구함|
|STDDEV(속성명)|그룹별 표준편차를 구함|
|VARIANCE(속성명)|그룹별 분산을 구함|
|ROLLUP(속성명)|인수로 주어진 속성을 대상으로 그룹별 소계를 구함|
|CUBE(속성명)|인수로 주어진 속성을 대상으로 모든 조합의 그룹별 소계를 구함|

<br>

### 프로시저 A
> 일종의 트랜잭션 언어로 데이터베이스에 저장되어 수행되므로 스토어드 프로시저라고도 불림
> - 일일 마감 작업, 일괄 작업 등에 주로 사용

<br>

### 트리거 B
> 삽입, 갱신, 삭제 등의 이벤트가 발생할 때마다 관련 작업이 자동으로 수행되는 절차형 SQL

- 개요
  - 트리거는 데이터베이스에 저장되며, 데이터 변경 및 무결성 유지, 로그 메시지 출력 등의 목적으로 사용
  - 트리거의 구문에는 DCL(데이터 제어어)을 사용할 수 없으며, DCL이 포함된 프로시저나 함수를 호출하는 경우에도 오류가 발생
  - 트리거에 오류가 있는 경우 트리거가 처리하는 데이터에도 영향을 미치므로 트리거 생성 시 주의

- 트리거의 구성
  - 선언, 이벤트, 시작, 종료로 구성
  - 시작과 종료 구문 사이에는 제어(CONTROL), SQL, 예외(EXCEPTION)가 포함
  - 구성도
    - DECLARE : 트리거의 명칭, 변수 및 상수, 데이터 타입을 정의하는 선언부
    - EVENT : 트리거가 실행되는 조건을 명시
    - BEGIN / END : 트리거의 시작과 종료를 의미
    - CONTROL : 조건문 또는 반복문이 삽입되어 순차적으로 처리
    - SQL : DML문이 삽입되어 데이터 관리를 위한 조회, 추가, 수정, 삭제 작업을 수행
    - EXCEPTION : BEGIN ~ END 안의 구문 실행 시 예외가 발생하면 이를 처리하는 방법을 정의

- 트리거의 생성
  - 표기 형식
    ```sql
    CREATE [OR REPLACE] TRIGGER 트리거명 [동작시기 옵션][동작 옵션] ON 테이블명
    REFERENCING [NEW | OLD] AS 테이블명
    FOR EACH ROW
    [WHEN 조건식]
    BEGIN
      트리거 BODY;
    END;
    ```
    - OR REPLACE : 선택적 예약어, 동일한 트리거 이름이 존재하는 경우 기존의 트리거를 대체 가능
    - 동작시기 옵션 : 트리거가 실행될 때를 지정
      - AFTER : 테이블이 변경된 후 트리거 실행
      - BEFORE : 테이블이 변경되기 전 트리거 실행
    - 동작 옵션 : 트리거가 실행되게 할 작업의 종류 지정
      - INSERT : 테이블에 새로운 튜플을 삽입할 때 트리거 실행
      - DELETE : 테이블의 튜플을 삭제할 때 트리거 실행
      - UPDATE : 테이블의 튜플을 수정할 때 트리거 실행
    - NEW | OLD : 트리거가 적용될 테이블의 별칭 지정
      - NEW : 추가되거나 수정에 참여할 튜플들의 집합(테이블)
      - OLD : 수정되거나 삭제 전 대상이 되는 튜플들의 집합(테이블)
    - FOR EACH ROW : 각 튜플마다 트리거를 적용한다는 의미
    - WHEN 조건식 : 선택적 예약어, 트리거를 적용할 튜플의 조건 지정
    - 트리거 BODY : 트리거의 본문 코드를 입력하는 부분으로 적어도 하나 이상의 SQL문이 존재하지 않으면 오류 발생

<br>

### 사용자 정의 함수 B
- 개요
  - 프로시저와 유사하게 SQL을 사용하여 일련의 작업을 연속적으로 처리하며, 종료 시 처리 결과를 단일값으로 반환하는 절차형 SQL
  - 데이터베이스에 저장되어 SELECT, INSERT, DELETE, UPDATE 등 DML문의 호출에 의해 실행
  - 예약어 RETURN을 통해 값을 반환하므로 출력 파라미터가 없음
  - SELECT문을 통해 조회만 가능하며 데이터 조작은 불가능
  - 프로시저를 호출하여 사용할 수 없음
  - 내장 함수처럼 DML문에서 반환값을 활용하기 위한 용도로 사용

- 사용자 정의 함수의 구성
  - 프로시저와 유사하며 프로시저의 구성에서 RETURN만 추가
  - 구성도
    ```sql
    DECLARE (필수)
    BEGIN (필수)
      CONTROL
      SQL
      EXCEPTION
      RETURN (필수)
    END (필수)
    ```
    - DECLARE : 사용자 정의 함수의 명칭, 변수, 인수, 데이터 타입을 정의하는 선언부
    - BEGINB / END : 사용자 정의 함수의 시작과 종료를 의미
    - CONTROL : 조건문 또는 반복문이 삽입되어 순차적으로 처리
    - SQL : SELECT문이 삽입되어 데이터 조회 작업을 수행
    - EXCEPTION : BEGIN ~ END 안의 구문 실행 시 예외가 발생하면 이를 처리하는 방법을 정의
    - RETURN : 호출 프로그램에 반환할 값이나 변수를 정의

- 사용자 정의 함수 생성
  ```sql
  CREATE [OR REPLACE] FUNCTION 사용자 정의 함수명(파라미터)
  [지역변수 선언]
  BEGIN
    사용자 정의 함수 BODY;
    RETURN 반환값;
  END;
  ```
  - OR REPLACE : 선택적 예약어, 동일한 사용자 정의 함수명이 존재하는 경우 기존의 사용자 정의 함수 대체 가능
  - 파라미터
    - IN : 호출 프로그램이 사용자 정의 함수에게 값을 전달할 때 지정
    - 매개변수명 : 호출 프로그램으로부터 전달받은 값을 저장할 변수의 이름을 저장
    - 자료형 : 변수의 자료형을 지정
  - 사용자 정의 함수 BODY
    - 사용자 정의 함수의 코드를 기록하는 부분으로 적어도 하나 이상의 SQL문이 존재하지 않으면 오류 발생
  - RETURN 반환값 : 반환할 값이나 반환할 값이 저장된 변수를 호출 프로그램으로 반환

<br>

### 제어문 A
> 절차형 SQL의 서술된 순서에 따라 진행되는 특징을 변경하기 위해 사용

<br>

### 커서 A
> 메모리 공간을 가리키는 포인터
> - 자동으로 생성되어 사용되는 묵시적 커서와 사용자가 직접 정의해서 사용하는 명시적 커서가 존재

- 개요
  - 커서의 수행은 열기, 패치, 닫기의 세 단계로 진행
    - 묵시적 커서는 각 단계가 자동으로 수행되나 명시적 커서는 직접 구현하여야 함

<hr>
<br>

## 소프트웨어 개발 보안 구축
### 소프트웨어 개발 보안 A
> 데이터의 기밀성, 무결성, 가용성을 유지하는 것이 목표

- 안전한 소프트웨어 개발을 위한 수행 작업
  - 프로젝트 참여자들의 역할과 책임을 명확히 정의하고 충분한 보안 교육을 실시
  - 소프트웨어 개발 생명주기(SDLC)의 각 단계마다 보안 활동을 수행
  - 표준을 확립
  - 재사용이 가능한 보안 모듈을 작성
  - 보안 통제의 효과성 검증을 실시

- 소프트웨어 개발 보안 관련 기관
  - 행정안전부
    - 개발 보안 정책 총괄
    - 관련 법규, 지침, 제도 정비
    - 보안 약점을 진단하는 사람의 양성 및 관련 업무 수행
  - 한국인터넷진흥원
    - 정책 및 가이드 개발
    - 기술 지원
    - 교육과정 및 자격제도 운영
  - 발주기관
    - 계획 수립
    - 사업자 및 감리법인 선정
    - 준수 여부 점검
  - 사업자
    - 기술 수준 및 적용 계획 명시
    - 인력을 대상으로 교육 실시
    - 가이드를 참조하여 개발
    - 보안 약점을 진단하고 제거
    - 시정 요구사항을 이행
  - 감리법인
    - 감리 계획을 수립하고 협의
    - 제거 여부 및 조치 결과를 확인

- 소프트웨어 개발 보안 활동 관련 법령
  - 개인정보 보호법
    - 개인의 자유와 권리를 보호
  - 정보통신망 이용촉진 및 정보보호 등에 관한 법률
    - 정보통신 서비스를 이용하는 이용자들의 개인정보를 보호
  - 신용정보의 이용 및 보호에 관한 법률
    - 정보의 오남용 방지
  - 위치정보의 보호 및 이용 등에 관한 법률
    - 정보의 유출이나 오남용 방지
  - 표준 개인정보 보호 지침
    - 세부사항 규정
  - 개인정보의 안전성 확보 조치 기준
    - 최소한의 기준을 규정
  - 개인정보 영향평가에 관한 고시
    - 평가기관의 지정, 영향평가의 절차 등에 관한 세부기준을 규정

- 소프트웨어 개발 보안 활동 관련 기타 규정
  - RFID 프라이버시 보호 가이드라인
  - 위치정보의 보호 및 이용 등에 관한 법률
  - 위치정보의 관리적, 기술적 보호조치 권고 해설서
  - 바이오정보 보호 가이드라인
  - 뉴미디어 서비스 개인정보 보호 가이드라인

<br>

### Secure SDLC A
> SDLC에 보안 강화를 위한 프로세스를 포함한 것을 의미
> - Secure Software 사의 CLASP, Microsoft 사의 SDL 이 존재

- 보안요소
  - 기밀성 : 인가된 사용자에게만 접근 허용
  - 무결성 : 인가된 사용자만 수정
  - 가용성 : 합법적인 사용자인지를 확인하는 모든 행위
  - 부인 방지 : 송수신 증거를 제공

- 설계 단계에서의 보안 활동
  - 네트워크 : 네트워크를 분리하거나 방화벽을 설치
  - 서버 : 보안이 뛰어난 운영체제를 사용하고 외부접속에 대한 접근통제 실시
  - 물리적 보안 : 출입통제, 개발 공간 제한, 감시설비 설치
  - 개발 프로그램 : 허가되지 않은 프로그램을 통제하고 지속적인 데이터 무결성 검사 실시

- 구현 단계에서의 보안 활동
 - 표준 코딩 정의서 및 소프트웨어 개발 보안 가이드를 준수
 - 시큐어 코딩 : 보안 요소들을 고려하며 코딩

- 테스트 단계에서의 보안 활동
  - 정적 분석 도구, 동적 분석 도구 또는 모의 침투테스트를 통해 설계 단계에서 식별된 위협들의 해결여부 검증

<br>

### 세션 통제 B

<br>

### 입력 데이터 검증 및 표현 B

<br>

### 보안 기능 B

<br>

### 시간 및 상태 C

<br>

### 에러처리 B

<br>

### 코드 오류 B

<br>

### 캡슐화 C

<br>

### API 오용 C

<br>

### 암호 알고리즘 A
> 해시(Hash)를 사용하는 단방향 암호화 방식과 개인키 및 공개키로 분류되는 양방향 암호화 방식이 존재

- 개인키 암호화 기법
  - 동일한 키로 데이터를 암호화하고 복호화
  - 대칭 암호 기법 또는 단일키 암호화 기법이라고도 함
  - 한 번에 하나의 데이터 블록을 암호화 하는 블록 암호화 방식과 평문과 동일한 길이의 스트림을 생성하여 비트 단위로 암호화 하는 스트림 암호화 방식으로 분류
  - 종류
    - 블록 암호화 방식 : DES, SEED, AES, ARIA
    - 스트림 암호화 방식 : LFSR, RC4
  - 장점 : 암/복호화 속도가 빠르고 알고리즘이 단순하며 공개키 암호 기법보다 파일 크기가 작음
  - 단점 : 사용자가 증가하면 관리해야 할 키의 수가 상대적으로 많아짐

- 공개키 암호화 기법
  - 암호화할 때 사용하는 공개키는 데이터베이스 사용자에게 공개하고, 복호화할 때 사용하는 비밀키는 관리자가 비밀리에 관리
  - 비대칭 암호 기법이라고도 하며 RSA 기법이 대표적
  - 장점 : 키의 분배가 용이하고 관리애햐 할 키의 개수가 적음
  - 단점 : 암/복호화 속도가 느리고 알고리즘이 복잡하며 개인키 암호화 기법보다 파일 크기가 큼

- 공개키 기반 구조
  - X.509 방식 : 인증기관에서 발생하는 인증서를 기반으로 상호 인증을 제공
  - 비X.509 방식 : 국가별, 지역별로 맞게 보완하여 개발

- 양방향 알고리즘 종류
  - SEED
    - 한국인터넷진흥원에서 개발한 블록 암호화 알고리즘
    - 블록 크기는 128비트, 키 길이에 따라 128, 256으로 분리
  - ARIA
    - 국가정보원과 산학연합회가 개발한 블록 암호화 알고리즘
    - 학계, 연구기관, 정부의 영문 앞 글자로 구성
    - 블록 크기는 128비트, 키 길이에 따라 128, 192, 256으로 분리
  - DES
    - 미국 NBS 에서 발표한 개인키 암호화 알고리즘
    - DES를 3번 적용하여 보안을 강화한 3DES가 있음
    - 블록 크기는 64비트, 키 길이는 56비트
  - AES
    - 미국 표준 기술 연구소(NIST)에서 발표한 개인키 암호화 알고리즘
    - DES의 한계를 보완하기 위해 발표
    - 블록 크기는 128비트, 키 길이는 128, 192, 256으롷 분류
  - RSA
    - MIT에서 제안된 공개키 암호화 알고리즘
    - 큰 숫자를 소인수분해 하기 어렵다는 것에 기반하여 작성
    - 공개키와 비밀키를 사용하며 메시지를 열고 잠그는 상수(Const)를 키로 사용

- 해시(Hash)
  - 임의의 길이를 가진 데이터를 고정된 길이의 값이나 키로 변환하는 알고리즘
  - 정보보호의 다양한 분야에서 활용
  - 종류
    - SHA 시리즈
    - MD5
    - N-NASH
    - SNEFRU

<br>

## 응용 SW 기초 기술 활용
### 운영체제의 개념 A
> 컴퓨터 시스템의 자원들을 효율적으로 관리
> - 사용자가 컴퓨터를 편리하고 효과적으로 사용할 수 있는 환경을 제공하는 여러 프로그램의 모임
> - 컴퓨터 사용자와 컴퓨터 하드웨어 간의 인터페이스

- 운영체제의 목적
  - 처리 능력 향상, 사용 가능도 향상, 신뢰도 향상, 반환 시간 단축
  - 처리 능력 : 일정 시간 내에 시스템이 처리하는 일의 양
  - 반환 시간 : 시스템에 작업을 의뢰한 시간부터 처리가 완료될 때까지 걸리는 시간
  - 사용 가능도 : 시스템을 사용할 필요가 있을 때 즉시 사용 가능한 정도
  - 신뢰도 : 시스템이 주어진 문제를 정확하게 해결하는 정도

- 운영체제의 기능
  - 프로세서, 기억장치, 입출력장치, 파일 및 정보 등의 자원을 관리
  - 자원을 효율적으로 관리하기 위해 자원의 스케줄링 기능을 제공
  - 사용자와 시스템 간의 편리한 인터페이스를 제공
  - 시스템의 각종 하드웨어와 네트워크를 관리
  - 데이터를 관리하고 데이터 및 자원의 공유 기능을 제공
  - 시스템의 오류를 검사하고 복구
  - 자원 보호 기능을 제공
  - 입출력에 대한 보조 기능을 제공
  - 가상 계산기 기능을 제공

- 운영체제의 주요 자원 관리
  - 기억장치 관리 : 프로세스에게 메모리 할당 및 회수 관리 담당
  - 프로세스 관리 : 프로세스 스케줄링 및 동기화 관리 담당
  - 주변장치 관리 : 입출력장치 스케줄링 및 전반적인 관리 담당
  - 파일 관리 : 파일의 생성과 삭제, 변경, 유지 등의 관리 담당

- 운영체제의 종류
  - 단일 작업 처리 시스템 : MS-DOS
  - 다중 작업 처리 시스템 : Windows, UNIX, LINUX, MacOS

<br>

### 운영체제의 종류 B

<br>

### 운영체제의 기본 명령어 B

<br>

### 기억장치 관리 C

<br>

### 프로세스 관리 C

<br>

### 데이터베이스 개념 A
> 특정 조직의 업무를 수행하는 데 필요한 상호 관련된 데이터들의 모임

- 정의
  - 통합된 데이터 : 중복이 최소화된 데이터의 모임
  - 저장된 데이터 : 컴퓨터가 접근 가능한 저장 매체에 저장된 데이터
  - 운영 데이터 : 조직의 고유한 업무를 수행하는 데 없어서는 안 될 반드시 필요한 데이터
  - 공용 데이터 : 여러 응용 시스템들이 공동으로 소유 및 유지하는 데이터

- DBMS
  - 기존의 파일 시스템이 갖는 데이터의 종속성과 중복성의 문제를 해결하기 위해 제안된 시스템
  - 데이터베이스의 구성, 접근 방법, 유지관리에 대해 모든 책임을 짐
  - 필수 기능
    - 정의 기능 : 모든 응용 프로그램들이 요구하는 데이터 구조를 지원하기 위해 데이터베이스에 저장될 데이터의 조건을 명시하는 기능
    - 조작 기능 : 데이터 조작을 체계적으로 처리하기 위해 사용자와 데이터베이스 사이에 인터페이스 수단을 제공하는 기능
    - 제어 기능 : 데이터베이스를 접근하는 수정 작업이 정확하게 수행되어 데이터의 무결성이 유지되도록 제어하는 기능

- DBMS의 종류
  - 계층형
    - 트리 구조, 일 대 다 대응 관계만 존재
    - 종류 : IMS, System2000
  - 망형
    - 그래프 구조, 일 대 일, 일 대 다, 다 대 다 대응 관계 지원
    - 종류 : IDS, TOTAL, IDMS
  - 관계형
    - 2차원적인 표를 하나의 DB로 묶어서 테이블 내에 있는 속성들 간/테이블 간의 관계를 설정하여 이용
    - 종류 : Oracle, SQL Server, MySQL
  - 비관계형
    - 데이터 간의 관계를 정의하지 않고 비구조적인 데이터를 저장하기 위한 시스템
    - 빅데이터를 처리하기 위한 데이터베이스
    - 수평적 확장 및 분산 저장이 가능
    - 종류 : Key-Value DBMS, Document DBMS, Graph DBMS

- DBMS의 장단점
  - 장점
    - 데이터의 논리적, 물리적 독립성이 보장
    - 데이터의 중복을 피하여 기억공간이 절약
    - 저장된 자료를 공동으로 이용
    - 데이터의 일관성을 윺지
    - 데이터의 무결성을 유지
    - 보안을 유지
    - 데이터 표준화
    - 데이터 통합 관리
    - 최신 데이터 유지
    - 데이터의 실시간 처리 가능
  - 단점
    - 전문가 부족
    - 전산화 비용 증가
    - 집중적 액세스로 과부하 발생
    - 백업과 리커버리가 어려움
    - 시스템이 복잡

<br>

### ER모델 B
### 관계형 데이터 모델 A
> 데이터를 테이블 또는 릴레이션의 구조로 표현하는 논리적 데이터 모델

- 관계형 데이터 구조 : 릴레이션
  - 릴레이션 : 데이터를 원자 값으로 갖는 2차원의 테이블
  - 릴레이션의 구조 : 논리적 구조이므로 다양한 정렬 기준을 통해 릴레이션을 표현 가능
  - 구조를 나타내는 릴레이션 스키마와 실제 값들인 릴레이션 인스턴스로 구성
  - 열을 속성이라 하고 행을 튜플이라 함
  - 하나의 애트리뷰트가 취할 수 있는 같은 타입의 원자 값들의 집합을 도메인이라고 함

- 용어
  - 릴레이션 스키마
    - 릴레이션의 이름, 각 송성의 이름과 타입, 속성 값의 도메인을 정의하는 릴레이션 틀
    - 릴레이션 스킴 또는 릴레이션 내포라고도 부름
  - 릴레이션 인스턴스
    - 릴레이션에 들어 있는 튜플들의 집합
    - 릴레이션 또는 릴레이션 외연이라고도 부름
  - 애트리뷰트(컬럼)
    - 디그리 = 속성의 수 = 차수
  - 튜플(로우)
    - 카디널리티 = 튜플의 수 = 기수

- ER 모델을 관계형 데이터 모델로 변환
  - 개념적 데이터 모델인 ER모델을 논리적 모델인 릴레이션 스키마로 변환하는 것으로 매핑 룰이라고 함
  - ER 도형에서의 개체와 관계는 관계형 데이터 모델에서의 개체 릴레이션과 관계 릴레이션으로 변환하여 표현
  - 속성은 컬럼으로, 식별자는 기본키로, 릴레이션 간의 관계는 기본키와 이를 참조하는 외래키를 이용하여 표현

<br>

### 키의 개념 및 종류 B
### 무결성 A
> 데이터베이스에 저장된 데이터 값과 그것이 표현하는 현실 세계의 실제값이 일치하는 정확성을 의미
> - 데이터의 정확성을 보장하기 위해 부정확한 자료가 데이터베이스 내에 저장되는 것을 방지하기 위한 제약

- 무결성의 종류
  - 개체 무결성
    - 기본키를 구성하는 어떤 속성도 Null 값이나 중복값을 가지지 못함
  - 도메인 무결성
    - 주어진 속성 값이 정의된 도메인에 속한 값이어야 함
  - 참조 무결성
    - 외래키 값은 Null이거나 참조 릴레이션의 기본키 값과 동일해야 함
  - 사용자 정의 무결성
    - 속성 값들이 사용자가 정의한 제약조건에 만족해야 함
  - NULL 무결성
    - 릴레이션의 특정 속성 값이 Null이 될 수 없음
  - 고유 무결성
    - 각 튜플이 갖는 속성값들이 서로 달라야 함
  - 키 무결성
    - 하나의 릴레이션에는 적어도 하나의 키가 존재해야 함
  - 관계 무결성
    - 튜플들 사이의 관계에 대한 적절성 여부를 지정

<br>

### 네트워크/인터넷 A
> 두 대 이상의 컴퓨터를 전화선이나 케이블 등으로 연결하여 자원을 공유하는 것
> - 지리적 범위에 따라 LAN과 WAN으로 분류

- 네트워크 통신망의 종류
  - 근거리 통신망(LAN)
    - 비교적 가까운 거리에 있는 자원을 연결하여 구성
    - 주로 자원 공유를 목적
    - 사이트 간의 거리가 짧아 데이터의 전송 속도가 빠르고, 에러 발생율이 낮음
    - 주로 버스형, 링형 구조를 사용
  - 광대역 통신망(WAN)
    - 멀리 떨어진 사이트들을 연결하여 구성
    - 사이트 간의 거리가 멀어 데이터의 전송 속도가 느리고, 에러 발생율이 높음
    - 일정한 지역에 있는 사이트들을 근거리 통신망으로 연결하고 각 근거리 통신망을 확장하는 방식

- 인터넷의 개요
  - 미 국방성의 ARPANET에서 시작
  - 유닉스 운영체제 기반
  - 인터넷에 연결된 모든 컴퓨터는 고유한 IP를 보유
  - 컴퓨터 또는 네트워크를 연결하기 위해 브릿지, 라우터, 게이트웨이가 사용
  - 보통 인터넷의 주가 되는 기간망을 백본이라 칭함

- IP 주소
  - 인터넷에 연결된 모든 컴퓨터 자원을 구분하기 위한 고유한 주소

- IPv6
  - IPv4의 주솧 부족 문제를 해결하기 위해 개발
  - IPv4에 비해 자료 전송 속도가 빠름
  - IPv4와 호환성이 뛰어남
  - 인증성, 기밀성, 데이터 무결성의 지원으로 보안 문제를 해결
  - 주소의 확장성, 융통성, 연동성이 뛰어남
  - 실시간 흐름 제어로 향상된 멀티미디어 기능을 지원
  - 트래픽 클래스, 플로우 레이블을 이용하여 등급별, 서비스별로 패킷을 구분할 수 있어 품질 보장이 용이
  - 구성
    - 유니캐스트 : 단일 송신자-단일 수신자
    - 멀티캐스트 : 단일 송신자-다중 수신자
    - 애니캐스트 : 단일 송신자-가장 가까이 있는 단일 수신자

- 도메인 네임
  - 숫자로 된 IP 주소를 사람이 이해하기 쉬운 문자 형태로 표현
  - 호스트 컴퓨터 이름, 소속 기관 이름, 소속 기관 종류, 소속 국가명 순
    - 왼쪽에서 오른쪽으로 갈 수록 상위 도메인
  - 문자로 된 도메인 네임을 컴퓨터가 이해하기 위해 IP 주소로 변환하는 역할을 하는 시스템이 DNS
    - 이런 역할 하는 서버를 DNS 서버라고 부름

<br>

### OSI 참조 모델 A
> 다른 시스템 간의 원활한 통신을 위해 ISO에서 제안한 통신 규약
> - 1~3계층을 하위 계층, 4~7계층을 상위 계층이라고 함
> - 물-데-네-전-세-표-응

- OSI 참조 모델의 목적
  - 서로 다른 시스템 간을 상호 접속하기 위한 개념
  - OSI 규격을 개발하기 위한 범위를 지정
  - 관련 규정의 적합성을 조절하기 위한 공통적 기반 제공

- OSI 참조 모델에서의 데이터 단위
  - 프로토콜 데이터 단위 : 동일 계층 간에 교환되는 정보의 단위
    - 물리 계층 : 비트
    - 데이터 링크 계층 : 프레임
    - 네트워크 계층 : 패킷
    - 전송 계층 : 세그먼트
    - 세션, 표현, 응용 계층 : 메시지
  - 서비스 데이터 단위 : 서비스 접근접(SAP)을 통해 상/하위 계층끼리 주고 받는 정보의 단위

- 물리 계층
  - 두 장치 간의 실제 접속과 절단 등의 특성에 대한 규칙 정의
  - 물리적 전송 매체와 전송 신호 방식을 정의
  - 관련 장비 : 리피터, 허브

- 데이터 링크 계층
  - 신뢰성 있고 효율적인 정보 전송이 가능하게 함
  - 송신-수신 측의 속도 차이를 해결하기 위한 흐름 제어
  - 프레임의 동기화
  - 유르 제어
  - 순서 제어
  - 관련 장비 : 랜카드, 브릿지, 스위치

- 네트워크 계층
  - 네트워크 연결을 관리하는 기능과 데이터의 교환 및 중계 기능
  - 네트워크 연결을 설정, 유지 해제
  - 관련 장비 : 라우터

- 전송 계층
  - 논리적 안정과 균일한 데이터 전송 서비스를 제공
  - 하위 3계층과 상위 3계층의 인터페이스 담당
  - TCP, UDP 표준 존재
  - 관련 장비 : 게이트웨이

- 세션 계층
  - 대화(회화) 구성 및 동기 제어, 데이터 교환 관리
  - 정보의 수신 상태를 체크하고 이 체크점을 동기점이라고 함
  - 동기점은 오류가 있는 데이터의 회복을 위해 사용하는 것으로 소동기점과 대동기점이 있음

- 표현 계층
  - 통신에 적당한 데이터로 변환
  - 서로 다른 데이터 표현 형태를 갖는 시스템 간의 상호 접속을 위해 필요한 계층

- 응용 계층
  - 사용자가 OSI 환경에 접근할 수 있도록 서비스를 제공

<br>

### 네트워크 관련 장비 B
### TCP/IP A
> 인터넷에 연결된 서로 다른 기종의 컴퓨터들이 데이터를 주고받을 수 있도록 하는 표준 프로토콜
> - UNIX의 기본 프로토콜로 사용되었으며 현재는 인터넷 범용 프로토콜임

- 개요
  - TCP
    - 연결형 서비스 제공
    - 패킷의 다중화, 순서 제어, 오류 제어, 흐름 제어 기능 제공
    - 스트림 전송 기능 제공
  - IP
    - 데이터그램을 기반으로 하는 비연결형 서비스 제공
    - 패킷의 분해/조립, 주소 지정, 경로 선택 기능을 제공

- 프로토콜의 특징
  - 단편화, 재조립, 캡슐화, 연결 제어, 오류 제어, 동기화, 다중화, 주소 지정

- TCP/IP의 구조

  |OSI|TCP/IP|기능|
  |---|------|---|
  |응용 계층/표현 계층/세션 계층|응용 계층|응용 프로그램 간의 데이터 송수신 제공|
  |전송 계층|전송 계층|호스트들 간의 신뢰성 있는 통신 제공|
  |네트워크 계층|인터넷 계층|데이터 전송을 위한 주소 지정, 경로 설정 제공|
  |데이터 링크 계층, 물리 계층|네트워크 엑세스 계층|실제 데이터(프레임)를 송수신하는 역할|

- 응용 계층의 주요 프로토콜
  - FTP
    - 파일을 주고받을 수 있도록 하는 원격 파일 전송 프로토콜
  - SMTP
    - 전자 우편을 교환하는 서비스
  - TELNET
    - 멀리 떨어져 있는 컴퓨터에 접속하여 자신의 컴퓨터처럼 사용할 수 있도록 해주는 서비스
  - HTTP
    - 월드와이드웹에서 HTML 문서ㅗ를 송수신 하기 위한 표준 프로토콜
  - SNMP
    - TCP/IP의 네트워크 관리 프로토콜
  - DNS
    - 도메인 네임을 IP 주소로 매핑하는 시스템

- 전송 계층의 주요 프로토콜
  - TCP
    - 양방향 연결형 서비스 제공
    - 가상 회선 연결 형태의 서비스 제공
    - 스트림 위주의 전달(패킷 단위)
    - 신뢰성 있는 경로를 확립하고 메시지 전송을 감독
    - 투명성이 보이는 통신 제공
  - UDP
    - 비연결형 서비스 제공
    - TCP보다 상대적으로 단순해 오버헤드가 적음
    - 고속의 안정성 있는 전송 매체를 사용하여 빠른 속도가 필요하거나, 동시에 여러 사용자에게 데이터를 전송하거나, 정기적으로 반복해야할 경우 사용
    - 실시간 전송에 유리하며 신뢰성보다 속도가 중요시되는 네트워크에서 사용
  - RTCP
    - 패킷의 전송 품질을 제어하기 위한 제어 프로토콜
    - 데이터 전송을 모니터링하고 최소한의 제어와 인증 기능만을 제공

- 인터넷 계층의 주요 프로토콜
  - IP
    - 주소를 지정하고 경로를 설정하는 기능
    - 데이터그램 방식을 사용
  - ICMP
    - 통신중에 발생하는 오류의 처리와 전송 경로 변경 등을 위한 제어 메시지 관리 역할
  - IGMP
    - 멀티캐스트 그룹 유지를 위해 사용
  - ARP
    - 호스트의 IP 주소를 물리적 주소(MAC Address)로 변환
  - RARP
    - 물리적 주소를 IP 주소로 변환

- 네트워크 액세스 계층의 주요 프로토콜
  - Ethernet : CSMA/CD 방식의 LAN
  - IEEE 802 : LAN을 위한 표준 프로토콜
  - HDLC : 비트 위주의 데이터 링크 제어 프로토콜
  - X.25 : 패킷 교환망을 통한 인터페이스를 제공하는 프로토콜
  - RS-232C : 공중 전화 교환망을 통한 인터페이스를 제공하는 프로토콜

<br>

### 데이터 교환 방식/라우팅 C

<hr>
<br>

## 제품 소프트웨어 패키징
### 소프트웨어 패키징 B

<br>

### 릴리즈 노트 작성 B

<br>

### 디지털 저작권 관리 A
> 창작자가 가지는 배타적 독점적 권리로 타인의 침해를 받지 않을 고유한 권한

- 디지털 저작권 관리의 개요
  - 저작권자가 의도한 용도로만 사용되도록 디지털 콘텐츠의 생성, 유통, 이용까지의 전 과정에 걸쳐 사용
  - 원본 콘텐츠가 아날로그인 경우 디지털로 변환 후 패키저에 의해 DRM 패키징을 수행
  - 콘텐츠의 크기가 작은 경우 : 사용자가 요청하는 시점에 실시간으로 패키징 수행
  - 콘텐츠의 크기가 큰 경우 : 미리 패키징을 수행한 후 배포
  - 암호화된 저작권자의 전자서명이 포함되고 해당 라이선스 정보가 클리어링 하우스에 등록

- 디지털 저작권 관리 용어
  - 클리어링 하우스 : 사용권한, 라이선스 발급, 사용량에 따른 결제 관리 등을 수행
  - 콘텐츠 제공자 : 콘텐츠를 제공하는 저작권자
  - 패키저 : 콘텐츠를 메타 데이터와 함께 배포 가능한 형태로 묶어 암호화하는 프로그램
  - 콘텐츠 분배자 : 암호화된 콘텐츠를 유통하는 곳이나 사람
  - 콘텐츠 소비자 : 콘텐츠를 구매하여 사용하는 주체
  - DRM 컨트롤러 : 배포된 콘텐츠의 이용 권한을 통제하는 프로그램
  - 보안 컨테이너 : 콘텐츠 원본을 안전하게 유통하기 위한 전자적 보안 장치

- 디지털 저작권 관리의 기술 요소
  - 암호화 : 콘텐츠 및 라이선스를 암호화하고 전자 서명을 할 수 있는 기술
  - 키 관리 : 콘텐츠를 암호화한 키에 대한 저장 및 분배 기술
  - 암호화 팡리 생성 : 콘텐츠를 암호화된 콘텐츠로 생성하기 위한 기술
  - 식별 기술 : 콘텐츠에 대한 식별 체계 표현 기술
  - 저작권 표현 : 라이선스의 내용 표현 기술
  - 정책 관리 : 라이선스 발급 및 사용에 대한 정책 표현 및 관리 기술
  - 크랙 방지 : 크랙에 의한 콘텐츠 사용 방지 기술
  - 인증 : 라이선스 발급 및 사용의 기준이 되는 사용자 인증 기술

<br>

### 소프트웨어 설치 메뉴얼 작성 C

<br>

### 소프트웨어 사용자 메뉴얼 작성 C

<br>

### 소프트웨어 버전 등록 B

<br>

### 소프트웨어 버전 관리 도구 A
- 공유 폴더 방식
  - 로컬 컴퓨터의 공유 폴더에 저장되어 관리되는 방식
  - 종류 : SCCS, RCS, PVCS, QVCS
  
- 클라이언트/서버 방식
  - 중앙 시스템(서버)에 저장되어 관리되는 방식
  - 모든 버전 관리는 서버에서 수행
  - 종류 : CVS, SVN, CVSNT, Clear Case, CMVC, Perforce

- 분산 저장소 방식
  - 하나의 원격 저장소와 분산된 개발자 PC의 로컬 저장소에 함께 저장되어 관리되는 방식
  - 종류 : Git, GNU arch, DCVS, Bazaar, Mercurial, TeamWare, Bitkeeper, Plastic SCM

- Subversion(서브버전, SVN)
  - CVS를 개선한 것
  - 클라이언트/서버 구조로 서버에는 최신 버전의 파일들과 변경 내역이 관리
  - 변경 내용을 서버에 반영함
  - 모든 개발 작업은 trunk 디렉터리에서 수행되고 추가 작업은 branches 디렉터리 안에 별도의 디렉터리를 만들어 작업을 완료하고 trunk 디렉터리와 병합한다.
  - 커밋할 때마다 리비전이 1씩 증가한다.
  - CVS의 단점인 파일이나 디렉터리 이름의 변경, 이동 등이 가능

- Git
  - 분산 버전 관리 시스템으로 2개의 저장소, 지역 및 원격 저장소가 존재
  - 지역 저장소 : 개발자들이 실제 개발을 진행하는 장소로 버전 관리가 수행
  - 원격 저장소 : 여러 사람들이 협업을 위해 버전을 공동 관리하는 곳
  - 버전 관리가 신속하게 처리되고, 원격 저장소나 네트워크에 문제가 있어도 작업이 가능
  - 브랜치를 이용하면 기본 버전 관리 틀에 영향을 주지 않으면서 다양한 형태의 기능 테스팅이 가능

<br>

### 빌드 자동화 도구 B

<br>
