# 코드를 깔끔하게 짜고 싶다면
- 좋은 경험과 끝없는 반성
- 잘 짜여진 오픈 소스를 참고(분석)한다.
- 깔끔한 코드를 본다.
  - 깔끔한 코드가 무엇인가? 클린 코드 책을 읽어보자.
- solid를 만족하는지 고민한다.
- 리팩토링을 적용한다.
- 디자인패턴을 적용한다.
- 코드리뷰를 진행한다.
  - LGTM(Looks Good To Me)은 최악이다.
  - 개발한 시스템과 코드 리뷰 또는 자료 요약 시 특별한 문제가 없을 떄만 사용할 것
- early return을 자주 사용한다.
- 변수, 함수명을 고민한다.
  - 좋은 네이밍 규칙을 적용
- 코드가 책처럼 읽히는지 고민한다.
- 린팅 플러그인을 설치하여 코드 가독성을 향상시킨다.
- 테스트 코드를 작성한다. 테스트 코드를 많이 만들면 코드가 깔끔해진다.
- 안 좋은 코드를 보고 어디가 안 좋은지 명확하게 말할 수 있어야 한다.
- 분리하는 습관을 기르자.
  - 클래스가 크면 클래스 역할을 위임한다.
  - 메서드가 크면 메서드를 분리하여 한 책임만을 부여한다.
  - 분리된 클래스나 메서드가 비슷한 기능을 한다면 인터페이스로 추출한다.
  - 단 코드가 많지도 않은데 유즈케이스 없이 이쁘게 짠다고 계층 만들면 라자냐 지옥이다.
- 코드를 줄이는 것부터가 시작이다.
  - 오픈 소스를 참고하여 동일한 기능임에도 코드량이 적다면 이를 분석하자.
  - 본인 코드에 적용하자.
  - 리뷰 받자!
  - 깔끔한 코드는 그 역할이 나뉘어져 중복이 없고 적절한 위임과 추상화가 완료된 것이다.
  - 코드 글자 중복의 제거, 코드 뒤 숨어있는 추상적 개념을 묶어내는 것이 진짜 실력이다.
- 싱글 프로세스로 큰 프로그램을 작성해보자. 1mil line 프로그램정도.
- 