# 빌더

## 빌드(Build)란?
> 소프트웨어가 응집력 있는 하나의 단위로써 작동하는지 확인하는 과정

- 프로그램을 만드는 것이 '개발'이라면 사용자의 컴퓨터에 설치-실행까지의 단계를 빌드라고 부릅니다.
  - 즉, 소프트웨어를 생성하고 테스트하고 검사하여 배포하기 위해 수행하는 행위의 집합으로 compile, testing, inspection, deploy등의 과정 등이 포함됩니다.

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<hr>
<br>

## 빌드 도구의 기능

|기능|설명|
|----|----|
|코드 컴파일|테스트를 포함한 소스코드 컴파일|
|컴포넌트 패키징|자바의 jar 파일이나 윈도우의 exe 파일 같은 배포할 수 있는 컴포넌트를 묶는 작업|
|파일 조작|파일과 디렉토리를 만들고 복사하고 지우는 작업|
|개발 테스트 실행|자동화된 테스트 진행|
|버전 관리 도구 통합|버전관리 시스템 지원|
|문서 생성|API문서(Java Doc 등)를 생성|
|배포 기능|테스트 서버(alpha, beta 등) 배포 지원|
|코드 품질 분석|자동화된 검사도구(findbug, checkstyle, pmd 등)를 통한 코드 품질 분석|

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<hr>
<br>

## 빌더(Builder), 빌드 도구
### [Ant](http://ant.apache.org/)
> OS와 상관없이 사용하는 Java 기반 빌드 툴로 Configuration 파일이 XML로 되어 있어 애플리케이션 구조에 맞게 적용하기에 편리
> - 가장 널리 사용되는 자바 빌드 도구로 2000년 Apache 에서 출시했습니다.

- 안정성이 좋고 문서화가 잘 되어 있으며, 자바 프로젝트에서 가장 쓸만한 도구중에 하나입니다.
- task라는 개념을 사용하여 아래의 기능을 지원합니다.
  - 자바 소스 파일 컴파일
  - jar, war, ear, zip 파일의 생성
  - javadoc 생성
  - 파일이나 폴더의 이동 및 복사, 삭제
  - 작업에 대한 의존성 설정
  - 외부 프로그램 실행

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<br>

### [Maven](http://maven.apache.org/)
> 프로젝트 객체 모델(Project Object Model, POM)이라는 개념이 바탕인 빌더
> - 플러그인을 기반으로 소스 코드로부터 배포 가능한 산출물을 만들어 내는 빌드 기능 뿐만 아니라 레포팅 및 documentation 작성 기능 등을 제공합니다.

- Ant가 빌드 툴이라면 Maven은 어플리케이션 개발을 위하여 필요한 모든 작업을 추상화하여 지원하는 프로젝트 관리 툴입니다.
  - Maven 사이트에서는 **소프트웨어 프로젝트 관리 및 도구** 로 설명합니다.
- 어플리케이션 개발 시 반복적으로 진행하던 작업들을 효율적으로 지원하기 위해 등장했으며, 최소한의 설정으로 프로젝트 빌드, 테스트 실행, 품질 보고서 생성이 가능합니다.
  - POM(Project Object Model)을 통해서 jar 파일의 의존성 관리, 빌드, 배포, 문서생성, Release 등을 관리 할 수 있습니다.

- 장점
  - 뛰어난 의존성 관리 : 의존성 자동 업데이트, 저장소를 통한 라이브러리 일괄 관리
  - 모든 프로젝트에 걸쳐 쉽게 적용 가능한 일관적인 사용법
  - 쉽게 작성 가능한 플러그 인을 통한 확장성
  - 동시에 다수의 프로젝트를 핸들링 할 수 있는 쉬운 설정 기반의 메커니즘
  - 간단한 설정을 통한 배포 관리

- 단점
  - Repository 관리의 불편함 : central repository가 제공하는 라이브러리가 빠르게 증가하나 현재까지도 미제공 라이브러리들이 존재
  - pom.xml 파일 관리 : 프로젝트 관리에 대한 모든 내용이 pom.xml 파일에 담기므로 길고 장황할 수 있음
  - 프로젝트에 특화된 복잡한 빌드 기능 제약 : 소프트웨어 빌드에 통용되는 라이프 사이클을 제공하고 있어 세부 항목 또는 특화된 빌드 환경에 대한 지원이 미약

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<br>

### [Gradle](https://gradle.org/)
> Groovy를 기반으로 한 오픈소스 빌드 도구
> - Ant의 자유도와 Maven의 관례를 통한 접근성을 바탕으로 이전 빌드툴의 단점을 보완하여 개선된 서비스를 제공합니다.


- 매우 유연한 범용 빌드 도구로 구조의 전환이 가능합니다.
- Maven 등의 기존 저장소 인프라 또는 pom.xml 파일에 대한 migration의 편이성이 제공되며 멀티 프로젝트 빌드를 지원합니다.
- 의존성 관리의 다양한 방법 제공합니다.
  - Build script를 xml이 아닌 Groovy 기반의 DSL(Domain Specific Language)을 사용
  - 기존 Build를 구성하기 위한 풍부한 도메인 모델 제공
  - Gradle 설치 없이 Gradle Wrapper를 이용하여 빌드 지원

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<br>

### 웹팩

### 롤업

### 파셀